/*
 * Decompiled with CFR 0.152.
 */
package io.agora.mediaplayer;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.rtc2.internal.Logging;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class AssetsFileReader {
    private static final String TAG = "AssetsFileReader";
    private FileInputStream fileInputStream = null;
    private FileChannel fileChannel = null;
    private AssetFileDescriptor afd = null;
    private long startOffset_ = 0L;
    private long length_ = 0L;
    public static final String PREFIX_ASSETS = "/assets/";

    @CalledByNative
    public AssetsFileReader() {
        Logging.i("AssetsFileReader constructor");
    }

    @CalledByNative
    public int open(String assetFilePath) {
        if (this.fileInputStream != null) {
            Logging.e("AssetsFileReader has opened file ");
            return -2;
        }
        int ret = 0;
        Context context = ContextUtils.getApplicationContext();
        AssetManager am = context.getAssets();
        try {
            String assetsFileName = assetFilePath.substring(assetFilePath.indexOf(PREFIX_ASSETS) + PREFIX_ASSETS.length());
            this.afd = am.openFd(assetsFileName);
            this.startOffset_ = this.afd.getStartOffset();
            this.length_ = this.afd.getLength();
            this.fileInputStream = this.afd.createInputStream();
            this.fileChannel = this.fileInputStream.getChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e("AssetsFileReader open error:" + e.getMessage());
            ret = -3;
            this.closeFile();
        }
        return ret;
    }

    @CalledByNative
    public long getFileSize() {
        if (this.fileChannel != null) {
            try {
                return this.length_;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.e("AssetsFileReader getFileSize error:" + e.getMessage());
            }
        }
        return -2L;
    }

    @CalledByNative
    public long seek(long pos) {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.position(this.startOffset_ + pos);
                return pos;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.e("AssetsFileReader seek error: " + e.getMessage());
            }
        }
        return -2L;
    }

    @CalledByNative
    public void closeFile() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e("AssetsFileReader closeFile Step1 error: " + e.getMessage());
            }
            this.fileChannel = null;
        }
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e("AssetsFileReader closeFile Step2 error: " + e.getMessage());
            }
            this.fileInputStream = null;
        }
        if (this.afd != null) {
            try {
                this.afd.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e("AssetsFileReader closeFile Step3 error: " + e.getMessage());
            }
            this.afd = null;
        }
    }

    @CalledByNative
    public int read(ByteBuffer readByteBuffer) {
        if (this.fileChannel == null) {
            return -2;
        }
        readByteBuffer.clear();
        try {
            long now_pos = this.fileChannel.position();
            if (now_pos - this.startOffset_ > this.length_) {
                return -1;
            }
            long hasRead = this.fileChannel.read(readByteBuffer);
            long now_len = now_pos + hasRead - this.startOffset_;
            if (now_len > this.length_) {
                hasRead -= now_len - this.length_;
            }
            return (int)hasRead;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logging.e("AssetsFileReader read error: " + e.getMessage());
            return -2;
        }
    }

    @CalledByNative
    public long getCurrentPosition() {
        if (this.fileChannel == null) {
            return -2L;
        }
        try {
            return this.fileChannel.position();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e("AssetsFileReader read error: " + e.getMessage());
            return -2L;
        }
    }
}

