/*
 * Decompiled with CFR 0.152.
 */
package io.agora.mediaplayer;

import io.agora.base.internal.CalledByNative;

public class Constants {
    public static final int PLAYER_ERROR_NOT_INIT = -1;
    public static final int PLAYER_RENDER_MODE_HIDDEN = 1;
    public static final int PLAYER_RENDER_MODE_FIT = 2;
    public static final int PLAYER_RENDER_MODE_ADAPTIVE = 3;

    public static enum AudioDualMonoMode {
        AUDIO_DUAL_MONO_STEREO(0),
        AUDIO_DUAL_MONO_L(1),
        AUDIO_DUAL_MONO_R(2),
        AUDIO_DUAL_MONO_MIX(3);

        private int value;

        private AudioDualMonoMode(int v) {
            this.value = v;
        }

        public static int getValue(AudioDualMonoMode mode) {
            return mode.value;
        }
    }

    public static enum MediaStreamType {
        STREAM_TYPE_UNKNOWN(0),
        STREAM_TYPE_VIDEO(1),
        STREAM_TYPE_AUDIO(2),
        STREAM_TYPE_SUBTITLE(3);

        private int value;

        private MediaStreamType(int v) {
            this.value = v;
        }

        public static int getValue(MediaStreamType type) {
            return type.value;
        }
    }

    public static enum MediaPlayerMetadataType {
        PLAYER_METADATA_TYPE_UNKNOWN(0),
        PLAYER_METADATA_TYPE_SEI(1);

        private int value;

        private MediaPlayerMetadataType(int v) {
            this.value = v;
        }

        public static int getValue(MediaPlayerMetadataType type) {
            return type.value;
        }

        @CalledByNative(value="MediaPlayerMetadataType")
        public static MediaPlayerMetadataType fromNativeIndex(int nativeIndex) {
            return MediaPlayerMetadataType.getTypeByValue(nativeIndex);
        }

        public static MediaPlayerMetadataType getTypeByValue(int value) {
            MediaPlayerMetadataType[] types;
            for (MediaPlayerMetadataType type : types = MediaPlayerMetadataType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return PLAYER_METADATA_TYPE_UNKNOWN;
        }
    }

    public static enum MediaPlayerPreloadEvent {
        PLAYER_PRELOAD_EVENT_BEGIN(0),
        PLAYER_PRELOAD_EVENT_COMPLETE(1),
        PLAYER_PRELOAD_EVENT_ERROR(2);

        private int value;

        private MediaPlayerPreloadEvent(int v) {
            this.value = v;
        }

        public static int getValue(MediaPlayerPreloadEvent type) {
            return type.value;
        }

        @CalledByNative(value="MediaPlayerPreloadEvent")
        public static MediaPlayerPreloadEvent fromNativeIndex(int nativeIndex) {
            return MediaPlayerPreloadEvent.getTypeByValue(nativeIndex);
        }

        public static MediaPlayerPreloadEvent getTypeByValue(int value) {
            MediaPlayerPreloadEvent[] evnets;
            for (MediaPlayerPreloadEvent event : evnets = MediaPlayerPreloadEvent.values()) {
                if (event.value != value) continue;
                return event;
            }
            return PLAYER_PRELOAD_EVENT_ERROR;
        }
    }

    public static enum MediaPlayerEvent {
        PLAYER_EVENT_UNKNOWN(-1),
        PLAYER_EVENT_SEEK_BEGIN(0),
        PLAYER_EVENT_SEEK_COMPLETE(1),
        PLAYER_EVENT_SEEK_ERROR(2),
        PLAYER_EVENT_AUDIO_TRACK_CHANGED(5),
        PLAYER_EVENT_BUFFER_LOW(6),
        PLAYER_EVENT_BUFFER_RECOVER(7),
        PLAYER_EVENT_FREEZE_START(8),
        PLAYER_EVENT_FREEZE_STOP(9),
        PLAYER_EVENT_SWITCH_BEGIN(10),
        PLAYER_EVENT_SWITCH_COMPLETE(11),
        PLAYER_EVENT_SWITCH_ERROR(12),
        PLAYER_EVENT_FIRST_DISPLAYED(13),
        PLAYER_EVENT_REACH_CACHE_FILE_MAX_COUNT(14),
        PLAYER_EVENT_REACH_CACHE_FILE_MAX_SIZE(15),
        PLAYER_EVENT_TRY_OPEN_START(16),
        PLAYER_EVENT_TRY_OPEN_SUCCEED(17),
        PLAYER_EVENT_TRY_OPEN_FAILED(18);

        private int value;

        private MediaPlayerEvent(int v) {
            this.value = v;
        }

        public static int getValue(MediaPlayerEvent type) {
            return type.value;
        }

        @CalledByNative(value="MediaPlayerEvent")
        public static MediaPlayerEvent fromNativeIndex(int nativeIndex) {
            return MediaPlayerEvent.getEventByValue(nativeIndex);
        }

        public static MediaPlayerEvent getEventByValue(int value) {
            MediaPlayerEvent[] events;
            for (MediaPlayerEvent event : events = MediaPlayerEvent.values()) {
                if (event.value != value) continue;
                return event;
            }
            return PLAYER_EVENT_UNKNOWN;
        }
    }

    public static enum MediaPlayerError {
        PLAYER_ERROR_NONE(0),
        PLAYER_ERROR_INVALID_ARGUMENTS(-1),
        PLAYER_ERROR_INTERNAL(-2),
        PLAYER_ERROR_NO_RESOURCE(-3),
        PLAYER_ERROR_INVALID_MEDIA_SOURCE(-4),
        PLAYER_ERROR_UNKNOWN_STREAM_TYPE(-5),
        PLAYER_ERROR_OBJ_NOT_INITIALIZED(-6),
        PLAYER_ERROR_CODEC_NOT_SUPPORTED(-7),
        PLAYER_ERROR_VIDEO_RENDER_FAILED(-8),
        PLAYER_ERROR_INVALID_STATE(-9),
        PLAYER_ERROR_URL_NOT_FOUND(-10),
        PLAYER_ERROR_INVALID_CONNECTION_STATE(-11),
        PLAY_ERROR_SRC_BUFFER_UNDERFLOW(-12),
        PLAYER_ERROR_INTERRUPTED(-13),
        PLAYER_ERROR_NOT_SUPPORTED(-14),
        PLAYER_ERROR_TOKEN_EXPIRED(-15),
        PLAYER_ERROR_IP_EXPIRED(-16),
        PLAYER_ERROR_UNKNOWN(-17);

        private int value;

        private MediaPlayerError(int v) {
            this.value = v;
        }

        public static int getValue(MediaPlayerError type) {
            return type.value;
        }

        @CalledByNative(value="MediaPlayerError")
        public static MediaPlayerError fromNativeIndex(int nativeIndex) {
            return MediaPlayerError.getErrorByValue(nativeIndex);
        }

        public static MediaPlayerError getErrorByValue(int value) {
            MediaPlayerError[] errors;
            for (MediaPlayerError error : errors = MediaPlayerError.values()) {
                if (error.value != value) continue;
                return error;
            }
            return PLAYER_ERROR_UNKNOWN;
        }
    }

    public static enum MediaPlayerState {
        PLAYER_STATE_UNKNOWN(-1),
        PLAYER_STATE_IDLE(0),
        PLAYER_STATE_OPENING(1),
        PLAYER_STATE_OPEN_COMPLETED(2),
        PLAYER_STATE_PLAYING(3),
        PLAYER_STATE_PAUSED(4),
        PLAYER_STATE_PLAYBACK_COMPLETED(5),
        PLAYER_STATE_PLAYBACK_ALL_LOOPS_COMPLETED(6),
        PLAYER_STATE_STOPPED(7),
        PLAYER_STATE_PAUSING_INTERNAL(50),
        PLAYER_STATE_STOPPING_INTERNAL(51),
        PLAYER_STATE_SEEKING_INTERNAL(52),
        PLAYER_STATE_GETTING_INTERNAL(53),
        PLAYER_STATE_NONE_INTERNAL(54),
        PLAYER_STATE_DO_NOTHING_INTERNAL(55),
        PLAYER_STATE_SET_TRACK_INTERNAL(56),
        PLAYER_STATE_FAILED(100);

        private int value;

        private MediaPlayerState(int v) {
            this.value = v;
        }

        public static int getValue(MediaPlayerState type) {
            return type.value;
        }

        @CalledByNative(value="MediaPlayerState")
        public static MediaPlayerState fromNativeIndex(int nativeIndex) {
            return MediaPlayerState.getStateByValue(nativeIndex);
        }

        public static MediaPlayerState getStateByValue(int value) {
            MediaPlayerState[] states;
            for (MediaPlayerState state : states = MediaPlayerState.values()) {
                if (state.value != value) continue;
                return state;
            }
            return PLAYER_STATE_UNKNOWN;
        }
    }
}

