/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter.internal;

import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.rtc2.internal.Logging;
import io.agora.rtc2.internal.MediaPlayerImpl;
import io.agora.rtc2.internal.RtcEngineImpl;
import java.util.concurrent.atomic.AtomicBoolean;

public class AgoraMusicPlayerImpl
extends MediaPlayerImpl
implements IAgoraMusicPlayer {
    private static final String TAG = "AgoraMusicPlayerImpl";
    private long mNativeHandle = 0L;
    private final RtcEngineImpl mRtcEngineImpl;
    private final AtomicBoolean mIsDestroying = new AtomicBoolean(false);

    AgoraMusicPlayerImpl(RtcEngineImpl rtcEngineImpl, long playerHandle, int sourceId) {
        super(rtcEngineImpl, sourceId);
        this.mRtcEngineImpl = rtcEngineImpl;
        this.mNativeHandle = playerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(long songCode, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (open)");
                return -7;
            }
            return this.nativeOpen(this.mNativeHandle, songCode, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String url, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (open)");
                return -7;
            }
            return this.nativeOpenWithUrl(this.mNativeHandle, url, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroy() {
        if (null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle != 0L) {
                this.mIsDestroying.set(true);
                AgoraMusicPlayerImpl.nativeDestroy(this.mNativeHandle);
                this.mNativeHandle = 0L;
                this.mIsDestroying.set(false);
            }
            return super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlaySrc() {
        if (this.mIsDestroying.get()) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle != 0L) {
                return AgoraMusicPlayerImpl.nativeGetPlaySrc(this.mNativeHandle);
            }
            return super.getPlaySrc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stop() {
        if (this.mIsDestroying.get()) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle != 0L) {
                return AgoraMusicPlayerImpl.nativeStop(this.mNativeHandle);
            }
            return super.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPlayMode(IAgoraMusicPlayer.MusicPlayMode mode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl || null == mode) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setPlayMode)");
                return -7;
            }
            return AgoraMusicPlayerImpl.nativeSetPlayMode(this.mNativeHandle, mode.getValue());
        }
    }

    private native int nativeOpen(long var1, long var3, long var5);

    private native int nativeOpenWithUrl(long var1, String var3, long var4);

    private static native int nativeDestroy(long var0);

    private static native String nativeGetPlaySrc(long var0);

    private static native int nativeSetPlayMode(long var0, int var2);

    private static native int nativeStop(long var0);
}

