/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter.internal;

import io.agora.musiccontentcenter.IAgoraMusicContentCenter;
import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.musiccontentcenter.IMusicContentCenterEventHandler;
import io.agora.musiccontentcenter.MusicCacheInfo;
import io.agora.musiccontentcenter.MusicContentCenterConfiguration;
import io.agora.musiccontentcenter.internal.AgoraMusicPlayerImpl;
import io.agora.musiccontentcenter.internal.MusicPlayerProperty;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.internal.Logging;
import io.agora.rtc2.internal.RtcEngineImpl;
import java.util.concurrent.atomic.AtomicBoolean;

public class MusicContentCenterImpl
extends IAgoraMusicContentCenter {
    private static final String TAG = "MusicContentCenterImpl";
    private long mNativeHandle = 0L;
    private final RtcEngineImpl mRtcEngine;
    private final AtomicBoolean mIsDestroying = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MusicContentCenterImpl(RtcEngine rtcEngine) {
        if (rtcEngine instanceof RtcEngineImpl) {
            RtcEngineImpl rtcEngineImpl = this.mRtcEngine = (RtcEngineImpl)rtcEngine;
            synchronized (rtcEngineImpl) {
                this.mNativeHandle = this.nativeObjectInit(rtcEngine.getNativeHandle());
            }
        } else {
            this.mRtcEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initialize(MusicContentCenterConfiguration configuration) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (initialize)");
                return -7;
            }
            return this.nativeInitialize(this.mNativeHandle, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renewToken(String token) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (renewToken)");
                return -7;
            }
            return this.nativeRenewToken(this.mNativeHandle, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAgoraMusicPlayer createMusicPlayer() {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (createMusicPlayer)");
                return null;
            }
            AgoraMusicPlayerImpl musicPlayer = null;
            MusicPlayerProperty playerProperty = this.nativeCreateMusicPlayer(this.mNativeHandle);
            if (playerProperty.handler != 0L) {
                musicPlayer = new AgoraMusicPlayerImpl(this.mRtcEngine, playerProperty.handler, playerProperty.id);
            }
            return musicPlayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroyMusicPlayer(IAgoraMusicPlayer player) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine || null == player) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (destroyMusicPlayer)");
                return -7;
            }
            return this.nativeDestroyMusicPlayer(this.mNativeHandle, player.getMediaPlayerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerEventHandler(IMusicContentCenterEventHandler eventHandler) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (registerEventHandler)");
                return -7;
            }
            return this.nativeRegisterEventHandler(this.mNativeHandle, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unregisterEventHandler() {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (unregisterEventHandler)");
                return -7;
            }
            return this.nativeUnregisterEventHandler(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMusicCharts() {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getMusicCharts)");
                return null;
            }
            return this.nativeGetMusicCharts(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMusicCollectionByMusicChartId(int musicChartId, int page, int pageSize, String option) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getMusicCollectionByMusicChartId)");
                return null;
            }
            return this.nativeGetMusicCollectionByMusicChartId(this.mNativeHandle, musicChartId, page, pageSize, option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String searchMusic(String keyword, int page, int pageSize, String option) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (searchMusic)");
                return null;
            }
            return this.nativeSearchMusic(this.mNativeHandle, keyword, page, pageSize, option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLyric(long songCode, int lyricType) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getLyric)");
                return null;
            }
            return this.nativeGetLyric(this.mNativeHandle, songCode, lyricType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDestroy() {
        if (null == this.mRtcEngine) {
            return;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle != 0L) {
                this.mIsDestroying.set(true);
                MusicContentCenterImpl.nativeDestroy(this.mNativeHandle, this.mRtcEngine.getNativeHandle());
                this.mNativeHandle = 0L;
                this.mIsDestroying.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String preload(long songCode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (preload)");
                return null;
            }
            return this.nativePreloadWithSongCode(this.mNativeHandle, songCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int preload(long songCode, String jsonOption) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (preload)");
                return -7;
            }
            return this.nativePreload(this.mNativeHandle, songCode, jsonOption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isPreloaded(long songCode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (isPreloaded)");
                return -7;
            }
            return this.nativeIsPreloaded(this.mNativeHandle, songCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeCache(long songCode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (removeCache)");
                return -7;
            }
            return this.nativeRemoveCache(this.mNativeHandle, songCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MusicCacheInfo[] getCaches() {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return new MusicCacheInfo[0];
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getCaches)");
                return new MusicCacheInfo[0];
            }
            return this.nativeGetCaches(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInternalSongCode(long songCode, String jsonOption) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return 0L;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getInternalSongCode)");
                return 0L;
            }
            return this.nativeGetInternalSongCode(this.mNativeHandle, songCode, jsonOption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSongSimpleInfo(long songCode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngine) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngine;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L || this.mRtcEngine.getNativeHandle() == 0L) {
                Logging.e(TAG, "MusicContentCenter does not initialize or it may be destroyed (getSongSimpleInfo)");
                return null;
            }
            return this.nativeGetSongSimpleInfo(this.mNativeHandle, songCode);
        }
    }

    private static native int nativeDestroy(long var0, long var2);

    private native long nativeObjectInit(long var1);

    private native int nativeInitialize(long var1, Object var3);

    private native int nativeRenewToken(long var1, String var3);

    private native int nativePreload(long var1, long var3, String var5);

    private native String nativePreloadWithSongCode(long var1, long var3);

    private native int nativeIsPreloaded(long var1, long var3);

    private native String nativeGetMusicCharts(long var1);

    private native String nativeGetMusicCollectionByMusicChartId(long var1, int var3, int var4, int var5, String var6);

    private native String nativeSearchMusic(long var1, String var3, int var4, int var5, String var6);

    private native String nativeGetLyric(long var1, long var3, int var5);

    private native int nativeRegisterEventHandler(long var1, Object var3);

    private native int nativeUnregisterEventHandler(long var1);

    private native MusicPlayerProperty nativeCreateMusicPlayer(long var1);

    private native int nativeDestroyMusicPlayer(long var1, int var3);

    private native int nativeRemoveCache(long var1, long var3);

    private native MusicCacheInfo[] nativeGetCaches(long var1);

    private native long nativeGetInternalSongCode(long var1, long var3, String var5);

    private native String nativeGetSongSimpleInfo(long var1, long var3);
}

