/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import io.agora.base.internal.video.VideoEncoderUtils;
import io.agora.rtc2.internal.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static double TMPERATURE_LOW_THR = -30.0;
    private static double TMPERATURE_HIGH_THR = 250.0;
    private static double INVALIED_TMPERATURE = -100000.0;
    private static final List<String> CPU_TEMP_FILE_PATHS = Arrays.asList("/sys/devices/system/cpu/cpu0/cpufreq/cpu_temp", "/sys/devices/system/cpu/cpu0/cpufreq/FakeShmoo_cpu_temp", "/sys/class/thermal/thermal_zone0/temp", "/sys/class/i2c-adapter/i2c-4/4-004c/temperature", "/sys/devices/platform/tegra-i2c.3/i2c-4/4-004c/temperature", "/sys/devices/platform/omap/omap_temp_sensor.0/temperature", "/sys/devices/platform/tegra_tmon/temp1_input", "/sys/kernel/debug/tegra_thermal/temp_tj", "/sys/devices/platform/s5p-tmu/temperature", "/sys/class/thermal/thermal_zone1/temp", "/sys/class/hwmon/hwmon0/device/temp1_input", "/sys/devices/virtual/thermal/thermal_zone1/temp", "/sys/devices/virtual/thermal/thermal_zone0/temp", "/sys/class/thermal/thermal_zone3/temp", "/sys/class/thermal/thermal_zone4/temp", "/sys/class/hwmon/hwmonX/temp1_input", "/sys/devices/platform/s5p-tmu/curr_temp");

    public static String getDeviceId() {
        String device;
        String product;
        String model;
        String manufacturer = Build.MANUFACTURER;
        if (!TextUtils.isEmpty((CharSequence)manufacturer)) {
            manufacturer = manufacturer.replace('/', '_');
        }
        if (!TextUtils.isEmpty((CharSequence)(model = Build.MODEL))) {
            model = model.replace('/', '_');
        }
        if (!TextUtils.isEmpty((CharSequence)(product = Build.PRODUCT))) {
            product = product.replace('/', '_');
        }
        if (!TextUtils.isEmpty((CharSequence)(device = Build.DEVICE))) {
            device = device.replace('/', '_');
        }
        String deviceId = manufacturer + "/" + model + "/" + product + "/" + device + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        deviceId = deviceId.toLowerCase();
        String bid = Build.ID;
        Pattern pattern = Pattern.compile(".*[A-Z][A-M][0-9]$");
        Matcher matcher = pattern.matcher(bid);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            deviceId = "yeshen_simulator/" + model + "/" + product + "/" + device + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return deviceId;
    }

    public static String getDeviceInfo() {
        String model;
        String manufacturer = Build.MANUFACTURER;
        if (!TextUtils.isEmpty((CharSequence)manufacturer)) {
            manufacturer = manufacturer.replace('/', '_');
        }
        if (!TextUtils.isEmpty((CharSequence)(model = Build.MODEL))) {
            model = model.replace('/', '_');
        }
        String deviceInfo = manufacturer + "/" + model;
        return deviceInfo.toLowerCase();
    }

    public static String getSystemInfo() {
        return "Android/" + Build.VERSION.RELEASE;
    }

    public static String getManufacturer() {
        String manufacturer = Build.MANUFACTURER;
        return manufacturer.toLowerCase();
    }

    public static int getRecommendedEncoderType() {
        return DeviceUtils.getRecommendedEncoderTypeImpl(Build.MODEL, Build.VERSION.SDK_INT);
    }

    static int getRecommendedEncoderTypeImpl(String model, int version) {
        if (VideoEncoderUtils.H264_HW_EXCEPTION_MODELS.contains(model)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return 1;
        }
        if (version <= 18) {
            return 1;
        }
        return 0;
    }

    static int getCpuTemperature() {
        return DeviceUtils.getCpuTemperature(CPU_TEMP_FILE_PATHS);
    }

    static int getCpuTemperature(@NonNull List<String> fileList) {
        double currentTemp = 0.0;
        for (String path : fileList) {
            double temp = DeviceUtils.readDoubleValueFromFileFirstLine(path, INVALIED_TMPERATURE);
            try {
                currentTemp = DeviceUtils.getValidateTemperature(temp);
                Logging.i(TAG, "getCpuTemperature from file: " + path);
                break;
            }
            catch (IllegalArgumentException e) {
                Logging.d(TAG, "can't getCpuTemperature from file: " + path);
            }
        }
        return (int)(currentTemp * 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double readDoubleValueFromFileFirstLine(String path, double defaultValue) {
        File file = new File(path);
        if (!file.exists()) {
            return defaultValue;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            double d = DeviceUtils.parseDouble(bufferedReader.readLine(), defaultValue);
            return d;
        }
        catch (FileNotFoundException e) {
            Logging.d(TAG, "failed to read from file", e);
            double d = defaultValue;
            return d;
        }
        catch (IOException e) {
            Logging.d(TAG, "failed to read from file", e);
            double d = defaultValue;
            return d;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static double parseDouble(String s, double defaultValue) {
        double result = defaultValue;
        try {
            result = Double.parseDouble(s);
        }
        catch (Exception e) {
            Logging.d(TAG, "failed to conver string to double ", e);
        }
        return result;
    }

    static double getValidateTemperature(double temp) throws IllegalArgumentException {
        if (Math.abs(temp) <= 1000.0) {
            if (DeviceUtils.isTemperatureValid(temp)) {
                return temp;
            }
        } else if (DeviceUtils.isTemperatureValid(temp / 1000.0)) {
            return temp / 1000.0;
        }
        throw new IllegalArgumentException("not a validate temperature value");
    }

    static boolean isTemperatureValid(double temp) {
        return temp >= TMPERATURE_LOW_THR && temp <= TMPERATURE_HIGH_THR;
    }
}

