/*************************************************************
 * Author:	Lionfore Hao (haolianfu@agora.io)
 * Date	 :	Jun 17th, 2024
 * Module:	AHPL memory management for C++ definition file
 *
 *
 * This is a part of the Advanced High Performance Library.
 * Copyright (C) 2018 ~ 2024 Agora IO
 * All rights reserved.
 *
 *************************************************************/

#ifndef __AHPL_MM_CLASS_H__
#define __AHPL_MM_CLASS_H__


#include <api/ahpl_types.h>
#include <api/ahpl_mm.h>


class ahpl_mm_class {
public:
	static void *operator new (size_t size)
	{
		return ahpl_mm_malloc (size);
	}

	static void *operator new [] (size_t size)
	{
		return ahpl_mm_malloc (size);
	}

	static void operator delete (void *ptr)
	{
		ahpl_mm_free (ptr);
	}

	static void operator delete [] (void *ptr)
	{
		ahpl_mm_free (ptr);
	}
};


#endif /* __AHPL_MM_CLASS_H__ */
