/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ATrace;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.EglRenderer;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.VideoSourceLayout;
import io.agora.base.internal.video.YuvConverter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class VideoFrameBlender {
    private static final boolean DEBUG = false;
    private final YuvConverter yuvConverter = new YuvConverter();
    private static final String TAG = "AndroidVideoFrameBlender";
    private static final int MAX_INVOKE_TIME_MS = 2000;
    private Handler mBlenderHandler = null;
    private EglBase mEglBase = null;
    private ArrayList<VideoSourceLayout> mVideoSourceLayouts = new ArrayList();
    private HashMap<String, VideoFrame> mVideoSources = new HashMap();
    private final Object mSourceLock = new Object();
    private final VideoFrameDrawer mFrameDrawer = new VideoFrameDrawer();
    private RendererCommon.GlDrawer mDrawer = new GlRectDrawer();
    private final Matrix drawMatrix = new Matrix();
    private String mCanvasId = "_agora_canvas_";
    private int mVideoBufferId = 0;
    private int mFramebuffer = 0;
    private int mCanvasWidth = 0;
    private int mCanvasHeight = 0;
    private boolean isBlenderRelased = false;

    @CalledByNative
    public VideoFrameBlender() {
    }

    @CalledByNative
    public boolean initBlender(String name, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(name + "VideoFameBlender");
        thread.start();
        this.mBlenderHandler = new Handler(thread.getLooper());
        boolean result = false;
        try {
            result = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (sharedContext == null) {
                        Logging.e(VideoFrameBlender.TAG, "initBlender failed for sharedContext is null");
                        return false;
                    }
                    VideoFrameBlender.this.mEglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_RGBA);
                    if (VideoFrameBlender.this.mEglBase == null) {
                        Logging.e(VideoFrameBlender.TAG, "initBlender failed for mEglBase is null");
                        return false;
                    }
                    try {
                        VideoFrameBlender.this.mEglBase.createDummyPbufferSurface();
                        VideoFrameBlender.this.mEglBase.makeCurrent();
                        GLES20.glPixelStorei((int)3317, (int)1);
                    }
                    catch (RuntimeException e) {
                        VideoFrameBlender.this.mEglBase.release();
                        return false;
                    }
                    VideoFrameBlender.this.isBlenderRelased = false;
                    return true;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "initBlender faild for EglBaseFactory failed");
            result = false;
        }
        return result;
    }

    private boolean createAndBindTextureBuffer(final int width, final int height) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Logging.d(VideoFrameBlender.TAG, "into createAndBindTextureBuffer width:" + width + " ,height:" + height);
                try {
                    VideoFrameBlender.this.mEglBase.makeCurrent();
                }
                catch (RuntimeException e) {
                    return false;
                }
                VideoFrameBlender.this.releaseTextureBuffer();
                VideoFrameBlender.this.mVideoBufferId = GlUtil.generateTexture(3553);
                if (VideoFrameBlender.this.mVideoBufferId <= 0) {
                    Logging.e(VideoFrameBlender.TAG, "generateTexture failed");
                    return false;
                }
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)VideoFrameBlender.this.mVideoBufferId);
                ATrace.beginSection("glTexImage2D");
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                ATrace.endSection();
                GlUtil.checkNoGLES2Error("TextureBufferPool.glTexImage2D");
                GLES20.glBindTexture((int)3553, (int)0);
                int[] frameBuffers = new int[1];
                GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
                GlUtil.checkNoGLES2Error("glGenFramebuffers");
                VideoFrameBlender.this.mFramebuffer = frameBuffers[0];
                GLES20.glBindFramebuffer((int)36160, (int)VideoFrameBlender.this.mFramebuffer);
                GlUtil.checkNoGLES2Error("glBindFramebuffer " + VideoFrameBlender.this.mFramebuffer);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)VideoFrameBlender.this.mVideoBufferId, (int)0);
                GlUtil.checkNoGLES2Error("glFramebufferTexture2D");
                int status = GLES20.glCheckFramebufferStatus((int)36160);
                if (status != 36053) {
                    Logging.w(VideoFrameBlender.TAG, "Framebuffer not complete, status: " + status);
                    return false;
                }
                GLES20.glBindFramebuffer((int)36160, (int)0);
                Logging.d(VideoFrameBlender.TAG, "createAndBindTextureBuffer success width:" + width + " ,height:" + height);
                return true;
            }
        });
    }

    private boolean checkIfNeedAlphaRender() {
        for (VideoSourceLayout layout : this.mVideoSourceLayouts) {
            if (this.mVideoSources.get(layout.getSourceId()).getAlphaBuffer() == null) continue;
            return true;
        }
        return false;
    }

    @CalledByNative
    public VideoFrame.Buffer blenderSourceList() {
        if (this.isBlenderRelased) {
            Logging.w(TAG, "blenderSourceList failed for BlenderRelased");
            return null;
        }
        if (this.mCanvasWidth == 0 || this.mCanvasHeight == 0) {
            Logging.w(TAG, "blenderSourceList failed for mCanvasWidth:" + this.mCanvasWidth + ", mCanvasHeight:" + this.mCanvasHeight);
            return null;
        }
        VideoFrame.Buffer new_buffer = null;
        try {
            new_buffer = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<VideoFrame.Buffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public VideoFrame.Buffer call() throws Exception {
                    TextureBuffer newTexture = null;
                    Object object = VideoFrameBlender.this.mSourceLock;
                    synchronized (object) {
                        if (VideoFrameBlender.this.mVideoBufferId <= 0) {
                            Logging.w(VideoFrameBlender.TAG, "blenderSourceList failed for  mVideoBufferId is:" + VideoFrameBlender.this.mVideoBufferId);
                            return null;
                        }
                        VideoFrameBlender.this.mEglBase.makeCurrent();
                        GLES20.glBindFramebuffer((int)36160, (int)VideoFrameBlender.this.mFramebuffer);
                        GlUtil.checkNoGLES2Error("glBindFramebuffer mFramebuffer");
                        boolean isNeedAlpha = VideoFrameBlender.this.checkIfNeedAlphaRender();
                        if (isNeedAlpha) {
                            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                            GLES20.glEnable((int)3042);
                            GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                        } else {
                            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        GlUtil.checkNoGLES2Error("glClearColor");
                        GLES20.glClear((int)16384);
                        GlUtil.checkNoGLES2Error("glClear");
                        for (VideoSourceLayout layout : VideoFrameBlender.this.mVideoSourceLayouts) {
                            if (VideoFrameBlender.this.mVideoSources.get(layout.getSourceId()) == null) continue;
                            VideoFrameBlender.this.doBlenderSource(layout, (VideoFrame)VideoFrameBlender.this.mVideoSources.get(layout.getSourceId()), isNeedAlpha);
                        }
                        if (isNeedAlpha) {
                            GLES20.glDisable((int)3042);
                        }
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GlUtil.checkNoGLES2Error("glBindFramebuffer 0");
                        GLES20.glUseProgram((int)0);
                        GlUtil.checkNoGLES2Error("glUseProgram");
                        GLES20.glFlush();
                        GlUtil.checkNoGLES2Error("glFlush");
                        newTexture = new TextureBuffer(VideoFrameBlender.this.mEglBase.getEglBaseContext(), VideoFrameBlender.this.mCanvasWidth, VideoFrameBlender.this.mCanvasHeight, VideoFrame.TextureBuffer.Type.RGB, VideoFrameBlender.this.mVideoBufferId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(GlUtil.IDENTITY_MATRIX), VideoFrameBlender.this.mBlenderHandler, VideoFrameBlender.this.yuvConverter, new Runnable(){

                            @Override
                            public void run() {
                                VideoFrameBlender.this.mBlenderHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                });
                            }
                        });
                    }
                    return newTexture;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new_buffer;
    }

    private void doBlenderSource(VideoSourceLayout layout, VideoFrame videoFrame, boolean isNeedAlpha) {
        Rect rect = new Rect(layout.getCroppedX(), layout.getCroppedY(), layout.getCroppedX() + layout.getCroppedWidth(), layout.getCroppedY() + layout.getCroppedHeight());
        float[] gltexturecoord = EglRenderer.DoConvertRectFromAndroidGraphicsRect(rect, videoFrame, layout.isMirrorY());
        this.mDrawer.setTextureCropCoord(GlUtil.createFloatBuffer(gltexturecoord));
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (layout.isMirrorY()) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        if (layout.getVideoSourceType() != VideoSourceLayout.VideoSourceType.STREAM) {
            this.drawMatrix.preScale(1.0f, -1.0f);
        }
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        int destPositionX = layout.getPositionX();
        int destPositionY = layout.getPositionY();
        if (!layout.getSourceId().equals(this.mCanvasId)) {
            destPositionX = layout.getPositionX();
            destPositionY = this.mCanvasHeight - layout.getPositionY() - layout.getDestHeight();
        }
        this.mFrameDrawer.disableNegativeAlphaData();
        this.mFrameDrawer.drawFrame(videoFrame, this.mDrawer, this.drawMatrix, destPositionX, destPositionY, layout.getDestWidth(), layout.getDestHeight(), isNeedAlpha && videoFrame.getAlphaBuffer() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void updateSourceContent(String sourceId, VideoFrame frame) {
        if (this.isBlenderRelased) {
            Logging.w(TAG, "updateSourceContent failed for BlenderRelased");
            return;
        }
        Object object = this.mSourceLock;
        synchronized (object) {
            if (this.mVideoSources.get(sourceId) != null) {
                this.mVideoSources.get(sourceId).release();
                this.mVideoSources.remove(sourceId);
            }
            if (frame.getBuffer() instanceof VideoFrame.RgbaBuffer) {
                VideoFrame.TextureBuffer newBuffer = null;
                newBuffer = this.uploadImageSourceToTexture(frame);
                if (newBuffer == null) {
                    return;
                }
                VideoFrame newframe = new VideoFrame(newBuffer, frame.getRotation(), frame.getTimestampNs());
                if (frame.getAlphaBuffer() != null) {
                    newframe.fillAlphaData(frame.getAlphaBuffer());
                }
                this.mVideoSources.put(sourceId, newframe);
            } else {
                frame.retain();
                this.mVideoSources.put(sourceId, frame);
            }
        }
    }

    private void removeSourceLayoutIfNeed(String sourceId) {
        for (int i = this.mVideoSourceLayouts.size() - 1; i >= 0; --i) {
            if (!this.mVideoSourceLayouts.get(i).getSourceId().equals(sourceId)) continue;
            this.mVideoSourceLayouts.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void updateVideoSourceLayout(VideoSourceLayout videoSourceLayout) {
        if (this.isBlenderRelased) {
            Logging.w(TAG, "updateSourceLayout failed for BlenderRelased");
            return;
        }
        Object object = this.mSourceLock;
        synchronized (object) {
            this.removeSourceLayoutIfNeed(videoSourceLayout.getSourceId());
            if (videoSourceLayout.getSourceId().equals(this.mCanvasId)) {
                this.mCanvasWidth = videoSourceLayout.getDestWidth();
                this.mCanvasHeight = videoSourceLayout.getDestHeight();
                this.createAndBindTextureBuffer(this.mCanvasWidth, this.mCanvasHeight);
            }
            this.mVideoSourceLayouts.add(videoSourceLayout);
            Collections.sort(this.mVideoSourceLayouts, new Comparator<VideoSourceLayout>(){

                @Override
                public int compare(VideoSourceLayout layout1, VideoSourceLayout layout2) {
                    return layout1.getZorder() - layout2.getZorder();
                }
            });
        }
    }

    private VideoFrame.TextureBuffer uploadImageSourceToTexture(final VideoFrame inputFrame) {
        VideoFrame.TextureBuffer buffer = null;
        try {
            buffer = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() throws Exception {
                    if (inputFrame.getBuffer() == null || !(inputFrame.getBuffer() instanceof VideoFrame.RgbaBuffer)) {
                        return null;
                    }
                    VideoFrameBlender.this.mEglBase.makeCurrent();
                    ByteBuffer originBuffer = ((VideoFrame.RgbaBuffer)inputFrame.getBuffer()).getData();
                    final int new_texture_id = VideoFrameBlender.createImageTexture(originBuffer, inputFrame.getRotatedWidth(), inputFrame.getRotatedHeight(), 6408);
                    GLES20.glFlush();
                    TextureBuffer buffer = new TextureBuffer(VideoFrameBlender.this.mEglBase.getEglBaseContext(), inputFrame.getRotatedWidth(), inputFrame.getRotatedHeight(), VideoFrame.TextureBuffer.Type.RGB, new_texture_id, RendererCommon.convertMatrixToAndroidGraphicsMatrix(GlUtil.IDENTITY_MATRIX), VideoFrameBlender.this.mBlenderHandler, VideoFrameBlender.this.yuvConverter, new Runnable(){

                        @Override
                        public void run() {
                            VideoFrameBlender.this.mBlenderHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    GLES20.glDeleteTextures((int)1, (int[])new int[]{new_texture_id}, (int)0);
                                }
                            });
                        }
                    });
                    return buffer;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "uploadImageSourceToTexture faild for " + e.toString());
            return buffer;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void releaseBlenderResource() {
        Object object = this.mSourceLock;
        synchronized (object) {
            this.mVideoSourceLayouts.clear();
            for (Map.Entry<String, VideoFrame> entry : this.mVideoSources.entrySet()) {
                entry.getValue().release();
            }
            this.mVideoSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTextureBuffer() {
        int[] values = new int[1];
        if (this.mVideoBufferId > 0) {
            values[0] = this.mVideoBufferId;
            GLES20.glDeleteTextures((int)1, (int[])values, (int)0);
            this.mVideoBufferId = -1;
        }
        if (this.mFramebuffer > 0) {
            values[0] = this.mFramebuffer;
            Object object = EglBase.lock;
            synchronized (object) {
                GLES20.glDeleteFramebuffers((int)1, (int[])values, (int)0);
            }
            this.mFramebuffer = -1;
        }
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public void releaseBlender() {
        if (this.mBlenderHandler == null) {
            return;
        }
        this.isBlenderRelased = true;
        this.releaseBlenderResource();
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Logging.d(VideoFrameBlender.TAG, "release egl resources on render thread");
                    if (VideoFrameBlender.this.mEglBase != null) {
                        try {
                            VideoFrameBlender.this.mEglBase.makeCurrent();
                        }
                        catch (RuntimeException e) {
                            Logging.d(VideoFrameBlender.TAG, "releaseBlender failed to make current");
                        }
                    }
                    VideoFrameBlender.this.yuvConverter.release();
                    Logging.d(VideoFrameBlender.TAG, "release texture resources on render thread");
                    VideoFrameBlender.this.releaseTextureBuffer();
                    Object object = EglBase.lock;
                    synchronized (object) {
                        GLES20.glUseProgram((int)0);
                    }
                    if (VideoFrameBlender.this.mEglBase != null) {
                        Logging.d(VideoFrameBlender.TAG, "releaseBlender detachCurrent");
                        VideoFrameBlender.this.mEglBase.detachCurrent();
                        VideoFrameBlender.this.mEglBase.release();
                        VideoFrameBlender.this.mEglBase = null;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "releaseBlender faild for " + e.toString());
        }
        this.mBlenderHandler.getLooper().quitSafely();
    }

    public static int createImageTexture(ByteBuffer data, int width, int height, int format) {
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        int textureHandle = textureHandles[0];
        GlUtil.checkNoGLES2Error("glGenTextures");
        GLES20.glBindTexture((int)3553, (int)textureHandle);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlUtil.checkNoGLES2Error("loadImageTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, (Buffer)data);
        GlUtil.checkNoGLES2Error("loadImageTexture");
        return textureHandle;
    }

    public static Bitmap getTexture2DImage(int textureID, int width, int height) {
        try {
            int[] oldFboId = new int[1];
            GLES20.glGetIntegerv((int)36006, (IntBuffer)IntBuffer.wrap(oldFboId));
            int[] framebuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])framebuffers, (int)0);
            int framebufferId = framebuffers[0];
            GLES20.glBindFramebuffer((int)36160, (int)framebufferId);
            int[] renderbuffers = new int[1];
            GLES20.glGenRenderbuffers((int)1, (int[])renderbuffers, (int)0);
            int renderId = renderbuffers[0];
            GLES20.glBindRenderbuffer((int)36161, (int)renderId);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureID, (int)0);
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)renderId);
            if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
                Logging.e(TAG, "Framebuffer error");
            }
            ByteBuffer rgbaBuf = ByteBuffer.allocateDirect(width * height * 4);
            rgbaBuf.position(0);
            GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)rgbaBuf);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)rgbaBuf);
            GLES20.glDeleteRenderbuffers((int)1, (IntBuffer)IntBuffer.wrap(framebuffers));
            GLES20.glDeleteFramebuffers((int)1, (IntBuffer)IntBuffer.allocate(framebufferId));
            GLES20.glBindFramebuffer((int)36160, (int)oldFboId[0]);
            return bitmap;
        }
        catch (Exception e) {
            Logging.e(TAG, e.toString());
            return null;
        }
    }
}

