/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import io.agora.base.internal.CalledByNative;
import java.util.ArrayList;
import java.util.List;

public class YuvConverterStats {
    private static final float CONFIDENCE_LEVEL_99_Z = 2.576f;
    private static final long STATS_SAMPLE_COUNT = 240L;
    private final int width;
    private final int height;
    private final YuvConvertMethod method;
    private final List<Integer> timeSpentUsCache = new ArrayList<Integer>();
    private float calLowerBound = 0.0f;
    private float calUpperBound = 0.0f;
    private int calAvgUs = 0;
    private int calMaxUs = 0;

    YuvConverterStats(int width, int height, YuvConvertMethod method) {
        this.width = width;
        this.height = height;
        this.method = method;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getMethod() {
        return this.method.value;
    }

    @CalledByNative
    private int getAvgUs() {
        return this.calAvgUs;
    }

    @CalledByNative
    private int getMaxUs() {
        return this.calMaxUs;
    }

    boolean stats(int timeSpentUs) {
        this.timeSpentUsCache.add(timeSpentUs);
        if ((long)this.timeSpentUsCache.size() >= 240L) {
            int[] samples = new int[this.timeSpentUsCache.size()];
            for (int i = 0; i < this.timeSpentUsCache.size(); ++i) {
                samples[i] = this.timeSpentUsCache.get(i);
            }
            float avgUs = YuvConverterStats.CalculateMean(samples);
            int maxUs = YuvConverterStats.CalculateMax(samples);
            boolean shouldReport = false;
            if (avgUs < this.calLowerBound || avgUs > this.calUpperBound) {
                float[] bound = YuvConverterStats.CalculateConfidenceBound(samples);
                this.calLowerBound = bound[0];
                this.calUpperBound = bound[1];
                this.calAvgUs = (int)avgUs;
                this.calMaxUs = maxUs;
                shouldReport = true;
            }
            this.timeSpentUsCache.clear();
            return shouldReport;
        }
        return false;
    }

    private static float[] CalculateConfidenceBound(int[] samples) {
        float mean = YuvConverterStats.CalculateMean(samples);
        float stdDev = YuvConverterStats.CalculateStandardDeviation(samples, mean);
        float marginOfError = (float)((double)2.576f * ((double)stdDev / Math.sqrt(samples.length)));
        float lowerBound = mean - marginOfError;
        float upperBound = mean + marginOfError;
        return new float[]{lowerBound, upperBound};
    }

    private static int CalculateMax(int[] samples) {
        int max = 0;
        for (int sample : samples) {
            max = Math.max(max, sample);
        }
        return max;
    }

    private static float CalculateMean(int[] samples) {
        long sum = 0L;
        for (int sample : samples) {
            sum += (long)sample;
        }
        return (float)sum * 1.0f / (float)samples.length;
    }

    private static float CalculateStandardDeviation(int[] samples, float mean) {
        long sum = 0L;
        for (int sample : samples) {
            sum += (long)Math.pow((float)sample - mean, 2.0);
        }
        return (float)Math.sqrt((float)sum * 1.0f / (float)(samples.length - 1));
    }

    static enum YuvConvertMethod {
        GL_READ_PIXELS(0),
        PBO(1);

        final int value;

        private YuvConvertMethod(int value) {
            this.value = value;
        }
    }
}

