/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine.earmonitor;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.Logging;
import io.agora.base.internal.voiceengine.BuildInfo;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorFactory;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorUtils;
import io.agora.base.internal.voiceengine.earmonitor.IHardwareEarMonitor;

public class HardwareEarMonitorController
implements HardwareEarMonitorListener {
    private static final String TAG = HardwareEarMonitorController.class.getSimpleName();
    @Nullable
    private IHardwareEarMonitor mHardwareEarMonitor = null;
    private int mHardwareEarMonitorState = 0;
    private boolean mHardwareEarMonitorSupported = false;

    public HardwareEarMonitorController(boolean enable) {
        if (!enable) {
            Logging.w(TAG, "config to disable hw earmonitor success");
            return;
        }
        String build = BuildInfo.getDeviceManufacturer();
        Logging.w(TAG, "device manufacturer is: " + build);
        this.mHardwareEarMonitor = HardwareEarMonitorFactory.create(build.trim().toLowerCase(), this);
    }

    public void initialize() {
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitorState = 1;
            this.mHardwareEarMonitor.initialize();
        }
    }

    @VisibleForTesting
    void setHardwareEarMonitor(IHardwareEarMonitor mHardwareEarMonitor) {
        this.mHardwareEarMonitor = mHardwareEarMonitor;
    }

    public boolean isHardwareEarMonitorSupported() {
        Logging.w(TAG, HardwareEarMonitorUtils.getDescriptionByState(this.mHardwareEarMonitorState));
        if (this.mHardwareEarMonitorState == 3) {
            return this.mHardwareEarMonitorSupported;
        }
        return false;
    }

    public int enableHardwareEarMonitor(boolean enable) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.enableHardwareEarMonitor(enable);
        }
        return -7;
    }

    public int setHardwareEarMonitorVolume(int vol) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.setHardwareEarMonitorVolume(vol);
        }
        return -7;
    }

    public void terminate() {
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitor.destroy();
            this.mHardwareEarMonitor = null;
        }
    }

    @Override
    public void onInitResult(int res) {
        Logging.w(TAG, "onInitResult: " + res);
        this.mHardwareEarMonitorState = 3;
        if (res == 2) {
            this.mHardwareEarMonitorState = 2;
            this.mHardwareEarMonitorSupported = false;
        }
    }

    @Override
    public void onHardwareEarMonitorSupported(boolean supported) {
        this.mHardwareEarMonitorSupported = supported;
    }
}

