/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.voiceengine.WebRtcAudioRecord;
import io.agora.base.internal.voiceengine.WebRtcAudioTrack;
import io.agora.rtc2.internal.AudioDeviceInventoryLowerThanM;
import io.agora.rtc2.internal.AudioDeviceInventoryMocker;
import io.agora.rtc2.internal.AudioDeviceInventoryMorHigher;
import io.agora.utils2.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private static final int UNINIT = 0;
    private static final int START = 1;
    private static final int STOP = 2;
    private static final int ERROR = 4;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private final WeakReference<Context> mContext;
    private long mNativeHandle;
    @NonNull
    private final ThreadUtils.ThreadChecker mThreadChecker;
    private EventHandler mEventHandler;
    private AudioDeviceInventory mAudioDeviceInventory;
    private int mVersionInUsed;
    private ControllerState mState;
    private boolean mIsWiredHeadsetPlugged = false;
    private int mHeadsetType = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private int ROUTING_ATTR_SPEAKER_SWITCH_SUPPORT = 1;
    private int mCurrentRouting = -1;
    private int mDefaultRouting = 3;
    private int mForcedRouting = -1;
    private int mChannelProfile = -1;
    private int mEngineRole = -1;
    private boolean mPhoneInCall = false;
    private int mSpeakerCommVolume = -1;
    private int mForceUseA2dp = -1;
    private int mBtScoState = 3;
    private boolean mIsBTScoStarted = false;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 3000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 2;
    private int dynamic_timeout = 3000;
    private int mScoConnectionAttemps;
    private boolean mIsFreezed = false;
    public static final int DEVICE_OUT_EARPIECE = 1;
    public static final int DEVICE_OUT_SPEAKER = 2;
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static final int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static final int DEVICE_OUT_USB_DEVICE = 16384;
    public static final int DEVICE_OUT_USB_HEADSET = 0x4000000;
    public static final int DEVICE_OUTPUT_OUT_IP = 0x800000;
    private ControllerStopState mStopState = null;
    private ControllerStartState mStartState = null;
    private ControllerErrorState mErrorState = null;
    public static final int DEVICE_EVT_BT_OFF = 0;
    public static final int DEVICE_EVT_BT_RECONNECT = 1;
    public static final int SDK_INT_FOR_DEVICE_INVENTORY = 23;
    @Nullable
    private static AudioDeviceChangedSpecialMonitor deviceSpecialMonitor = null;
    private static AudioManager mockedAudioManager = null;
    private static MockedBroadcaseter mockedBroadcaster = null;
    private static boolean mockBlueToothEnable = false;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                AudioRoutingController.this.bluetoothTimeout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    @Nullable
    private ControllerAudioDeviceChangeCallback ctrlAudioDeviceCb = null;
    private boolean mDisposed = false;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET = 2;
    private static final int EVT_BT_SCO = 3;
    private static final int EVT_USB = 4;
    private static final int EVT_USB_HEADSET = 5;
    private static final int EVT_HDMI = 6;
    public static final int CMD_SET_DEFAULT_ROUTING = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_START_BT_SCO = 15;
    public static final int CMD_FORCE_TO_A2DP = 16;
    public static final int EVT_CHANNEL_PROFILE = 20;
    public static final int EVT_ENGINE_ROLE_CHANGED = 21;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    private static final int EVT_BT_HEADSET_RECONNECT = 23;
    private static final int CMD_SET_PREFER_ROUTING = 25;
    private static final int CMD_SET_ROUTING_FREEZE = 26;
    private static final SparseIntArray ROUTE_TYPE_TO_EVT = new SparseIntArray();
    AudioManagerScoStateReceiver mScoStateReceiver = null;
    public static final int AUDIO_DEVICE_EVENT_FALLBACK_TO_A2DP = 4;

    public static void setAudioDeviceChangedSpecialMonitor(AudioDeviceChangedSpecialMonitor specialMonitor) {
        Logging.i(TAG, "setAudioDeviceChangedSpecialMonitor");
        deviceSpecialMonitor = specialMonitor;
    }

    @VisibleForTesting
    public static void setMockedAudioManager(AudioManager mockedAudioManager) {
        AudioRoutingController.mockedAudioManager = mockedAudioManager;
    }

    @VisibleForTesting
    public static void setMockedBroadcaster(MockedBroadcaseter mockedBroadcaster) {
        AudioRoutingController.mockedBroadcaster = mockedBroadcaster;
        AudioDeviceInventoryMocker.setMockedBroadcaster(mockedBroadcaster);
    }

    @VisibleForTesting
    public static void setMockBlueToothEnable(boolean mockBlueToothEnable) {
        AudioRoutingController.mockBlueToothEnable = mockBlueToothEnable;
    }

    private void startTimer() {
        this.dynamic_timeout += 3000 * this.mScoConnectionAttemps;
        Logging.w(TAG, "start bluetooth timer " + this.dynamic_timeout);
        this.mEventHandler.postDelayed(this.bluetoothTimeoutRunnable, 3000L);
    }

    private void cancelTimer() {
        this.mScoConnectionAttemps = 0;
        Logging.d(TAG, "cancel bluetooth timer");
        this.mEventHandler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private ControllerState changeState(int state) {
        if (state == 2) {
            if (this.mStopState == null) {
                this.mStopState = new ControllerStopState();
            } else {
                this.mStopState.reset();
            }
            return this.mStopState;
        }
        if (state == 1) {
            if (this.mStartState == null) {
                this.mStartState = new ControllerStartState();
            } else {
                this.mStartState.reset();
            }
            return this.mStartState;
        }
        if (this.mErrorState == null) {
            this.mErrorState = new ControllerErrorState();
        } else {
            this.mErrorState.reset();
        }
        return this.mErrorState;
    }

    @CalledByNative
    public AudioRoutingController(Context context, long handle) {
        this.mContext = new WeakReference<Context>(context);
        this.mNativeHandle = handle;
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        this.mVersionInUsed = Build.VERSION.SDK_INT >= 23 ? 1 : 0;
    }

    @CalledByNative
    public long getNativeHandle() {
        this.mThreadChecker.checkIsOnValidThread();
        return this.mNativeHandle;
    }

    @CalledByNative
    public boolean checkVersion(int version) {
        boolean change = false;
        if (this.mVersionInUsed == 0 && version == 1 && Build.VERSION.SDK_INT >= 23 || this.mVersionInUsed == 1 && version == 0) {
            this.mVersionInUsed = version;
            change = true;
        }
        if (change) {
            this.dispose();
            this.initialize();
        }
        return change;
    }

    @CalledByNative
    public int initialize() {
        Logging.i(TAG, "AudioRoutingController initialize+ (Android: " + Build.VERSION.SDK_INT + ")");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            Logging.e(TAG, "context has been GCed");
            return -1;
        }
        AudioManager am = this.getAudioManager();
        if (am == null) {
            Logging.e(TAG, "invalid context: can't get AudioManager");
            return -1;
        }
        this.ctrlAudioDeviceCb = new ControllerAudioDeviceChangeCallback();
        WebRtcAudioRecord.setRecordRouteCallback(this.ctrlAudioDeviceCb);
        WebRtcAudioTrack.setTrackRouteCallback(this.ctrlAudioDeviceCb);
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mEventHandler = new EventHandler(handlerThread.getLooper());
        this.mAudioDeviceInventory = mockedBroadcaster != null ? new AudioDeviceInventoryMocker() : (this.mVersionInUsed == 1 && Build.VERSION.SDK_INT >= 23 ? new AudioDeviceInventoryMorHigher(context) : new AudioDeviceInventoryLowerThanM(context));
        this.mAudioDeviceInventory.setAudioDeviceChangeCallback(new AudioDeviceChangedCallbackImpl());
        this.mAudioDeviceInventory.initialize();
        if (this.mAudioDeviceInventory.isDeviceAvaliable(0)) {
            this.mIsWiredHeadsetPlugged = true;
            this.mHeadsetType = 0;
        } else if (this.mAudioDeviceInventory.isDeviceAvaliable(2)) {
            this.mIsWiredHeadsetPlugged = true;
            this.mHeadsetType = 2;
        }
        this.mIsBTHeadsetPlugged = this.mAudioDeviceInventory.isDeviceAvaliable(5);
        this.mBtScoState = am.isBluetoothScoOn() ? 1 : 3;
        Logging.i(TAG, "Headset state: " + this.mIsWiredHeadsetPlugged + "(type:" + this.mHeadsetType + "), BT state:" + this.mIsBTHeadsetPlugged + "(sco: " + (this.mBtScoState == 1 ? " enable " : " disable") + ")");
        this.mScoStateReceiver = new AudioManagerScoStateReceiver();
        IntentFilter it = new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        context.registerReceiver((BroadcastReceiver)this.mScoStateReceiver, it);
        if (mockedBroadcaster != null) {
            mockedBroadcaster.registerReceiver(this.mScoStateReceiver, it);
        }
        this.mScoStateReceiver.setRegistered(true);
        this.mDisposed = false;
        this.mState = this.changeState(2);
        this.setupHotPlugDeviceInitValue();
        Logging.i(TAG, "AudioRoutingController initialize-");
        return 0;
    }

    private void setupHotPlugDeviceInitValue() {
        int targetRouting = -1;
        if (this.mIsBTHeadsetPlugged) {
            targetRouting = 5;
        } else if (this.mIsWiredHeadsetPlugged) {
            targetRouting = this.mHeadsetType;
        } else if (this.mAudioDeviceInventory.isDeviceAvaliable(6)) {
            targetRouting = 6;
        }
        if (targetRouting != -1) {
            this.notifyAudioRoutingChanged(targetRouting);
        }
    }

    @CalledByNative
    public String getCurrentUsbAudioDeviceVID(int mic_or_spk) {
        String retVid = null;
        if (deviceSpecialMonitor != null) {
            retVid = deviceSpecialMonitor.GetUSBDeviceVID(mic_or_spk);
        }
        Logging.d(TAG, String.format("getVIDFromNative: mic_or_spk=%d, vid=%s", mic_or_spk, retVid == null ? "null" : retVid));
        return retVid;
    }

    @CalledByNative
    public String getCurrentUsbAudioDevicePID(int mic_or_spk) {
        String retPid = null;
        if (deviceSpecialMonitor != null) {
            retPid = deviceSpecialMonitor.GetUSBDevicePID(mic_or_spk);
        }
        Logging.d(TAG, String.format("getPIDFromNative: mic_or_spk=%d, pid=%s", mic_or_spk, retPid == null ? "null" : retPid));
        return retPid;
    }

    @CalledByNative
    public void dispose() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        this.mNativeHandle = 0L;
        if (this.mAudioDeviceInventory != null) {
            this.mAudioDeviceInventory.dispose();
        }
        try {
            if (this.mScoStateReceiver != null && this.mScoStateReceiver.getRegistered()) {
                Context context;
                if (mockedBroadcaster != null) {
                    mockedBroadcaster.unRegisterReceiver(this.mScoStateReceiver);
                }
                if ((context = (Context)this.mContext.get()) != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mScoStateReceiver);
                }
                this.mScoStateReceiver.setRegistered(false);
            }
            this.mEventHandler.getLooper().quit();
        }
        catch (Exception e) {
            Logging.e(TAG, "AudioRoutingController dispose fail: ", e);
        }
        Logging.d(TAG, "dispose");
    }

    @CalledByNative
    public int startMonitoring() {
        Logging.d(TAG, "startMonitoring()");
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AudioRoutingController.this.mState != null) {
                    AudioRoutingController.this.mState.setState(1);
                }
            }
        });
        int targetRouting = this.mIsBTHeadsetPlugged ? 5 : (this.mIsWiredHeadsetPlugged ? this.mHeadsetType : (this.mAudioDeviceInventory.isDeviceAvaliable(6) ? 6 : this.mDefaultRouting));
        return targetRouting;
    }

    @CalledByNative
    public void stopMonitoring() {
        Logging.d(TAG, "stopMonitoring()");
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AudioRoutingController.this.mState != null) {
                    AudioRoutingController.this.mState.setState(2);
                }
            }
        });
    }

    @CalledByNative
    public void sendEvent(int event, int arg) {
        Logging.d(TAG, "sendEvent: [" + event + "], extra arg: " + arg + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(event, arg, 0);
            this.mEventHandler.sendMessage(m);
        }
    }

    private AudioManager getAudioManager() {
        if (mockedAudioManager != null) {
            return mockedAudioManager;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int routing) {
        Logging.i(TAG, "Enter notifyAudioRoutingChanged: " + routing + ", force a2dp: " + this.mForceUseA2dp);
        if (this.mDisposed) {
            Logging.w(TAG, "notifyAudioRoutingChanged returned cause of disposed");
            return;
        }
        int nativeRouting = routing;
        if (routing == 5 && this.mForceUseA2dp == 1 && mockedBroadcaster == null) {
            AudioManager am = this.getAudioManager();
            nativeRouting = 10;
            if (am != null && !am.isBluetoothA2dpOn()) {
                Logging.w(TAG, "callback A2DP but its not stable yet");
            }
        }
        this.nativeAudioRoutingChanged(nativeRouting);
    }

    private int doSetAudioOutputRouting(int routing) {
        Logging.i(TAG, "Set audio output routing from " + this.getAudioRouteDesc(this.mCurrentRouting) + " to " + this.getAudioRouteDesc(routing));
        if (this.mIsFreezed) {
            Logging.i(TAG, "Ignore set routing for freezed");
            return 0;
        }
        try {
            AudioManager am = this.getAudioManager();
            if (am != null) {
                am.setSpeakerphoneOn(routing == 3);
            }
            if (this.queryCurrentAudioRouting() != routing) {
                int current = this.queryCurrentAudioRouting();
                Logging.i(TAG, "Different audio routing from target " + routing + ", actual routing: " + current + "[" + this.getAudioRouteDesc(current) + "]");
            }
            this.updateBluetoothSco(routing);
            if (routing == this.mCurrentRouting) {
                Logging.i(TAG, "Audio routing not changed, ignore: " + routing);
                return 0;
            }
            this.mCurrentRouting = routing;
            this.notifyAudioRoutingChanged(routing);
        }
        catch (Exception e) {
            Logging.e(TAG, "Set audio output routing failed:", e);
        }
        return 0;
    }

    private int updateBluetoothSco(int targetRouting) {
        if (this.mPhoneInCall) {
            Logging.d(TAG, "Not process updateBluetoothSco in call");
            return 0;
        }
        if (this.mIsFreezed) {
            Logging.i(TAG, "update bluetoosh sco ignore for freezed");
            return 0;
        }
        Logging.d(TAG, "Update sco control, current sco : " + this.mIsBTScoStarted + ", audio route target: " + targetRouting + "[" + this.getAudioRouteDesc(targetRouting) + "] current: " + this.mCurrentRouting + "[" + this.getAudioRouteDesc(this.mCurrentRouting) + "]");
        if (targetRouting == 5) {
            if (this.mForceUseA2dp == 0) {
                Logging.i(TAG, "Enable hfp");
                this.mIsBTScoStarted = true;
                this.startTimer();
                this.startBtSco();
            } else if (this.mIsBTScoStarted) {
                Logging.i(TAG, "Enable a2dp");
                this.mIsBTScoStarted = false;
                this.cancelTimer();
                this.stopBtSco();
            }
        } else if (this.mCurrentRouting == 5 && this.mIsBTScoStarted) {
            this.mIsBTScoStarted = false;
            this.cancelTimer();
            this.stopBtSco();
        }
        return 0;
    }

    private void startBtSco() {
        AudioManager am = this.getAudioManager();
        if (am != null) {
            int mode = am.getMode();
            Logging.i(TAG, "Start opening bt sco " + this.mScoConnectionAttemps + " " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
            this.mBtScoState = 0;
            this.doStartBTSco(am);
        }
    }

    private String modeAsString(int mode) {
        String modeAsString;
        switch (mode) {
            case 0: {
                modeAsString = "MODE_NORMAL";
                break;
            }
            case 1: {
                modeAsString = "MODE_RINGTONE";
                break;
            }
            case 2: {
                modeAsString = "MODE_IN_CALL";
                break;
            }
            case 3: {
                modeAsString = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                modeAsString = "Unknown " + mode;
            }
        }
        return modeAsString;
    }

    private String btStateAsString(int state) {
        String btStateAsString;
        switch (state) {
            case 0: {
                btStateAsString = "SCO_CONNECTING";
                break;
            }
            case 1: {
                btStateAsString = "SCO_CONNECTED";
                break;
            }
            case 2: {
                btStateAsString = "SCO_DISCONNECTING";
                break;
            }
            case 3: {
                btStateAsString = "SCO_DISCONNECTED";
                break;
            }
            default: {
                btStateAsString = "Unknown " + state;
            }
        }
        return btStateAsString;
    }

    private String evtAsString(int evt) {
        String evtString;
        switch (evt) {
            case 1: {
                evtString = "EVT_HEADSET";
                break;
            }
            case 2: {
                evtString = "EVT_BT_HEADSET";
                break;
            }
            case 3: {
                evtString = "EVT_BT_SCO";
                break;
            }
            case 10: {
                evtString = "CMD_SET_DEFAULT_ROUTING";
                break;
            }
            case 11: {
                evtString = "CMD_FORCE_TO_SPEAKER";
                break;
            }
            case 16: {
                evtString = "CMD_FORCE_TO_A2DP";
                break;
            }
            case 20: {
                evtString = "EVT_CHANNEL_PROFILE";
                break;
            }
            case 22: {
                evtString = "EVT_PHONE_STATE_CHANGED";
                break;
            }
            case 4: {
                evtString = "EVT_USB";
                break;
            }
            case 26: {
                evtString = "CMD_SET_ROUTING_FREEZE";
                break;
            }
            default: {
                evtString = "evt " + evt;
            }
        }
        return evtString;
    }

    private void doStartBTSco(AudioManager am) {
        try {
            int mode = am.getMode();
            Logging.i(TAG, "doStartBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn() + " " + mode + "[" + this.modeAsString(mode) + "]");
            if (am.isBluetoothScoOn()) {
                am.stopBluetoothSco();
                Thread.sleep(600L);
                Logging.i(TAG, "doStartBTSco in sco already on, try stop old connect firstly!");
            }
            am.startBluetoothSco();
        }
        catch (Exception e) {
            Logging.e(TAG, "doStartBTSco fail ", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doStopBTSco(AudioManager am) {
        Logging.i(TAG, "doStopBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn());
        try {
            am.stopBluetoothSco();
            if (Build.VERSION.SDK_INT >= 22) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopBtSco() {
        if (this.mIsFreezed) {
            Logging.i(TAG, "stop sco ignored for freezed");
            return;
        }
        AudioManager am = this.getAudioManager();
        if (am != null) {
            int mode = am.getMode();
            Logging.i(TAG, "try to stopping bt sco " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
            this.mBtScoState = !am.isBluetoothScoOn() ? 3 : 2;
            this.doStopBTSco(am);
        }
    }

    private void checkFallbackA2dpIfNeed() {
        AudioManager am = this.getAudioManager();
        if (am == null || !this.mIsBTHeadsetPlugged || !am.isBluetoothA2dpOn()) {
            Logging.i(TAG, "could not use a2dp also..");
            this.mIsBTHeadsetPlugged = false;
            this.resetAudioRouting();
            return;
        }
        this.nativeAudioRoutingCallbackEvent(4);
    }

    private void bluetoothTimeout() {
        AudioManager am = this.getAudioManager();
        boolean scoConnected = false;
        if (am != null) {
            scoConnected = am.isBluetoothScoOn();
        }
        if (this.mScoConnectionAttemps < 2) {
            Logging.i(TAG, "Attemps trying, bt sco started: " + this.mIsBTScoStarted + " sco connected: " + scoConnected + " " + this.mScoConnectionAttemps + " times " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "]");
            if (!scoConnected) {
                this.startTimer();
                ++this.mScoConnectionAttemps;
                this.stopBtSco();
                am.stopBluetoothSco();
                this.doStartBTSco(am);
            } else {
                Logging.d(TAG, "Soc connected success.");
                this.cancelTimer();
            }
        } else {
            Logging.e(TAG, "Start bluetooth sco timeout, actual routing: " + this.queryCurrentAudioRouting());
            this.cancelTimer();
            this.nativeAudioRoutingError(1030);
            this.checkFallbackA2dpIfNeed();
        }
    }

    private int getOutputDevicesByStream(int stream) {
        AudioManager am = this.getAudioManager();
        int devices = 0;
        try {
            Method method = AudioManager.class.getMethod("getDevicesForStream", Integer.TYPE);
            devices = (Integer)method.invoke((Object)am, stream);
        }
        catch (Exception error) {
            Logging.e(TAG, "Error while getDevicesForStream! ", error);
        }
        return devices;
    }

    private int getSdkDeviceByAndroidType(int devices) {
        int sdkdevices;
        switch (devices) {
            case 128: 
            case 256: 
            case 512: {
                sdkdevices = 5;
                break;
            }
            case 4: {
                sdkdevices = 0;
                break;
            }
            case 8: {
                sdkdevices = 2;
                break;
            }
            case 16384: 
            case 0x4000000: {
                sdkdevices = 6;
                break;
            }
            case 1024: {
                sdkdevices = 7;
                break;
            }
            case 2: {
                sdkdevices = 3;
                break;
            }
            default: {
                sdkdevices = (devices & 0x800000) != 0 ? 6 : 3;
            }
        }
        return sdkdevices;
    }

    private void selectRoutingForCommunication(int route) {
        AudioManager am = this.getAudioManager();
        if (am == null || am.getMode() != 3) {
            return;
        }
        if (route == 1 && am.isWiredHeadsetOn()) {
            return;
        }
        Logging.i(TAG, "Api select prefer communication route: " + route);
        switch (route) {
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                if (this.mAudioDeviceInventory.isDeviceAvaliable(route)) break;
                Logging.w(TAG, "Selected route is not connected");
                return;
            }
            case 1: 
            case 3: {
                break;
            }
            default: {
                route = -1;
            }
        }
        if (route != -1) {
            this.doSetAudioOutputRouting(route);
        }
    }

    private void resetAudioRouting() {
        int targetRouting;
        if (this.mIsBTHeadsetPlugged && this.mIsWiredHeadsetPlugged) {
            AudioManager am = this.getAudioManager();
            int mode = am == null ? 0 : am.getMode();
            int streamType = mode == 0 ? 3 : 0;
            int androidRouting = this.getOutputDevicesByStream(streamType);
            targetRouting = this.getSdkDeviceByAndroidType(androidRouting);
            Logging.i(TAG, "In multidevice connect, query target: " + targetRouting + ", " + androidRouting);
            if (targetRouting != 5 && targetRouting != this.mHeadsetType) {
                targetRouting = 5;
            }
        } else {
            targetRouting = this.mIsBTHeadsetPlugged ? 5 : (this.mIsWiredHeadsetPlugged ? this.mHeadsetType : (this.mForcedRouting != -1 ? this.mForcedRouting : this.mDefaultRouting));
        }
        Logging.i(TAG, "Reset audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(targetRouting) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
        if (this.mCurrentRouting != targetRouting || this.queryCurrentAudioRouting() != this.mCurrentRouting) {
            this.doSetAudioOutputRouting(targetRouting);
        }
    }

    private String getAudioRouteDesc(int route) {
        switch (route) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "Default";
            }
            case 6: {
                return "USBDevice";
            }
            case 8: {
                return "USB_HEADSET";
            }
        }
        return "Unknown";
    }

    @CalledByNative
    public int queryCurrentAudioRouting() {
        AudioManager am = this.getAudioManager();
        try {
            int streamType;
            int defaultDevice;
            if (am.isSpeakerphoneOn()) {
                return 3;
            }
            if (am.isBluetoothScoOn() || am.isBluetoothA2dpOn()) {
                return 5;
            }
            if (am.isWiredHeadsetOn()) {
                return 0;
            }
            if (am.getMode() == 0) {
                defaultDevice = 3;
                streamType = 3;
            } else {
                defaultDevice = 1;
                streamType = 0;
            }
            int androidDevice = this.getOutputDevicesByStream(streamType);
            int exDevice = this.getSdkDeviceByAndroidType(androidDevice);
            if (exDevice == 7 || exDevice == 6) {
                defaultDevice = exDevice;
            }
            return defaultDevice;
        }
        catch (Exception e) {
            Logging.e(TAG, "fatal error @queryCurrentAudioRouting", e);
            return -1;
        }
    }

    public int handleBluetoothHeadsetEvent(int info) {
        this.mIsBTHeadsetPlugged = info == 1;
        int route = this.mIsBTHeadsetPlugged ? 5 : this.queryCurrentAudioRouting();
        return route;
    }

    public int handleHeadsetEvent(int info) {
        AudioManager am = this.getAudioManager();
        if (am != null && am.isWiredHeadsetOn() && this.mIsWiredHeadsetPlugged && info < 0) {
            Logging.i(TAG, "not handle extra headset event, as headset still connect");
            return -1;
        }
        this.mHeadsetType = info;
        this.mIsWiredHeadsetPlugged = info >= 0;
        int route = this.mIsWiredHeadsetPlugged ? info : this.queryCurrentAudioRouting();
        return route;
    }

    private native void nativeAudioDeviceStateChanged(String var1, String var2, int var3, int var4);

    private native void nativeAudioRoutingChanged(int var1);

    private native void nativeAudioRoutingError(int var1);

    private native void nativeAudioRoutingCallbackEvent(int var1);

    static {
        ROUTE_TYPE_TO_EVT.put(0, 1);
        ROUTE_TYPE_TO_EVT.put(2, 1);
        ROUTE_TYPE_TO_EVT.put(5, 2);
        ROUTE_TYPE_TO_EVT.put(6, 4);
        ROUTE_TYPE_TO_EVT.put(7, 6);
    }

    private class AudioManagerScoStateReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private AudioManagerScoStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                int previousState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                Logging.i(AudioRoutingController.TAG, "Receive SCO state event, prev: " + previousState + ", curr: " + state);
                switch (state) {
                    case 1: {
                        Logging.i(AudioRoutingController.TAG, "SCO state connected");
                        AudioRoutingController.this.sendEvent(3, 1);
                        break;
                    }
                    case 0: {
                        Logging.i(AudioRoutingController.TAG, "SCO state disconnected");
                        AudioRoutingController.this.sendEvent(3, 0);
                        break;
                    }
                    default: {
                        Logging.i(AudioRoutingController.TAG, "SCO device unknown event, state=" + state);
                    }
                }
            }
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }
    }

    private class AudioDeviceChangedCallbackImpl
    implements AudioDeviceChangedCallback {
        private AudioDeviceChangedCallbackImpl() {
        }

        @Override
        public void onAudioDeviceChanged(boolean connect, int route) {
            int evt = ROUTE_TYPE_TO_EVT.get(route);
            if (evt == 0) {
                Logging.i(AudioRoutingController.TAG, "Not handle " + AudioRoutingController.this.getAudioRouteDesc(route) + " device event yet!");
                return;
            }
            int arg = route == 5 ? (connect ? 1 : 0) : (connect ? route : -1);
            AudioRoutingController.this.sendEvent(evt, arg);
            Logging.i(AudioRoutingController.TAG, "Device event: " + AudioRoutingController.this.evtAsString(evt) + ", arg: " + arg);
        }

        @Override
        public void onAudioDeviceEvent(int evt) {
            if (evt == 0) {
                AudioRoutingController.this.cancelTimer();
            } else if (evt == 1) {
                AudioRoutingController.this.sendEvent(23, 0);
            }
        }
    }

    public static interface AudioDeviceChangedCallback {
        public void onAudioDeviceChanged(boolean var1, int var2);

        public void onAudioDeviceEvent(int var1);
    }

    public static interface AudioDeviceInventory {
        public void initialize();

        public void dispose();

        public boolean isDeviceAvaliable(int var1);

        public void setAudioDeviceChangeCallback(AudioDeviceChangedCallback var1);
    }

    private class ControllerAudioDeviceChangeCallback
    implements WebRtcAudioRecord.AudioRecordRouteCallback,
    WebRtcAudioTrack.AudioTrackRouteCallback {
        private ControllerAudioDeviceChangeCallback() {
        }

        @Override
        public void onAudioRecordRouteNotify(int i, AudioDeviceInfo audioRecord) {
            Logging.i(AudioRoutingController.TAG, "[ADM] Enter ControllerAudioDeviceChangeCallback.onAudioRecordRouteNotify");
            if (deviceSpecialMonitor != null) {
                deviceSpecialMonitor.AudioDeviceChangeCallback(true, audioRecord);
                AudioRoutingController.this.nativeAudioDeviceStateChanged(Integer.toString(audioRecord.getId()), audioRecord.getProductName().toString(), 1, 1);
            }
        }

        @Override
        public void onAudioTrackRouteNotify(int i, AudioDeviceInfo audioTrack) {
            Logging.i(AudioRoutingController.TAG, "[ADM] Enter ControllerAudioDeviceChangeCallback.onAudioTrackRouteNotify");
            if (deviceSpecialMonitor != null) {
                deviceSpecialMonitor.AudioDeviceChangeCallback(false, audioTrack);
                AudioRoutingController.this.sendEvent(4, deviceSpecialMonitor.GetUSBRouteType());
            }
        }
    }

    private class ControllerErrorState
    extends ControllerBaseState {
        private ControllerErrorState() {
        }

        @Override
        public int getState() {
            return 4;
        }
    }

    private class ControllerStartState
    extends ControllerBaseState {
        public ControllerStartState() {
            this.resetImpl();
            Logging.i(AudioRoutingController.TAG, "ControllerStartState ctor, default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        private void resetImpl() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 1) {
                    AudioRoutingController.this.mDefaultRouting = 3;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 1;
                }
            }
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mForcedRouting = -1;
            AudioRoutingController.this.resetAudioRouting();
        }

        @Override
        public void reset() {
            this.resetImpl();
            Logging.i(AudioRoutingController.TAG, "Monitor reset: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public void onEvent(int event, int info) {
            Logging.d(AudioRoutingController.TAG, "StartState: onEvent: " + AudioRoutingController.this.evtAsString(event) + ", info: " + info);
            AudioManager am = AudioRoutingController.this.getAudioManager();
            switch (event) {
                case 1: {
                    if (info < 0) {
                        if (am != null && am.isWiredHeadsetOn()) {
                            return;
                        }
                        AudioRoutingController.this.mHeadsetType = info;
                        AudioRoutingController.this.mIsWiredHeadsetPlugged = false;
                    } else {
                        AudioRoutingController.this.mHeadsetType = info;
                        AudioRoutingController.this.mIsWiredHeadsetPlugged = true;
                    }
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged && AudioRoutingController.this.mCurrentRouting != info) {
                        AudioRoutingController.this.doSetAudioOutputRouting(info);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 11: {
                    if (AudioRoutingController.this.mCurrentRouting == 2 || AudioRoutingController.this.mCurrentRouting == 0 || AudioRoutingController.this.mCurrentRouting == 6 || AudioRoutingController.this.mCurrentRouting == 8 || AudioRoutingController.this.mCurrentRouting == 5) {
                        Logging.i(AudioRoutingController.TAG, "StartState: not proceed with force speaker event for BT/HS");
                        return;
                    }
                    AudioRoutingController.this.mForcedRouting = info == 1 ? 3 : 1;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    if (info == 1) {
                        AudioRoutingController.this.doSetAudioOutputRouting(3);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 2: {
                    if (info == 0 && !AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        return;
                    }
                    AudioRoutingController.this.mIsBTHeadsetPlugged = AudioRoutingController.this.mAudioDeviceInventory.isDeviceAvaliable(5) || info == 1;
                    Logging.i(AudioRoutingController.TAG, "Process BT event, final state: " + AudioRoutingController.this.mIsBTHeadsetPlugged + "(" + info + ")");
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(5);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 3: {
                    if (mockBlueToothEnable && am != null) {
                        am.setBluetoothScoOn(false);
                    }
                    AudioRoutingController.this.mBtScoState = info == 1 ? 1 : 2;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (info == 1) {
                        AudioRoutingController.this.mScoConnectionAttemps = 0;
                        break;
                    }
                    if (info != 0 || AudioRoutingController.this.mCurrentRouting != 5) break;
                    Logging.w(AudioRoutingController.TAG, "Sco disconnect when using Bluetooth device");
                    break;
                }
                case 10: {
                    AudioRoutingController.this.mDefaultRouting = info;
                    Logging.i(AudioRoutingController.TAG, "User set default routing to: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting));
                    break;
                }
                case 22: {
                    Logging.i(AudioRoutingController.TAG, "Phone state changed: " + info);
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    if (info == 0) {
                        AudioRoutingController.this.resetAudioRouting();
                        break;
                    }
                    AudioRoutingController.this.mCurrentRouting = -1;
                    break;
                }
                case 23: {
                    Logging.i(AudioRoutingController.TAG, "Try reconnect bt: ");
                    if (AudioRoutingController.this.mCurrentRouting != 5) break;
                    AudioRoutingController.this.doSetAudioOutputRouting(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (info == 6 || info == 7) {
                        AudioRoutingController.this.doSetAudioOutputRouting(info);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 25: {
                    AudioRoutingController.this.selectRoutingForCommunication(info);
                    break;
                }
                case 26: {
                    Logging.i(AudioRoutingController.TAG, "set routing freeze " + info);
                    if (info == 0) {
                        AudioRoutingController.this.mIsFreezed = false;
                        AudioRoutingController.this.resetAudioRouting();
                        break;
                    }
                    AudioRoutingController.this.mIsFreezed = true;
                    break;
                }
                default: {
                    super.onEvent(event, info);
                }
            }
        }
    }

    private class ControllerStopState
    extends ControllerBaseState {
        public ControllerStopState() {
            Logging.i(AudioRoutingController.TAG, "ControllerStopState ctor");
            AudioRoutingController.this.mIsBTScoStarted = false;
            AudioRoutingController.this.mCurrentRouting = -1;
        }

        @Override
        public int getState() {
            return 2;
        }

        private void resetImpl() {
            AudioRoutingController.this.cancelTimer();
            AudioManager am = AudioRoutingController.this.getAudioManager();
            if (AudioRoutingController.this.mIsBTScoStarted || am != null && am.isBluetoothScoOn()) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mCurrentRouting = -1;
        }

        @Override
        public void reset() {
            Logging.i(AudioRoutingController.TAG, "Monitor stop state, reset");
            this.resetImpl();
        }

        @Override
        public void onEvent(int evt, int info) {
            Logging.d(AudioRoutingController.TAG, "StopState: onEvent: " + AudioRoutingController.this.evtAsString(evt) + ", info: " + info);
            try {
                AudioManager am = AudioRoutingController.this.getAudioManager();
                switch (evt) {
                    case 11: {
                        am.setSpeakerphoneOn(info == 1);
                        AudioRoutingController.this.mCurrentRouting = info == 1 ? 3 : -1;
                        AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.queryCurrentAudioRouting());
                        break;
                    }
                    default: {
                        super.onEvent(evt, info);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logging.e(AudioRoutingController.TAG, "onEvent: Exception ", e);
            }
        }
    }

    private abstract class ControllerBaseState
    implements ControllerState {
        private ControllerBaseState() {
        }

        @Override
        public void setState(int state) {
            if (state == this.getState()) {
                Logging.i(AudioRoutingController.TAG, "setState: state not changed!");
                return;
            }
            AudioRoutingController.this.mState = AudioRoutingController.this.changeState(state);
        }

        @Override
        public void reset() {
            AudioRoutingController.this.resetAudioRouting();
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public void onEvent(int event, int info) {
            switch (event) {
                case 1: {
                    int route = AudioRoutingController.this.handleHeadsetEvent(info);
                    if (route == -1) {
                        return;
                    }
                    AudioRoutingController.this.notifyAudioRoutingChanged(route);
                    break;
                }
                case 20: {
                    AudioRoutingController.this.mChannelProfile = info;
                    break;
                }
                case 2: {
                    int route = AudioRoutingController.this.handleBluetoothHeadsetEvent(info);
                    AudioRoutingController.this.notifyAudioRoutingChanged(route);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    int route = info == 6 || info == 7 ? info : AudioRoutingController.this.queryCurrentAudioRouting();
                    AudioRoutingController.this.notifyAudioRoutingChanged(route);
                    break;
                }
                case 16: {
                    int prevA2dp = AudioRoutingController.this.mForceUseA2dp;
                    AudioRoutingController.this.mForceUseA2dp = info == 1 ? 1 : 0;
                    Logging.w(AudioRoutingController.TAG, "bluetooth protocol to: " + (AudioRoutingController.this.mForceUseA2dp == 1 ? "a2dp" : "hfp"));
                    AudioRoutingController.this.updateBluetoothSco(AudioRoutingController.this.mCurrentRouting);
                    if (AudioRoutingController.this.mForceUseA2dp == prevA2dp || AudioRoutingController.this.mCurrentRouting != 5) break;
                    AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 10: {
                    AudioRoutingController.this.mDefaultRouting = info;
                    Logging.i(AudioRoutingController.TAG, "User set default routing to: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting));
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    break;
                }
                case 26: {
                    AudioRoutingController.this.mIsFreezed = info > 0;
                    break;
                }
            }
        }
    }

    private static interface ControllerState {
        public void setState(int var1);

        public int getState();

        public void onEvent(int var1, int var2);

        public void reset();
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (AudioRoutingController.this.mState != null) {
                AudioRoutingController.this.mState.onEvent(msg.what, msg.arg1);
            }
        }
    }

    public static interface MockedBroadcaseter {
        public void registerReceiver(BroadcastReceiver var1, IntentFilter var2);

        public void unRegisterReceiver(BroadcastReceiver var1);
    }

    public static interface AudioDeviceChangedSpecialMonitor {
        public void AudioDeviceChangeCallback(boolean var1, AudioDeviceInfo var2);

        public String GetUSBDevicePID(int var1);

        public String GetUSBDeviceVID(int var1);

        public int GetUSBRouteType();
    }
}

