/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ATrace;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.YuvConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.microedition.khronos.egl.EGL10;

public class TextureBufferPool {
    private static final boolean VERBOSE = false;
    private static final String TAG = TextureBufferPool.class.getSimpleName();
    private static final AtomicInteger nextSeq = new AtomicInteger(0);
    private final String name;
    private final Handler handler;
    private final boolean ownGlThread;
    private final EglBase eglBase;
    private final EglBase.Context eglContext;
    private final YuvConverter yuvConverter;
    private final YuvConverter yuvConverterInternal = new YuvConverter();
    private final GlRectDrawer drawer;
    private boolean shrinkPool = true;
    private final int glPixelFormat;
    private final int maxBufferCnt;
    private final int keepBufferCnt;
    private final ArrayList<TextureInfo> textureInfoList = new ArrayList();
    private Runnable poolBufferReleaseCallback = null;
    private boolean isQuitting = false;
    private int dropCount = 0;
    private static int MAX_SYNC_OUT_TIME = 10000000;
    private static List<String> glFlushBuggyDevices = Arrays.asList("Pixel 7", "Redmi 4A", "Redmi 5A", "V2231A");
    private static boolean forceGlFinish = false;
    private static boolean useGlFence = true;
    public static AtomicInteger fenceCount = new AtomicInteger(0);

    @CalledByNative
    public static TextureBufferPool create(final String threadName, final EglBase.Context sharedContext, final int maxBufferCnt) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        final TextureBufferPool[] bufferPool = new TextureBufferPool[]{null};
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(handler, new Runnable(){

                @Override
                public void run() {
                    try {
                        EglBase newEglBase = TextureBufferPool.createEglAndMakeCurrent(sharedContext);
                        bufferPool[0] = new TextureBufferPool(threadName, maxBufferCnt, 6408, handler, true, newEglBase, sharedContext, null);
                    }
                    catch (RuntimeException e) {
                        Logging.e(TAG, threadName + " failed to initialize egl", e);
                        handler.getLooper().quit();
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " failed to initialize egl", e);
        }
        return bufferPool[0];
    }

    public static TextureBufferPool createWithinGlThread(String name, int maxBufferCnt, int glPixelFormat, Handler handler, EglBase eglBase, EglBase.Context sharedContext, YuvConverter yuvConverter, boolean shrinkPool) {
        return new TextureBufferPool(name, maxBufferCnt, glPixelFormat, handler, false, eglBase, sharedContext, yuvConverter, shrinkPool);
    }

    public static TextureBufferPool createWithinGlThread(String name, int maxBufferCnt, int glPixelFormat, Handler handler, EglBase eglBase, EglBase.Context sharedContext, YuvConverter yuvConverter) {
        return new TextureBufferPool(name, maxBufferCnt, glPixelFormat, handler, false, eglBase, sharedContext, yuvConverter);
    }

    private static EglBase createEglAndMakeCurrent(EglBase.Context sharedContext) {
        EglBase newEglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            newEglBase.createDummyPbufferSurface();
            newEglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            newEglBase.release();
            throw e;
        }
        return newEglBase;
    }

    private TextureBufferPool(String name, int maxBufferCnt, int glPixelFormat, Handler handler, boolean ownGlThread, EglBase eglBase, EglBase.Context sharedContext, YuvConverter yuvConverter, boolean shrinkPool) {
        this.name = name;
        this.maxBufferCnt = Math.max(maxBufferCnt, 1);
        this.shrinkPool = shrinkPool;
        this.keepBufferCnt = shrinkPool ? Math.min(this.maxBufferCnt, 3) : this.maxBufferCnt;
        this.glPixelFormat = glPixelFormat;
        this.handler = handler;
        this.ownGlThread = ownGlThread;
        this.eglBase = eglBase;
        this.yuvConverter = yuvConverter != null ? yuvConverter : this.yuvConverterInternal;
        this.eglContext = sharedContext != null ? sharedContext : eglBase.getEglBaseContext();
        this.drawer = new GlRectDrawer();
        Logging.i(TAG, name + " init buffer pool, ownGlThread: " + ownGlThread + " cnt: " + maxBufferCnt + " sharedContext: " + this.eglContext + " " + this);
    }

    private TextureBufferPool(String name, int maxBufferCnt, int glPixelFormat, Handler handler, boolean ownGlThread, EglBase eglBase, EglBase.Context sharedContext, YuvConverter yuvConverter) {
        this(name, maxBufferCnt, glPixelFormat, handler, ownGlThread, eglBase, sharedContext, yuvConverter, true);
    }

    public void setPoolBufferReleaseCallback(Runnable releaseCallback) {
        this.poolBufferReleaseCallback = releaseCallback;
    }

    @CalledByNative
    public VideoFrame.TextureBuffer textureCopy(VideoFrame.TextureBuffer textureBuffer, Runnable bufferReleaseCallback) {
        return this.textureCopy(textureBuffer, 0, bufferReleaseCallback);
    }

    public VideoFrame.TextureBuffer textureCopy(VideoFrame.TextureBuffer textureBuffer, int transfer, Runnable bufferReleaseCallback) {
        if (textureBuffer == null) {
            Logging.w(TAG, "textureCopy: " + this.name + " textureBuffer null");
            return null;
        }
        return this.textureCopy(textureBuffer.getTextureId(), textureBuffer.getType(), textureBuffer.getWidth(), textureBuffer.getHeight(), textureBuffer.getTransformMatrix(), textureBuffer.getFenceObject(), transfer, bufferReleaseCallback);
    }

    @Nullable
    public VideoFrame.TextureBuffer textureCopy(final int textureId, final VideoFrame.TextureBuffer.Type type, final int width, final int height, final Matrix transformMatrix, final long fenceObject, final int transfer, final Runnable bufferReleaseCallback) {
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() throws Exception {
                    return TextureBufferPool.this.doTextureCopy(textureId, type, width, height, transfer, transformMatrix, fenceObject, bufferReleaseCallback);
                }
            });
        }
        catch (Exception e) {
            Logging.w(TAG, "textureCopy faile: " + e.getMessage());
            return null;
        }
    }

    @CalledByNative
    public void dispose() {
        Logging.i(TAG, this.name + " dispose()");
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    TextureBufferPool.this.isQuitting = true;
                    if (!TextureBufferPool.this.anyTextureInUse()) {
                        Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no more buffer in flight");
                        TextureBufferPool.this.release();
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.i(TAG, this.name + " dispose fail: " + e.getMessage());
        }
    }

    @CalledByNative
    public void waitGlFenceIfNeeded(final long fenceSyncObject) {
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, 1000L, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TextureBufferPool.waitFenceSignal2(fenceSyncObject, TextureBufferPool.this.name);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @CalledByNative
    public void deleteGlFenceIfNeeded(final long fenceSyncObject) {
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, 1000L, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TextureBufferPool.deleteFenceObject(fenceSyncObject, TextureBufferPool.this.name);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getGLFenceObject() {
        if (Build.VERSION.SDK_INT >= 21) {
            long result = GLES30.glFenceSync((int)37143, (int)0);
            if (result != 0L) {
                GLES30.glFlush();
            }
            return result;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFenceObject(long fenceObject, String name) {
        if (Build.VERSION.SDK_INT >= 21 && fenceObject != 0L) {
            Object object = EglBase.lock;
            synchronized (object) {
                if (GLES30.glIsSync((long)fenceObject)) {
                    GLES30.glDeleteSync((long)fenceObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitFenceSignal(long fenceSyncObject, String name) {
        long startMs = System.currentTimeMillis();
        if (Build.VERSION.SDK_INT < 21) return false;
        if (fenceSyncObject == 0L) return false;
        if (!GLES30.glIsSync((long)fenceSyncObject)) return false;
        int result = GLES30.glClientWaitSync((long)fenceSyncObject, (int)1, (long)MAX_SYNC_OUT_TIME);
        switch (result) {
            case 37146: {
                return true;
            }
            case 37148: {
                return true;
            }
            case 37147: {
                return false;
            }
            case 37149: {
                int errorCode = EGL14.eglGetError();
                Logging.e(TAG, "waitFenceSignal error:" + errorCode);
                return false;
            }
            default: {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFenceSignal2(long fenceSyncObject, String name) {
        block7: {
            long startMs = System.currentTimeMillis();
            if (Build.VERSION.SDK_INT < 21 || fenceSyncObject == 0L) break block7;
            Object object = EglBase.lock;
            synchronized (object) {
                if (GLES30.glIsSync((long)fenceSyncObject)) {
                    GLES30.glWaitSync((long)fenceSyncObject, (int)0, (long)-1L);
                }
            }
            boolean bl = true;
            return bl;
        }
        boolean bl = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoFrame.TextureBuffer doTextureCopy(int srcTextureId, VideoFrame.TextureBuffer.Type srcType, int width, int height, int transfer, Matrix transformMatrix, long fenceObject, final Runnable bufferReleaseCallback) {
        TextureBuffer[] ret;
        TextureInfo texInfo;
        if (this.eglContext instanceof EglBase10.Context && ((EglBase10.Context)this.eglContext).getEglContext().equals(EGL10.EGL_NO_CONTEXT)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17 && this.eglContext instanceof EglBase14.Context && ((EglBase14.Context)this.eglContext).getEglContext().equals((Object)EGL14.EGL_NO_CONTEXT)) {
            return null;
        }
        if (fenceObject != 0L) {
            TextureBufferPool.waitFenceSignal2(fenceObject, this.name);
        }
        if ((texInfo = this.acquireTextureFramebuffer()) == null) {
            Logging.w(TAG, this.name + "acquireTextureFramebuffer failed!");
            return null;
        }
        ATrace.beginSection("setupTextureFrameBuffer");
        boolean success = this.setupTextureFrameBuffer(texInfo, width, height, transfer);
        ATrace.endSection();
        if (!success) {
            Logging.w(TAG, this.name + "setupTextureFrameBuffer failed!");
            this.releaseTextureFramebuffer(texInfo);
            return null;
        }
        GLES20.glBindFramebuffer((int)36160, (int)texInfo.frameBufferId);
        ATrace.beginSection("drawTexture");
        this.drawTexture(srcTextureId, srcType, width, height, transfer);
        ATrace.endSection();
        ATrace.beginSection("flush");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        Object object = EglBase.lock;
        synchronized (object) {
            GLES20.glUseProgram((int)0);
        }
        long newFenceObject = 0L;
        if (useGlFence) {
            newFenceObject = TextureBufferPool.getGLFenceObject();
        }
        if (newFenceObject == 0L) {
            GLES20.glFlush();
        }
        texInfo.fenceObject = newFenceObject;
        if (TextureBufferPool.isGlFlushBuggyDevice()) {
            GLES20.glFinish();
        }
        ATrace.endSection();
        ret = new TextureBuffer[]{new TextureBuffer(this.eglContext, width, height, VideoFrame.TextureBuffer.Type.RGB, texInfo.textureId, transformMatrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        TextureBufferPool.this.releaseTextureFramebuffer(texInfo);
                        if (TextureBufferPool.this.isQuitting && !TextureBufferPool.this.anyTextureInUse()) {
                            Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no buffer in flight");
                            TextureBufferPool.this.release();
                        }
                        if (bufferReleaseCallback != null) {
                            bufferReleaseCallback.run();
                        }
                        if (TextureBufferPool.this.poolBufferReleaseCallback != null) {
                            TextureBufferPool.this.poolBufferReleaseCallback.run();
                        }
                    }
                });
            }
        }, this, newFenceObject, nextSeq.getAndIncrement(), HdrUtil.is10BitLumaDepth(transfer))};
        return ret[0];
    }

    private TextureInfo acquireTextureFramebuffer() {
        TextureInfo texInfo = null;
        for (TextureInfo info : this.textureInfoList) {
            if (info.inUse) continue;
            texInfo = info;
            break;
        }
        if (texInfo == null) {
            if (this.textureInfoList.size() >= this.maxBufferCnt) {
                ++this.dropCount;
                ATrace.traceCounter("Drop@TexPool", this.dropCount);
                return null;
            }
            int textureId = GlUtil.generateTexture(3553);
            int[] frameBuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
            texInfo = new TextureInfo(textureId, frameBuffers[0]);
            this.textureInfoList.add(texInfo);
        }
        texInfo.inUse = true;
        return texInfo;
    }

    private void releaseTextureFramebuffer(TextureInfo texInfo) {
        texInfo.inUse = false;
        if (this.shrinkPool) {
            int index = this.textureInfoList.indexOf(texInfo);
            if (index < 0) {
                String strName = Thread.currentThread().getName();
                strName = strName + " texture info not found!";
                strName = strName + " texInfo.textureId: ";
                strName = strName + texInfo.textureId;
                Logging.e(TAG, strName);
            } else if (index >= this.keepBufferCnt) {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{texInfo.textureId}, (int)0);
                GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{texInfo.frameBufferId}, (int)0);
                this.textureInfoList.remove(index);
            }
        }
        TextureBufferPool.deleteFenceObject(texInfo.fenceObject, this.name);
    }

    private boolean setupTextureFrameBuffer(TextureInfo texInfo, int width, int height, int transfer) {
        if (width <= 0 || height <= 0) {
            Logging.w(TAG, "Invalid size: " + width + "x" + height);
            return false;
        }
        if (texInfo.specified && texInfo.width == width && texInfo.height == height) {
            return true;
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)texInfo.textureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        ATrace.beginSection("glTexImage2D");
        if (Build.VERSION.SDK_INT >= 18 && HdrUtil.is10BitLumaDepth(transfer) && HdrUtil.isSupportedEGL3()) {
            GLES30.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5131, null);
        } else {
            GLES20.glTexImage2D((int)3553, (int)0, (int)this.glPixelFormat, (int)width, (int)height, (int)0, (int)this.glPixelFormat, (int)5121, null);
        }
        ATrace.endSection();
        GlUtil.checkNoGLES2Error("TextureBufferPool.glTexImage2D");
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)texInfo.frameBufferId);
        ATrace.beginSection("glFramebufferTexture2D");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texInfo.textureId, (int)0);
        ATrace.endSection();
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        if (status != 36053) {
            Logging.w(TAG, "Framebuffer not complete, status: " + status);
            return false;
        }
        texInfo.specified = true;
        texInfo.width = width;
        texInfo.height = height;
        return true;
    }

    private void drawTexture(int srcTexture, VideoFrame.TextureBuffer.Type srcType, int width, int height, int transfer) {
        GLES20.glClear((int)16384);
        switch (srcType) {
            case OES: {
                this.drawer.drawOes(srcTexture, 0, GlUtil.IDENTITY_MATRIX, width, height, 0, 0, width, height, transfer, VideoFrame.AlphaStitchMode.ALPHA_NO_STITCH.value());
                break;
            }
            case RGB: {
                this.drawer.drawRgb(srcTexture, 0, GlUtil.IDENTITY_MATRIX, width, height, 0, 0, width, height, transfer, VideoFrame.AlphaStitchMode.ALPHA_NO_STITCH.value());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("TextureBufferPool.drawFrameBuffer");
    }

    boolean anyTextureInUse() {
        for (TextureInfo info : this.textureInfoList) {
            if (!info.inUse) continue;
            return true;
        }
        return false;
    }

    private void release() {
        Logging.i(TAG, this.name + " release()");
        if (!this.textureInfoList.isEmpty()) {
            int count = this.textureInfoList.size();
            int[] textures = new int[count];
            int[] framebuffers = new int[count];
            for (int i = 0; i < count; ++i) {
                TextureInfo texInfo = this.textureInfoList.get(i);
                textures[i] = texInfo.textureId;
                framebuffers[i] = texInfo.frameBufferId;
                TextureBufferPool.deleteFenceObject(texInfo.fenceObject, this.name);
            }
            Logging.i(TAG, this.name + ": delete textures " + Arrays.toString(textures) + " framebuffers:" + Arrays.toString(framebuffers));
            GLES20.glDeleteTextures((int)textures.length, (int[])textures, (int)0);
            GLES20.glDeleteFramebuffers((int)framebuffers.length, (int[])framebuffers, (int)0);
            this.textureInfoList.clear();
        }
        this.yuvConverterInternal.release();
        this.drawer.release();
        if (this.ownGlThread) {
            if (this.eglBase != null) {
                this.eglBase.release();
            }
            this.handler.getLooper().quit();
        }
    }

    @CalledByNative
    public static boolean isGlFlushBuggyDevice() {
        for (String model : glFlushBuggyDevices) {
            if (!model.equalsIgnoreCase(Build.MODEL)) continue;
            return true;
        }
        return forceGlFinish;
    }

    @CalledByNative
    public static void setForceGlFinish(boolean value) {
        Logging.i(TAG, "setForceGlFinish " + value);
        forceGlFinish = value;
    }

    @CalledByNative
    public static void setUseGlFence(boolean value) {
        Logging.i(TAG, "setUseGlFence " + value);
        useGlFence = value;
    }

    private static class TextureInfo {
        int textureId;
        int frameBufferId;
        boolean inUse;
        boolean specified;
        int width;
        int height;
        long fenceObject;

        public TextureInfo(int textureId, int frameBufferId) {
            this.textureId = textureId;
            this.frameBufferId = frameBufferId;
            this.inUse = false;
            this.specified = false;
            this.width = 0;
            this.height = 0;
            this.fenceObject = 0L;
        }

        public String toString() {
            return "TextureInfo{textureId=" + this.textureId + ", frameBufferId=" + this.frameBufferId + ", inUse=" + this.inUse + ", specified=" + this.specified + ", width=" + this.width + ", height=" + this.height + ", fenceObject=" + this.fenceObject + '}';
        }
    }
}

