/*
 * Decompiled with CFR 0.152.
 */
package io.agora.meta.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import io.agora.meta.IMetaService;
import io.agora.meta.IMetaServiceEventHandler;
import io.agora.meta.MetaSceneConfig;
import io.agora.meta.MetaServiceConfig;
import io.agora.utils2.internal.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class MetaServiceImpl
extends IMetaService {
    private static final String TAG = MetaServiceImpl.class.getSimpleName();
    private long mNativeHandle = 0L;
    private String mLauncherVersion;
    private final AtomicBoolean mIsDestroying = new AtomicBoolean(false);

    private void readLauncherVersion(Context context) {
        try {
            AssetManager assetManager = context.getAssets();
            InputStream stream1 = assetManager.open("LauncherVersion.txt", 3);
            int bufSize = stream1.available();
            byte[] buf = new byte[bufSize];
            int count = stream1.read(buf);
            if (count <= 0) {
                String v = "unknown";
                buf = v.getBytes();
            }
            stream1.close();
            this.mLauncherVersion = new String(buf, "UTF-8");
        }
        catch (IOException e) {
            Logging.e(TAG, "get launcher version failed, " + e.getMessage());
        }
    }

    @Override
    public String getLauncherVersion(Context ctx) {
        if (ctx == null) {
            return "unknown";
        }
        if (TextUtils.isEmpty((CharSequence)this.mLauncherVersion)) {
            this.readLauncherVersion(ctx);
        }
        return this.mLauncherVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initialize(MetaServiceConfig config) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(initialize)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (config.mRtcEngine == null || TextUtils.isEmpty((CharSequence)config.mAppId)) {
                return -2;
            }
            if (config.mRtcEngine.loadExtensionProvider("agora_rtm_loader") != 0) {
                Logging.e(TAG, "Rtm extension is not loaded");
            }
            this.mNativeHandle = this.nativeObjectInit(config, config.mRtcEngine.getNativeHandle());
            if (this.mNativeHandle == 0L) {
                return -7;
            }
            return 0;
        }
    }

    @Override
    protected int doDestroy() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "MetaService does not initialize or it may be destroyed (doDestroy)");
            return -7;
        }
        this.mIsDestroying.set(true);
        MetaServiceImpl.nativeDestroy(this.mNativeHandle);
        this.mNativeHandle = 0L;
        this.mIsDestroying.set(false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renewToken(String token) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(renewToken)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (renewToken)");
                return -7;
            }
            return this.nativeRenewToken(this.mNativeHandle, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addEventHandler(IMetaServiceEventHandler eventHandler) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(addEventHandler)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (addEventHandler)");
                return -7;
            }
            return this.nativeAddEventHandler(this.mNativeHandle, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeEventHandler(IMetaServiceEventHandler eventHandler) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(removeEventHandler)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (removeEventHandler)");
                return -7;
            }
            return this.nativeRemoveEventHandler(this.mNativeHandle, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSceneAssetsInfo() {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(getSceneAssetsInfo)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (getSceneAssetsInfo)");
                return -7;
            }
            return this.nativeGetSceneAssetsInfo(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isSceneAssetsDownloaded(long sceneId) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(isSceneAssetsDownloaded)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (isSceneAssetsDownloaded)");
                return -7;
            }
            return this.nativeIsSceneAssetsDownloaded(this.mNativeHandle, sceneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int downloadSceneAssets(long sceneId) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(downloadSceneAssets)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (downloadSceneAssets)");
                return -7;
            }
            return this.nativeDownloadSceneAssets(this.mNativeHandle, sceneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelDownloadSceneAssets(long sceneId) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(cancelDownloadSceneAssets)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (cancelDownloadSceneAssets)");
                return -7;
            }
            return this.nativeCancelDownloadSceneAssets(this.mNativeHandle, sceneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanSceneAssets(long sceneId) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(cleanSceneAssets)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (cleanSceneAssets)");
                return -7;
            }
            return this.nativeCleanSceneAssets(this.mNativeHandle, sceneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createScene(MetaSceneConfig config) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaService is destroying(createScene)");
            return -8;
        }
        MetaServiceImpl metaServiceImpl = this;
        synchronized (metaServiceImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaService does not initialize or it may be destroyed (createScene)");
                return -7;
            }
            if (config.mActivityContext == null) {
                return -2;
            }
            return this.nativeCreateScene(this.mNativeHandle, config);
        }
    }

    private native long nativeObjectInit(MetaServiceConfig var1, long var2);

    private static native int nativeDestroy(long var0);

    private native int nativeRenewToken(long var1, String var3);

    private native int nativeAddEventHandler(long var1, Object var3);

    private native int nativeRemoveEventHandler(long var1, Object var3);

    private native int nativeGetSceneAssetsInfo(long var1);

    private native int nativeIsSceneAssetsDownloaded(long var1, long var3);

    private native int nativeDownloadSceneAssets(long var1, long var3);

    private native int nativeCancelDownloadSceneAssets(long var1, long var3);

    private native int nativeCleanSceneAssets(long var1, long var3);

    private native int nativeCreateScene(long var1, MetaSceneConfig var3);
}

