/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.projection.MediaProjection;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.mediaplayer.IMediaPlayer;
import io.agora.mediaplayer.IMediaPlayerCacheManager;
import io.agora.rtc2.AgoraMediaRecorder;
import io.agora.rtc2.ChannelMediaOptions;
import io.agora.rtc2.ClientRoleOptions;
import io.agora.rtc2.Constants;
import io.agora.rtc2.DataStreamConfig;
import io.agora.rtc2.DeviceInfo;
import io.agora.rtc2.DirectCdnStreamingMediaOptions;
import io.agora.rtc2.EchoTestConfiguration;
import io.agora.rtc2.EncodedVideoTrackOptions;
import io.agora.rtc2.ExtensionInfo;
import io.agora.rtc2.IAudioEffectManager;
import io.agora.rtc2.IAudioEncodedFrameObserver;
import io.agora.rtc2.IAudioFrameObserver;
import io.agora.rtc2.IDirectCdnStreamingEventHandler;
import io.agora.rtc2.IH265Transcoder;
import io.agora.rtc2.IMetadataObserver;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.IRtcEngineReleaseCallback;
import io.agora.rtc2.LeaveChannelOptions;
import io.agora.rtc2.LocalAudioMixerConfiguration;
import io.agora.rtc2.LocalTranscoderConfiguration;
import io.agora.rtc2.RecorderStreamInfo;
import io.agora.rtc2.RtcEngineConfig;
import io.agora.rtc2.ScreenCaptureParameters;
import io.agora.rtc2.SimulcastConfig;
import io.agora.rtc2.SimulcastStreamConfig;
import io.agora.rtc2.SpatialAudioParams;
import io.agora.rtc2.UserInfo;
import io.agora.rtc2.audio.AdvancedAudioOptions;
import io.agora.rtc2.audio.AgoraRhythmPlayerConfig;
import io.agora.rtc2.audio.AudioTrackConfig;
import io.agora.rtc2.audio.IAudioSpectrumObserver;
import io.agora.rtc2.internal.AudioEncodedFrameObserverConfig;
import io.agora.rtc2.internal.AudioRecordingConfiguration;
import io.agora.rtc2.internal.EncryptionConfig;
import io.agora.rtc2.internal.LastmileProbeConfig;
import io.agora.rtc2.internal.RtcEngineImpl;
import io.agora.rtc2.live.LiveTranscoding;
import io.agora.rtc2.proxy.LocalAccessPointConfiguration;
import io.agora.rtc2.video.AgoraFocalLengthInfo;
import io.agora.rtc2.video.AgoraImage;
import io.agora.rtc2.video.AgoraVideoFrame;
import io.agora.rtc2.video.BeautyOptions;
import io.agora.rtc2.video.CameraCapturerConfiguration;
import io.agora.rtc2.video.ChannelMediaRelayConfiguration;
import io.agora.rtc2.video.CodecCapInfo;
import io.agora.rtc2.video.ColorEnhanceOptions;
import io.agora.rtc2.video.ContentInspectConfig;
import io.agora.rtc2.video.EncodedVideoFrameInfo;
import io.agora.rtc2.video.FaceShapeAreaOptions;
import io.agora.rtc2.video.FaceShapeBeautyOptions;
import io.agora.rtc2.video.FilterEffectOptions;
import io.agora.rtc2.video.IFaceInfoObserver;
import io.agora.rtc2.video.IVideoEncodedFrameObserver;
import io.agora.rtc2.video.IVideoFrameObserver;
import io.agora.rtc2.video.ImageTrackOptions;
import io.agora.rtc2.video.LowLightEnhanceOptions;
import io.agora.rtc2.video.SegmentationProperty;
import io.agora.rtc2.video.SnapshotConfig;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoDenoiserOptions;
import io.agora.rtc2.video.VideoEncoderConfiguration;
import io.agora.rtc2.video.VideoSubscriptionOptions;
import io.agora.rtc2.video.VirtualBackgroundSource;
import io.agora.rtc2.video.WatermarkOptions;
import java.nio.ByteBuffer;

public abstract class RtcEngine {
    protected static RtcEngineImpl mInstance = null;

    public static synchronized RtcEngine create(Context context, String appId, IRtcEngineEventHandler handler) throws Exception {
        long startTs = SystemClock.uptimeMillis();
        if (context == null || !RtcEngineImpl.initializeNativeLibs()) {
            return null;
        }
        RtcEngineConfig config = new RtcEngineConfig();
        config.mContext = context;
        config.mAppId = appId;
        config.mEventHandler = handler;
        if (mInstance == null) {
            mInstance = new RtcEngineImpl(config);
            mInstance.recordCreateEngineTimeStamp(startTs, SystemClock.uptimeMillis());
        } else {
            mInstance.reinitialize(config);
        }
        return mInstance;
    }

    public static synchronized RtcEngine create(RtcEngineConfig config) throws Exception {
        long startTs = SystemClock.uptimeMillis();
        if (config == null || config.mContext == null || !RtcEngineImpl.initializeNativeLibs(config.mNativeLibPath)) {
            return null;
        }
        if (mInstance == null) {
            mInstance = new RtcEngineImpl(config);
            mInstance.recordCreateEngineTimeStamp(startTs, SystemClock.uptimeMillis());
        } else {
            mInstance.reinitialize(config);
        }
        return mInstance;
    }

    public static synchronized void destroy() {
        RtcEngine.destroy(null);
    }

    public static synchronized void destroy(@Nullable IRtcEngineReleaseCallback callback) {
        if (mInstance == null) {
            return;
        }
        mInstance.doDestroy(callback);
        mInstance = null;
        System.gc();
    }

    public abstract int setChannelProfile(int var1);

    public abstract int setClientRole(int var1);

    public abstract int setClientRole(int var1, ClientRoleOptions var2);

    public abstract int sendCustomReportMessage(String var1, String var2, String var3, String var4, int var5);

    public abstract int preloadChannel(String var1, String var2, int var3);

    public abstract int preloadChannelWithUserAccount(String var1, String var2, String var3);

    public abstract int updatePreloadChannelToken(String var1);

    public abstract int joinChannel(String var1, String var2, String var3, int var4);

    public abstract int joinChannel(String var1, String var2, int var3, ChannelMediaOptions var4);

    public abstract int registerLocalUserAccount(String var1, String var2);

    public abstract int joinChannelWithUserAccount(String var1, String var2, String var3);

    public abstract int joinChannelWithUserAccount(String var1, String var2, String var3, ChannelMediaOptions var4);

    public abstract int getUserInfoByUserAccount(String var1, UserInfo var2);

    public abstract int getUserInfoByUid(int var1, UserInfo var2);

    public abstract int leaveChannel();

    public abstract int leaveChannel(LeaveChannelOptions var1);

    public abstract int renewToken(String var1);

    public abstract DeviceInfo getAudioDeviceInfo();

    public abstract int enableWebSdkInteroperability(boolean var1);

    public abstract int getConnectionState();

    public abstract int enableAudio();

    public abstract int disableAudio();

    public abstract int pauseAudio();

    public abstract int resumeAudio();

    public abstract int setAudioProfile(int var1);

    public abstract int setAudioProfile(int var1, int var2);

    public abstract int setAudioScenario(int var1);

    public abstract int setHighQualityAudioParameters(boolean var1, boolean var2, boolean var3);

    public abstract int adjustRecordingSignalVolume(int var1);

    public abstract int adjustPlaybackSignalVolume(int var1);

    public abstract int enableAudioVolumeIndication(int var1, int var2, boolean var3);

    public abstract int enableLocalAudio(boolean var1);

    public abstract int muteLocalAudioStream(boolean var1);

    public abstract int muteRemoteAudioStream(int var1, boolean var2);

    public abstract int adjustUserPlaybackSignalVolume(int var1, int var2);

    public abstract int muteAllRemoteAudioStreams(boolean var1);

    public abstract int enableVideo();

    public abstract int disableVideo();

    public abstract int setVideoEncoderConfiguration(VideoEncoderConfiguration var1);

    public abstract CodecCapInfo[] queryCodecCapability();

    public abstract int queryDeviceScore();

    public abstract AgoraFocalLengthInfo[] queryCameraFocalLengthCapability();

    public abstract int setCameraCapturerConfiguration(CameraCapturerConfiguration var1);

    public abstract int setupLocalVideo(VideoCanvas var1);

    public abstract int setupRemoteVideo(VideoCanvas var1);

    @Deprecated
    public abstract int setRemoteRenderMode(int var1, int var2);

    @Deprecated
    public abstract int setLocalRenderMode(int var1);

    public abstract int setRemoteRenderMode(int var1, int var2, int var3);

    public abstract int setLocalRenderMode(int var1, int var2);

    public abstract int startPreview();

    public abstract int startPreview(Constants.VideoSourceType var1);

    public abstract int stopPreview();

    public abstract int stopPreview(Constants.VideoSourceType var1);

    public abstract int enableLocalVideo(boolean var1);

    public abstract int startCameraCapture(Constants.VideoSourceType var1, CameraCapturerConfiguration var2);

    public abstract int stopCameraCapture(Constants.VideoSourceType var1);

    public abstract int startLocalVideoTranscoder(LocalTranscoderConfiguration var1);

    public abstract int stopLocalVideoTranscoder();

    public abstract int updateLocalTranscoderConfiguration(LocalTranscoderConfiguration var1);

    public abstract int startLocalAudioMixer(LocalAudioMixerConfiguration var1);

    public abstract int updateLocalAudioMixerConfiguration(LocalAudioMixerConfiguration var1);

    public abstract int stopLocalAudioMixer();

    public abstract int muteLocalVideoStream(boolean var1);

    public abstract int muteRemoteVideoStream(int var1, boolean var2);

    public abstract int muteAllRemoteVideoStreams(boolean var1);

    public abstract int setBeautyEffectOptions(boolean var1, BeautyOptions var2);

    public abstract int setBeautyEffectOptions(boolean var1, BeautyOptions var2, Constants.MediaSourceType var3);

    public abstract int setFaceShapeBeautyOptions(boolean var1, FaceShapeBeautyOptions var2);

    public abstract int setFaceShapeBeautyOptions(boolean var1, FaceShapeBeautyOptions var2, Constants.MediaSourceType var3);

    public abstract FaceShapeBeautyOptions getFaceShapeBeautyOptions();

    public abstract FaceShapeBeautyOptions getFaceShapeBeautyOptions(Constants.MediaSourceType var1);

    public abstract int setFaceShapeAreaOptions(FaceShapeAreaOptions var1);

    public abstract int setFaceShapeAreaOptions(FaceShapeAreaOptions var1, Constants.MediaSourceType var2);

    public abstract FaceShapeAreaOptions getFaceShapeAreaOptions(int var1);

    public abstract FaceShapeAreaOptions getFaceShapeAreaOptions(int var1, Constants.MediaSourceType var2);

    public abstract int setFilterEffectOptions(boolean var1, FilterEffectOptions var2);

    public abstract int setFilterEffectOptions(boolean var1, FilterEffectOptions var2, Constants.MediaSourceType var3);

    public abstract int setLowlightEnhanceOptions(boolean var1, LowLightEnhanceOptions var2);

    public abstract int setLowlightEnhanceOptions(boolean var1, LowLightEnhanceOptions var2, Constants.MediaSourceType var3);

    public abstract int setVideoDenoiserOptions(boolean var1, VideoDenoiserOptions var2);

    public abstract int setVideoDenoiserOptions(boolean var1, VideoDenoiserOptions var2, Constants.MediaSourceType var3);

    public abstract int setColorEnhanceOptions(boolean var1, ColorEnhanceOptions var2);

    public abstract int setColorEnhanceOptions(boolean var1, ColorEnhanceOptions var2, Constants.MediaSourceType var3);

    public abstract int enableVirtualBackground(boolean var1, VirtualBackgroundSource var2, SegmentationProperty var3);

    public abstract int enableVirtualBackground(boolean var1, VirtualBackgroundSource var2, SegmentationProperty var3, Constants.MediaSourceType var4);

    public abstract int setDefaultAudioRoutetoSpeakerphone(boolean var1);

    public abstract int setEnableSpeakerphone(boolean var1);

    public abstract int setRouteInCommunicationMode(int var1);

    public abstract boolean isSpeakerphoneEnabled();

    public abstract int enableInEarMonitoring(boolean var1);

    public abstract int enableInEarMonitoring(boolean var1, int var2);

    public abstract int setInEarMonitoringVolume(int var1);

    public abstract int setLocalVoicePitch(double var1);

    public abstract int setLocalVoiceFormant(double var1);

    public abstract int setLocalVoiceEqualization(Constants.AUDIO_EQUALIZATION_BAND_FREQUENCY var1, int var2);

    public abstract int setLocalVoiceReverb(Constants.AUDIO_REVERB_TYPE var1, int var2);

    public abstract int setHeadphoneEQPreset(int var1);

    public abstract int setHeadphoneEQParameters(int var1, int var2);

    public abstract int setAudioEffectPreset(int var1);

    public abstract int setVoiceBeautifierPreset(int var1);

    public abstract int setVoiceConversionPreset(int var1);

    public abstract int setAudioEffectParameters(int var1, int var2, int var3);

    public abstract int setVoiceBeautifierParameters(int var1, int var2, int var3);

    public abstract int setVoiceConversionParameters(int var1, int var2, int var3);

    public abstract int enableSoundPositionIndication(boolean var1);

    public abstract int setRemoteVoicePosition(int var1, double var2, double var4);

    public abstract int enableVoiceAITuner(boolean var1, Constants.VOICE_AI_TUNER_TYPE var2);

    public abstract int startAudioMixing(String var1, boolean var2, int var3);

    public abstract int enableSpatialAudio(boolean var1);

    public abstract int setRemoteUserSpatialAudioParams(int var1, SpatialAudioParams var2);

    public abstract int setRemoteVideoSubscriptionOptions(int var1, VideoSubscriptionOptions var2);

    public abstract int setAINSMode(boolean var1, int var2);

    public abstract int startAudioMixing(String var1, boolean var2, int var3, int var4);

    public abstract int stopAudioMixing();

    public abstract int pauseAudioMixing();

    public abstract int resumeAudioMixing();

    public abstract int adjustAudioMixingVolume(int var1);

    public abstract int adjustAudioMixingPlayoutVolume(int var1);

    public abstract int adjustAudioMixingPublishVolume(int var1);

    public abstract int getAudioMixingPlayoutVolume();

    public abstract int getAudioMixingPublishVolume();

    public abstract int getAudioMixingDuration();

    public abstract int getAudioMixingCurrentPosition();

    public abstract int setAudioMixingPosition(int var1);

    public abstract int setAudioMixingDualMonoMode(Constants.AudioMixingDualMonoMode var1);

    public abstract int setAudioMixingPitch(int var1);

    public abstract int setAudioMixingPlaybackSpeed(int var1);

    public abstract int selectAudioTrack(int var1);

    public abstract int getAudioTrackCount();

    public abstract IAudioEffectManager getAudioEffectManager();

    public abstract int startAudioRecording(String var1, int var2);

    public abstract int startAudioRecording(AudioRecordingConfiguration var1);

    public abstract int stopAudioRecording();

    public abstract int startEchoTest(EchoTestConfiguration var1);

    public abstract int stopEchoTest();

    public abstract int startLastmileProbeTest(LastmileProbeConfig var1);

    public abstract int stopLastmileProbeTest();

    @Deprecated
    public abstract int setExternalAudioSource(boolean var1, int var2, int var3);

    public abstract int setExternalAudioSink(boolean var1, int var2, int var3);

    public abstract int setExternalRemoteEglContext(Object var1);

    public abstract int pullPlaybackAudioFrame(byte[] var1, int var2);

    public abstract int pullPlaybackAudioFrame(ByteBuffer var1, int var2);

    public abstract int startRecordingDeviceTest(int var1);

    public abstract int stopRecordingDeviceTest();

    public abstract int startPlaybackDeviceTest(String var1);

    public abstract int stopPlaybackDeviceTest();

    public abstract int createCustomAudioTrack(Constants.AudioTrackType var1, AudioTrackConfig var2);

    public abstract int destroyCustomAudioTrack(int var1);

    @Deprecated
    public abstract int setExternalAudioSource(boolean var1, int var2, int var3, boolean var4, boolean var5);

    @Deprecated
    public abstract int pushExternalAudioFrame(byte[] var1, long var2);

    @Deprecated
    public abstract int pushExternalAudioFrame(ByteBuffer var1, long var2, int var4);

    public abstract int pushExternalAudioFrame(byte[] var1, long var2, int var4, int var5, Constants.BytesPerSample var6, int var7);

    public abstract int pushExternalAudioFrame(ByteBuffer var1, long var2, int var4, int var5, Constants.BytesPerSample var6, int var7);

    public abstract int setExternalVideoSource(boolean var1, boolean var2, Constants.ExternalVideoSourceType var3);

    public abstract int setExternalVideoSource(boolean var1, boolean var2, Constants.ExternalVideoSourceType var3, EncodedVideoTrackOptions var4);

    @Deprecated
    public abstract boolean pushExternalVideoFrame(VideoFrame var1);

    public abstract int pushExternalVideoFrameById(VideoFrame var1, int var2);

    public abstract int pushExternalVideoFrameById(AgoraVideoFrame var1, int var2);

    @Deprecated
    public abstract int pushExternalEncodedVideoFrame(ByteBuffer var1, EncodedVideoFrameInfo var2);

    public abstract int pushExternalEncodedVideoFrameById(ByteBuffer var1, EncodedVideoFrameInfo var2, int var3);

    @Deprecated
    public abstract boolean pushExternalVideoFrame(AgoraVideoFrame var1);

    public abstract boolean isTextureEncodeSupported();

    public abstract int registerAudioFrameObserver(IAudioFrameObserver var1);

    public abstract int registerAudioEncodedFrameObserver(AudioEncodedFrameObserverConfig var1, IAudioEncodedFrameObserver var2);

    public abstract int setRecordingAudioFrameParameters(int var1, int var2, int var3, int var4);

    public abstract int setPlaybackAudioFrameParameters(int var1, int var2, int var3, int var4);

    public abstract int setMixedAudioFrameParameters(int var1, int var2, int var3);

    public abstract int setEarMonitoringAudioFrameParameters(int var1, int var2, int var3, int var4);

    @Deprecated
    public abstract int addVideoWatermark(AgoraImage var1);

    public abstract int addVideoWatermark(String var1, WatermarkOptions var2);

    public abstract int clearVideoWatermarks();

    public abstract int setRemoteUserPriority(int var1, int var2);

    public abstract int setLocalPublishFallbackOption(Constants.StreamFallbackOptions var1);

    @Deprecated
    public abstract int setLocalPublishFallbackOption(int var1);

    public abstract int setRemoteSubscribeFallbackOption(Constants.StreamFallbackOptions var1);

    @Deprecated
    public abstract int setRemoteSubscribeFallbackOption(int var1);

    public abstract int setHighPriorityUserList(int[] var1, int var2);

    @Deprecated
    public abstract int enableDualStreamMode(boolean var1);

    @Deprecated
    public abstract int enableDualStreamMode(boolean var1, SimulcastStreamConfig var2);

    public abstract int setDualStreamMode(Constants.SimulcastStreamMode var1);

    public abstract int setDualStreamMode(Constants.SimulcastStreamMode var1, SimulcastStreamConfig var2);

    public abstract int setSimulcastConfig(SimulcastConfig var1);

    public abstract int setLocalRenderTargetFps(Constants.VideoSourceType var1, int var2);

    public abstract int setRemoteRenderTargetFps(int var1);

    public abstract int setRemoteVideoStreamType(int var1, Constants.VideoStreamType var2);

    @Deprecated
    public abstract int setRemoteVideoStreamType(int var1, int var2);

    public abstract int setRemoteDefaultVideoStreamType(Constants.VideoStreamType var1);

    @Deprecated
    public abstract int setRemoteDefaultVideoStreamType(int var1);

    public abstract int setSubscribeAudioBlocklist(int[] var1);

    public abstract int setSubscribeAudioAllowlist(int[] var1);

    public abstract int setSubscribeVideoBlocklist(int[] var1);

    public abstract int setSubscribeVideoAllowlist(int[] var1);

    public abstract int enableEncryption(boolean var1, EncryptionConfig var2);

    public abstract int startRtmpStreamWithoutTranscoding(String var1);

    public abstract int startRtmpStreamWithTranscoding(String var1, LiveTranscoding var2);

    public abstract int updateRtmpTranscoding(LiveTranscoding var1);

    public abstract int stopRtmpStream(String var1);

    public abstract int createDataStream(boolean var1, boolean var2);

    public abstract int createDataStream(DataStreamConfig var1);

    public abstract int sendStreamMessage(int var1, byte[] var2);

    public abstract int setVideoQualityParameters(boolean var1);

    @Deprecated
    public abstract int setLocalVideoMirrorMode(int var1);

    @Deprecated
    public static int getRecommendedEncoderType() {
        return 0;
    }

    public abstract int switchCamera();

    public abstract int switchCamera(String var1);

    public abstract boolean isCameraZoomSupported();

    public abstract boolean isCameraTorchSupported();

    public abstract boolean isCameraFocusSupported();

    public abstract boolean isCameraExposurePositionSupported();

    public abstract boolean isCameraAutoFocusFaceModeSupported();

    public abstract boolean isCameraFaceDetectSupported();

    public abstract boolean isCameraExposureSupported();

    public abstract int setCameraZoomFactor(float var1);

    public abstract float getCameraMaxZoomFactor();

    public abstract int setCameraFocusPositionInPreview(float var1, float var2);

    public abstract int setCameraExposurePosition(float var1, float var2);

    public abstract int enableFaceDetection(boolean var1);

    public abstract int setCameraTorchOn(boolean var1);

    public abstract int setCameraAutoFocusFaceModeEnabled(boolean var1);

    public abstract int setCameraExposureFactor(int var1);

    public abstract String getCallId();

    public abstract int rate(String var1, int var2, String var3);

    public abstract int complain(String var1, String var2);

    public static String getSdkVersion() {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetSdkVersion();
    }

    @Deprecated
    public static String getMediaEngineVersion() {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetMediaEngineVersion();
    }

    public abstract int setLogFile(String var1);

    public abstract int setLogFilter(int var1);

    public abstract int setLogLevel(int var1);

    public abstract int setLogFileSize(long var1);

    public abstract String uploadLogFile();

    public abstract int writeLog(int var1, String var2, Object ... var3);

    public abstract long getNativeHandle();

    public void addHandler(IRtcEngineEventHandler handler) {
        mInstance.addHandler(handler);
    }

    public void removeHandler(IRtcEngineEventHandler handler) {
        mInstance.removeHandler(handler);
    }

    @Deprecated
    public abstract boolean enableHighPerfWifiMode(boolean var1);

    public abstract long getNativeMediaPlayer(int var1);

    public static String getErrorDescription(int error) {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetErrorDescription(error);
    }

    public abstract int queryScreenCaptureCapability();

    @Deprecated
    public abstract void monitorHeadsetEvent(boolean var1);

    @Deprecated
    public abstract void monitorBluetoothHeadsetEvent(boolean var1);

    @Deprecated
    public abstract void setPreferHeadset(boolean var1);

    public abstract int setParameters(String var1);

    public abstract String getParameters(String var1);

    public abstract String getParameter(String var1, String var2);

    public abstract int registerMediaMetadataObserver(IMetadataObserver var1, int var2);

    public abstract int unregisterMediaMetadataObserver(IMetadataObserver var1, int var2);

    public abstract int startOrUpdateChannelMediaRelay(ChannelMediaRelayConfiguration var1);

    public abstract int stopChannelMediaRelay();

    public abstract int pauseAllChannelMediaRelay();

    public abstract int resumeAllChannelMediaRelay();

    public abstract int updateChannelMediaOptions(ChannelMediaOptions var1);

    public abstract int muteRecordingSignal(boolean var1);

    public abstract int setPlaybackAudioFrameBeforeMixingParameters(int var1, int var2);

    public abstract int enableAudioSpectrumMonitor(int var1);

    public abstract int disableAudioSpectrumMonitor();

    public abstract int registerAudioSpectrumObserver(IAudioSpectrumObserver var1);

    public abstract int unRegisterAudioSpectrumObserver(IAudioSpectrumObserver var1);

    public abstract double getEffectsVolume();

    public abstract int setEffectsVolume(double var1);

    public abstract int preloadEffect(int var1, String var2);

    public abstract int preloadEffect(int var1, String var2, int var3);

    public abstract int playEffect(int var1, String var2, int var3, double var4, double var6, double var8, boolean var10);

    public abstract int playEffect(int var1, String var2, int var3, double var4, double var6, double var8, boolean var10, int var11);

    public abstract int playAllEffects(int var1, double var2, double var4, double var6, boolean var8);

    public abstract int getVolumeOfEffect(int var1);

    public abstract int setVolumeOfEffect(int var1, double var2);

    public abstract int pauseEffect(int var1);

    public abstract int pauseAllEffects();

    public abstract int resumeEffect(int var1);

    public abstract int resumeAllEffects();

    public abstract int stopEffect(int var1);

    public abstract int stopAllEffects();

    public abstract int unloadEffect(int var1);

    public abstract int unloadAllEffects();

    public abstract int getEffectDuration(String var1);

    public abstract int setEffectPosition(int var1, int var2);

    public abstract int getEffectCurrentPosition(int var1);

    public abstract int registerVideoEncodedFrameObserver(IVideoEncodedFrameObserver var1);

    public abstract int registerFaceInfoObserver(IFaceInfoObserver var1);

    public abstract int takeSnapshot(int var1, String var2);

    public abstract int takeSnapshot(int var1, SnapshotConfig var2);

    public abstract int enableContentInspect(boolean var1, ContentInspectConfig var2);

    public abstract int loadExtensionProvider(String var1);

    public abstract int registerExtension(String var1, String var2, Constants.MediaSourceType var3);

    public abstract int enableExtension(String var1, String var2, boolean var3);

    public abstract int enableExtension(String var1, String var2, boolean var3, Constants.MediaSourceType var4);

    public abstract int setExtensionProperty(String var1, String var2, String var3, String var4);

    public abstract int setExtensionProperty(String var1, String var2, String var3, String var4, Constants.MediaSourceType var5);

    public abstract String getExtensionProperty(String var1, String var2, String var3);

    public abstract String getExtensionProperty(String var1, String var2, String var3, Constants.MediaSourceType var4);

    public abstract int setExtensionProviderProperty(String var1, String var2, String var3);

    public abstract int enableExtension(String var1, String var2, ExtensionInfo var3, boolean var4);

    public abstract int setExtensionProperty(String var1, String var2, ExtensionInfo var3, String var4, String var5);

    public abstract String getExtensionProperty(String var1, String var2, ExtensionInfo var3, String var4);

    public abstract int startScreenCapture(ScreenCaptureParameters var1);

    public abstract int setExternalMediaProjection(MediaProjection var1);

    public abstract int setScreenCaptureScenario(Constants.ScreenScenarioType var1);

    public abstract int stopScreenCapture();

    public abstract int setVideoScenario(Constants.VideoScenario var1);

    public abstract int setVideoQoEPreference(Constants.QoEPreference var1);

    public abstract int updateScreenCaptureParameters(ScreenCaptureParameters var1);

    public abstract int registerVideoFrameObserver(IVideoFrameObserver var1);

    public abstract IMediaPlayer createMediaPlayer();

    public abstract AgoraMediaRecorder createMediaRecorder(RecorderStreamInfo var1);

    public abstract void destroyMediaRecorder(AgoraMediaRecorder var1);

    public abstract IMediaPlayerCacheManager getMediaPlayerCacheManager();

    public abstract IH265Transcoder getH265Transcoder();

    public abstract int enableExternalAudioSourceLocalPlayback(boolean var1);

    public abstract int adjustCustomAudioPublishVolume(int var1, int var2);

    public abstract int adjustCustomAudioPlayoutVolume(int var1, int var2);

    public abstract int startRhythmPlayer(String var1, String var2, AgoraRhythmPlayerConfig var3);

    public abstract int stopRhythmPlayer();

    public abstract int configRhythmPlayer(AgoraRhythmPlayerConfig var1);

    public abstract int setDirectCdnStreamingAudioConfiguration(int var1);

    public abstract int setDirectCdnStreamingVideoConfiguration(VideoEncoderConfiguration var1);

    public abstract long getCurrentMonotonicTimeInMs();

    public abstract int startDirectCdnStreaming(IDirectCdnStreamingEventHandler var1, String var2, DirectCdnStreamingMediaOptions var3);

    public abstract int stopDirectCdnStreaming();

    public abstract int updateDirectCdnStreamingMediaOptions(DirectCdnStreamingMediaOptions var1);

    public abstract int createCustomVideoTrack();

    public abstract int createCustomEncodedVideoTrack(EncodedVideoTrackOptions var1);

    public abstract int destroyCustomVideoTrack(int var1);

    public abstract int destroyCustomEncodedVideoTrack(int var1);

    public abstract int setCloudProxy(int var1);

    public abstract int setLocalAccessPoint(LocalAccessPointConfiguration var1);

    public abstract int enableCustomAudioLocalPlayback(int var1, boolean var2);

    public abstract int setAdvancedAudioOptions(AdvancedAudioOptions var1);

    public abstract int setAVSyncSource(String var1, int var2);

    public abstract int enableVideoImageSource(boolean var1, ImageTrackOptions var2);

    public abstract int enableWirelessAccelerate(boolean var1);

    public abstract int getNetworkType();

    public abstract long getNtpWallTimeInMs();

    public abstract int startMediaRenderingTracing();

    public abstract int enableInstantMediaRendering();

    public abstract int setupAudioAttributes(AudioAttributes var1);

    public abstract boolean isFeatureAvailableOnDevice(int var1);

    public abstract int sendAudioMetadata(byte[] var1);
}

