/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.base.internal.CalledByNative;

public class PlayerStats {
    private long mNativeHandle = 0L;
    private boolean mIsNativeOwner = true;

    public PlayerStats() {
        this.mNativeHandle = this.nativeCreatePlayerStats();
    }

    @CalledByNative
    public PlayerStats(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mIsNativeOwner = false;
    }

    protected void finalize() {
        this.destroy();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private void destroy() {
        if (this.mIsNativeOwner) {
            this.nativeReleasePlayerStats(this.mNativeHandle);
        }
        this.mNativeHandle = 0L;
    }

    public int videoDecodeFrameRate() {
        return this.nativeVideoDecodeFrameRate(this.mNativeHandle);
    }

    public int videoRenderFrameRate() {
        return this.nativeVideoRenderFrameRate(this.mNativeHandle);
    }

    public int videoBitrate() {
        return this.nativeVideoBitrate(this.mNativeHandle);
    }

    public int audioBitrate() {
        return this.nativeAudioBitrate(this.mNativeHandle);
    }

    private native long nativeCreatePlayerStats();

    private native void nativeReleasePlayerStats(long var1);

    private native int nativeVideoDecodeFrameRate(long var1);

    private native int nativeVideoRenderFrameRate(long var1);

    private native int nativeVideoBitrate(long var1);

    private native int nativeAudioBitrate(long var1);
}

