/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal;

import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.internal.Logging;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectUtils {
    private static final String TAG = "ReflectUtils";

    @Nullable
    public static Class<?> safeFindClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        return clazz;
    }

    @Nullable
    public static Method safeGetMethod(Class<?> clazz, String methodName, Class<?> ... paraClasses) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, paraClasses);
        }
        catch (Throwable e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        return method;
    }

    @Nullable
    public static Object safeCallMethod(Class<?> clazz, Object obj, String methodName, Class<?>[] paraClazz, Object[] args) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, paraClazz);
        }
        catch (Throwable e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        if (method == null) {
            Logging.e(TAG, "cannot find method:  " + clazz.getSimpleName() + "." + methodName + ":" + Arrays.toString(paraClazz));
            return null;
        }
        Object result = null;
        try {
            result = method.invoke(obj, args);
        }
        catch (Throwable e) {
            Logging.e(TAG, "cannot execute method:  " + clazz.getSimpleName() + "." + methodName + ":" + Arrays.toString(paraClazz));
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        return result;
    }
}

