/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.projection.MediaProjection;
import android.net.wifi.WifiManager;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.BuildConfig;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.mediaplayer.IMediaPlayer;
import io.agora.mediaplayer.IMediaPlayerAudioFrameObserver;
import io.agora.mediaplayer.IMediaPlayerCacheManager;
import io.agora.mediaplayer.IMediaPlayerObserver;
import io.agora.mediaplayer.IMediaPlayerVideoFrameObserver;
import io.agora.mediaplayer.data.MediaPlayerSource;
import io.agora.mediaplayer.data.MediaStreamInfo;
import io.agora.rtc2.AgoraMediaRecorder;
import io.agora.rtc2.ChannelMediaOptions;
import io.agora.rtc2.ClientRoleOptions;
import io.agora.rtc2.Constants;
import io.agora.rtc2.DataStreamConfig;
import io.agora.rtc2.DeviceInfo;
import io.agora.rtc2.DirectCdnStreamingMediaOptions;
import io.agora.rtc2.EchoTestConfiguration;
import io.agora.rtc2.EncodedVideoTrackOptions;
import io.agora.rtc2.ExtensionInfo;
import io.agora.rtc2.IAudioEffectManager;
import io.agora.rtc2.IAudioEncodedFrameObserver;
import io.agora.rtc2.IAudioFrameObserver;
import io.agora.rtc2.IDirectCdnStreamingEventHandler;
import io.agora.rtc2.IH265Transcoder;
import io.agora.rtc2.IH265TranscoderObserver;
import io.agora.rtc2.IMediaRecorderCallback;
import io.agora.rtc2.IMetadataObserver;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.IRtcEngineReleaseCallback;
import io.agora.rtc2.IVideoEffectObject;
import io.agora.rtc2.LeaveChannelOptions;
import io.agora.rtc2.LocalAudioMixerConfiguration;
import io.agora.rtc2.LocalTranscoderConfiguration;
import io.agora.rtc2.RecorderStreamInfo;
import io.agora.rtc2.RtcConnection;
import io.agora.rtc2.RtcEngineConfig;
import io.agora.rtc2.RtcEngineInternal;
import io.agora.rtc2.ScreenCaptureParameters;
import io.agora.rtc2.SimulcastConfig;
import io.agora.rtc2.SimulcastStreamConfig;
import io.agora.rtc2.SpatialAudioParams;
import io.agora.rtc2.UserInfo;
import io.agora.rtc2.audio.AdvancedAudioOptions;
import io.agora.rtc2.audio.AgoraRhythmPlayerConfig;
import io.agora.rtc2.audio.AudioTrackConfig;
import io.agora.rtc2.audio.IAudioSpectrumObserver;
import io.agora.rtc2.internal.AudioEncodedFrameObserverConfig;
import io.agora.rtc2.internal.AudioRecordingConfiguration;
import io.agora.rtc2.internal.EncryptionConfig;
import io.agora.rtc2.internal.H265TranscoderImpl;
import io.agora.rtc2.internal.LastmileProbeConfig;
import io.agora.rtc2.internal.MediaPlayerCacheManagerImpl;
import io.agora.rtc2.internal.MediaPlayerImpl;
import io.agora.rtc2.internal.RtcEngineEventHandlerProxy;
import io.agora.rtc2.internal.RtcEngineMessage;
import io.agora.rtc2.internal.VideoEffectObjectImpl;
import io.agora.rtc2.live.LiveTranscoding;
import io.agora.rtc2.proxy.LocalAccessPointConfiguration;
import io.agora.rtc2.video.AgoraFocalLengthInfo;
import io.agora.rtc2.video.AgoraImage;
import io.agora.rtc2.video.AgoraVideoFrame;
import io.agora.rtc2.video.BeautyOptions;
import io.agora.rtc2.video.CameraCapturerConfiguration;
import io.agora.rtc2.video.ChannelMediaInfo;
import io.agora.rtc2.video.ChannelMediaRelayConfiguration;
import io.agora.rtc2.video.CodecCapInfo;
import io.agora.rtc2.video.ColorEnhanceOptions;
import io.agora.rtc2.video.ContentInspectConfig;
import io.agora.rtc2.video.EncodedVideoFrameInfo;
import io.agora.rtc2.video.FaceShapeAreaOptions;
import io.agora.rtc2.video.FaceShapeBeautyOptions;
import io.agora.rtc2.video.FilterEffectOptions;
import io.agora.rtc2.video.IFaceInfoObserver;
import io.agora.rtc2.video.IVideoEncodedFrameObserver;
import io.agora.rtc2.video.IVideoFrameObserver;
import io.agora.rtc2.video.ImageTrackOptions;
import io.agora.rtc2.video.LowLightEnhanceOptions;
import io.agora.rtc2.video.SegmentationProperty;
import io.agora.rtc2.video.SnapshotConfig;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoDenoiserOptions;
import io.agora.rtc2.video.VideoEncoderConfiguration;
import io.agora.rtc2.video.VideoSubscriptionOptions;
import io.agora.rtc2.video.VirtualBackgroundSource;
import io.agora.rtc2.video.WatermarkOptions;
import io.agora.utils2.internal.CommonUtility;
import io.agora.utils2.internal.Logging;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.microedition.khronos.egl.EGL10;

public class RtcEngineImpl
extends RtcEngineInternal
implements IAudioEffectManager {
    public static final String TAG = "RtcEngine";
    private int mExSourceAudioSampleRate = 0;
    private int mExSourceAudioChannels = 0;
    private int mExSinkAudioSampleRate = 0;
    private int mExSinkAudioChannels = 0;
    private int mPushVideoFrameInvalidCnt = 0;
    private long mNativeHandle = 0L;
    private static boolean sLibLoaded = false;
    private final ConcurrentHashMap<IRtcEngineEventHandler, RtcEngineEventHandlerProxy> mRtcHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<String, Object>, ArrayList<RtcEngineEventHandlerProxy>> mRtcExHandlerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ExtensionLoadState> mLoadedExtensions = new ConcurrentHashMap();
    private static final String[] PRELOAD_EXTENSIONS = new String[]{"agora_clear_vision_extension", "agora_segmentation_extension", "agora_screen_capture_extension", "agora_audio_beauty_extension", "agora_spatial_audio_extension", "video_enc", "video_dec", "agora_video_encoder_extension", "agora_video_av1_encoder_extension", "agora_content_inspect_extension", "agora_video_quality_analyzer_extension", "agora_face_detection_extension", "agora_ai_noise_suppression_extension", "agora_ai_noise_suppression_ll_extension", "agora_ai_echo_cancellation_extension", "agora_ai_echo_cancellation_ll_extension", "agora_metakit_extension", "agora_face_capture_extension", "agora_lip_sync_extension", "agora_rtm_loader_extension", "agora_portrait_rhythm_extension"};
    private WifiManager.WifiLock mWifiLock = null;
    private WeakReference<Context> mContext = null;
    static String nativeLibraryName = "agora-rtc-sdk";
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySurffix = ".so";

    public static synchronized boolean initializeNativeLibs() {
        return RtcEngineImpl.initializeNativeLibs(null);
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        if (!sLibLoaded) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                sLibLoaded = RtcEngineImpl.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (sLibLoaded) continue;
                return sLibLoaded;
            }
            sLibLoaded = RtcEngineImpl.safeLoadLibrary(libPath, nativeLibraryName);
        }
        return sLibLoaded;
    }

    public static synchronized boolean preloadExtensions() {
        return RtcEngineImpl.preloadExtensions("", null);
    }

    public static synchronized boolean preloadExtensions(String libPath, String[] extensions) {
        boolean loaded = false;
        String[] extensionArray = PRELOAD_EXTENSIONS;
        if (extensions != null && extensions.length > 0) {
            extensionArray = extensions;
        }
        for (int i = 0; i < extensionArray.length; ++i) {
            String providerName = extensionArray[i];
            Logging.i(TAG, "load extension: " + providerName);
            loaded = RtcEngineImpl.safeLoadLibrary(libPath, providerName);
            if (loaded) continue;
            return loaded;
        }
        return loaded;
    }

    @Override
    public synchronized int loadExtensionProvider(String path) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (mLoadedExtensions.get(path) == ExtensionLoadState.LOADED) {
            return 0;
        }
        int loaded = this.nativeLoadExtensionProvider(this.mNativeHandle, path);
        mLoadedExtensions.put(path, loaded == 0 ? ExtensionLoadState.LOADED : ExtensionLoadState.LOAD_FAIL);
        return loaded;
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        String message = null;
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                System.loadLibrary(name);
            } else {
                System.load(RtcEngineImpl.getNativeLibFullPath(path, name));
            }
        }
        catch (SecurityException e) {
            message = e.getMessage();
            loaded = false;
        }
        catch (UnsatisfiedLinkError e) {
            message = e.getMessage();
            loaded = false;
        }
        catch (NullPointerException e) {
            message = e.getMessage();
            loaded = false;
        }
        catch (Exception e) {
            message = e.getMessage();
            loaded = false;
        }
        if (!loaded) {
            Log.i((String)TAG, (String)("failed to load library " + name + " from " + path + " msg: " + message));
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySurffix;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    public RtcEngineImpl(RtcEngineConfig config) throws Exception {
        if (config.mAutoRegisterAgoraExtensions) {
            config.mExtensionList.addAll(Arrays.asList(PRELOAD_EXTENSIONS));
        }
        for (String providerName : config.mExtensionList) {
            Logging.i(TAG, "load extension: " + providerName);
            RtcEngineImpl.safeLoadLibrary(config.mNativeLibPath, providerName);
        }
        this.mContext = new WeakReference<Context>(config.mContext);
        this.addHandler(config.mEventHandler);
        InitResult initResult = (InitResult)this.nativeObjectInit(config);
        if (initResult.retVal != 0) {
            String errMsg = String.format(Locale.getDefault(), "cannot initialize Agora Rtc Engine, error=%d", Math.abs(initResult.retVal));
            throw new IllegalArgumentException(errMsg);
        }
        this.mNativeHandle = initResult.nativeHandle;
    }

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    public synchronized void doDestroy(@Nullable IRtcEngineReleaseCallback callback) {
        MediaPlayerCacheManagerImpl.destroyMediaPlayerCacheManager();
        H265TranscoderImpl.destroyInstance();
        if (this.mNativeHandle != 0L) {
            RtcEngineImpl.nativeDestroy(this.mNativeHandle, callback);
            this.mNativeHandle = 0L;
            sLibLoaded = false;
        }
    }

    public synchronized void reinitialize(RtcEngineConfig config) {
        this.mRtcHandlers.clear();
        this.addHandler(config.mEventHandler);
    }

    @Override
    public synchronized void addHandler(IRtcEngineEventHandler handler) {
        if (null != handler) {
            RtcEngineEventHandlerProxy handlerProxy = new RtcEngineEventHandlerProxy(handler);
            this.mRtcHandlers.put(handler, handlerProxy);
        }
    }

    @Override
    public synchronized void removeHandler(IRtcEngineEventHandler handler) {
        if (null != handler) {
            this.mRtcHandlers.remove(handler);
        }
    }

    public synchronized void recordCreateEngineTimeStamp(long startTs, long endTs) {
        if (this.mNativeHandle != 0L) {
            this.nativeRecordCreateEngineTimeStamp(this.mNativeHandle, startTs, endTs);
        }
    }

    @Override
    public synchronized void addHandlerEx(IRtcEngineEventHandler handler, RtcConnection connection) {
        if (handler == null || connection == null) {
            return;
        }
        Pair key = Pair.create((Object)RtcEngineImpl.getChannelId(connection), (Object)RtcEngineImpl.getUserId(connection));
        this.addHandlerExKey((Pair<String, Object>)key, handler);
    }

    private void addHandlerExKey(Pair<String, Object> key, IRtcEngineEventHandler handler) {
        ArrayList<RtcEngineEventHandlerProxy> proxys = this.mRtcExHandlerMap.get(key);
        if (proxys == null) {
            proxys = new ArrayList();
        }
        for (RtcEngineEventHandlerProxy proxy : proxys) {
            if (proxy.getHandler() != handler) continue;
            proxys.remove(proxy);
            break;
        }
        RtcEngineEventHandlerProxy newProxy = new RtcEngineEventHandlerProxy(handler);
        proxys.add(newProxy);
        this.mRtcExHandlerMap.put(key, proxys);
    }

    @Override
    public synchronized void removeHandlerEx(IRtcEngineEventHandler handler, RtcConnection connection) {
        if (handler == null || connection == null) {
            return;
        }
        Pair key = Pair.create((Object)RtcEngineImpl.getChannelId(connection), (Object)RtcEngineImpl.getUserId(connection));
        ArrayList<RtcEngineEventHandlerProxy> proxys = this.mRtcExHandlerMap.get(key);
        if (proxys != null) {
            for (RtcEngineEventHandlerProxy proxy : proxys) {
                if (proxy.getHandler() != handler) continue;
                proxys.remove(proxy);
                break;
            }
        }
    }

    private static String toStringUserId(int uid) {
        return RtcEngineMessage.toStringUserId(uid);
    }

    private boolean validateVideoRendererView(VideoCanvas canvas) {
        if (canvas == null) {
            return false;
        }
        if (canvas.view == null && canvas.surfaceTexture == null) {
            return true;
        }
        if (canvas.view != null) {
            return canvas.view instanceof SurfaceView || canvas.view instanceof TextureView;
        }
        return canvas.surfaceTexture instanceof SurfaceTexture;
    }

    private int[] getRect(Rect src) {
        if (null == src) {
            return null;
        }
        int[] rect = new int[]{src.left, src.top, src.right - src.left, src.bottom - src.top};
        return rect;
    }

    @Override
    public synchronized int setupRemoteVideo(VideoCanvas remote) {
        return this.setupRemoteVideoEx(remote, null);
    }

    @Override
    public synchronized int setupRemoteVideoEx(VideoCanvas remote, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (remote == null) {
            return -2;
        }
        if (!this.validateVideoRendererView(remote)) {
            return -2;
        }
        if (0 == remote.uid) {
            return -1;
        }
        int[] rect = this.getRect(remote.rect);
        return this.nativeSetupRemoteVideo(this.mNativeHandle, remote.view, remote.surfaceTexture, remote.renderMode, remote.mirrorMode, remote.uid, remote.subviewUid, rect, remote.setupMode, remote.enableAlphaMask, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection), remote.backgroundColor);
    }

    @Override
    public synchronized int setupLocalVideo(VideoCanvas local) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (local != null) {
            if (!this.validateVideoRendererView(local)) {
                return -2;
            }
            int[] rect = null;
            if (local.rect != null) {
                rect = new int[]{local.rect.left, local.rect.top, local.rect.right - local.rect.left, local.rect.bottom - local.rect.top};
            }
            return this.nativeSetupLocalVideo(this.mNativeHandle, local.view, local.surfaceTexture, local.renderMode, local.mirrorMode, local.sourceType, local.mediaPlayerId, rect, local.setupMode, local.enableAlphaMask, Constants.VideoModulePosition.getValue(local.position), local.backgroundColor);
        }
        return this.nativeSetupLocalVideo(this.mNativeHandle, null, null, 1, 0, 0, 0, null, 1, false, Constants.VideoModulePosition.getValue(Constants.VideoModulePosition.VIDEO_MODULE_POSITION_POST_CAPTURER), 0);
    }

    @Override
    @Deprecated
    public synchronized int setLocalRenderMode(int renderMode) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLocalRenderMode(this.mNativeHandle, renderMode, 0);
    }

    @Override
    public synchronized int setLocalRenderMode(int renderMode, int mirrorMode) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLocalRenderMode(this.mNativeHandle, renderMode, mirrorMode);
    }

    @Override
    @Deprecated
    public synchronized int setRemoteRenderMode(int uid, int renderMode) {
        return this.setRemoteRenderModeEx(uid, renderMode, 2, null);
    }

    @Override
    public synchronized int setRemoteRenderMode(int uid, int renderMode, int mirrorMode) {
        return this.setRemoteRenderModeEx(uid, renderMode, mirrorMode, null);
    }

    @Override
    public synchronized int setRemoteRenderModeEx(int uid, int renderMode, int mirrorMode, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRemoteRenderMode(this.mNativeHandle, uid, renderMode, mirrorMode, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    @Deprecated
    public synchronized int setLocalVideoMirrorMode(int mode) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return -2;
            }
        }
        return this.nativeSetLocalVideoMirrorMode(this.mNativeHandle, mode);
    }

    @Override
    public synchronized int addVideoWatermark(AgoraImage watermark) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (watermark == null || TextUtils.isEmpty((CharSequence)watermark.url)) {
            return -2;
        }
        WatermarkOptions options = new WatermarkOptions();
        String watermarkUrl = watermark.url;
        options.visibleInPreview = false;
        options.positionInPortraitMode = options.positionInLandscapeMode = new WatermarkOptions.Rectangle(watermark.x, watermark.y, watermark.width, watermark.height);
        return this.addVideoWatermark(watermarkUrl, options);
    }

    private int[] getRect(WatermarkOptions.Rectangle src) {
        int[] rect = new int[4];
        if (null != src) {
            rect[0] = src.x;
            rect[1] = src.y;
            rect[2] = src.width;
            rect[3] = src.height;
        }
        return rect;
    }

    @Override
    public synchronized int addVideoWatermark(String watermarkUrl, WatermarkOptions options) {
        return this.addVideoWatermarkEx(watermarkUrl, options, null);
    }

    @Override
    public synchronized int addVideoWatermarkEx(String watermarkUrl, WatermarkOptions options, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (watermarkUrl == null || TextUtils.isEmpty((CharSequence)watermarkUrl) || options == null) {
            return -2;
        }
        int[] lrect = this.getRect(options.positionInLandscapeMode);
        int[] prect = this.getRect(options.positionInPortraitMode);
        if (connection == null) {
            return this.nativeAddVideoWatermark(this.mNativeHandle, watermarkUrl, options.visibleInPreview, lrect, prect);
        }
        return this.nativeAddVideoWatermarkEx(this.mNativeHandle, watermarkUrl, options.visibleInPreview, lrect, prect, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int clearVideoWatermarkEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeClearVideoWatermarkEx(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int clearVideoWatermarks() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeClearVideoWatermarks(this.mNativeHandle);
    }

    @Override
    public synchronized int enableDualStreamMode(boolean enabled) {
        return this.enableDualStreamMode(enabled, new SimulcastStreamConfig());
    }

    @Override
    public synchronized int enableDualStreamMode(boolean enabled, SimulcastStreamConfig streamConfig) {
        return this.enableDualStreamModeEx(enabled, streamConfig, null);
    }

    @Override
    public synchronized int enableDualStreamModeEx(boolean enabled, SimulcastStreamConfig streamConfig, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (streamConfig == null) {
            streamConfig = new SimulcastStreamConfig();
        }
        return this.nativeEnableDualStreamModeEx(this.mNativeHandle, enabled, streamConfig, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setDualStreamMode(Constants.SimulcastStreamMode mode) {
        return this.setDualStreamMode(mode, new SimulcastStreamConfig());
    }

    @Override
    public synchronized int setDualStreamMode(Constants.SimulcastStreamMode mode, SimulcastStreamConfig streamConfig) {
        return this.setDualStreamModeEx(mode, streamConfig, null);
    }

    @Override
    public synchronized int setDualStreamModeEx(Constants.SimulcastStreamMode mode, SimulcastStreamConfig streamConfig, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (streamConfig == null) {
            streamConfig = new SimulcastStreamConfig();
        }
        return this.nativeSetDualStreamModeEx(this.mNativeHandle, Constants.SimulcastStreamMode.getValue(mode), streamConfig, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setSimulcastConfig(SimulcastConfig simulcastConfig) {
        return this.setSimulcastConfigEx(simulcastConfig, null);
    }

    @Override
    public synchronized int setSimulcastConfigEx(SimulcastConfig simulcastConfig, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (simulcastConfig == null) {
            return -2;
        }
        return this.nativeSetSimulcastConfigEx(this.mNativeHandle, simulcastConfig.configs, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setLocalRenderTargetFps(Constants.VideoSourceType sourceType, int targetFps) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativesetLocalRenderTargetFps(this.mNativeHandle, Constants.VideoSourceType.getValue(sourceType), targetFps);
    }

    @Override
    public synchronized int setRemoteRenderTargetFps(int targetFps) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativesetRemoteRenderTargetFps(this.mNativeHandle, targetFps);
    }

    @Override
    @Deprecated
    public synchronized void monitorHeadsetEvent(boolean monitor) {
        Logging.i(TAG, "enter monitorHeadsetEvent:" + monitor);
    }

    @Override
    public synchronized int queryScreenCaptureCapability() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeQueryScreenCaptureCapability(this.mNativeHandle);
    }

    @Override
    @Deprecated
    @TargetApi(value=11)
    public synchronized void monitorBluetoothHeadsetEvent(boolean monitor) {
        Logging.i(TAG, "enter monitorBluetoothHeadsetEvent:" + monitor);
    }

    @Override
    public synchronized boolean enableHighPerfWifiMode(boolean enable) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return false;
        }
        if (enable) {
            int wakeLock = context.checkPermission("android.permission.WAKE_LOCK", Process.myPid(), Process.myUid());
            if (wakeLock != 0) {
                Logging.w(TAG, "Failed to enableHighPerfWifiMode, permission WAKE_LOCK not granted ");
                this.mWifiLock = null;
                return false;
            }
            if (this.mWifiLock == null) {
                WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                this.mWifiLock = wifiManager.createWifiLock(3, "agora.voip.lock");
            }
        } else {
            this.mWifiLock = null;
        }
        return true;
    }

    private void doMonitorSystemEvent(Context context) {
        if (CommonUtility.getInstance(context).getNetworkType() != 2) {
            return;
        }
        if (this.mWifiLock != null) {
            this.mWifiLock.acquire();
            Logging.i(TAG, "hp connection mode detected");
        }
    }

    private void doStopMonitorSystemEvent() {
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
            Logging.i(TAG, "hp connection mode ended");
        }
    }

    @Override
    public synchronized int preloadChannel(String token, String channelName, int optionalUid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePreloadChannel(this.mNativeHandle, token, channelName, optionalUid);
    }

    @Override
    public synchronized int preloadChannelWithUserAccount(String token, String channelName, String userAccount) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePreloadChannelWithUserAccount(this.mNativeHandle, token, channelName, userAccount);
    }

    @Override
    public synchronized int updatePreloadChannelToken(String token) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUpdatePreloadChannelToken(this.mNativeHandle, token);
    }

    @Override
    public synchronized int joinChannel(String key, String channelName, String optionalInfo, int uid) {
        Context context = (Context)this.mContext.get();
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeJoinChannel(this.mNativeHandle, key, channelName, optionalInfo, uid);
    }

    @Override
    public synchronized int joinChannel(String token, String channelId, int uid, ChannelMediaOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeJoinChannel2(this.mNativeHandle, token, channelId, uid, options);
    }

    @Override
    public synchronized int joinChannelEx(String token, RtcConnection connection, ChannelMediaOptions options, IRtcEngineEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        String channelId = RtcEngineImpl.getChannelId(connection);
        if (null == channelId || channelId.isEmpty()) {
            return -2;
        }
        int uid = RtcEngineImpl.getUserId(connection);
        int result = this.nativeJoinChannelEx(this.mNativeHandle, token, channelId, uid, options);
        if (result == 0 && null != eventHandler) {
            this.mRtcExHandlerMap.remove(Pair.create((Object)channelId, (Object)uid));
            this.addHandlerEx(eventHandler, connection);
        }
        return result;
    }

    @Override
    public synchronized int updateChannelMediaOptions(ChannelMediaOptions options) {
        return this.updateChannelMediaOptionsEx(options, null);
    }

    @Override
    public synchronized int updateChannelMediaOptionsEx(ChannelMediaOptions options, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUpdateChannelMediaOptions(this.mNativeHandle, options, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int leaveChannel() {
        return this.leaveChannel(new LeaveChannelOptions());
    }

    @Override
    public synchronized int leaveChannel(LeaveChannelOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        this.doStopMonitorSystemEvent();
        return this.nativeLeaveChannel(this.mNativeHandle, options);
    }

    @Override
    public synchronized int leaveChannelEx(RtcConnection connection) {
        return this.leaveChannelEx(connection, new LeaveChannelOptions());
    }

    @Override
    public synchronized int leaveChannelEx(RtcConnection connection, LeaveChannelOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeLeaveChannelEx(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection), options);
    }

    @Override
    public int leaveChannelWithUserAccountEx(String channelId, String userAccount) {
        return this.leaveChannelWithUserAccountEx(channelId, userAccount, new LeaveChannelOptions());
    }

    @Override
    public int leaveChannelWithUserAccountEx(String channelId, String userAccount, LeaveChannelOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeLeaveChannelWithUserAccountEx(this.mNativeHandle, channelId, userAccount, options);
    }

    @Override
    public synchronized int setLocalAccessPoint(LocalAccessPointConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (config.ipList == null) {
            config.ipList = new ArrayList();
        }
        if (config.domainList == null) {
            config.domainList = new ArrayList();
        }
        if (config.verifyDomainName == null) {
            config.verifyDomainName = "";
        }
        if (config.advancedConfig == null) {
            config.advancedConfig = new LocalAccessPointConfiguration.AdvancedConfigInfo();
        }
        return this.nativeSetLocalAccessPoint(this.mNativeHandle, config.ipList, config.domainList, config.verifyDomainName, config.mode, config.advancedConfig, config.disableAut);
    }

    private int setUidCompatibleMode(boolean enabled) {
        return this.setParameter("rtc.api.set_uid_compatible_mode", enabled);
    }

    @Override
    public synchronized int startEchoTest(EchoTestConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTestWithConfig(this.mNativeHandle, (View)config.view, config.enableAudio, config.enableVideo, config.token, config.channelId, config.intervalInSeconds);
    }

    @Override
    public synchronized int setCloudProxy(int proxyType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCloudProxy(this.mNativeHandle, proxyType);
    }

    @Override
    public synchronized int getNetworkType() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetNetworkType(this.mNativeHandle);
    }

    @Override
    public synchronized int stopEchoTest() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopEchoTest(this.mNativeHandle);
    }

    @Override
    public synchronized int startLastmileProbeTest(LastmileProbeConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartLastmileProbeTest(this.mNativeHandle, config.probeUplink, config.probeDownlink, config.expectedUplinkBitrate, config.expectedDownlinkBitrate);
    }

    @Override
    public synchronized int stopLastmileProbeTest() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopLastmileProbeTest(this.mNativeHandle);
    }

    @Override
    public synchronized int enableVideo() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableVideo(this.mNativeHandle);
    }

    @Override
    public synchronized int disableVideo() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDisableVideo(this.mNativeHandle);
    }

    @Override
    public synchronized int enableLocalVideo(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableLocalVideo(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int startCameraCapture(Constants.VideoSourceType sourceType, CameraCapturerConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (null == config) {
            return -2;
        }
        return this.nativeStartCameraCapture(this.mNativeHandle, Constants.VideoSourceType.getValue(sourceType), config);
    }

    @Override
    public synchronized int stopCameraCapture(Constants.VideoSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopCameraCapture(this.mNativeHandle, Constants.VideoSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int startLocalVideoTranscoder(LocalTranscoderConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        RtcEngineMessage.PLocalLiveTranscoderConfiguration pt = new RtcEngineMessage.PLocalLiveTranscoderConfiguration();
        byte[] data = pt.marshall(config);
        return this.nativeStartLocalVideoTranscoder(this.mNativeHandle, data);
    }

    @Override
    public synchronized int updateLocalTranscoderConfiguration(LocalTranscoderConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        RtcEngineMessage.PLocalLiveTranscoderConfiguration pt = new RtcEngineMessage.PLocalLiveTranscoderConfiguration();
        byte[] data = pt.marshall(config);
        return this.nativeUpdateLocalTranscoderConfiguration(this.mNativeHandle, data);
    }

    @Override
    public synchronized int stopLocalVideoTranscoder() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopLocalVideoTranscoder(this.mNativeHandle);
    }

    @Override
    public synchronized int startLocalAudioMixer(LocalAudioMixerConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        RtcEngineMessage.PLocalAudioMixedTrackConfiguration pt = new RtcEngineMessage.PLocalAudioMixedTrackConfiguration();
        byte[] data = pt.marshall(config);
        return this.nativeStartLocalAudioMixer(this.mNativeHandle, data);
    }

    @Override
    public synchronized int updateLocalAudioMixerConfiguration(LocalAudioMixerConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        RtcEngineMessage.PLocalAudioMixedTrackConfiguration pt = new RtcEngineMessage.PLocalAudioMixedTrackConfiguration();
        byte[] data = pt.marshall(config);
        return this.nativeUpdateLocalAudioMixerConfiguration(this.mNativeHandle, data);
    }

    @Override
    public synchronized int stopLocalAudioMixer() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopLocalAudioMixer(this.mNativeHandle);
    }

    @Override
    public synchronized int startPreview() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartPreview(this.mNativeHandle);
    }

    @Override
    public synchronized int startPreview(Constants.VideoSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartPreviewForSourceType(this.mNativeHandle, Constants.VideoSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int stopPreview() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopPreview(this.mNativeHandle);
    }

    @Override
    public synchronized int stopPreview(Constants.VideoSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopPreviewForSourceType(this.mNativeHandle, Constants.VideoSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int enableAudio() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableAudio(this.mNativeHandle, true);
    }

    @Override
    public synchronized int disableAudio() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableAudio(this.mNativeHandle, false);
    }

    @Override
    public synchronized int enableLocalAudio(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableLocalAudio(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int pauseAudio() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePauseAudio(this.mNativeHandle);
    }

    @Override
    public synchronized int resumeAudio() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeResumeAudio(this.mNativeHandle);
    }

    @Override
    public synchronized int setBeautyEffectOptions(boolean enabled, BeautyOptions options) {
        return this.setBeautyEffectOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setBeautyEffectOptions(boolean enabled, BeautyOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetBeautyEffectOptions(this.mNativeHandle, enabled, options.lighteningContrastLevel, options.lighteningLevel, options.smoothnessLevel, options.rednessLevel, options.sharpnessLevel, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setFaceShapeBeautyOptions(boolean enabled, FaceShapeBeautyOptions options) {
        return this.setFaceShapeBeautyOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setFaceShapeBeautyOptions(boolean enabled, FaceShapeBeautyOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetFaceShapeBeautyOptions(this.mNativeHandle, enabled, options.shapeStyle, options.styleIntensity, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized FaceShapeBeautyOptions getFaceShapeBeautyOptions() {
        return this.getFaceShapeBeautyOptions(Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized FaceShapeBeautyOptions getFaceShapeBeautyOptions(Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeGetFaceShapeBeautyOptions(this.mNativeHandle, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setFaceShapeAreaOptions(FaceShapeAreaOptions options) {
        return this.setFaceShapeAreaOptions(options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setFaceShapeAreaOptions(FaceShapeAreaOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetFaceShapeAreaOptions(this.mNativeHandle, options.shapeArea, options.shapeIntensity, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized FaceShapeAreaOptions getFaceShapeAreaOptions(int shapeArea) {
        return this.getFaceShapeAreaOptions(shapeArea, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized FaceShapeAreaOptions getFaceShapeAreaOptions(int shapeArea, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeGetFaceShapeAreaOptions(this.mNativeHandle, shapeArea, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setFilterEffectOptions(boolean enabled, FilterEffectOptions options) {
        return this.setFilterEffectOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setFilterEffectOptions(boolean enabled, FilterEffectOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetFilterEffectOptions(this.mNativeHandle, enabled, options.path, options.strength, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setLowlightEnhanceOptions(boolean enabled, LowLightEnhanceOptions options) {
        return this.setLowlightEnhanceOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setLowlightEnhanceOptions(boolean enabled, LowLightEnhanceOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLowlightEnhanceOptions(this.mNativeHandle, enabled, options.lowlightEnhanceMode, options.lowlightEnhanceLevel, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setVideoDenoiserOptions(boolean enabled, VideoDenoiserOptions options) {
        return this.setVideoDenoiserOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setVideoDenoiserOptions(boolean enabled, VideoDenoiserOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVideoDenoiserOptions(this.mNativeHandle, enabled, options.denoiserMode, options.denoiserLevel, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setColorEnhanceOptions(boolean enabled, ColorEnhanceOptions options) {
        if (0L == this.mNativeHandle) {
            return -7;
        }
        return this.setColorEnhanceOptions(enabled, options, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int setColorEnhanceOptions(boolean enabled, ColorEnhanceOptions options, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetColorEnhanceOptions(this.mNativeHandle, enabled, options.strengthLevel, options.skinProtectLevel, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized IVideoEffectObject createVideoEffectObject(String bundlePath, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        int ret = this.nativeCreateVideoEffectObject(this.mNativeHandle, bundlePath, Constants.MediaSourceType.getValue(sourceType));
        if (ret != 0) {
            Logging.e(TAG, "Failed to create video effect object!");
            return null;
        }
        VideoEffectObjectImpl videoEffectObject = new VideoEffectObjectImpl(this, bundlePath);
        return videoEffectObject;
    }

    @Override
    public synchronized int destroyVideoEffectObject(IVideoEffectObject videoEffectObject) {
        if (this.mNativeHandle == 0L || null == videoEffectObject) {
            return -7;
        }
        return this.nativeDestroyVideoEffectObject(this.mNativeHandle);
    }

    public synchronized int addOrUpdateVideoEffect(int nodeId, String templateName) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAddOrUpdateVideoEffect(this.mNativeHandle, nodeId, templateName);
    }

    public synchronized int removeVideoEffect(int nodeId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveVideoEffect(this.mNativeHandle, nodeId);
    }

    public synchronized int performVideoEffectAction(int nodeId, int actionId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePerformVideoEffectAction(this.mNativeHandle, nodeId, actionId);
    }

    public synchronized int setVideoEffectFloatParam(String option, String key, float value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVideoEffectFloatParam(this.mNativeHandle, option, key, value);
    }

    public synchronized int setVideoEffectIntParam(String option, String key, int value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVideoEffectIntParam(this.mNativeHandle, option, key, value);
    }

    public synchronized int setVideoEffectBoolParam(String option, String key, boolean value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVideoEffectBoolParam(this.mNativeHandle, option, key, value);
    }

    public synchronized float getVideoEffectFloatParam(String option, String key) {
        if (this.mNativeHandle == 0L) {
            return 0.0f;
        }
        return this.nativeGetVideoEffectFloatParam(this.mNativeHandle, option, key);
    }

    public synchronized int getVideoEffectIntParam(String option, String key) {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.nativeGetVideoEffectIntParam(this.mNativeHandle, option, key);
    }

    public synchronized boolean getVideoEffectBoolParam(String option, String key) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.nativeGetVideoEffectBoolParam(this.mNativeHandle, option, key);
    }

    @Override
    public synchronized int enableVirtualBackground(boolean enabled, VirtualBackgroundSource backgroundSource, SegmentationProperty segProperty) {
        return this.enableVirtualBackground(enabled, backgroundSource, segProperty, Constants.MediaSourceType.PRIMARY_CAMERA_SOURCE);
    }

    @Override
    public synchronized int enableVirtualBackground(boolean enabled, VirtualBackgroundSource backgroundSource, SegmentationProperty segProperty, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (backgroundSource == null) {
            if (enabled) {
                return -2;
            }
            backgroundSource = new VirtualBackgroundSource();
        }
        if (segProperty == null) {
            if (enabled) {
                return -2;
            }
            segProperty = new SegmentationProperty();
        }
        return this.nativeEnableVirtualBackground(this.mNativeHandle, enabled, backgroundSource.backgroundSourceType, backgroundSource.color, backgroundSource.source, backgroundSource.blurDegree, segProperty.modelType, segProperty.greenCapacity, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setAdvancedAudioOptions(AdvancedAudioOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAdvancedAudioOptions(this.mNativeHandle, options.audioProcessingChannels.getValue());
    }

    @Override
    public synchronized int muteLocalAudioStream(boolean muted) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.muteLocalAudioStreamEx(muted, null);
    }

    @Override
    public synchronized int muteLocalAudioStreamEx(boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteLocalAudioStream(this.mNativeHandle, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int muteLocalVideoStream(boolean muted) {
        return this.muteLocalVideoStreamEx(muted, null);
    }

    @Override
    public synchronized int muteLocalVideoStreamEx(boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteLocalVideoStream(this.mNativeHandle, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int muteAllRemoteAudioStreams(boolean muted) {
        return this.muteAllRemoteAudioStreamsEx(muted, null);
    }

    @Override
    public synchronized int muteAllRemoteAudioStreamsEx(boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteAllRemoteAudioStreams(this.mNativeHandle, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int muteAllRemoteVideoStreams(boolean muted) {
        return this.muteAllRemoteVideoStreamsEx(muted, null);
    }

    @Override
    public synchronized int muteAllRemoteVideoStreamsEx(boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteAllRemoteVideoStreams(this.mNativeHandle, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int muteRemoteAudioStream(int uid, boolean muted) {
        return this.muteRemoteAudioStreamEx(uid, muted, null);
    }

    @Override
    public synchronized int muteRemoteAudioStreamEx(int uid, boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteRemoteAudioStream(this.mNativeHandle, uid, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int muteRemoteVideoStream(int uid, boolean muted) {
        return this.muteRemoteVideoStreamEx(uid, muted, null);
    }

    @Override
    public synchronized int muteRemoteVideoStreamEx(int uid, boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteRemoteVideoStream(this.mNativeHandle, uid, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int renewToken(String token) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (token == null) {
            return -2;
        }
        return this.nativeRenewToken(this.mNativeHandle, token);
    }

    @Override
    public synchronized int setDefaultAudioRoutetoSpeakerphone(boolean defaultToSpeaker) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetDefaultAudioRoutetoSpeakerphone(this.mNativeHandle, defaultToSpeaker);
    }

    @Override
    public synchronized int setEnableSpeakerphone(boolean speakerOn) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetEnableSpeakerphone(this.mNativeHandle, speakerOn);
    }

    @Override
    public synchronized int setRouteInCommunicationMode(int route) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRouteInCommunicationMode(this.mNativeHandle, route);
    }

    @Override
    public synchronized boolean isSpeakerphoneEnabled() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.nativeIsSpeakerphoneEnabled(this.mNativeHandle);
    }

    @Override
    public synchronized int muteRecordingSignal(boolean muted) {
        return this.muteRecordingSignalEx(muted, null);
    }

    @Override
    public synchronized int muteRecordingSignalEx(boolean muted, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteRecordingSignal(this.mNativeHandle, muted, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int adjustRecordingSignalVolume(int volume) {
        return this.adjustRecordingSignalVolumeEx(volume, null);
    }

    @Override
    public synchronized int adjustRecordingSignalVolumeEx(int volume, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustRecordingSignalVolume(this.mNativeHandle, volume, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int adjustPlaybackSignalVolume(int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustPlaybackSignalVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized int adjustUserPlaybackSignalVolume(int uid, int volume) {
        return this.adjustUserPlaybackSignalVolumeEx(uid, volume, null);
    }

    @Override
    public synchronized int adjustUserPlaybackSignalVolumeEx(int uid, int volume, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustUserPlaybackSignalVolume(this.mNativeHandle, uid, volume, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRecordingAudioFrameParameters(this.mNativeHandle, sampleRate, channel, mode, samplesPerCall);
    }

    @Override
    public synchronized int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetPlaybackAudioFrameParameters(this.mNativeHandle, sampleRate, channel, mode, samplesPerCall);
    }

    @Override
    public synchronized int setMixedAudioFrameParameters(int sampleRate, int channel, int samplesPerCall) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetMixedAudioFrameParameters(this.mNativeHandle, sampleRate, channel, samplesPerCall);
    }

    @Override
    public synchronized int setEarMonitoringAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetEarMonitoringAudioFrameParameters(this.mNativeHandle, sampleRate, channel, mode, samplesPerCall);
    }

    @Override
    public synchronized int setPlaybackAudioFrameBeforeMixingParameters(int sampleRate, int channel) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetPlaybackAudioFrameBeforeMixingParameters(this.mNativeHandle, sampleRate, channel);
    }

    synchronized int mediaPlayerRegisterAudioFrameObserver(int sourceId, IMediaPlayerAudioFrameObserver audioFrameObserver, int mode) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerRegisterAudioFrameObserver)");
            return -7;
        }
        return this.nativeMediaPlayerRegisterAudioFrameObserver(this.mNativeHandle, sourceId, audioFrameObserver, mode);
    }

    synchronized int mediaPlayerRegisterVideoFrameObserver(int sourceId, IMediaPlayerVideoFrameObserver observer) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerRegisterVideoFrameObserver)");
            return -7;
        }
        return this.nativeMediaPlayerRegisterVideoFrameObserver(this.mNativeHandle, sourceId, observer);
    }

    @Override
    public synchronized int registerAudioFrameObserver(IAudioFrameObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterAudioFrameObserver(this.mNativeHandle, observer);
    }

    @Override
    public synchronized int enableAudioSpectrumMonitor(int intervalInMS) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableAudioSpectrumMonitor(this.mNativeHandle, intervalInMS);
    }

    @Override
    public synchronized int disableAudioSpectrumMonitor() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDisableAudioSpectrumMonitor(this.mNativeHandle);
    }

    @Override
    public synchronized int registerAudioSpectrumObserver(IAudioSpectrumObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterAudioSpectrumObserver(this.mNativeHandle, observer);
    }

    @Override
    public synchronized int unRegisterAudioSpectrumObserver(IAudioSpectrumObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUnRegisterAudioSpectrumObserver(this.mNativeHandle, observer);
    }

    @Override
    public synchronized int registerAudioEncodedFrameObserver(AudioEncodedFrameObserverConfig config, IAudioEncodedFrameObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (config == null) {
            config = new AudioEncodedFrameObserverConfig();
        }
        return this.nativeregisterAudioEncodedFrameObserver(this.mNativeHandle, observer, config.postionType, config.encodingType);
    }

    @Override
    public synchronized int setHighQualityAudioParameters(boolean fullband, boolean stereo, boolean fullBitrate) {
        return this.setParameterObject("che.audio.codec.hq", RtcEngineImpl.formatString("{\"fullband\":%b,\"stereo\":%b,\"fullBitrate\":%b}", fullband, stereo, fullBitrate));
    }

    @Override
    public synchronized int enableInEarMonitoring(boolean enabled, int includeAudioFilters) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableInEarMonitoring(this.mNativeHandle, enabled, includeAudioFilters);
    }

    @Override
    public synchronized int enableInEarMonitoring(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.enableInEarMonitoring(enabled, 1);
    }

    @Override
    public synchronized int enableWebSdkInteroperability(boolean enabled) {
        return this.setParameters(String.format("{\"rtc.video.web_h264_interop_enable\":%b,\"che.video.web_h264_interop_enable\":%b}", enabled, enabled));
    }

    @Override
    public synchronized int enableWirelessAccelerate(boolean enabled) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.wifi_acc_enable\":%s}", enabled ? "true" : "false"));
    }

    @Override
    public synchronized int setVideoQualityParameters(boolean preferFrameRateOverImageQuality) {
        return this.setParameters(String.format("{\"rtc.video.prefer_frame_rate\":%b,\"che.video.prefer_frame_rate\":%b}", preferFrameRateOverImageQuality, preferFrameRateOverImageQuality));
    }

    @Override
    @Deprecated
    public synchronized void setPreferHeadset(boolean enabled) {
    }

    @Override
    public synchronized int enableAudioVolumeIndication(int interval, int smooth, boolean reportVad) {
        return this.enableAudioVolumeIndicationEx(interval, smooth, reportVad, null);
    }

    @Override
    public synchronized int enableAudioVolumeIndicationEx(int interval, int smooth, boolean reportVad, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableAudioVolumeIndication(this.mNativeHandle, interval, smooth, reportVad, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int enableTransportQualityIndication(boolean enabled) {
        return this.setParameter("rtc.transport_quality_indication", enabled);
    }

    @Override
    public synchronized int setVideoEncoderConfiguration(VideoEncoderConfiguration config) {
        return this.setVideoEncoderConfigurationEx(config, null);
    }

    @Override
    public synchronized int setVideoEncoderConfigurationEx(VideoEncoderConfiguration config, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVideoEncoderConfiguration(this.mNativeHandle, config.dimensions.width, config.dimensions.height, config.frameRate, config.bitrate, config.minBitrate, config.orientationMode.getValue(), config.mirrorMode.getValue(), config.degradationPrefer.getValue(), config.advanceOptions.compressionPreference.getValue(), config.advanceOptions.encodingPreference.getValue(), config.advanceOptions.encodeAlpha, config.codecType.getValue(), RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setVideoScenario(Constants.VideoScenario scenarioType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativesetVideoScenario(this.mNativeHandle, Constants.VideoScenario.getValue(scenarioType));
    }

    @Override
    public synchronized int setVideoQoEPreference(Constants.QoEPreference preferenceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativesetVideoQoEPreference(this.mNativeHandle, Constants.QoEPreference.getValue(preferenceType));
    }

    @Override
    public synchronized boolean isFeatureAvailableOnDevice(int type) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.nativeIsFeatureAvailableOnDevice(this.mNativeHandle, type);
    }

    @Override
    public synchronized int setAudioProfile(int profile, int scenario) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioProfileScenario(this.mNativeHandle, profile, scenario);
    }

    @Override
    public synchronized int setAudioProfile(int profile) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioProfile(this.mNativeHandle, profile);
    }

    @Override
    public synchronized int setAudioScenario(int scenario) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioScenario(this.mNativeHandle, scenario);
    }

    @Override
    public synchronized int monitorAudioRouteChange(boolean isMonitoring) {
        Logging.i("API call monitorAudioRouteChange:" + isMonitoring);
        return 0;
    }

    @Override
    public synchronized int switchCamera() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSwitchCamera(this.mNativeHandle);
    }

    @Override
    public synchronized int switchCamera(String cameraId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSwitchCameraId(this.mNativeHandle, cameraId);
    }

    @Override
    public synchronized boolean isCameraZoomSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraZoomSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraTorchSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraTorchSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraFocusSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraFocusSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraFaceDetectSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraFaceDetectSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraAutoFocusFaceModeSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraAutoFocusFaceModeSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraExposurePositionSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraExposurePositionSupported(this.mNativeHandle);
    }

    @Override
    public synchronized boolean isCameraExposureSupported() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return false;
        }
        return this.nativeGetCameraExposureSupported(this.mNativeHandle);
    }

    @Override
    public synchronized int setCameraZoomFactor(float factor) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraZoomFactor(this.mNativeHandle, factor);
    }

    @Override
    public synchronized float getCameraMaxZoomFactor() {
        if (this.mNativeHandle == 0L) {
            return 1.0f;
        }
        return this.nativeGetCameraMaxZoomFactor(this.mNativeHandle);
    }

    @Override
    public synchronized int setCameraFocusPositionInPreview(float positionX, float positionY) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraFocusPositionInPreview(this.mNativeHandle, positionX, positionY);
    }

    @Override
    public synchronized int setCameraTorchOn(boolean isOn) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraTorchOn(this.mNativeHandle, isOn);
    }

    @Override
    public synchronized int enableFaceDetection(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableFaceDetection(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int setCameraAutoFocusFaceModeEnabled(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraAutoFocusFaceModeEnabled(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int setCameraExposureFactor(int factor) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraExposureFactor(this.mNativeHandle, factor);
    }

    @Override
    public int sendAudioMetadata(byte[] metadata) {
        return this.sendAudioMetadataEx(metadata, null);
    }

    @Override
    public synchronized int sendAudioMetadataEx(byte[] metadata, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSendAudioMetadata(this.mNativeHandle, metadata, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setCameraCapturerConfiguration(CameraCapturerConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (config == null) {
            Logging.e(TAG, "CameraCapturerConfiguration is null");
            return -2;
        }
        return this.nativeSetCameraCapturerConfiguration(this.mNativeHandle, config);
    }

    @Override
    public synchronized CodecCapInfo[] queryCodecCapability() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeQueryCodecCapability(this.mNativeHandle);
    }

    @Override
    public synchronized int queryDeviceScore() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeQueryDeviceScore(this.mNativeHandle);
    }

    @Override
    public synchronized AgoraFocalLengthInfo[] queryCameraFocalLengthCapability() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeQueryCameraFocalLengthCapability(this.mNativeHandle);
    }

    @Override
    public synchronized int setCameraExposurePosition(float positionXinView, float positionYinView) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetCameraExposurePosition(this.mNativeHandle, positionXinView, positionYinView);
    }

    @Override
    public synchronized int sendCustomReportMessage(String id, String category, String event, String label, int value) {
        return this.sendCustomReportMessageEx(id, category, event, label, value, null);
    }

    @Override
    public synchronized int sendCustomReportMessageEx(String id, String category, String event, String label, int value, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSendCustomReportMessage(this.mNativeHandle, id, category, event, label, value, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized IMediaPlayer createMediaPlayer() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        int sourceId = this.nativeCreateMediaPlayer(this.mNativeHandle);
        if (sourceId < 0) {
            return null;
        }
        return new MediaPlayerImpl(this, sourceId);
    }

    @Override
    public synchronized AgoraMediaRecorder createMediaRecorder(RecorderStreamInfo info) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        if (info == null) {
            Logging.e(TAG, "RecorderStreamInfo is null, return");
            return null;
        }
        return new AgoraMediaRecorder(this, info);
    }

    @Override
    public synchronized void destroyMediaRecorder(AgoraMediaRecorder mediaRecorder) {
        if (this.mNativeHandle == 0L || null == mediaRecorder) {
            return;
        }
        mediaRecorder.release();
    }

    @Override
    public IMediaPlayerCacheManager getMediaPlayerCacheManager() {
        IMediaPlayerCacheManager mediaPlayerCacheManager = null;
        if (this.mNativeHandle != 0L) {
            mediaPlayerCacheManager = MediaPlayerCacheManagerImpl.getMediaPlayerCacheManager(this);
            if (mediaPlayerCacheManager == null) {
                Logging.e(TAG, "mediaPlayerCacheManager is not init");
            }
        } else {
            Logging.e(TAG, "mNativeHandle is not init");
        }
        return mediaPlayerCacheManager;
    }

    synchronized int mediaPlayerOpen(int sourceId, String url, long startPos) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerOpen)");
            return -7;
        }
        return this.nativeMediaPlayerOpen(this.mNativeHandle, sourceId, url, startPos);
    }

    synchronized int mediaPlayerPlay(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerPlay)");
            return -7;
        }
        return this.nativeMediaPlayerPlay(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerPause(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerPause)");
            return -7;
        }
        return this.nativeMediaPlayerPause(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerStop(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerStop)");
            return -7;
        }
        return this.nativeMediaPlayerStop(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerResume(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerResume)");
            return -7;
        }
        return this.nativeMediaPlayerResume(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerSeek(int sourceId, long newPos) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSeek)");
            return -7;
        }
        return this.nativeMediaPlayerSeek(this.mNativeHandle, sourceId, newPos);
    }

    synchronized int mediaPlayerSetAudioPitch(int sourceId, int pitch) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetAudioPitch)");
            return -7;
        }
        return this.nativeMediaPlayerSetAudioPitch(this.mNativeHandle, sourceId, pitch);
    }

    synchronized long mediaPlayerGetPlayPosition(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetPlayPosition)");
            return -7L;
        }
        return this.nativeMediaPlayerGetPlayPosition(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerMute(int sourceId, boolean muted) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerMute)");
            return -7;
        }
        return this.nativeMediaPlayerMute(this.mNativeHandle, sourceId, muted);
    }

    synchronized boolean mediaPlayerGetMute(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerIsMuted)");
            return false;
        }
        return this.nativeMediaPlayerGetMute(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerGetState(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetState)");
            return -7;
        }
        return this.nativeMediaPlayerGetState(this.mNativeHandle, sourceId);
    }

    synchronized long mediaPlayerGetDuration(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetDuration)");
            return -7L;
        }
        return this.nativeMediaPlayerGetDuration(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerGetStreamCount(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetStreamCount)");
            return -7;
        }
        return this.nativeMediaPlayerGetStreamCount(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerSetView(int sourceId, View videoView) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetView)");
            return -7;
        }
        return this.nativeMediaPlayerSetView(this.mNativeHandle, sourceId, videoView);
    }

    synchronized int mediaPlayerSetRenderMode(int sourceId, int mode) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetRenderMode)");
            return -7;
        }
        return this.nativeMediaPlayerSetRenderMode(this.mNativeHandle, sourceId, mode);
    }

    synchronized MediaStreamInfo mediaPlayerGetStreamInfo(int sourceId, int index) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetStreamInfo)");
            return null;
        }
        return this.nativeMediaPlayerGetStreamInfo(this.mNativeHandle, sourceId, index);
    }

    synchronized int mediaPlayerSetLoopCount(int sourceId, int loopCount) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetLoopCount)");
            return -7;
        }
        return this.nativeMediaPlayerSetLoopCount(this.mNativeHandle, sourceId, loopCount);
    }

    synchronized int mediaPlayerChangePlaybackSpeed(int sourceId, int speed) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerChangePlaybackSpeed)");
            return -7;
        }
        return this.nativeMediaPlayerChangePlaybackSpeed(this.mNativeHandle, sourceId, speed);
    }

    synchronized int mediaPlayerSelectAudioTrack(int sourceId, int index) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSelectAudioTrack)");
            return -7;
        }
        return this.nativeMediaPlayerSelectAudioTrack(this.mNativeHandle, sourceId, index);
    }

    synchronized int mediaPlayerSelectMultiAudioTrack(int sourceId, int playoutTrackIndex, int publishTrackIndex) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSelectAudioTrack)");
            return -7;
        }
        return this.nativeMediaPlayerSelectMultiAudioTrack(this.mNativeHandle, sourceId, playoutTrackIndex, publishTrackIndex);
    }

    synchronized int mediaPlayerSetPlayerOption(int sourceId, String key, int value) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetPlayerOption)");
            return -7;
        }
        return this.nativeMediaPlayerSetPlayerOption(this.mNativeHandle, sourceId, key, value);
    }

    synchronized int mediaPlayerSetPlayerOptionString(int sourceId, String key, String value) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetPlayerOption)");
            return -7;
        }
        return this.nativeMediaPlayerSetPlayerOptionString(this.mNativeHandle, sourceId, key, value);
    }

    synchronized int mediaPlayerTakeScreenshot(int sourceId, String filename) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerTakeScreenshot)");
            return -7;
        }
        return this.nativeMediaPlayerTakeScreenshot(this.mNativeHandle, sourceId, filename);
    }

    synchronized int mediaPlayerSelectInternalSubtitle(int sourceId, int index) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSelectInternalSubtitle)");
            return -7;
        }
        return this.nativeMediaPlayerSelectInternalSubtitle(this.mNativeHandle, sourceId, index);
    }

    synchronized int mediaPlayerSetExternalSubtitle(int sourceId, String url) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetExternalSubtitle)");
            return -7;
        }
        return this.nativeMediaPlayerSetExternalSubtitle(this.mNativeHandle, sourceId, url);
    }

    synchronized int mediaPlayerAdjustPlayoutVolume(int sourceId, int volume) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerAdjustPlayoutVolume)");
            return -7;
        }
        return this.nativeMediaPlayerAdjustPlayoutVolume(this.mNativeHandle, sourceId, volume);
    }

    synchronized int mediaPlayerGetPlayoutVolume(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetPlayoutVolume)");
            return -7;
        }
        return this.nativeMediaPlayerGetPlayoutVolume(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerAdjustPublishSignalVolume(int sourceId, int volume) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerAdjustPublishSignalVolume)");
            return -7;
        }
        return this.nativeMediaPlayerAdjustPublishSignalVolume(this.mNativeHandle, sourceId, volume);
    }

    synchronized int mediaPlayerGetPublishSignalVolume(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetPublishSignalVolume)");
            return -7;
        }
        return this.nativeMediaPlayerGetPublishSignalVolume(this.mNativeHandle, sourceId);
    }

    synchronized String mediaPlayerGetPlaySrc(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetPlaySrc)");
            return null;
        }
        return this.nativeMediaPlayerGetPlaySrc(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerSwitchSrc(int sourceId, String src, boolean syncPts) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSwitchSrc(this.mNativeHandle, sourceId, src, syncPts);
    }

    synchronized int mediaPlayerPreloadSrc(int sourceId, String src, long startPos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerPreloadSrc(this.mNativeHandle, sourceId, src, startPos);
    }

    synchronized int mediaPlayerUnloadSrc(int sourceId, String src) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerUnloadSrc(this.mNativeHandle, sourceId, src);
    }

    synchronized int mediaPlayerPlayPreloadedSrc(int sourceId, String src) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerPlayPreloadedSrc(this.mNativeHandle, sourceId, src);
    }

    synchronized int mediaPlayerDestroy(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSourceDestroy)");
            return -7;
        }
        return this.nativeMediaPlayerDestroy(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerRegisterPlayerObserver(int sourceId, IMediaPlayerObserver playerObserver) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerRegisterPlayerObserver)");
            return -7;
        }
        return this.nativeMediaPlayerRegisterPlayerObserver(this.mNativeHandle, sourceId, playerObserver);
    }

    public synchronized int registerMediaPlayerAudioSpectrumObserver(int sourceId, IAudioSpectrumObserver observer, int intervalInMS) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterMediaPlayerAudioSpectrumObserver(this.mNativeHandle, sourceId, observer, intervalInMS);
    }

    public synchronized int unregisterMediaPlayerAudioSpectrumObserver(int sourceId, IAudioSpectrumObserver observer) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerUnRegisterPlayerObserver)");
            return -7;
        }
        return this.nativeUnRegisterMediaPlayerAudioSpectrumObserver(this.mNativeHandle, sourceId, observer);
    }

    synchronized int mediaPlayerUnRegisterPlayerObserver(int sourceId, IMediaPlayerObserver playerObserver) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerUnRegisterPlayerObserver)");
            return -7;
        }
        return this.nativeMediaPlayerUnRegisterPlayerObserver(this.mNativeHandle, sourceId, playerObserver);
    }

    synchronized int mediaPlayerOpenWithAgoraCDNSrc(int sourceId, String src, long startPos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerOpenWithAgoraCDNSrc(this.mNativeHandle, sourceId, src, startPos);
    }

    synchronized int mediaPlayerGetAgoraCDNLineCount(int sourceId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerGetAgoraCDNLineCount(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerSwitchAgoraCDNLineByIndex(int sourceId, int index) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSwitchAgoraCDNLineByIndex(this.mNativeHandle, sourceId, index);
    }

    synchronized int mediaPlayerGetCurrentAgoraCDNIndex(int sourceId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerGetCurrentAgoraCDNIndex(this.mNativeHandle, sourceId);
    }

    synchronized int mediaPlayerEnableAutoSwitchAgoraCDN(int sourceId, boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerEnableAutoSwitchAgoraCDN(this.mNativeHandle, sourceId, enable);
    }

    synchronized int mediaPlayerRenewAgoraCDNSrcToken(int sourceId, String token, long ts) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerRenewAgoraCDNSrcToken(this.mNativeHandle, sourceId, token, ts);
    }

    synchronized int mediaPlayerSwitchAgoraCDNSrc(int sourceId, String src, boolean syncPts) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSwitchAgoraCDNSrc(this.mNativeHandle, sourceId, src, syncPts);
    }

    synchronized int mediaPlayerSetAudioDualMonoMode(int sourceId, int mode) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetAudioDualMonoMode)");
            return -7;
        }
        return this.nativeMediaPlayerSetAudioDualMonoMode(this.mNativeHandle, sourceId, mode);
    }

    synchronized int mediaPlayerSetSpatialAudioParams(int sourceId, SpatialAudioParams params) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerSetSpatialAudioParams)");
            return -7;
        }
        return this.nativeMediaPlayerSetSpatialAudioParams(this.mNativeHandle, sourceId, params);
    }

    synchronized int mediaPlayerGetAudioBufferDelay(int sourceId) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed (mediaPlayerGetAudioBufferDelay)");
            return -7;
        }
        return this.nativeMediaPlayerGetAudioBufferDelay(this.mNativeHandle, sourceId);
    }

    synchronized int initMediaPlayerCacheManager() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeInitMediaPlayerCacheManager(this.mNativeHandle);
    }

    synchronized int mediaPlayerOpenWithMediaSource(int sourceId, MediaPlayerSource source) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerOpenWithSource(this.mNativeHandle, sourceId, source);
    }

    synchronized int mediaPlayerCacheRemoveAllCaches() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerRemoveAllCaches(this.mNativeHandle);
    }

    synchronized int mediaPlayerCacheRemoveOldCache() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerRemoveOldCache(this.mNativeHandle);
    }

    synchronized int mediaPlayerCacheRemoveCacheByUri(String uri) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerRemoveCacheByUri(this.mNativeHandle, uri);
    }

    synchronized int mediaPlayerCacheSetCacheDir(String path) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSetCacheDir(this.mNativeHandle, path);
    }

    synchronized int mediaPlayerCacheSetMaxCacheFileCount(int count) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSetMaxCacheFileCount(this.mNativeHandle, count);
    }

    synchronized int mediaPlayerCacheSetMaxCacheFileSize(long cacheSize) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerSetMaxCacheFileSize(this.mNativeHandle, cacheSize);
    }

    synchronized int mediaPlayerCacheEnableAutoRemoveCache(boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerEnableAutoRemoveCache(this.mNativeHandle, enable);
    }

    synchronized String mediaPlayerCacheGetCacheDir() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeMediaPlayerGetCacheDir(this.mNativeHandle);
    }

    synchronized int mediaPlayerCacheGetMaxCacheFileCount() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerGetMaxCacheFileCount(this.mNativeHandle);
    }

    synchronized long mediaPlayerCacheGetMaxCacheFileSize() {
        if (this.mNativeHandle == 0L) {
            return -7L;
        }
        return this.nativeMediaPlayerGetMaxCacheFileSize(this.mNativeHandle);
    }

    synchronized int mediaPlayerCacheGetCacheFileCount() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMediaPlayerGetCacheFileCount(this.mNativeHandle);
    }

    @Override
    public synchronized IH265Transcoder getH265Transcoder() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        H265TranscoderImpl h265Transcoder = null;
        if (0 <= this.nativeCreateH265Transcoder(this.mNativeHandle)) {
            h265Transcoder = H265TranscoderImpl.getInstance(this);
        }
        return h265Transcoder;
    }

    public synchronized int h265TranscoderEnableTranscode(String token, String channel, int uid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeH265TranscoderEnableTranscode(this.mNativeHandle, token, channel, uid);
    }

    public synchronized int h265TranscoderQueryChannel(String token, String originChannal, int uid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeH265TranscoderQueryChannel(this.mNativeHandle, token, originChannal, uid);
    }

    public synchronized int h265TranscoderTriggerTranscode(String token, String channel, int uid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeH265TranscoderTriggerTranscode(this.mNativeHandle, token, channel, uid);
    }

    public synchronized int h265TranscoderRegisterObserver(IH265TranscoderObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeH265TranscoderRegisterObserver(this.mNativeHandle, observer);
    }

    public synchronized int h265TranscoderUnregisterObserver(IH265TranscoderObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeH265TranscoderUnregisterObserver(this.mNativeHandle, observer);
    }

    public synchronized int enableRemoteVideo(boolean enabled, int uid) {
        return this.setParameterObject("che.video.peer.receive", RtcEngineImpl.formatString("{\"enable\":%b, \"uid\":\"%s\"}", enabled, RtcEngineImpl.toStringUserId(uid)));
    }

    public synchronized int stopRemoteVideo(int uid) {
        return this.setParameter("che.video.peer.stop_video", RtcEngineImpl.toStringUserId(uid));
    }

    private static String formatString(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public synchronized int stopAllRemoteVideo() {
        return this.setParameter("che.video.peer.stop_all_renders", true);
    }

    @Override
    public synchronized int startAudioRecording(String filePath, int quality) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return -2;
        }
        return this.nativeStartAudioRecording(this.mNativeHandle, filePath, quality);
    }

    @Override
    public synchronized int startAudioRecording(AudioRecordingConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (TextUtils.isEmpty((CharSequence)config.filePath)) {
            return -2;
        }
        return this.nativeStartAudioRecording2(this.mNativeHandle, config.filePath, config.codec, config.sampleRate, config.fileRecordOption, config.quality, config.recordingChannel);
    }

    @Override
    public synchronized int stopAudioRecording() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopAudioRecording(this.mNativeHandle);
    }

    @Override
    public synchronized int startAudioMixing(String filePath, boolean loopback, int cycle) {
        return this.startAudioMixing(filePath, loopback, cycle, 0);
    }

    @Override
    public synchronized int startAudioMixing(String filePath, boolean loopback, int cycle, int startPos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartAudioMixing(this.mNativeHandle, filePath, loopback, cycle, startPos);
    }

    @Override
    public synchronized int stopAudioMixing() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopAudioMixing(this.mNativeHandle);
    }

    @Override
    public synchronized int pauseAudioMixing() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePauseAudioMixing(this.mNativeHandle);
    }

    @Override
    public synchronized int resumeAudioMixing() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeResumeAudioMixing(this.mNativeHandle);
    }

    @Override
    public synchronized int adjustAudioMixingVolume(int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustAudioMixingVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized int adjustAudioMixingPublishVolume(int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustAudioMixingPublishVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized int getAudioMixingPublishVolume() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetAudioMixingPublishVolume(this.mNativeHandle);
    }

    @Override
    public synchronized int adjustAudioMixingPlayoutVolume(int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustAudioMixingPlayoutVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized int getAudioMixingPlayoutVolume() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetAudioMixingPlayoutVolume(this.mNativeHandle);
    }

    @Override
    public synchronized int getAudioMixingDuration() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetAudioMixingDuration(this.mNativeHandle);
    }

    @Override
    public synchronized int getAudioMixingCurrentPosition() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetAudioMixingCurrentPosition(this.mNativeHandle);
    }

    @Override
    public synchronized int setAudioMixingPosition(int pos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioMixingPosition(this.mNativeHandle, pos);
    }

    @Override
    public synchronized int setAudioMixingDualMonoMode(Constants.AudioMixingDualMonoMode mode) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioMixingDualMonoMode(this.mNativeHandle, Constants.AudioMixingDualMonoMode.getValue(mode));
    }

    @Override
    public synchronized int setAudioMixingPitch(int pitch) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioMixingPitch(this.mNativeHandle, pitch);
    }

    @Override
    public synchronized int setAudioMixingPlaybackSpeed(int speed) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioMixingPlaybackSpeed(this.mNativeHandle, speed);
    }

    @Override
    public synchronized int selectAudioTrack(int audioIndex) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSelectAudioTrack(this.mNativeHandle, audioIndex);
    }

    @Override
    public synchronized int getAudioTrackCount() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetAudioTrackCount(this.mNativeHandle);
    }

    @Override
    public synchronized int startRecordingDeviceTest(int indicationInterval) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartRecordingDeviceTest(this.mNativeHandle, indicationInterval);
    }

    @Override
    public synchronized int stopRecordingDeviceTest() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopRecordingDeviceTest(this.mNativeHandle);
    }

    @Override
    public synchronized int startPlaybackDeviceTest(String audioFileName) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartPlaybackDeviceTest(this.mNativeHandle, audioFileName);
    }

    @Override
    public synchronized int stopPlaybackDeviceTest() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopPlaybackDeviceTest(this.mNativeHandle);
    }

    @Override
    public synchronized int createCustomAudioTrack(Constants.AudioTrackType trackType, AudioTrackConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCreateCustomAudioTrack(this.mNativeHandle, Constants.AudioTrackType.getValue(trackType), config.enableLocalPlayback, config.enableAudioProcessing);
    }

    @Override
    public synchronized int destroyCustomAudioTrack(int audioTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDestroyCustomAudioTrack(this.mNativeHandle, audioTrackId);
    }

    @Override
    public synchronized int setExternalAudioSource(boolean enabled, int sampleRate, int channels) {
        return this.setExternalAudioSource(enabled, sampleRate, channels, false, true);
    }

    @Override
    public synchronized int setExternalAudioSource(boolean enabled, int sampleRate, int channels, boolean localPlayback, boolean publish) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        this.mExSourceAudioSampleRate = sampleRate;
        this.mExSourceAudioChannels = channels;
        return this.nativeSetExternalAudioSource(this.mNativeHandle, enabled, sampleRate, channels, localPlayback, publish);
    }

    @Override
    public synchronized int pushExternalAudioFrame(byte[] data, long timestamp) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (data == null) {
            return -2;
        }
        ByteBuffer frame = ByteBuffer.allocateDirect(data.length);
        frame.order(ByteOrder.LITTLE_ENDIAN);
        frame.put(data, 0, data.length);
        frame.flip();
        return this.pushExternalAudioFrame(frame, timestamp, 0);
    }

    @Override
    public synchronized int pushExternalAudioFrame(ByteBuffer data, long timestamp, int trackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (!data.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer!");
        }
        return this.nativePushExternalAudioFrameRawData(this.mNativeHandle, data, timestamp, this.mExSourceAudioSampleRate, 2, this.mExSourceAudioChannels, trackId);
    }

    @Override
    public synchronized int pushExternalAudioFrame(byte[] data, long timestamp, int sampleRate, int channels, Constants.BytesPerSample bytesPerSample, int trackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (data == null) {
            return -2;
        }
        ByteBuffer frame = ByteBuffer.allocateDirect(data.length);
        frame.order(ByteOrder.LITTLE_ENDIAN);
        frame.put(data, 0, data.length);
        frame.flip();
        return this.nativePushExternalAudioFrameRawData(this.mNativeHandle, frame, timestamp, sampleRate, Constants.BytesPerSample.getValue(bytesPerSample), channels, trackId);
    }

    @Override
    public synchronized int pushExternalAudioFrame(ByteBuffer data, long timestamp, int sampleRate, int channels, Constants.BytesPerSample bytesPerSample, int trackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (!data.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer!");
        }
        return this.nativePushExternalAudioFrameRawData(this.mNativeHandle, data, timestamp, sampleRate, Constants.BytesPerSample.getValue(bytesPerSample), channels, trackId);
    }

    @Override
    public synchronized int setExternalAudioSink(boolean enabled, int sampleRate, int channels) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        this.mExSinkAudioSampleRate = sampleRate;
        this.mExSinkAudioChannels = channels;
        return this.nativeSetExternalAudioSink(this.mNativeHandle, enabled, sampleRate, channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExternalRemoteEglContext(Object eglContext) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (eglContext != null) {
            boolean ret = false;
            if (eglContext instanceof EglBase10.Context) {
                ret = !((EglBase10.Context)eglContext).getEglContext().equals(EGL10.EGL_NO_CONTEXT);
            } else if (eglContext instanceof EglBase14.Context && Build.VERSION.SDK_INT >= 17) {
                ret = !((EglBase14.Context)eglContext).getEglContext().equals((Object)EGL14.EGL_NO_CONTEXT);
            } else if (eglContext instanceof javax.microedition.khronos.egl.EGLContext) {
                ret = !((javax.microedition.khronos.egl.EGLContext)eglContext).equals(EGL10.EGL_NO_CONTEXT);
            } else if (Build.VERSION.SDK_INT >= 17 && eglContext instanceof EGLContext) {
                boolean bl = ret = !((EGLContext)eglContext).equals((Object)EGL14.EGL_NO_CONTEXT);
            }
            if (!ret) {
                Logging.e(TAG, "setExternalRemoteEglContext failure, eglContext Invalid.");
                return -1;
            }
        }
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                return -7;
            }
            return this.nativeSetExternalRemoteEglContext(this.mNativeHandle, eglContext);
        }
    }

    @Override
    public synchronized int pullPlaybackAudioFrame(byte[] data, int lengthInByte) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (data == null || data.length != lengthInByte) {
            return -2;
        }
        ByteBuffer frame = ByteBuffer.allocateDirect(lengthInByte);
        frame.order(ByteOrder.LITTLE_ENDIAN);
        int ret = this.pullPlaybackAudioFrame(frame, lengthInByte);
        if (ret == 0) {
            frame.get(data, 0, lengthInByte);
        }
        return ret;
    }

    @Override
    public synchronized int pullPlaybackAudioFrame(ByteBuffer data, int lengthInByte) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (data == null || data.capacity() != lengthInByte) {
            return -2;
        }
        if (!data.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer!");
        }
        return this.nativePullAudioFrame(this.mNativeHandle, data, lengthInByte, this.mExSinkAudioSampleRate, this.mExSinkAudioChannels);
    }

    @Override
    public synchronized int setLogFile(String filePath) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLogFile(this.mNativeHandle, filePath);
    }

    @Override
    public synchronized int setLogFilter(int filter) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLogFilter(this.mNativeHandle, filter & 0x80F);
    }

    @Override
    public synchronized int setLogFileSize(long fileSizeInKBytes) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLogFileSize(this.mNativeHandle, fileSizeInKBytes);
    }

    @Override
    public synchronized String uploadLogFile() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeUploadLogFile(this.mNativeHandle);
    }

    @Override
    public synchronized int setProfile(String profile, boolean merge) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetProfile(this.mNativeHandle, profile, merge);
    }

    public synchronized String getProfile() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeGetProfile(this.mNativeHandle);
    }

    @Override
    public synchronized int setParameters(String parameters) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, parameters);
    }

    @Override
    public synchronized String getParameters(String parameters) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeGetParameters(this.mNativeHandle, parameters);
    }

    @Override
    public synchronized String getParameter(String parameter, String args) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeGetParameter(this.mNativeHandle, parameter, args);
    }

    @Override
    public synchronized String makeQualityReportUrl(String channelName, String listenerUid, String speakerUid, int format) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeMakeQualityReportUrl(this.mNativeHandle, channelName, listenerUid, speakerUid, format);
    }

    @Override
    public synchronized String getCallId() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeGetCallId(this.mNativeHandle);
    }

    @Override
    public synchronized String getCallIdEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return null;
        }
        return this.nativeGetCallIdEx(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int getConnectionState() {
        return this.getConnectionStateEx(null);
    }

    @Override
    public synchronized int getConnectionStateEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetConnectionState(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int rate(String callId, int rating, String description) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRate(this.mNativeHandle, callId, rating, description);
    }

    @Override
    public synchronized int complain(String callId, String description) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeComplain(this.mNativeHandle, callId, description);
    }

    @Override
    public synchronized int setChannelProfile(int profile) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetChannelProfile(this.mNativeHandle, profile);
    }

    @Override
    public synchronized int setClientRole(int role) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetClientRole(this.mNativeHandle, role, null);
    }

    @Override
    public synchronized int setClientRole(int role, ClientRoleOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetClientRole(this.mNativeHandle, role, options);
    }

    @Override
    @Deprecated
    public synchronized int setRemoteVideoStreamType(int uid, int streamType) {
        return this.setRemoteVideoStreamTypeEx(uid, streamType, (RtcConnection)null);
    }

    @Override
    public synchronized int setRemoteVideoStreamType(int uid, Constants.VideoStreamType streamType) {
        return this.setRemoteVideoStreamTypeEx(uid, streamType, (RtcConnection)null);
    }

    @Override
    @Deprecated
    public synchronized int setRemoteVideoStreamTypeEx(int uid, int streamType, RtcConnection connection) {
        return this.setRemoteVideoStreamTypeEx(uid, streamType == 0 ? Constants.VideoStreamType.VIDEO_STREAM_HIGH : Constants.VideoStreamType.VIDEO_STREAM_LOW, connection);
    }

    @Override
    public synchronized int setRemoteVideoStreamTypeEx(int uid, Constants.VideoStreamType streamType, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRemoteVideoStreamType(this.mNativeHandle, uid, streamType.getValue(), RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    @Deprecated
    public synchronized int setRemoteDefaultVideoStreamType(int streamType) {
        return this.setRemoteDefaultVideoStreamType(streamType == 0 ? Constants.VideoStreamType.VIDEO_STREAM_HIGH : Constants.VideoStreamType.VIDEO_STREAM_LOW);
    }

    @Override
    public synchronized int setRemoteDefaultVideoStreamType(Constants.VideoStreamType streamType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        this.setParameter("rtc.video.set_remote_default_video_stream_type", streamType.getValue());
        return this.nativeSetRemoteDefaultVideoStreamType(this.mNativeHandle, streamType.getValue());
    }

    @Override
    public synchronized int setRemoteUserPriority(int uid, int userPriority) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRemoteUserPriority(this.mNativeHandle, uid, userPriority);
    }

    @Override
    @Deprecated
    public synchronized int setLocalPublishFallbackOption(int option) {
        Constants.StreamFallbackOptions fallbackOption = null;
        for (Constants.StreamFallbackOptions opt : Constants.StreamFallbackOptions.values()) {
            if (opt.getValue() != option) continue;
            fallbackOption = opt;
            break;
        }
        if (fallbackOption == null) {
            return -2;
        }
        return this.setLocalPublishFallbackOption(fallbackOption);
    }

    @Override
    @Deprecated
    public synchronized int setRemoteSubscribeFallbackOption(int option) {
        Constants.StreamFallbackOptions fallbackOption = null;
        for (Constants.StreamFallbackOptions opt : Constants.StreamFallbackOptions.values()) {
            if (opt.getValue() != option) continue;
            fallbackOption = opt;
            break;
        }
        if (fallbackOption == null) {
            return -2;
        }
        return this.setRemoteSubscribeFallbackOption(fallbackOption);
    }

    @Override
    public synchronized int setLocalPublishFallbackOption(Constants.StreamFallbackOptions option) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.setParameter("rtc.local_publish_fallback_option", option.getValue());
    }

    @Override
    public synchronized int setRemoteSubscribeFallbackOption(Constants.StreamFallbackOptions option) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (option.getValue() < Constants.StreamFallbackOptions.STREAM_FALLBACK_OPTION_DISABLED.getValue() || option.getValue() > Constants.StreamFallbackOptions.STREAM_FALLBACK_OPTION_VIDEO_STREAM_LAYER_6.getValue()) {
            return -2;
        }
        this.setParameter("rtc.remote_subscribe_fallback_option", option.getValue());
        return this.nativeSetRemoteSubscribeFallbackOption(this.mNativeHandle, option.getValue());
    }

    @Override
    public synchronized int setHighPriorityUserList(int[] uidList, int option) {
        return this.setHighPriorityUserListEx(uidList, option, null);
    }

    @Override
    public synchronized int setHighPriorityUserListEx(int[] uidList, int option, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetHighPriorityUserList(this.mNativeHandle, uidList, option, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setSubscribeAudioBlocklist(int[] uidList) {
        return this.setSubscribeAudioBlocklistEx(uidList, null);
    }

    @Override
    public synchronized int setSubscribeAudioBlocklistEx(int[] uidList, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSubscribeAudioBlacklist(this.mNativeHandle, uidList, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setSubscribeAudioAllowlist(int[] uidList) {
        return this.setSubscribeAudioAllowlistEx(uidList, null);
    }

    @Override
    public synchronized int setSubscribeAudioAllowlistEx(int[] uidList, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSubscribeAudioWhitelist(this.mNativeHandle, uidList, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setSubscribeVideoBlocklist(int[] uidList) {
        return this.setSubscribeVideoBlocklistEx(uidList, null);
    }

    @Override
    public synchronized int setSubscribeVideoBlocklistEx(int[] uidList, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSubscribeVideoBlacklist(this.mNativeHandle, uidList, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setSubscribeVideoAllowlist(int[] uidList) {
        return this.setSubscribeVideoAllowlistEx(uidList, null);
    }

    @Override
    public synchronized int setSubscribeVideoAllowlistEx(int[] uidList, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSubscribeVideoWhitelist(this.mNativeHandle, uidList, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int enableEncryption(boolean enabled, EncryptionConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableEncryption(this.mNativeHandle, enabled, config.encryptionMode.getValue(), config.encryptionKey, config.encryptionKdfSalt, config.datastreamEncryptionEnabled);
    }

    @Override
    public synchronized int enableEncryptionEx(boolean enabled, EncryptionConfig config, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableEncryptionEx(this.mNativeHandle, enabled, config.encryptionMode.getValue(), config.encryptionKey, config.encryptionKdfSalt, config.datastreamEncryptionEnabled, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @CalledByNative
    private void onLogEvent(int level, String message) {
    }

    @CalledByNative
    protected void onEvent(int eventId, byte[] evt) {
        Iterator<Map.Entry<IRtcEngineEventHandler, RtcEngineEventHandlerProxy>> it = this.mRtcHandlers.entrySet().iterator();
        while (it.hasNext()) {
            RtcEngineEventHandlerProxy h = it.next().getValue();
            if (h == null) {
                it.remove();
                continue;
            }
            h.handleEvent(eventId, evt);
        }
    }

    @CalledByNative
    protected void onEventEx(String channelId, int uid, String userId, int eventId, byte[] evt) {
        ArrayList<RtcEngineEventHandlerProxy> proxys = null;
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            proxys = this.mRtcExHandlerMap.get(Pair.create((Object)channelId, (Object)userId));
        }
        if (proxys == null) {
            proxys = this.mRtcExHandlerMap.get(Pair.create((Object)channelId, (Object)uid));
        }
        if (proxys != null) {
            for (RtcEngineEventHandlerProxy proxy : proxys) {
                proxy.handleEvent(eventId, evt);
            }
        } else {
            Log.e((String)TAG, (String)("onEventEx: can't find exhandler for channelId=" + channelId + " uid=" + uid));
        }
    }

    @Override
    public synchronized int createDataStream(boolean reliable, boolean ordered) {
        return this.createDataStreamEx(reliable, ordered, null);
    }

    @Override
    public synchronized int createDataStreamEx(boolean reliable, boolean ordered, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCreateDataStream(this.mNativeHandle, reliable, ordered, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int createDataStream(DataStreamConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.createDataStreamEx(config, null);
    }

    @Override
    public synchronized int createDataStreamEx(DataStreamConfig config, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCreateDataStream2(this.mNativeHandle, config.ordered, config.syncWithAudio, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int sendStreamMessage(int streamId, byte[] message) {
        return this.sendStreamMessageEx(streamId, message, null);
    }

    @Override
    public synchronized int sendStreamMessageEx(int streamId, byte[] message, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSendStreamMessage(this.mNativeHandle, streamId, message, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int updateSharedContext(javax.microedition.khronos.egl.EGLContext sharedContext) {
        return -4;
    }

    @Override
    public synchronized int updateSharedContext(EGLContext sharedContext) {
        return -4;
    }

    @Override
    public synchronized int setTextureId(int id, javax.microedition.khronos.egl.EGLContext sharedContext, int width, int height, long ts) {
        return -4;
    }

    @Override
    public synchronized int setTextureId(int id, EGLContext sharedContext, int width, int height, long ts) {
        return -4;
    }

    public synchronized int setTextureIdWithMatrix(int id, javax.microedition.khronos.egl.EGLContext sharedContext, int format, int width, int height, long ts, float[] matrix) {
        return -4;
    }

    public synchronized int setTextureIdWithMatrix(int id, EGLContext sharedContext, int format, int width, int height, long ts, float[] matrix) {
        return -4;
    }

    @Override
    public synchronized boolean isTextureEncodeSupported() {
        return true;
    }

    @Override
    public synchronized int setExternalVideoSource(boolean enable, boolean useTexture, Constants.ExternalVideoSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.setExternalVideoSource(enable, useTexture, sourceType, null);
    }

    @Override
    public synchronized int setExternalVideoSource(boolean enable, boolean useTexture, Constants.ExternalVideoSourceType sourceType, EncodedVideoTrackOptions encoded_opt) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetExternalVideoSource(this.mNativeHandle, enable, useTexture, Constants.ExternalVideoSourceType.getValue(sourceType), encoded_opt);
    }

    private int validatePushExternalVideoFrame(AgoraVideoFrame frame) {
        int expectedMinSize;
        if (frame == null) {
            return -2;
        }
        if (frame.format == 10 || frame.format == 11) {
            return 0;
        }
        if (frame.buf == null || frame.buf.length == 0) {
            return -2;
        }
        if (frame.format == 1) {
            int uvStride = (frame.stride + 1) / 2;
            int uvHeight = (frame.height + 1) / 2;
            expectedMinSize = frame.stride * frame.height + uvStride * uvHeight * 2 - (frame.cropRight + 1) / 2 - (frame.cropBottom + 1) / 2 * uvStride;
        } else if (frame.format == 2 || frame.format == 4) {
            expectedMinSize = frame.stride * frame.height * 4 - frame.cropRight - frame.cropBottom * frame.stride;
        } else if (frame.format == 3) {
            int uvStride = frame.stride % 2 == 0 ? frame.stride : frame.stride + 1;
            int uvHeight = (frame.height + 1) / 2;
            expectedMinSize = frame.stride * frame.height + uvStride * uvHeight - frame.cropRight - (frame.cropBottom + 1) / 2 * uvStride;
        } else if (frame.format == 16) {
            int uvStride = (frame.stride + 1) / 2;
            expectedMinSize = frame.stride * frame.height + uvStride * frame.height * 2 - (frame.cropRight + 1) / 2 - frame.cropBottom * uvStride;
        } else {
            return -2;
        }
        if (frame.buf.length < expectedMinSize) {
            return -2;
        }
        return 0;
    }

    @Override
    public synchronized boolean pushExternalVideoFrame(AgoraVideoFrame frame) {
        return this.pushExternalVideoFrameById(frame, 0) == 0;
    }

    @Override
    public synchronized int pushExternalVideoFrameById(AgoraVideoFrame frame, int videoTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        int err = this.validatePushExternalVideoFrame(frame);
        if (err != 0) {
            if (++this.mPushVideoFrameInvalidCnt % 150 == 1) {
                Logging.e(TAG, "failed to push video frame: " + frame);
            }
            return err;
        }
        return this.nativePushExternalAgoraVideoFrame(this.mNativeHandle, frame.format, frame.buf, frame.stride, frame.height, frame.cropLeft, frame.cropTop, frame.cropRight, frame.cropBottom, frame.rotation, frame.timeStamp, frame.eglContext10, frame.eglContext14, frame.textureID, frame.transform, frame.alphaStitchMode.value(), videoTrackId);
    }

    @Override
    public synchronized boolean pushExternalVideoFrame(VideoFrame frame) {
        int result = this.pushExternalVideoFrameById(frame, 0);
        if (result != 0) {
            Logging.e(TAG, "Failed to pushExternalVideoFrame, " + result);
            return false;
        }
        return true;
    }

    @Override
    public synchronized int pushExternalVideoFrameById(VideoFrame frame, int videoTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (frame == null) {
            return -2;
        }
        return this.nativePushExternalVideoFrame(this.mNativeHandle, frame, videoTrackId);
    }

    @Override
    public synchronized int pushExternalEncodedVideoFrame(ByteBuffer data, EncodedVideoFrameInfo frameInfo) {
        return this.pushExternalEncodedVideoFrameById(data, frameInfo, 0);
    }

    @Override
    public synchronized int pushExternalEncodedVideoFrameById(ByteBuffer data, EncodedVideoFrameInfo frameInfo, int videoTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (!data.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer!");
        }
        return this.nativePushExternalEncodedVideoFrame(this.mNativeHandle, data, frameInfo, videoTrackId);
    }

    @Override
    public synchronized int registerVideoEncodedFrameObserver(IVideoEncodedFrameObserver receiver) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterVideoEncodedFrameObserver(this.mNativeHandle, receiver);
    }

    @Override
    public synchronized int registerFaceInfoObserver(IFaceInfoObserver receiver) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterFaceInfoObserver(this.mNativeHandle, receiver);
    }

    @Override
    public synchronized int startRtmpStreamWithoutTranscoding(String url) {
        return this.startRtmpStreamWithoutTranscodingEx(url, null);
    }

    @Override
    public synchronized int startRtmpStreamWithoutTranscodingEx(String url, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartRtmpStreamWithoutTranscoding(this.mNativeHandle, url, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int startRtmpStreamWithTranscoding(String url, LiveTranscoding transcoding) {
        return this.startRtmpStreamWithTranscodingEx(url, transcoding, null);
    }

    @Override
    public synchronized int startRtmpStreamWithTranscodingEx(String url, LiveTranscoding transcoding, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (transcoding == null) {
            return -2;
        }
        RtcEngineMessage.PLiveTranscoding pt = new RtcEngineMessage.PLiveTranscoding();
        byte[] data = pt.marshall(transcoding);
        return this.nativeStartRtmpStreamWithTranscoding(this.mNativeHandle, url, data, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int updateRtmpTranscoding(LiveTranscoding transcoding) {
        return this.updateRtmpTranscodingEx(transcoding, null);
    }

    @Override
    public synchronized int updateRtmpTranscodingEx(LiveTranscoding transcoding, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (transcoding == null) {
            return -2;
        }
        RtcEngineMessage.PLiveTranscoding pt = new RtcEngineMessage.PLiveTranscoding();
        byte[] data = pt.marshall(transcoding);
        return this.nativeUpdateRtmpTranscoding(this.mNativeHandle, data, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int stopRtmpStream(String url) {
        return this.stopRtmpStreamEx(url, null);
    }

    @Override
    public synchronized int stopRtmpStreamEx(String url, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopRtmpStream(this.mNativeHandle, url, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int startOrUpdateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        return this.startOrUpdateChannelMediaRelayEx(channelMediaRelayConfiguration, null);
    }

    @Override
    public synchronized int startOrUpdateChannelMediaRelayEx(ChannelMediaRelayConfiguration channelMediaRelayConfiguration, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (!this.checkRelayConfiguration(channelMediaRelayConfiguration)) {
            return -2;
        }
        Map<String, ChannelMediaInfo> descInfos = channelMediaRelayConfiguration.getDestChannelMediaInfos();
        ChannelMediaInfo[] descInfosArray = new ChannelMediaInfo[descInfos.size()];
        descInfos.values().toArray(descInfosArray);
        return this.nativeStartOrUpdateChannelMediaRelay(this.mNativeHandle, channelMediaRelayConfiguration.getSrcChannelMediaInfo(), descInfosArray, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int stopChannelMediaRelay() {
        return this.stopChannelMediaRelayEx(null);
    }

    @Override
    public synchronized int stopChannelMediaRelayEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopChannelMediaRelay(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int pauseAllChannelMediaRelay() {
        return this.pauseAllChannelMediaRelayEx(null);
    }

    @Override
    public synchronized int pauseAllChannelMediaRelayEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePauseAllChannelMediaRelay(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int resumeAllChannelMediaRelay() {
        return this.resumeAllChannelMediaRelayEx(null);
    }

    @Override
    public synchronized int resumeAllChannelMediaRelayEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeResumeAllChannelMediaRelay(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    private boolean checkRelayConfiguration(ChannelMediaRelayConfiguration relayConfiguration) {
        if (relayConfiguration == null || relayConfiguration.getSrcChannelMediaInfo() == null || relayConfiguration.getDestChannelMediaInfos() == null || relayConfiguration.getDestChannelMediaInfos().isEmpty()) {
            return false;
        }
        Map<String, ChannelMediaInfo> descInfos = relayConfiguration.getDestChannelMediaInfos();
        for (ChannelMediaInfo info : descInfos.values()) {
            if (info != null && !TextUtils.isEmpty((CharSequence)info.getChannelName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized long getNativeHandle() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.nativeGetRtcEngine(this.mNativeHandle);
    }

    @Override
    public synchronized long getNativeMediaPlayer(int sourceId) {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.nativeGetMediaPlayer(this.mNativeHandle, sourceId);
    }

    @Override
    public synchronized long getNtpWallTimeInMs() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.nativeGetNtpWallTimeInMs(this.mNativeHandle);
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        return this;
    }

    @Override
    public synchronized int setVoiceBeautifierPreset(int preset) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVoiceBeautifierPreset(this.mNativeHandle, preset);
    }

    @Override
    public synchronized int setAudioEffectPreset(int preset) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioEffectPreset(this.mNativeHandle, preset);
    }

    @Override
    public synchronized int setVoiceConversionPreset(int preset) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVoiceConversionPreset(this.mNativeHandle, preset);
    }

    @Override
    public synchronized int setAudioEffectParameters(int preset, int param1, int param2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAudioEffectParameters(this.mNativeHandle, preset, param1, param2);
    }

    @Override
    public synchronized int setVoiceBeautifierParameters(int preset, int param1, int param2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVoiceBeautifierParameters(this.mNativeHandle, preset, param1, param2);
    }

    @Override
    public synchronized int setVoiceConversionParameters(int preset, int param1, int param2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVoiceConversionParameters(this.mNativeHandle, preset, param1, param2);
    }

    @Override
    public synchronized int setLocalVoicePitch(double pitch) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLocalVoicePitch(this.mNativeHandle, pitch);
    }

    @Override
    public synchronized int setLocalVoiceFormant(double formantRatio) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLocalVoiceFormant(this.mNativeHandle, formantRatio);
    }

    @Override
    public synchronized int setLocalVoiceEqualization(Constants.AUDIO_EQUALIZATION_BAND_FREQUENCY bandFrequency, int bandGain) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (bandFrequency == null) {
            return -2;
        }
        return this.nativeSetLocalVoiceEqualization(this.mNativeHandle, bandFrequency.getValue(), bandGain);
    }

    @Override
    public synchronized int setLocalVoiceReverb(Constants.AUDIO_REVERB_TYPE reverbKey, int value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (reverbKey == null) {
            return -2;
        }
        return this.nativeSetLocalVoiceReverb(this.mNativeHandle, reverbKey.getValue(), value);
    }

    @Override
    public synchronized int setHeadphoneEQPreset(int preset) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetHeadphoneEQPreset(this.mNativeHandle, preset);
    }

    @Override
    public synchronized int setHeadphoneEQParameters(int lowGain, int highGain) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetHeadphoneEQParameters(this.mNativeHandle, lowGain, highGain);
    }

    @Override
    public synchronized int setInEarMonitoringVolume(int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetInEarMonitoringVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized double getEffectsVolume() {
        if (this.mNativeHandle == 0L) {
            Logging.e(TAG, "RtcEngine does not initialize or it may be destroyed");
            return 0.0;
        }
        return this.nativeGetEffectsVolume(this.mNativeHandle);
    }

    @Override
    public synchronized int setEffectsVolume(double volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetEffectsVolume(this.mNativeHandle, volume);
    }

    @Override
    public synchronized int preloadEffect(int soundId, String filePath) {
        return this.preloadEffect(soundId, filePath, 0);
    }

    @Override
    public int preloadEffect(int soundId, String filePath, int startPos) {
        return this.preloadEffectEx(null, soundId, filePath, startPos);
    }

    @Override
    public int preloadEffectEx(RtcConnection connection, int soundId, String filePath) {
        return this.preloadEffectEx(connection, soundId, filePath, 0);
    }

    @Override
    public synchronized int preloadEffectEx(RtcConnection connection, int soundId, String filePath, int startPos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return -2;
        }
        return this.nativePreloadEffect(this.mNativeHandle, soundId, filePath, startPos, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    @Deprecated
    public synchronized int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain) {
        return this.playEffect(soundId, filePath, loopCount, pitch, pan, gain, false);
    }

    @Override
    public synchronized int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish) {
        return this.playEffect(soundId, filePath, loopCount, pitch, pan, gain, publish, 0);
    }

    @Override
    public synchronized int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish, int startPos) {
        return this.playEffectEx(null, soundId, filePath, loopCount, pitch, pan, gain, publish, startPos);
    }

    @Override
    public int playEffectEx(RtcConnection connection, int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish) {
        return this.playEffectEx(connection, soundId, filePath, loopCount, pitch, pan, gain, publish, 0);
    }

    @Override
    public int playEffectEx(RtcConnection connection, int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish, int startPos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePlayEffectWithFilePath(this.mNativeHandle, soundId, filePath, loopCount, pitch, pan, gain, publish, startPos, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int playAllEffects(int loopCount, double pitch, double pan, double gain, boolean publish) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePlayAllEffects(this.mNativeHandle, loopCount, pitch, pan, gain, publish);
    }

    @Override
    public synchronized int getVolumeOfEffect(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetVolumeOfEffect(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int setVolumeOfEffect(int soundId, double volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetVolumeOfEffect(this.mNativeHandle, soundId, volume);
    }

    @Override
    public synchronized int pauseEffect(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePauseEffect(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int pauseAllEffects() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePauseAllEffects(this.mNativeHandle);
    }

    @Override
    public synchronized int resumeEffect(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeResumeEffect(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int resumeAllEffects() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeResumeAllEffects(this.mNativeHandle);
    }

    @Override
    public synchronized int stopEffect(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopEffect(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int stopAllEffects() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopAllEffects(this.mNativeHandle);
    }

    @Override
    public synchronized int unloadEffect(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUnloadEffect(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int unloadAllEffects() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUnloadAllEffects(this.mNativeHandle);
    }

    @Override
    public synchronized int getEffectDuration(String filePath) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetEffectDuration(this.mNativeHandle, filePath);
    }

    @Override
    public synchronized int setEffectPosition(int soundId, int pos) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetEffectPosition(this.mNativeHandle, soundId, pos);
    }

    @Override
    public synchronized int getEffectCurrentPosition(int soundId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetEffectCurrentPosition(this.mNativeHandle, soundId);
    }

    @Override
    public synchronized int setApiCallMode(int syncCallTimeout) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetApiCallMode(this.mNativeHandle, syncCallTimeout);
    }

    int getOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    void allowCaptureCurrentApp(ScreenCaptureParameters parameters) {
        if (Build.VERSION.SDK_INT < 29) {
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        AudioManager mgr = (AudioManager)this.getContext().getSystemService("audio");
        if (parameters.audioCaptureParameters.allowCaptureCurrentApp) {
            mgr.setAllowedCapturePolicy(1);
        } else {
            mgr.setAllowedCapturePolicy(3);
        }
    }

    @Override
    public int setExternalMediaProjection(MediaProjection mediaProjection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (mediaProjection == null) {
            Logging.w(TAG, "setExternalMediaProjection null");
        }
        return this.nativeSetExternalMediaProjection(this.mNativeHandle, mediaProjection);
    }

    @Override
    public synchronized int startScreenCapture(ScreenCaptureParameters parameters) {
        int nativeResult;
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (parameters == null) {
            Logging.e(TAG, "Failed to startScreenCapture, parameters null");
            return -2;
        }
        if (this.getOSVersion() < 21) {
            Logging.e("current android version not support for screen capture!");
            return -2;
        }
        int osVersionCheckResult = 0;
        if (this.getOSVersion() < 29 && parameters.captureAudio) {
            Logging.e("current android version not support for capture audio!");
            parameters.captureAudio = false;
            osVersionCheckResult = -3;
        }
        if (parameters.captureAudio) {
            this.allowCaptureCurrentApp(parameters);
        }
        if ((nativeResult = this.nativeStartScreenCapture(this.mNativeHandle, parameters)) != 0) {
            return nativeResult;
        }
        return osVersionCheckResult;
    }

    @Override
    public synchronized int setScreenCaptureScenario(Constants.ScreenScenarioType screenScenario) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetScreenCaptureScenario(this.mNativeHandle, Constants.ScreenScenarioType.getValue(screenScenario));
    }

    @Override
    public synchronized int stopScreenCapture() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopScreenCapture(this.mNativeHandle);
    }

    @Override
    public synchronized int updateScreenCaptureParameters(ScreenCaptureParameters parameters) {
        int nativeResult;
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (parameters == null) {
            Logging.e(TAG, "Failed to updateScreenCaptureParameters, parameters null");
            return -2;
        }
        if (this.getOSVersion() < 21) {
            Logging.e("current android version not support for screen capture!");
            return -2;
        }
        int osVersionCheckResult = 0;
        if (this.getOSVersion() < 29 && parameters.captureAudio) {
            Logging.e("current android version not support for capture audio!");
            parameters.captureAudio = false;
            osVersionCheckResult = -3;
        }
        if (parameters.captureAudio) {
            this.allowCaptureCurrentApp(parameters);
        }
        if ((nativeResult = this.nativeUpdateScreenCaptureParameters(this.mNativeHandle, parameters)) != 0) {
            return nativeResult;
        }
        return osVersionCheckResult;
    }

    @Override
    public synchronized int registerVideoFrameObserver(IVideoFrameObserver observer) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterVideoFrameObserver(this.mNativeHandle, observer);
    }

    @Override
    public synchronized int takeSnapshot(int uid, String filePath) {
        return this.takeSnapshotEx((RtcConnection)null, uid, filePath);
    }

    @Override
    public synchronized int takeSnapshot(int uid, SnapshotConfig config) {
        return this.takeSnapshotEx((RtcConnection)null, uid, config);
    }

    @Override
    public synchronized int takeSnapshotEx(RtcConnection connection, int uid, String filePath) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeTakeSnapshot(this.mNativeHandle, uid, filePath, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int takeSnapshotEx(RtcConnection connection, int uid, SnapshotConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (config.filePath == null) {
            config.filePath = "";
        }
        return this.nativeTakeSnapshot2(this.mNativeHandle, uid, config.filePath, Constants.VideoModulePosition.getValue(config.position), RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int enableContentInspect(boolean enabled, ContentInspectConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.enableContentInspectEx(enabled, config, null);
    }

    @Override
    public synchronized int enableContentInspectEx(boolean enabled, ContentInspectConfig config, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        byte[] data = null;
        if (enabled) {
            if (config == null) {
                return -7;
            }
            RtcEngineMessage.PContentInspectConfig pt = new RtcEngineMessage.PContentInspectConfig();
            data = pt.marshall(config);
        }
        return this.nativeEnableContentInspect(this.mNativeHandle, enabled, data, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    public int setMediaRecorderObserver(IMediaRecorderCallback callback, int uid, String channelId, boolean isLocal, int streamtype) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        Logging.e("setMediaRecorderObserver streamtype is " + streamtype + " channelId" + channelId);
        return this.nativeSetMediaRecorderObserver(this.mNativeHandle, callback, uid, channelId, isLocal, streamtype);
    }

    public int startRecording(String path, int containerFormat, int streamType, int maxDuration, int interval, int uid, String channelId, boolean isLocal, int stream_type, int width, int height, int fps, int sample_rate, int channel_num, int videoSourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartRecording(this.mNativeHandle, path, containerFormat, streamType, maxDuration, interval, uid, channelId, isLocal, stream_type, width, height, fps, sample_rate, channel_num, videoSourceType);
    }

    public int stopRecording(String channelId, int uid, boolean isLocal, int stream_type) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopRecording(this.mNativeHandle, uid, channelId, isLocal, stream_type);
    }

    public int releaseRecorder(String channelId, int uid, int streamType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeReleaseRecorder(this.mNativeHandle, uid, channelId, streamType);
    }

    public synchronized void finalize() {
        if (this.mNativeHandle != 0L) {
            RtcEngineImpl.nativeDestroy(this.mNativeHandle, null);
        }
    }

    @Override
    public synchronized int enableExtension(String provider, String extension, boolean enable) {
        return this.enableExtension(provider, extension, enable, Constants.MediaSourceType.UNKNOWN_MEDIA_SOURCE);
    }

    @Override
    public synchronized int enableExtension(String provider, String extension, boolean enable, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableExtension(this.mNativeHandle, provider, extension, enable, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int enableExtension(String provider, String extension, ExtensionInfo extensionInfo, boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (extensionInfo == null) {
            return -2;
        }
        return this.nativeEnableExtension2(this.mNativeHandle, provider, extension, enable, Constants.MediaSourceType.getValue(extensionInfo.mediaSourceType), extensionInfo.remoteUid, extensionInfo.channelId, extensionInfo.localUid);
    }

    @Override
    public synchronized int registerExtension(String provider, String extension, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterExtension(this.mNativeHandle, provider, extension, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setExtensionProperty(String provider, String extension, String key, String value) {
        return this.setExtensionProperty(provider, extension, key, value, Constants.MediaSourceType.UNKNOWN_MEDIA_SOURCE);
    }

    @Override
    public synchronized int setExtensionProperty(String provider, String extension, String key, String value, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetExtensionProperty(this.mNativeHandle, provider, extension, key, value, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized int setExtensionProperty(String provider, String extension, ExtensionInfo extensionInfo, String key, String value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (extensionInfo == null) {
            return -2;
        }
        return this.nativeSetExtensionProperty2(this.mNativeHandle, provider, extension, key, value, Constants.MediaSourceType.getValue(extensionInfo.mediaSourceType), extensionInfo.remoteUid, extensionInfo.channelId, extensionInfo.localUid);
    }

    @Override
    public synchronized String getExtensionProperty(String provider, String extension, String key) {
        return this.getExtensionProperty(provider, extension, key, Constants.MediaSourceType.UNKNOWN_MEDIA_SOURCE);
    }

    @Override
    public synchronized String getExtensionProperty(String provider, String extension, String key, Constants.MediaSourceType sourceType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeGetExtensionProperty(this.mNativeHandle, provider, extension, key, Constants.MediaSourceType.getValue(sourceType));
    }

    @Override
    public synchronized String getExtensionProperty(String provider, String extension, ExtensionInfo extensionInfo, String key) {
        if (this.mNativeHandle == 0L || extensionInfo == null) {
            return null;
        }
        return this.nativeGetExtensionProperty2(this.mNativeHandle, provider, extension, key, Constants.MediaSourceType.getValue(extensionInfo.mediaSourceType), extensionInfo.remoteUid, extensionInfo.channelId, extensionInfo.localUid);
    }

    @Override
    public synchronized int setExtensionProviderProperty(String provider, String key, String value) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetExtensionProviderProperty(this.mNativeHandle, provider, key, value);
    }

    @Override
    public synchronized int registerMediaMetadataObserver(IMetadataObserver observer, int type) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (observer == null) {
            Logging.e(TAG, "Failed to registerMediaMetadataObserver, observer is null");
            return -2;
        }
        return this.nativeRegisterMediaMetadataObserver(this.mNativeHandle, observer, type);
    }

    @Override
    public synchronized int unregisterMediaMetadataObserver(IMetadataObserver observer, int type) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (observer == null) {
            Logging.e(TAG, "Failed to unRegisterMediaMetadataObserver, observer null");
            return -2;
        }
        return this.nativeUnregisterMediaMetadataObserver(this.mNativeHandle, observer, type);
    }

    @Override
    public synchronized int setLogLevel(int level) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetLogLevel(this.mNativeHandle, level);
    }

    @Override
    public synchronized int writeLog(int level, String format, Object ... args) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        String log = String.format(format, args);
        return this.nativeWriteLog(this.mNativeHandle, level, log);
    }

    @Override
    public synchronized int enableExternalAudioSourceLocalPlayback(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableExternalAudioSourceLocalPlayback(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int adjustCustomAudioPublishVolume(int trackId, int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustCustomAudioPublishVolume(this.mNativeHandle, trackId, volume);
    }

    @Override
    public synchronized int adjustCustomAudioPlayoutVolume(int trackId, int volume) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAdjustCustomAudioPlayoutVolume(this.mNativeHandle, trackId, volume);
    }

    @Override
    public synchronized int startRhythmPlayer(String sound1, String sound2, AgoraRhythmPlayerConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (TextUtils.isEmpty((CharSequence)sound1) || TextUtils.isEmpty((CharSequence)sound2) || config == null) {
            return -2;
        }
        return this.nativeStartRhythmPlayer(this.mNativeHandle, sound1, sound2, config);
    }

    @Override
    public synchronized int stopRhythmPlayer() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopRhythmPlayer(this.mNativeHandle);
    }

    @Override
    public synchronized int configRhythmPlayer(AgoraRhythmPlayerConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (config == null) {
            return -2;
        }
        return this.nativeConfigRhythmPlayer(this.mNativeHandle, config);
    }

    @Override
    public synchronized int enableCustomAudioLocalPlayback(int trackId, boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableCustomAudioLocalPlayback(this.mNativeHandle, trackId, enabled);
    }

    @Override
    public synchronized int enableSoundPositionIndication(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableSoundPositionIndication(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized long getCurrentMonotonicTimeInMs() {
        if (this.mNativeHandle == 0L) {
            return -7L;
        }
        return this.nativeGetCurrentMonotonicTimeInMs(this.mNativeHandle);
    }

    @Override
    public synchronized int setRemoteVoicePosition(int uid, double pan, double gain) {
        return this.setRemoteVoicePositionEx(uid, pan, gain, null);
    }

    @Override
    public synchronized int setRemoteVoicePositionEx(int uid, double pan, double gain, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRemoteVoicePosition(this.mNativeHandle, uid, pan, gain, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int enableSpatialAudio(boolean enabled) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableSpatialAudio(this.mNativeHandle, enabled);
    }

    @Override
    public synchronized int enableVoiceAITuner(boolean enabled, Constants.VOICE_AI_TUNER_TYPE type) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (type == null) {
            return -2;
        }
        return this.nativeEnableVoiceAITuner(this.mNativeHandle, enabled, type.getValue());
    }

    @Override
    public synchronized int setAINSMode(boolean enabled, int mode) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativesetAINSMode(this.mNativeHandle, enabled, mode);
    }

    @Override
    public synchronized int setRemoteVideoSubscriptionOptions(int uid, VideoSubscriptionOptions options) {
        return this.setRemoteVideoSubscriptionOptionsEx(uid, options, null);
    }

    @Override
    public synchronized int setRemoteVideoSubscriptionOptionsEx(int uid, VideoSubscriptionOptions options, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (options == null) {
            return -2;
        }
        return this.nativeSetRemoteVideoSubscriptionOptions(this.mNativeHandle, uid, options, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setRemoteUserSpatialAudioParams(int uid, SpatialAudioParams params) {
        return this.setRemoteUserSpatialAudioParamsEx(uid, params, null);
    }

    @Override
    public synchronized int setRemoteUserSpatialAudioParamsEx(int uid, SpatialAudioParams params, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (params == null) {
            return -2;
        }
        return this.nativeSetRemoteUserSpatialAudioParams(this.mNativeHandle, uid, params, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int registerLocalUserAccount(String appId, String userAccount) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRegisterLocalUserAccount(this.mNativeHandle, appId, userAccount);
    }

    @Override
    public synchronized int joinChannelWithUserAccount(String token, String channelId, String userAccount) {
        return this.joinChannelWithUserAccount(token, channelId, userAccount, null);
    }

    @Override
    public synchronized int joinChannelWithUserAccount(String token, String channelId, String userAccount, ChannelMediaOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeJoinChannelWithUserAccount(this.mNativeHandle, token, channelId, userAccount, options);
    }

    @Override
    public synchronized int joinChannelWithUserAccountEx(String token, String channelId, String userAccount, ChannelMediaOptions options, IRtcEngineEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        int result = this.nativeJoinChannelWithUserAccountEx(this.mNativeHandle, token, channelId, userAccount, options);
        if (result == 0) {
            this.mRtcExHandlerMap.remove(Pair.create((Object)channelId, (Object)userAccount));
            this.addHandlerExKey((Pair<String, Object>)Pair.create((Object)channelId, (Object)userAccount), eventHandler);
        }
        return result;
    }

    @Override
    public synchronized int getUserInfoByUserAccount(String userAccount, UserInfo userInfo) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (userInfo == null) {
            Logging.e(TAG, "Failed to getUserInfoByUserAccount, userInfo null");
            return -2;
        }
        return this.nativeGetUserInfoByUserAccount(this.mNativeHandle, userAccount, userInfo);
    }

    @Override
    public synchronized int getUserInfoByUid(int uid, UserInfo userInfo) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (userInfo == null) {
            Logging.e(TAG, "Failed to getUserInfoByUid, userInfo null");
            return -2;
        }
        return this.nativeGetUserInfoByUid(this.mNativeHandle, uid, userInfo);
    }

    @Override
    public synchronized int getUserInfoByUserAccountEx(String userAccount, UserInfo userInfo, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (userInfo == null) {
            Logging.e(TAG, "Failed to getUserInfoByUserAccountEx, userInfo null");
            return -2;
        }
        if (connection == null) {
            return -2;
        }
        String channelId = RtcEngineImpl.getChannelId(connection);
        int localUid = RtcEngineImpl.getUserId(connection);
        return this.nativeGetUserInfoByUserAccountEx(this.mNativeHandle, userAccount, userInfo, channelId, localUid);
    }

    @Override
    public synchronized int getUserInfoByUidEx(int uid, UserInfo userInfo, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (userInfo == null) {
            Logging.e(TAG, "Failed to getUserInfoByUidEx, userInfo null");
            return -2;
        }
        if (connection == null) {
            return -2;
        }
        String channelId = RtcEngineImpl.getChannelId(connection);
        int localUid = RtcEngineImpl.getUserId(connection);
        return this.nativeGetUserInfoByUidEx(this.mNativeHandle, uid, userInfo, channelId, localUid);
    }

    @Override
    public synchronized int setDirectCdnStreamingAudioConfiguration(int profile) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetDirectCdnStreamingAudioConfiguration(this.mNativeHandle, profile);
    }

    @Override
    public synchronized int setDirectCdnStreamingVideoConfiguration(VideoEncoderConfiguration config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetDirectCdnStreamingVideoConfiguration(this.mNativeHandle, config.dimensions.width, config.dimensions.height, config.frameRate, config.bitrate, config.minBitrate, config.orientationMode.getValue(), config.mirrorMode.getValue(), config.degradationPrefer.getValue());
    }

    @Override
    public synchronized int startDirectCdnStreaming(IDirectCdnStreamingEventHandler eventHandler, String publishUrl, DirectCdnStreamingMediaOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartDirectCdnStreaming(this.mNativeHandle, eventHandler, publishUrl, options);
    }

    @Override
    public synchronized int stopDirectCdnStreaming() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStopDirectCdnStreaming(this.mNativeHandle);
    }

    @Override
    public synchronized int updateDirectCdnStreamingMediaOptions(DirectCdnStreamingMediaOptions options) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUpdateDirectCdnStreamingMediaOptions(this.mNativeHandle, options);
    }

    @Override
    public synchronized int createCustomVideoTrack() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCreateCustomVideoTrack(this.mNativeHandle);
    }

    @Override
    public synchronized int createCustomEncodedVideoTrack(EncodedVideoTrackOptions encodedOpt) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCreateCustomEncodedVideoTrack(this.mNativeHandle, encodedOpt);
    }

    @Override
    public synchronized int destroyCustomVideoTrack(int videoTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDestroyCustomVideoTrack(this.mNativeHandle, videoTrackId);
    }

    @Override
    public synchronized int destroyCustomEncodedVideoTrack(int videoTrackId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDestroyCustomEncodedVideoTrack(this.mNativeHandle, videoTrackId);
    }

    @Override
    public synchronized DeviceInfo getAudioDeviceInfo() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.nativeGetAudioDeviceInfo(this.mNativeHandle);
    }

    @Override
    public synchronized int setAVSyncSource(String channelId, int uid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetAVSyncSource(this.mNativeHandle, channelId, uid);
    }

    @Override
    public synchronized int enableVideoImageSource(boolean enabled, ImageTrackOptions options) {
        return this.enableVideoImageSourceEx(enabled, options, null);
    }

    @Override
    public synchronized int enableVideoImageSourceEx(boolean enabled, ImageTrackOptions options, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (enabled && (options == null || TextUtils.isEmpty((CharSequence)options.getImageUrl()) || options.getFps() <= 0)) {
            return -2;
        }
        String imageUrl = "";
        int fps = 0;
        int mirrorMode = VideoEncoderConfiguration.MIRROR_MODE_TYPE.MIRROR_MODE_DISABLED.getValue();
        if (options != null) {
            imageUrl = options.getImageUrl();
            fps = options.getFps();
            mirrorMode = options.getMirrorMode();
        }
        return this.nativeEnableVideoImageSource(this.mNativeHandle, enabled, imageUrl, fps, mirrorMode, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int startMediaRenderingTracing() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartMediaRenderingTracing(this.mNativeHandle);
    }

    @Override
    public synchronized int startMediaRenderingTracingEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeStartMediaRenderingTracingEx(this.mNativeHandle, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int setParametersEx(String parameters, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParametersEx(this.mNativeHandle, parameters, RtcEngineImpl.getChannelId(connection), RtcEngineImpl.getUserId(connection));
    }

    @Override
    public synchronized int enableInstantMediaRendering() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableInstantMediaRendering(this.mNativeHandle);
    }

    @Override
    public synchronized int setupAudioAttributes(AudioAttributes attr) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetupAudioAttributeContext(this.mNativeHandle, attr);
    }

    private int setParameter(String key, boolean value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%b}", key, value));
    }

    private int setParameter(String key, int value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", key, value));
    }

    private int setParameter(String key, String value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":\"%s\"}", key, value));
    }

    private int setParameterObject(String key, String value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%s}", key, value));
    }

    static String getChannelId(RtcConnection connection) {
        return connection != null ? connection.channelId : null;
    }

    static int getUserId(RtcConnection connection) {
        return connection != null ? connection.localUid : 0;
    }

    public static native String nativeGetSdkVersion();

    public static native String nativeGetMediaEngineVersion();

    public static native String nativeGetErrorDescription(int var0);

    private native Object nativeObjectInit(RtcEngineConfig var1);

    private static native int nativeDestroy(long var0, Object var2);

    private native int nativeRecordCreateEngineTimeStamp(long var1, long var3, long var5);

    private native int nativeSetProfile(long var1, String var3, boolean var4);

    private native int nativeEnableEncryption(long var1, boolean var3, int var4, String var5, byte[] var6, boolean var7);

    private native int nativeEnableEncryptionEx(long var1, boolean var3, int var4, String var5, byte[] var6, boolean var7, String var8, int var9);

    private native String nativeGetProfile(long var1);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetParameters(long var1, String var3);

    private native String nativeGetParameter(long var1, String var3, String var4);

    private native int nativePreloadChannel(long var1, String var3, String var4, int var5);

    private native int nativePreloadChannelWithUserAccount(long var1, String var3, String var4, String var5);

    private native int nativeUpdatePreloadChannelToken(long var1, String var3);

    private native int nativeJoinChannel(long var1, String var3, String var4, String var5, int var6);

    private native int nativeJoinChannel2(long var1, String var3, String var4, int var5, ChannelMediaOptions var6);

    private native int nativeJoinChannelEx(long var1, String var3, String var4, int var5, ChannelMediaOptions var6);

    private native int nativeUpdateChannelMediaOptions(long var1, ChannelMediaOptions var3, String var4, int var5);

    private native int nativeLeaveChannel(long var1, LeaveChannelOptions var3);

    private native int nativeLeaveChannelEx(long var1, String var3, int var4, LeaveChannelOptions var5);

    private native int nativeLeaveChannelWithUserAccountEx(long var1, String var3, String var4, LeaveChannelOptions var5);

    private native int nativeSetClientRole(long var1, int var3, Object var4);

    private native int nativeEnableAudio(long var1, boolean var3);

    private native int nativeEnableLocalAudio(long var1, boolean var3);

    private native int nativePauseAudio(long var1);

    private native int nativeResumeAudio(long var1);

    private native int nativeMuteLocalAudioStream(long var1, boolean var3, String var4, int var5);

    private native int nativeEnableAudioVolumeIndication(long var1, int var3, int var4, boolean var5, String var6, int var7);

    private native int nativeMuteAllRemoteAudioStreams(long var1, boolean var3, String var4, int var5);

    private native int nativeMuteRemoteAudioStream(long var1, int var3, boolean var4, String var5, int var6);

    private native int nativeStartEchoTestWithConfig(long var1, View var3, boolean var4, boolean var5, String var6, String var7, int var8);

    private native int nativeStopEchoTest(long var1);

    private native int nativeSetCloudProxy(long var1, int var3);

    private native int nativeQueryScreenCaptureCapability(long var1);

    private native int nativeGetNetworkType(long var1);

    private native int nativeStartLastmileProbeTest(long var1, boolean var3, boolean var4, int var5, int var6);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeSwitchCamera(long var1);

    private native int nativeSwitchCameraId(long var1, String var3);

    private native int nativeSetCameraCapturerConfiguration(long var1, CameraCapturerConfiguration var3);

    private native CodecCapInfo[] nativeQueryCodecCapability(long var1);

    private native int nativeQueryDeviceScore(long var1);

    private native AgoraFocalLengthInfo[] nativeQueryCameraFocalLengthCapability(long var1);

    private native int nativeStartPreview(long var1);

    private native int nativeStartPreviewForSourceType(long var1, int var3);

    private native int nativeStopPreview(long var1);

    private native int nativeStopPreviewForSourceType(long var1, int var3);

    private native int nativeCreateDataStream(long var1, boolean var3, boolean var4, String var5, int var6);

    private native int nativeCreateDataStream2(long var1, boolean var3, boolean var4, String var5, int var6);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4, String var5, int var6);

    private native int nativeSendAudioMetadata(long var1, byte[] var3, String var4, int var5);

    private native int nativeStartRtmpStreamWithoutTranscoding(long var1, String var3, String var4, int var5);

    private native int nativeStartRtmpStreamWithTranscoding(long var1, String var3, byte[] var4, String var5, int var6);

    private native int nativeUpdateRtmpTranscoding(long var1, byte[] var3, String var4, int var5);

    private native int nativeStopRtmpStream(long var1, String var3, String var4, int var5);

    private native int nativeRenewToken(long var1, String var3);

    private native int nativeSetupRemoteVideo(long var1, View var3, SurfaceTexture var4, int var5, int var6, int var7, int var8, int[] var9, int var10, boolean var11, String var12, int var13, int var14);

    private native int nativeSetupLocalVideo(long var1, View var3, SurfaceTexture var4, int var5, int var6, int var7, int var8, int[] var9, int var10, boolean var11, int var12, int var13);

    private native int nativeSetLocalRenderMode(long var1, int var3, int var4);

    private native int nativeSetRemoteRenderMode(long var1, int var3, int var4, int var5, String var6, int var7);

    private native int nativeSetLocalVideoMirrorMode(long var1, int var3);

    private native int nativesetVideoScenario(long var1, int var3);

    private native int nativesetVideoQoEPreference(long var1, int var3);

    private native int nativeSetAudioProfileScenario(long var1, int var3, int var4);

    private native int nativeSetAudioProfile(long var1, int var3);

    private native int nativeSetAudioScenario(long var1, int var3);

    private native int nativeSetVideoEncoderConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, boolean var13, int var14, String var15, int var16);

    private native int nativeSetBeautyEffectOptions(long var1, boolean var3, int var4, float var5, float var6, float var7, float var8, int var9);

    private native int nativeSetFaceShapeBeautyOptions(long var1, boolean var3, int var4, int var5, int var6);

    private native FaceShapeBeautyOptions nativeGetFaceShapeBeautyOptions(long var1, int var3);

    private native int nativeSetFaceShapeAreaOptions(long var1, int var3, int var4, int var5);

    private native FaceShapeAreaOptions nativeGetFaceShapeAreaOptions(long var1, int var3, int var4);

    private native int nativeSetFilterEffectOptions(long var1, boolean var3, String var4, float var5, int var6);

    private native int nativeSetLowlightEnhanceOptions(long var1, boolean var3, int var4, int var5, int var6);

    private native int nativeSetVideoDenoiserOptions(long var1, boolean var3, int var4, int var5, int var6);

    private native int nativeSetColorEnhanceOptions(long var1, boolean var3, float var4, float var5, int var6);

    private native int nativeEnableVirtualBackground(long var1, boolean var3, int var4, int var5, String var6, int var7, int var8, float var9, int var10);

    private native int nativeSetAdvancedAudioOptions(long var1, int var3);

    private native int nativeAddVideoWatermark(long var1, String var3, boolean var4, int[] var5, int[] var6);

    private native int nativeAddVideoWatermarkEx(long var1, String var3, boolean var4, int[] var5, int[] var6, String var7, int var8);

    private native int nativeClearVideoWatermarks(long var1);

    private native int nativeClearVideoWatermarkEx(long var1, String var3, int var4);

    private native int nativeSetRemoteUserPriority(long var1, int var3, int var4);

    private native String nativeMakeQualityReportUrl(long var1, String var3, String var4, String var5, int var6);

    private native String nativeGetCallId(long var1);

    private native String nativeGetCallIdEx(long var1, String var3, int var4);

    private native int nativeRate(long var1, String var3, int var4, String var5);

    private native int nativeComplain(long var1, String var3, String var4);

    private native int nativeRegisterAudioFrameObserver(long var1, IAudioFrameObserver var3);

    private native int nativeEnableAudioSpectrumMonitor(long var1, int var3);

    private native int nativeDisableAudioSpectrumMonitor(long var1);

    private native int nativeRegisterAudioSpectrumObserver(long var1, IAudioSpectrumObserver var3);

    private native int nativeUnRegisterAudioSpectrumObserver(long var1, IAudioSpectrumObserver var3);

    private native int nativeregisterAudioEncodedFrameObserver(long var1, IAudioEncodedFrameObserver var3, int var4, int var5);

    private native int nativeCreateCustomAudioTrack(long var1, int var3, boolean var4, boolean var5);

    private native int nativeDestroyCustomAudioTrack(long var1, int var3);

    private native int nativeSetExternalAudioSource(long var1, boolean var3, int var4, int var5, boolean var6, boolean var7);

    private native int nativePushExternalAudioFrameRawData(long var1, ByteBuffer var3, long var4, int var6, int var7, int var8, int var9);

    private native int nativeSetExternalAudioSink(long var1, boolean var3, int var4, int var5);

    private native int nativeSetExternalRemoteEglContext(long var1, Object var3);

    private native int nativePullAudioFrame(long var1, ByteBuffer var3, int var4, int var5, int var6);

    private native int nativeSetApiCallMode(long var1, int var3);

    private native long nativeGetRtcEngine(long var1);

    private native int nativeSetExternalVideoSource(long var1, boolean var3, boolean var4, int var5, EncodedVideoTrackOptions var6);

    private native long nativeGetMediaPlayer(long var1, int var3);

    private native long nativeGetNtpWallTimeInMs(long var1);

    private native int nativePushExternalEncodedVideoFrame(long var1, ByteBuffer var3, EncodedVideoFrameInfo var4, int var5);

    private native int nativeRegisterVideoEncodedFrameObserver(long var1, IVideoEncodedFrameObserver var3);

    private native int nativeRegisterFaceInfoObserver(long var1, IFaceInfoObserver var3);

    private native int nativeEnableVideo(long var1);

    private native int nativeDisableVideo(long var1);

    private native int nativeEnableLocalVideo(long var1, boolean var3);

    private native int nativeStartCameraCapture(long var1, int var3, CameraCapturerConfiguration var4);

    private native int nativeStopCameraCapture(long var1, int var3);

    private native int nativeStartLocalVideoTranscoder(long var1, byte[] var3);

    private native int nativeUpdateLocalTranscoderConfiguration(long var1, byte[] var3);

    private native int nativeStopLocalVideoTranscoder(long var1);

    private native int nativeStartLocalAudioMixer(long var1, byte[] var3);

    private native int nativeUpdateLocalAudioMixerConfiguration(long var1, byte[] var3);

    private native int nativeStopLocalAudioMixer(long var1);

    private native int nativeMuteLocalVideoStream(long var1, boolean var3, String var4, int var5);

    private native int nativeMuteAllRemoteVideoStreams(long var1, boolean var3, String var4, int var5);

    private native int nativeSetRemoteDefaultVideoStreamType(long var1, int var3);

    private native int nativeSetRemoteVideoStreamType(long var1, int var3, int var4, String var5, int var6);

    private native int nativeEnableDualStreamModeEx(long var1, boolean var3, SimulcastStreamConfig var4, String var5, int var6);

    private native int nativeSetDualStreamModeEx(long var1, int var3, SimulcastStreamConfig var4, String var5, int var6);

    private native int nativeSetSimulcastConfigEx(long var1, SimulcastConfig.StreamLayerConfig[] var3, String var4, int var5);

    private native int nativesetLocalRenderTargetFps(long var1, int var3, int var4);

    private native int nativesetRemoteRenderTargetFps(long var1, int var3);

    private native int nativeMuteRemoteVideoStream(long var1, int var3, boolean var4, String var5, int var6);

    private native int nativeSetDefaultAudioRoutetoSpeakerphone(long var1, boolean var3);

    private native int nativeSetEnableSpeakerphone(long var1, boolean var3);

    private native int nativeSetRouteInCommunicationMode(long var1, int var3);

    private native boolean nativeIsSpeakerphoneEnabled(long var1);

    private native int nativeAdjustRecordingSignalVolume(long var1, int var3, String var4, int var5);

    private native int nativeAdjustPlaybackSignalVolume(long var1, int var3);

    private native int nativeAdjustUserPlaybackSignalVolume(long var1, int var3, int var4, String var5, int var6);

    private native int nativeMuteRecordingSignal(long var1, boolean var3, String var4, int var5);

    private native int nativeSetRecordingAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetPlaybackAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetMixedAudioFrameParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetEarMonitoringAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetPlaybackAudioFrameBeforeMixingParameters(long var1, int var3, int var4);

    private native int nativeSetChannelProfile(long var1, int var3);

    private native int nativeStartScreenCapture(long var1, ScreenCaptureParameters var3);

    private native int nativeSetExternalMediaProjection(long var1, MediaProjection var3);

    private native int nativeSetScreenCaptureScenario(long var1, int var3);

    private native int nativeStopScreenCapture(long var1);

    private native int nativeUpdateScreenCaptureParameters(long var1, ScreenCaptureParameters var3);

    private native int nativeSetLogFile(long var1, String var3);

    private native int nativeSetLogFilter(long var1, int var3);

    private native int nativeSetLogFileSize(long var1, long var3);

    private native String nativeUploadLogFile(long var1);

    private native int nativeLoadExtensionProvider(long var1, String var3);

    private native int nativeEnableExtension(long var1, String var3, String var4, boolean var5, int var6);

    private native int nativeEnableExtension2(long var1, String var3, String var4, boolean var5, int var6, int var7, String var8, int var9);

    private native int nativeRegisterExtension(long var1, String var3, String var4, int var5);

    private native int nativeSetExtensionProperty(long var1, String var3, String var4, String var5, String var6, int var7);

    private native int nativeSetExtensionProperty2(long var1, String var3, String var4, String var5, String var6, int var7, int var8, String var9, int var10);

    private native String nativeGetExtensionProperty(long var1, String var3, String var4, String var5, int var6);

    private native String nativeGetExtensionProperty2(long var1, String var3, String var4, String var5, int var6, int var7, String var8, int var9);

    private native int nativeSetExtensionProviderProperty(long var1, String var3, String var4, String var5);

    private native int nativeEnableInEarMonitoring(long var1, boolean var3, int var4);

    private native int nativeSetInEarMonitoringVolume(long var1, int var3);

    private native double nativeGetEffectsVolume(long var1);

    private native int nativeSetEffectsVolume(long var1, double var3);

    private native int nativeSetVolumeOfEffect(long var1, int var3, double var4);

    private native int nativePlayEffectWithFilePath(long var1, int var3, String var4, int var5, double var6, double var8, double var10, boolean var12, int var13, String var14, int var15);

    private native int nativePlayAllEffects(long var1, int var3, double var4, double var6, double var8, boolean var10);

    private native int nativeGetVolumeOfEffect(long var1, int var3);

    private native int nativeStopEffect(long var1, int var3);

    private native int nativeStopAllEffects(long var1);

    private native int nativePreloadEffect(long var1, int var3, String var4, int var5, String var6, int var7);

    private native int nativeUnloadEffect(long var1, int var3);

    private native int nativeUnloadAllEffects(long var1);

    private native int nativeGetEffectDuration(long var1, String var3);

    private native int nativeSetEffectPosition(long var1, int var3, int var4);

    private native int nativeGetEffectCurrentPosition(long var1, int var3);

    private native int nativePauseEffect(long var1, int var3);

    private native int nativePauseAllEffects(long var1);

    private native int nativeResumeEffect(long var1, int var3);

    private native int nativeResumeAllEffects(long var1);

    private native int nativeGetConnectionState(long var1, String var3, int var4);

    private native int nativeStartAudioRecording(long var1, String var3, int var4);

    private native int nativeStartAudioRecording2(long var1, String var3, boolean var4, int var5, int var6, int var7, int var8);

    private native int nativeStopAudioRecording(long var1);

    private native int nativeSetLocalAccessPoint(long var1, ArrayList<String> var3, ArrayList<String> var4, String var5, int var6, Object var7, boolean var8);

    private native int nativeStartAudioMixing(long var1, String var3, boolean var4, int var5, int var6);

    private native int nativeStopAudioMixing(long var1);

    private native int nativePauseAudioMixing(long var1);

    private native int nativeResumeAudioMixing(long var1);

    private native int nativeAdjustAudioMixingVolume(long var1, int var3);

    private native int nativeAdjustAudioMixingPublishVolume(long var1, int var3);

    private native int nativeGetAudioMixingPublishVolume(long var1);

    private native int nativeAdjustAudioMixingPlayoutVolume(long var1, int var3);

    private native int nativeGetAudioMixingPlayoutVolume(long var1);

    private native int nativeGetAudioMixingDuration(long var1);

    private native int nativeGetAudioMixingCurrentPosition(long var1);

    private native int nativeSetAudioMixingPosition(long var1, int var3);

    private native int nativeSetAudioMixingDualMonoMode(long var1, int var3);

    private native int nativeSetAudioMixingPitch(long var1, int var3);

    private native int nativeSetAudioMixingPlaybackSpeed(long var1, int var3);

    private native int nativeSelectAudioTrack(long var1, int var3);

    private native int nativeStartRecordingDeviceTest(long var1, int var3);

    private native int nativeStopRecordingDeviceTest(long var1);

    private native int nativeStartPlaybackDeviceTest(long var1, String var3);

    private native int nativeStopPlaybackDeviceTest(long var1);

    private native int nativeGetAudioTrackCount(long var1);

    public native int nativePushExternalVideoFrame(long var1, VideoFrame var3, int var4);

    private native int nativePushExternalAgoraVideoFrame(long var1, int var3, byte[] var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12, javax.microedition.khronos.egl.EGLContext var14, EGLContext var15, long var16, float[] var18, int var19, int var20);

    private native int nativeRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeUnregisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeRegisterVideoFrameObserver(long var1, IVideoFrameObserver var3);

    private native int nativeSendCustomReportMessage(long var1, String var3, String var4, String var5, String var6, int var7, String var8, int var9);

    private native int nativeSetLogLevel(long var1, int var3);

    private native int nativeWriteLog(long var1, int var3, String var4);

    private native int nativeCreateMediaPlayer(long var1);

    private native int nativeCreateVideoEffectObject(long var1, String var3, int var4);

    private native int nativeDestroyVideoEffectObject(long var1);

    private native int nativeAddOrUpdateVideoEffect(long var1, int var3, String var4);

    private native int nativeRemoveVideoEffect(long var1, int var3);

    private native int nativePerformVideoEffectAction(long var1, int var3, int var4);

    private native int nativeSetVideoEffectFloatParam(long var1, String var3, String var4, float var5);

    private native int nativeSetVideoEffectIntParam(long var1, String var3, String var4, int var5);

    private native int nativeSetVideoEffectBoolParam(long var1, String var3, String var4, boolean var5);

    private native float nativeGetVideoEffectFloatParam(long var1, String var3, String var4);

    private native int nativeGetVideoEffectIntParam(long var1, String var3, String var4);

    private native boolean nativeGetVideoEffectBoolParam(long var1, String var3, String var4);

    private native int nativeCreateH265Transcoder(long var1);

    private native int nativeMediaPlayerOpen(long var1, int var3, String var4, long var5);

    private native int nativeMediaPlayerPlay(long var1, int var3);

    private native int nativeMediaPlayerPause(long var1, int var3);

    private native int nativeMediaPlayerStop(long var1, int var3);

    private native int nativeMediaPlayerResume(long var1, int var3);

    private native int nativeMediaPlayerSeek(long var1, int var3, long var4);

    private native int nativeMediaPlayerSetAudioPitch(long var1, int var3, int var4);

    private native long nativeMediaPlayerGetPlayPosition(long var1, int var3);

    private native int nativeMediaPlayerGetState(long var1, int var3);

    private native int nativeMediaPlayerMute(long var1, int var3, boolean var4);

    private native boolean nativeMediaPlayerGetMute(long var1, int var3);

    private native long nativeMediaPlayerGetDuration(long var1, int var3);

    private native int nativeMediaPlayerGetStreamCount(long var1, int var3);

    private native int nativeMediaPlayerSetView(long var1, int var3, View var4);

    private native int nativeMediaPlayerSetRenderMode(long var1, int var3, int var4);

    private native MediaStreamInfo nativeMediaPlayerGetStreamInfo(long var1, int var3, int var4);

    private native int nativeMediaPlayerSetLoopCount(long var1, int var3, int var4);

    private native int nativeMediaPlayerChangePlaybackSpeed(long var1, int var3, int var4);

    private native int nativeMediaPlayerSelectAudioTrack(long var1, int var3, int var4);

    private native int nativeMediaPlayerSelectMultiAudioTrack(long var1, int var3, int var4, int var5);

    private native int nativeMediaPlayerSetPlayerOption(long var1, int var3, String var4, int var5);

    private native int nativeMediaPlayerSetPlayerOptionString(long var1, int var3, String var4, String var5);

    private native int nativeMediaPlayerTakeScreenshot(long var1, int var3, String var4);

    private native int nativeMediaPlayerSelectInternalSubtitle(long var1, int var3, int var4);

    private native int nativeMediaPlayerSetExternalSubtitle(long var1, int var3, String var4);

    private native int nativeMediaPlayerAdjustPlayoutVolume(long var1, int var3, int var4);

    private native int nativeMediaPlayerGetPlayoutVolume(long var1, int var3);

    private native int nativeMediaPlayerAdjustPublishSignalVolume(long var1, int var3, int var4);

    private native int nativeMediaPlayerGetPublishSignalVolume(long var1, int var3);

    private native String nativeMediaPlayerGetPlaySrc(long var1, int var3);

    private native int nativeMediaPlayerPreloadSrc(long var1, int var3, String var4, long var5);

    private native int nativeMediaPlayerUnloadSrc(long var1, int var3, String var4);

    private native int nativeMediaPlayerPlayPreloadedSrc(long var1, int var3, String var4);

    private native int nativeMediaPlayerSwitchSrc(long var1, int var3, String var4, boolean var5);

    private native int nativeMediaPlayerDestroy(long var1, int var3);

    private native int nativeMediaPlayerRegisterPlayerObserver(long var1, int var3, IMediaPlayerObserver var4);

    private native int nativeMediaPlayerUnRegisterPlayerObserver(long var1, int var3, IMediaPlayerObserver var4);

    private native int nativeRegisterMediaPlayerAudioSpectrumObserver(long var1, int var3, IAudioSpectrumObserver var4, int var5);

    private native int nativeUnRegisterMediaPlayerAudioSpectrumObserver(long var1, int var3, IAudioSpectrumObserver var4);

    private native int nativeMediaPlayerSetAudioDualMonoMode(long var1, int var3, int var4);

    private native int nativeMediaPlayerOpenWithAgoraCDNSrc(long var1, int var3, String var4, long var5);

    private native int nativeMediaPlayerGetAgoraCDNLineCount(long var1, int var3);

    private native int nativeMediaPlayerSwitchAgoraCDNLineByIndex(long var1, int var3, int var4);

    private native int nativeMediaPlayerGetCurrentAgoraCDNIndex(long var1, int var3);

    private native int nativeMediaPlayerEnableAutoSwitchAgoraCDN(long var1, int var3, boolean var4);

    private native int nativeMediaPlayerRenewAgoraCDNSrcToken(long var1, int var3, String var4, long var5);

    private native int nativeMediaPlayerSwitchAgoraCDNSrc(long var1, int var3, String var4, boolean var5);

    private native int nativeMediaPlayerSetSpatialAudioParams(long var1, int var3, SpatialAudioParams var4);

    private native int nativeMediaPlayerGetAudioBufferDelay(long var1, int var3);

    private native int nativeRegisterLocalUserAccount(long var1, String var3, String var4);

    private native int nativeJoinChannelWithUserAccount(long var1, String var3, String var4, String var5, ChannelMediaOptions var6);

    private native int nativeJoinChannelWithUserAccountEx(long var1, String var3, String var4, String var5, ChannelMediaOptions var6);

    private native int nativeGetUserInfoByUserAccount(long var1, String var3, UserInfo var4);

    private native int nativeGetUserInfoByUserAccountEx(long var1, String var3, UserInfo var4, String var5, int var6);

    private native int nativeGetUserInfoByUid(long var1, int var3, UserInfo var4);

    private native int nativeGetUserInfoByUidEx(long var1, int var3, UserInfo var4, String var5, int var6);

    private native DeviceInfo nativeGetAudioDeviceInfo(long var1);

    private native int nativeStartOrUpdateChannelMediaRelay(long var1, ChannelMediaInfo var3, ChannelMediaInfo[] var4, String var5, int var6);

    private native int nativeStopChannelMediaRelay(long var1, String var3, int var4);

    private native int nativePauseAllChannelMediaRelay(long var1, String var3, int var4);

    private native int nativeResumeAllChannelMediaRelay(long var1, String var3, int var4);

    private native int nativeEnableExternalAudioSourceLocalPlayback(long var1, boolean var3);

    private native long nativeGetCurrentMonotonicTimeInMs(long var1);

    private native int nativeAdjustCustomAudioPublishVolume(long var1, int var3, int var4);

    private native int nativeAdjustCustomAudioPlayoutVolume(long var1, int var3, int var4);

    private native int nativeStartRhythmPlayer(long var1, String var3, String var4, AgoraRhythmPlayerConfig var5);

    private native int nativeStopRhythmPlayer(long var1);

    private native int nativeConfigRhythmPlayer(long var1, AgoraRhythmPlayerConfig var3);

    private native int nativeEnableCustomAudioLocalPlayback(long var1, int var3, boolean var4);

    private native int nativeEnableSoundPositionIndication(long var1, boolean var3);

    private native int nativeSetRemoteVoicePosition(long var1, int var3, double var4, double var6, String var8, int var9);

    private native int nativeEnableSpatialAudio(long var1, boolean var3);

    private native int nativeEnableVoiceAITuner(long var1, boolean var3, int var4);

    private native int nativesetAINSMode(long var1, boolean var3, int var4);

    private native int nativeSetRemoteUserSpatialAudioParams(long var1, int var3, SpatialAudioParams var4, String var5, int var6);

    private native int nativeSetRemoteVideoSubscriptionOptions(long var1, int var3, VideoSubscriptionOptions var4, String var5, int var6);

    private native boolean nativeGetCameraTorchSupported(long var1);

    private native boolean nativeGetCameraFocusSupported(long var1);

    private native boolean nativeGetCameraZoomSupported(long var1);

    private native boolean nativeGetCameraAutoFocusFaceModeSupported(long var1);

    private native boolean nativeGetCameraFaceDetectSupported(long var1);

    private native int nativeSetCameraExposureFactor(long var1, int var3);

    private native boolean nativeGetCameraExposurePositionSupported(long var1);

    private native boolean nativeGetCameraExposureSupported(long var1);

    private native int nativeSetCameraFocusPositionInPreview(long var1, float var3, float var4);

    private native int nativeSetCameraTorchOn(long var1, boolean var3);

    private native int nativeSetCameraZoomFactor(long var1, float var3);

    private native int nativeSetCameraAutoFocusFaceModeEnabled(long var1, boolean var3);

    private native int nativeEnableFaceDetection(long var1, boolean var3);

    private native int nativeSetCameraExposurePosition(long var1, float var3, float var4);

    private native float nativeGetCameraMaxZoomFactor(long var1);

    private native int nativeSetVoiceBeautifierPreset(long var1, int var3);

    private native int nativeSetAudioEffectPreset(long var1, int var3);

    private native int nativeSetVoiceConversionPreset(long var1, int var3);

    private native int nativeSetAudioEffectParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetVoiceBeautifierParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetVoiceConversionParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetLocalVoicePitch(long var1, double var3);

    private native int nativeSetLocalVoiceFormant(long var1, double var3);

    private native int nativeSetLocalVoiceEqualization(long var1, int var3, int var4);

    private native int nativeSetLocalVoiceReverb(long var1, int var3, int var4);

    private native int nativeSetHeadphoneEQPreset(long var1, int var3);

    private native int nativeSetHeadphoneEQParameters(long var1, int var3, int var4);

    private native int nativeMediaPlayerRegisterAudioFrameObserver(long var1, int var3, IMediaPlayerAudioFrameObserver var4, int var5);

    private native int nativeMediaPlayerRegisterVideoFrameObserver(long var1, int var3, IMediaPlayerVideoFrameObserver var4);

    private native int nativeSetDirectCdnStreamingAudioConfiguration(long var1, int var3);

    private native int nativeSetDirectCdnStreamingVideoConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native int nativeStartDirectCdnStreaming(long var1, Object var3, String var4, DirectCdnStreamingMediaOptions var5);

    private native int nativeStopDirectCdnStreaming(long var1);

    private native int nativeUpdateDirectCdnStreamingMediaOptions(long var1, DirectCdnStreamingMediaOptions var3);

    private native int nativeSetAVSyncSource(long var1, String var3, int var4);

    private native int nativeCreateCustomVideoTrack(long var1);

    private native int nativeCreateCustomEncodedVideoTrack(long var1, EncodedVideoTrackOptions var3);

    private native int nativeDestroyCustomVideoTrack(long var1, int var3);

    private native int nativeDestroyCustomEncodedVideoTrack(long var1, int var3);

    private native int nativeSetHighPriorityUserList(long var1, int[] var3, int var4, String var5, int var6);

    private native int nativeSetRemoteSubscribeFallbackOption(long var1, int var3);

    private native int nativeSetSubscribeAudioBlacklist(long var1, int[] var3, String var4, int var5);

    private native int nativeSetSubscribeAudioWhitelist(long var1, int[] var3, String var4, int var5);

    private native int nativeSetSubscribeVideoBlacklist(long var1, int[] var3, String var4, int var5);

    private native int nativeSetSubscribeVideoWhitelist(long var1, int[] var3, String var4, int var5);

    private native int nativeMediaPlayerOpenWithSource(long var1, int var3, MediaPlayerSource var4);

    private native int nativeInitMediaPlayerCacheManager(long var1);

    private native int nativeMediaPlayerRemoveAllCaches(long var1);

    private native int nativeMediaPlayerRemoveOldCache(long var1);

    private native int nativeMediaPlayerRemoveCacheByUri(long var1, String var3);

    private native int nativeMediaPlayerSetCacheDir(long var1, String var3);

    private native int nativeMediaPlayerSetMaxCacheFileCount(long var1, int var3);

    private native int nativeMediaPlayerSetMaxCacheFileSize(long var1, long var3);

    private native String nativeMediaPlayerGetCacheDir(long var1);

    private native int nativeMediaPlayerEnableAutoRemoveCache(long var1, boolean var3);

    private native int nativeMediaPlayerGetMaxCacheFileCount(long var1);

    private native long nativeMediaPlayerGetMaxCacheFileSize(long var1);

    private native int nativeMediaPlayerGetCacheFileCount(long var1);

    private native int nativeH265TranscoderEnableTranscode(long var1, String var3, String var4, int var5);

    private native int nativeH265TranscoderQueryChannel(long var1, String var3, String var4, int var5);

    private native int nativeH265TranscoderTriggerTranscode(long var1, String var3, String var4, int var5);

    private native int nativeH265TranscoderRegisterObserver(long var1, IH265TranscoderObserver var3);

    private native int nativeH265TranscoderUnregisterObserver(long var1, IH265TranscoderObserver var3);

    private native int nativeEnableVideoImageSource(long var1, boolean var3, String var4, int var5, int var6, String var7, int var8);

    private native int nativeTakeSnapshot(long var1, int var3, String var4, String var5, int var6);

    private native int nativeTakeSnapshot2(long var1, int var3, String var4, int var5, String var6, int var7);

    private native int nativeEnableContentInspect(long var1, boolean var3, byte[] var4, String var5, int var6);

    private native int nativeSetMediaRecorderObserver(long var1, Object var3, int var4, String var5, boolean var6, int var7);

    private native int nativeStartRecording(long var1, String var3, int var4, int var5, int var6, int var7, int var8, String var9, boolean var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    private native int nativeStopRecording(long var1, int var3, String var4, boolean var5, int var6);

    private native int nativeReleaseRecorder(long var1, int var3, String var4, int var5);

    private native int nativeStartMediaRenderingTracing(long var1);

    private native int nativeStartMediaRenderingTracingEx(long var1, String var3, int var4);

    private native int nativeSetParametersEx(long var1, String var3, String var4, int var5);

    private native int nativeEnableInstantMediaRendering(long var1);

    private native int nativeSetupAudioAttributeContext(long var1, AudioAttributes var3);

    private native boolean nativeIsFeatureAvailableOnDevice(long var1, int var3);

    private static class InitResult {
        private int retVal;
        private long nativeHandle;

        @CalledByNative(value="InitResult")
        public InitResult(int retVal, long nativeHandle) {
            this.retVal = retVal;
            this.nativeHandle = nativeHandle;
        }
    }

    private static enum ExtensionLoadState {
        LOADED,
        LOAD_FAIL;

    }
}

