/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.graphics.Rect;
import android.text.TextUtils;
import io.agora.rtc2.Constants;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.LocalAudioMixerConfiguration;
import io.agora.rtc2.LocalTranscoderConfiguration;
import io.agora.rtc2.internal.Marshallable;
import io.agora.rtc2.live.LiveInjectStreamConfig;
import io.agora.rtc2.live.LiveTranscoding;
import io.agora.rtc2.video.AgoraImage;
import io.agora.rtc2.video.ContentInspectConfig;
import io.agora.rtc2.video.VideoCompositingLayout;
import java.util.ArrayList;
import java.util.Map;

public class RtcEngineMessage {
    public static long toIntegerUserId(int uid) {
        return (long)uid & 0xFFFFFFFFL;
    }

    public static String toStringUserId(int uid) {
        return String.valueOf(RtcEngineMessage.toIntegerUserId(uid));
    }

    public static int toIntegerUserId(String userId) {
        try {
            if (userId != null) {
                return (int)Long.parseLong(userId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static class PVideoLayoutInfo
    extends Marshallable {
        public String service;
        public int uid;
        public int width;
        public int height;
        public int layoutCount;
        public Layout[] layoutList;

        @Override
        public byte[] marshall() {
            this.pushString16(this.service);
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            int len = this.layoutList.length;
            this.pushInt(len);
            for (int i = 0; i < len; ++i) {
                this.pushString16(this.layoutList[i].channel);
                this.pushInt(this.layoutList[i].uid);
                this.pushInt(this.layoutList[i].x);
                this.pushInt(this.layoutList[i].y);
                this.pushInt(this.layoutList[i].width);
                this.pushInt(this.layoutList[i].height);
                this.pushInt(this.layoutList[i].videoState);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.service = this.popString16UTF8();
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.layoutCount = this.popInt();
            this.popShort();
            if (this.layoutCount > 0) {
                this.layoutList = new Layout[this.layoutCount];
                for (int i = 0; i < this.layoutCount; ++i) {
                    this.layoutList[i] = new Layout();
                    this.layoutList[i].channel = this.popString16UTF8();
                    this.layoutList[i].uid = this.popInt();
                    this.layoutList[i].x = this.popInt();
                    this.layoutList[i].y = this.popInt();
                    this.layoutList[i].width = this.popInt();
                    this.layoutList[i].height = this.popInt();
                    this.layoutList[i].videoState = this.popInt();
                }
            }
        }

        public static class Layout {
            public String channel;
            public int uid;
            public int x;
            public int y;
            public int width;
            public int height;
            public int videoState;
        }
    }

    public static class PLayout
    extends Marshallable {
    }

    public static class PVideoRenderingTracingInfo
    extends Marshallable {
        public int uid;
        public short event;
        public int elapsedTime;
        public int start2JoinChannel;
        public int join2JoinSuccess;
        public int joinSuccess2RemoteJoined;
        public int remoteJoined2SetView;
        public int remoteJoined2UnmuteVideo;
        public int remoteJoined2PacketReceived;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushShort(this.event);
            this.pushInt(this.elapsedTime);
            this.pushInt(this.start2JoinChannel);
            this.pushInt(this.join2JoinSuccess);
            this.pushInt(this.joinSuccess2RemoteJoined);
            this.pushInt(this.remoteJoined2SetView);
            this.pushInt(this.remoteJoined2UnmuteVideo);
            this.pushInt(this.remoteJoined2PacketReceived);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.event = this.popShort();
            this.elapsedTime = this.popInt();
            this.start2JoinChannel = this.popInt();
            this.join2JoinSuccess = this.popInt();
            this.joinSuccess2RemoteJoined = this.popInt();
            this.remoteJoined2SetView = this.popInt();
            this.remoteJoined2UnmuteVideo = this.popInt();
            this.remoteJoined2PacketReceived = this.popInt();
        }

        public IRtcEngineEventHandler.VideoRenderingTracingInfo getVideoRenderingTracingInfo() {
            IRtcEngineEventHandler.VideoRenderingTracingInfo tracingInfo = new IRtcEngineEventHandler.VideoRenderingTracingInfo();
            tracingInfo.elapsedTime = this.elapsedTime;
            tracingInfo.start2JoinChannel = this.start2JoinChannel;
            tracingInfo.join2JoinSuccess = this.join2JoinSuccess;
            tracingInfo.joinSuccess2RemoteJoined = this.joinSuccess2RemoteJoined;
            tracingInfo.remoteJoined2SetView = this.remoteJoined2SetView;
            tracingInfo.remoteJoined2UnmuteVideo = this.remoteJoined2UnmuteVideo;
            tracingInfo.remoteJoined2PacketReceived = this.remoteJoined2PacketReceived;
            return tracingInfo;
        }
    }

    public static class PAudioMetadataReceived
    extends Marshallable {
        int uid;
        String userAccount;
        byte[] payload;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.userAccount = this.popString16UTF8();
            this.payload = this.popBytes();
        }
    }

    public static class PProxyConnect
    extends Marshallable {
        public String channel;
        public int uid;
        public int proxyType;
        public String localProxyIp;
        public int elapsed;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.proxyType = this.popInt();
            this.localProxyIp = this.popString16UTF8();
            this.elapsed = this.popInt();
        }
    }

    public static class PUploadLogResult
    extends Marshallable {
        public String requestId;
        public boolean success;
        public int reason;

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.requestId = this.popString16();
            this.success = this.popBool();
            this.reason = this.popInt();
        }
    }

    public static class PPublishVideoStateChanged
    extends Marshallable {
        int source;
        String channelId;
        short oldState;
        short newState;
        int elapseSinceLastState;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.channelId = this.popString16UTF8();
            this.oldState = this.popShort();
            this.newState = this.popShort();
            this.elapseSinceLastState = this.popInt();
        }
    }

    public static class PPublishAudioStateChanged
    extends Marshallable {
        String channelId;
        short oldState;
        short newState;
        int elapseSinceLastState;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channelId = this.popString16UTF8();
            this.oldState = this.popShort();
            this.newState = this.popShort();
            this.elapseSinceLastState = this.popInt();
        }
    }

    public static class PSubscribeVideoStateChanged
    extends Marshallable {
        String channelId;
        int uid;
        short oldState;
        short newState;
        int elapseSinceLastState;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channelId = this.popString16UTF8();
            this.uid = this.popInt();
            this.oldState = this.popShort();
            this.newState = this.popShort();
            this.elapseSinceLastState = this.popInt();
        }
    }

    public static class PSubscribeAudioStateChanged
    extends Marshallable {
        String channelId;
        int uid;
        short oldState;
        short newState;
        int elapseSinceLastState;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channelId = this.popString16UTF8();
            this.uid = this.popInt();
            this.oldState = this.popShort();
            this.newState = this.popShort();
            this.elapseSinceLastState = this.popInt();
        }
    }

    public static class PPermissionError
    extends Marshallable {
        int permission;

        @Override
        public byte[] marshall() {
            this.pushInt(this.permission);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.permission = this.popInt();
        }
    }

    public static class PEncryptionError
    extends Marshallable {
        int errorType;

        @Override
        public byte[] marshall() {
            this.pushInt(this.errorType);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.errorType = this.popInt();
        }
    }

    public static class PDownlinkNetworkInfoUpdated
    extends Marshallable {
        int lastmile_buffer_delay_time_ms;
        int bandwidth_estimation_bps;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.lastmile_buffer_delay_time_ms = this.popInt();
            this.bandwidth_estimation_bps = this.popInt();
        }

        public IRtcEngineEventHandler.DownlinkNetworkInfo getDownlinkNetworkInfo() {
            IRtcEngineEventHandler.DownlinkNetworkInfo info = new IRtcEngineEventHandler.DownlinkNetworkInfo();
            info.lastmile_buffer_delay_time_ms = this.lastmile_buffer_delay_time_ms;
            info.bandwidth_estimation_bps = this.bandwidth_estimation_bps;
            return info;
        }
    }

    public static class PUplinkNetworkInfoUpdated
    extends Marshallable {
        int videoEncoderTargetBitrateBps;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.videoEncoderTargetBitrateBps = this.popInt();
        }

        public IRtcEngineEventHandler.UplinkNetworkInfo getUplinkNetworkInfo() {
            IRtcEngineEventHandler.UplinkNetworkInfo info = new IRtcEngineEventHandler.UplinkNetworkInfo();
            info.video_encoder_target_bitrate_bps = this.videoEncoderTargetBitrateBps;
            return info;
        }
    }

    public static class PRhythmPlayerStateChanged
    extends Marshallable {
        int state;
        int errorCode;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.errorCode = this.popInt();
        }
    }

    public static class PAudioMixingPositionChanged
    extends Marshallable {
        long position;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.position = this.popInt64();
        }
    }

    public static class PAudioMixingStateChanged
    extends Marshallable {
        int state;
        int reasonCode;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.reasonCode = this.popInt();
        }
    }

    public static class PAudioRoutingChanged
    extends Marshallable {
        int routing;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.routing = this.popInt();
        }
    }

    public static class PLocalFallbackStatus
    extends Marshallable {
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popBool();
        }
    }

    public static class PNetworkTypeChanged
    extends Marshallable {
        public int type;

        @Override
        public byte[] marshall() {
            this.pushInt(this.type);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.type = this.popInt();
        }
    }

    public static class PMediaResWlAccStats
    extends Marshallable {
        public short e2eDelayPercentCur;
        public short frozenRatioPercentCur;
        public short lossRatePercentCur;
        public short e2eDelayPercentAve;
        public short frozenRatioPercentAve;
        public short lossRatePercentAve;

        @Override
        public byte[] marshall() {
            this.pushShort(this.e2eDelayPercentCur);
            this.pushShort(this.frozenRatioPercentCur);
            this.pushShort(this.lossRatePercentCur);
            this.pushShort(this.e2eDelayPercentAve);
            this.pushShort(this.frozenRatioPercentAve);
            this.pushShort(this.lossRatePercentAve);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.e2eDelayPercentCur = this.popShort();
            this.frozenRatioPercentCur = this.popShort();
            this.lossRatePercentCur = this.popShort();
            this.e2eDelayPercentAve = this.popShort();
            this.frozenRatioPercentAve = this.popShort();
            this.lossRatePercentAve = this.popShort();
        }

        public IRtcEngineEventHandler.WlAccStats getWlAccStatsCur() {
            IRtcEngineEventHandler.WlAccStats stats = new IRtcEngineEventHandler.WlAccStats();
            stats.e2eDelayPercent = this.e2eDelayPercentCur;
            stats.frozenRatioPercent = this.frozenRatioPercentCur;
            stats.lossRatePercent = this.lossRatePercentCur;
            return stats;
        }

        public IRtcEngineEventHandler.WlAccStats getWlAccStatsAve() {
            IRtcEngineEventHandler.WlAccStats stats = new IRtcEngineEventHandler.WlAccStats();
            stats.e2eDelayPercent = this.e2eDelayPercentAve;
            stats.frozenRatioPercent = this.frozenRatioPercentAve;
            stats.lossRatePercent = this.lossRatePercentAve;
            return stats;
        }
    }

    public static class PMediaResWlAccMessage
    extends Marshallable {
        public int reason;
        public int action;
        public String wlAccMsg;

        @Override
        public byte[] marshall() {
            this.pushInt(this.reason);
            this.pushInt(this.action);
            this.pushString16(this.wlAccMsg);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.reason = this.popInt();
            this.action = this.popInt();
            this.wlAccMsg = this.popString16UTF8();
        }
    }

    public static class PConnectionState
    extends Marshallable {
        public int state;
        public int reason;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PUserTransportStat
    extends Marshallable {
        public boolean isAudio;
        public int peerUid;
        public short delay;
        public short lost;
        public short rxKBitRate;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.isAudio = this.popBool();
            this.peerUid = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
            this.rxKBitRate = this.popShort();
        }
    }

    public static class PCrossChannelEvent
    extends Marshallable {
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.code = this.popInt();
        }
    }

    public static class PCrossChannelState
    extends Marshallable {
        public int state;
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.code = this.popInt();
        }
    }

    public static class PRemoteAudioState
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushByte((byte)this.state);
            this.pushByte((byte)this.reason);
            this.pushByte((byte)this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popByte();
            this.reason = this.popByte();
            this.elapsed = this.popInt();
        }
    }

    public static class PLocalAudioState
    extends Marshallable {
        public int state;
        public int errorCode;

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.state);
            this.pushByte((byte)this.errorCode);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popByte();
            this.errorCode = this.popByte();
        }
    }

    public static class PRemoteVideoState
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.state);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popByte();
            this.reason = this.popByte();
            this.elapsed = this.popInt();
        }
    }

    public static class PUserInfoState
    extends Marshallable {
        public int uid;
        public String userAccount;
        public String customUserInfo;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushBytes(this.userAccount.getBytes());
            this.pushBytes(this.customUserInfo.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.userAccount = this.popString16UTF8();
            this.customUserInfo = this.popString16UTF8();
        }
    }

    public static class PLocalVideoState
    extends Marshallable {
        public int source;
        public int state;
        public int errorCode;

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.source);
            this.pushByte((byte)this.state);
            this.pushByte((byte)this.errorCode);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.state = this.popByte();
            this.errorCode = this.popByte();
        }
    }

    public static class PPrivilegeWillExpire
    extends Marshallable {
        public String token;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.token = this.popString16UTF8();
        }
    }

    public static class PStreamInjectedStatus
    extends Marshallable {
        public String url;
        public int uid;
        public int status;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.url.getBytes());
            this.pushInt(this.uid);
            this.pushInt(this.status);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.uid = this.popInt();
            this.status = this.popInt();
        }
    }

    public static class PHostInStopped
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PHostInRequest
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PHostInResponse
    extends Marshallable {
        public int uid;
        public boolean accepted;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.accepted = this.popBool();
            this.error = this.popInt();
        }
    }

    public static class PInjectStreamConfig
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 25;

        private void marshall(Marshallable m, LiveInjectStreamConfig config) {
            m.pushShort((short)0);
            m.pushShort((short)25);
            m.pushInt(config.width);
            m.pushInt(config.height);
            m.pushInt(config.videoGop);
            m.pushInt(config.videoFramerate);
            m.pushInt(config.videoBitrate);
            m.pushInt(LiveInjectStreamConfig.AudioSampleRateType.getValue(config.audioSampleRate));
            m.pushInt(config.audioBitrate);
            m.pushInt(config.audioChannels);
        }

        public byte[] marshall(LiveInjectStreamConfig config) {
            this.marshall(this, config);
            return super.marshall();
        }
    }

    public static class PLiveTranscoding
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 23;

        private void marshallUserConfig(Marshallable m, LiveTranscoding.TranscodingUser user) {
            m.pushInt(user.uid);
            String userId = user.userId;
            if (userId == null) {
                userId = "";
            }
            m.pushString16(userId);
            m.pushInt(user.x);
            m.pushInt(user.y);
            m.pushInt(user.width);
            m.pushInt(user.height);
            m.pushInt(user.zOrder);
            m.pushDouble(user.alpha);
            m.pushInt(user.audioChannel);
        }

        private void marshallImage(Marshallable m, AgoraImage image) {
            m.pushString16(image.url);
            m.pushInt(image.x);
            m.pushInt(image.y);
            m.pushInt(image.width);
            m.pushInt(image.height);
            m.pushInt(image.zOrder);
            m.pushDouble(image.alpha);
        }

        private void marshallWatermarks(Marshallable m, ArrayList<AgoraImage> watermarkList) {
            if (null == watermarkList) {
                this.pushShort((short)0);
                return;
            }
            this.pushShort((short)watermarkList.size());
            for (AgoraImage watermark : watermarkList) {
                this.marshallImage(m, watermark);
            }
        }

        private void marshallBackgroundImage(Marshallable m, ArrayList<AgoraImage> backgroundImageList) {
            if (null == backgroundImageList) {
                this.pushShort((short)0);
                return;
            }
            this.pushShort((short)backgroundImageList.size());
            for (AgoraImage backgroundImage : backgroundImageList) {
                this.marshallImage(m, backgroundImage);
            }
        }

        private void marshall(Marshallable m, LiveTranscoding transcoding) {
            m.pushShort((short)0);
            m.pushShort((short)23);
            m.pushInt(transcoding.width);
            m.pushInt(transcoding.height);
            m.pushInt(transcoding.videoGop);
            m.pushInt(transcoding.videoFramerate);
            m.pushInt(LiveTranscoding.VideoCodecProfileType.getValue(transcoding.videoCodecProfile));
            m.pushInt(LiveTranscoding.VideoCodecType.getValue(transcoding.videoCodecType));
            m.pushInt(transcoding.videoBitrate);
            this.marshallWatermarks(m, transcoding.getWatermarkList());
            this.marshallBackgroundImage(m, transcoding.getBackgroundImageList());
            m.pushBool(transcoding.lowLatency);
            m.pushInt(LiveTranscoding.AudioSampleRateType.getValue(transcoding.audioSampleRate));
            m.pushInt(transcoding.audioBitrate);
            m.pushInt(transcoding.audioChannels);
            m.pushInt(LiveTranscoding.AudioCodecProfileType.getValue(transcoding.audioCodecProfile));
            m.pushInt(transcoding.backgroundColor & 0xFFFFFF);
            if (TextUtils.isEmpty((CharSequence)transcoding.userConfigExtraInfo)) {
                transcoding.userConfigExtraInfo = "";
            }
            m.pushString16(transcoding.userConfigExtraInfo);
            if (TextUtils.isEmpty((CharSequence)transcoding.metadata)) {
                transcoding.metadata = "";
            }
            m.pushString16(transcoding.metadata);
            this.pushShort((short)transcoding.getAdvancedFeatures().size());
            for (Map.Entry<String, Boolean> entry : transcoding.getAdvancedFeatures().entrySet()) {
                m.pushString16(entry.getKey());
                m.pushBool(entry.getValue());
            }
            this.pushShort((short)transcoding.getUserCount());
            for (LiveTranscoding.TranscodingUser user : transcoding.getUsers()) {
                this.marshallUserConfig(m, user);
            }
        }

        public byte[] marshall(LiveTranscoding transcoding) {
            this.marshall(this, transcoding);
            return super.marshall();
        }
    }

    public static class PLocalAudioMixedTrackConfiguration
    extends Marshallable {
        private void marshallLocalAudioMixedStream(Marshallable m, LocalAudioMixerConfiguration.MixedAudioStream audioStream) {
            m.pushInt(Constants.AudioSourceType.getValue(audioStream.sourceType));
            m.pushInt(audioStream.remoteUserUid);
            m.pushString16(audioStream.channelId);
            m.pushInt(audioStream.trackId);
        }

        private void marshallMixedAudioStream(Marshallable m, ArrayList<LocalAudioMixerConfiguration.MixedAudioStream> audioInputStreams) {
            for (LocalAudioMixerConfiguration.MixedAudioStream audioStream : audioInputStreams) {
                this.marshallLocalAudioMixedStream(m, audioStream);
            }
        }

        private void marshall(Marshallable m, LocalAudioMixerConfiguration localAudioMixerConfiguration) {
            m.pushInt(localAudioMixerConfiguration.audioInputStreams.size());
            m.pushBool(localAudioMixerConfiguration.syncWithLocalMic);
            this.marshallMixedAudioStream(m, localAudioMixerConfiguration.audioInputStreams);
        }

        public byte[] marshall(LocalAudioMixerConfiguration localAudioMixerConfiguration) {
            this.marshall(this, localAudioMixerConfiguration);
            return super.marshall();
        }
    }

    public static class PLocalLiveTranscoderConfiguration
    extends Marshallable {
        private void marshallTranscodingVideoStream(Marshallable m, ArrayList<LocalTranscoderConfiguration.TranscodingVideoStream> transcodingVideoStreams) {
            this.pushShort((short)transcodingVideoStreams.size());
            for (LocalTranscoderConfiguration.TranscodingVideoStream transcodingVideoStream : transcodingVideoStreams) {
                this.marshallLocalTranscodingVideoStream(m, transcodingVideoStream);
            }
        }

        private void marshallLocalTranscodingVideoStream(Marshallable m, LocalTranscoderConfiguration.TranscodingVideoStream transcodingVideoStream) {
            m.pushInt(Constants.VideoSourceType.getValue(transcodingVideoStream.sourceType));
            m.pushInt(transcodingVideoStream.remoteUserUid);
            m.pushString16("");
            m.pushString16(transcodingVideoStream.imageUrl);
            m.pushInt(transcodingVideoStream.mediaPlayerId);
            m.pushInt(transcodingVideoStream.x);
            m.pushInt(transcodingVideoStream.y);
            m.pushInt(transcodingVideoStream.width);
            m.pushInt(transcodingVideoStream.height);
            m.pushInt(transcodingVideoStream.zOrder);
            m.pushDouble(transcodingVideoStream.alpha);
            m.pushBool(transcodingVideoStream.mirror);
        }

        private void marshallVideoEncoderConfiguration(Marshallable m, LocalTranscoderConfiguration localTranscoderConfiguration) {
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.dimensions.width);
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.dimensions.height);
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.frameRate);
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.bitrate);
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.minBitrate);
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.orientationMode.getValue());
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.mirrorMode.getValue());
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.degradationPrefer.getValue());
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.advanceOptions.compressionPreference.getValue());
            m.pushInt(localTranscoderConfiguration.videoOutputConfiguration.advanceOptions.encodingPreference.getValue());
        }

        private void marshall(Marshallable m, LocalTranscoderConfiguration localTranscoderConfiguration) {
            m.pushInt(localTranscoderConfiguration.transcodingVideoStreams.size());
            m.pushBool(localTranscoderConfiguration.syncWithPrimaryCamera);
            this.marshallVideoEncoderConfiguration(m, localTranscoderConfiguration);
            this.marshallTranscodingVideoStream(m, localTranscoderConfiguration.transcodingVideoStreams);
        }

        public byte[] marshall(LocalTranscoderConfiguration localTranscoderConfiguration) {
            this.marshall(this, localTranscoderConfiguration);
            return super.marshall();
        }
    }

    public static class PTranscodingVideoStream
    extends Marshallable {
        public int error;
        public int sourceType;
        public int remoteUserUid;
        public String imageUrl;
        public int x;
        public int y;
        public int width;
        public int height;
        public int zOrder;
        public double alpha;
        public boolean mirror;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.error = this.popInt();
            this.sourceType = this.popInt();
            this.remoteUserUid = this.popInt();
            this.imageUrl = this.popString16UTF8();
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.zOrder = this.popInt();
            this.alpha = this.popDouble();
            this.mirror = this.popBool();
        }

        public LocalTranscoderConfiguration.TranscodingVideoStream getTranscodingVideoStream() {
            LocalTranscoderConfiguration.TranscodingVideoStream stream = new LocalTranscoderConfiguration.TranscodingVideoStream();
            stream.sourceType = Constants.VideoSourceType.fromInt(this.sourceType);
            stream.remoteUserUid = this.remoteUserUid;
            stream.imageUrl = this.imageUrl;
            stream.x = this.x;
            stream.y = this.y;
            stream.width = this.width;
            stream.height = this.height;
            stream.zOrder = this.zOrder;
            stream.alpha = this.alpha;
            stream.mirror = this.mirror;
            return stream;
        }
    }

    public static class PStreamUnPublished
    extends Marshallable {
        public String url;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
        }
    }

    public static class PStreamPublished
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.error = this.popInt();
        }
    }

    public static class PStreamPublishEvent
    extends Marshallable {
        public String url;
        public int event;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.event = this.popInt();
        }
    }

    public static class PStreamPublishState
    extends Marshallable {
        public String url;
        public int state;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.state = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PLicenseVerifyFailed
    extends Marshallable {
        int reason;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.reason = this.popInt();
        }
    }

    public static class PClientRoleChangeFailed
    extends Marshallable {
        int reason;
        int currentRole;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.reason = this.popInt();
            this.currentRole = this.popInt();
        }
    }

    public static class PClientRoleChanged
    extends Marshallable {
        int oldRole;
        int newRole;
        int newRoleLatencyLevel;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.oldRole = this.popInt();
            this.newRole = this.popInt();
            this.newRoleLatencyLevel = this.popInt();
        }
    }

    public static class PActiveSpeaker
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PFirstLocalVideoFramePublished
    extends Marshallable {
        public int source;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.source);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalAudioFrame
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.elapsed = this.popInt();
        }
    }

    public static class PVideoCompositingLayout
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 20;

        private void marshallRegion(Marshallable m, VideoCompositingLayout.Region region) {
            m.pushInt(region.uid);
            if (!TextUtils.isEmpty((CharSequence)region.userId)) {
                m.pushBytes(region.userId.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            m.pushDouble(region.x);
            m.pushDouble(region.y);
            m.pushDouble(region.width);
            m.pushDouble(region.height);
            m.pushInt(region.zOrder);
            m.pushDouble(region.alpha);
            m.pushInt(region.renderMode);
        }

        private void marshall(Marshallable m, VideoCompositingLayout layout) {
            m.pushShort((short)0);
            m.pushShort((short)20);
            m.pushInt(layout.canvasWidth);
            m.pushInt(layout.canvasHeight);
            if (layout.backgroundColor != null) {
                m.pushBytes(layout.backgroundColor.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            if (layout.appData != null) {
                m.pushBytes(layout.appData);
            } else {
                m.pushBytes("".getBytes());
            }
            m.pushShort((short)layout.regions.length);
            for (int i = 0; i < layout.regions.length; ++i) {
                this.marshallRegion(m, layout.regions[i]);
            }
        }

        public byte[] marshall(VideoCompositingLayout layout) {
            this.marshall(this, layout);
            return super.marshall();
        }
    }

    public static class PStreamMessageError
    extends Marshallable {
        int uid;
        int streamId;
        int error;
        int missed;
        int cached;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.error = this.popInt();
            this.missed = this.popInt();
            this.cached = this.popInt();
        }
    }

    public static class PStreamMessage
    extends Marshallable {
        int uid;
        int streamId;
        long sentTs;
        byte[] payload;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.sentTs = this.popInt64();
            this.payload = this.popBytes();
        }
    }

    public static class PError
    extends Marshallable {
        public int err;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.err = this.popInt();
        }
    }

    public static class PMediaEngineEvent
    extends Marshallable {
        int code;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.code = this.popInt();
        }
    }

    public static class PVideoSizeChanged
    extends Marshallable {
        public int source;
        public int uid;
        public int width;
        public int height;
        public int rotation;

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.source);
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.rotation);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.rotation = this.popInt();
        }
    }

    public static class PFacePositionChanged
    extends Marshallable {
        public int imageWidth;
        public int imageHeight;
        FaceRect[] rectArr = null;
        int[] disArr = null;
        public int num;

        @Override
        public void unmarshall(byte[] buf) {
            int lenDistance;
            super.unmarshall(buf);
            this.imageWidth = this.popInt();
            this.imageHeight = this.popInt();
            int lenRect = this.popShort();
            if (lenRect > 0) {
                this.rectArr = new FaceRect[lenRect];
                for (int i = 0; i < lenRect; ++i) {
                    this.rectArr[i] = new FaceRect();
                    this.rectArr[i].x = this.popInt();
                    this.rectArr[i].y = this.popInt();
                    this.rectArr[i].width = this.popInt();
                    this.rectArr[i].height = this.popInt();
                }
            }
            if ((lenDistance = this.popShort()) > 0) {
                this.disArr = new int[lenDistance];
                for (int i = 0; i < lenDistance; ++i) {
                    this.disArr[i] = this.popInt();
                }
            }
        }

        IRtcEngineEventHandler.AgoraFacePositionInfo[] getAgoraFacePositionInfo() {
            IRtcEngineEventHandler.AgoraFacePositionInfo[] faceRectArr = null;
            if (this.rectArr != null && this.rectArr.length > 0) {
                faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[this.rectArr.length];
                for (int i = 0; i < this.rectArr.length; ++i) {
                    FaceRect rect = this.rectArr[i];
                    IRtcEngineEventHandler.AgoraFacePositionInfo faceInfo = new IRtcEngineEventHandler.AgoraFacePositionInfo();
                    faceInfo.x = rect.x;
                    faceInfo.y = rect.y;
                    faceInfo.width = rect.width;
                    faceInfo.height = rect.height;
                    faceInfo.distance = this.disArr[i];
                    faceRectArr[i] = faceInfo;
                }
            } else {
                faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[]{};
            }
            return faceRectArr;
        }

        public static class FaceRect {
            public int x;
            public int y;
            public int width;
            public int height;
        }
    }

    public static class PCameraExposureAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }

        Rect getRect() {
            Rect rect = new Rect(this.x, this.y, this.x + this.width, this.y + this.height);
            return rect;
        }
    }

    public static class PCameraFocusAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }

        Rect getRect() {
            Rect rect = new Rect(this.x, this.y, this.x + this.width, this.y + this.height);
            return rect;
        }
    }

    public static class PFirstRemoteVideoDecoded
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalVideoFrame
    extends Marshallable {
        public int source;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.source);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteVideoFrame
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteAudioDecoded
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteAudioFrame
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PLocalAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalAudioStats stats = new IRtcEngineEventHandler.LocalAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.sentSampleRate);
            this.pushInt(this.stats.sentBitrate);
            this.pushInt(this.stats.internalCodec);
            this.pushShort((short)this.stats.txPacketLossRate);
            this.pushInt(this.stats.audioDeviceDelay);
            this.pushInt(this.stats.audioPlayoutDelay);
            this.pushInt(this.stats.earMonitorDelay);
            this.pushInt(this.stats.aecEstimatedDelay);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.numChannels = this.popInt();
            this.stats.sentSampleRate = this.popInt();
            this.stats.sentBitrate = this.popInt();
            this.stats.internalCodec = this.popInt();
            this.stats.txPacketLossRate = this.popShort();
            this.stats.audioDeviceDelay = this.popInt();
            this.stats.audioPlayoutDelay = this.popInt();
            this.stats.earMonitorDelay = this.popInt();
            this.stats.aecEstimatedDelay = this.popInt();
        }
    }

    public static class PContentInspectConfig
    extends Marshallable {
        private void marshall(Marshallable m, ContentInspectConfig config) {
            if (config == null || config.moduleCount <= 0 || config.moduleCount > 32) {
                return;
            }
            m.pushString16(config.extraInfo);
            m.pushString16(config.serverConfig);
            this.pushShort((short)config.moduleCount);
            for (int i = 0; i < config.moduleCount; ++i) {
                m.pushInt(config.modules[i].type);
                m.pushInt(config.modules[i].interval);
                m.pushInt(Constants.VideoModulePosition.getValue(config.modules[i].position));
            }
        }

        public byte[] marshall(ContentInspectConfig config) {
            this.marshall(this, config);
            return super.marshall();
        }
    }

    public static class PSnapshotTaken
    extends Marshallable {
        public int uid;
        public String filepath;
        public int width;
        public int height;
        public int errCode;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushBytes(this.filepath.getBytes());
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.errCode);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.filepath = this.popString16UTF8();
            this.width = this.popInt();
            this.height = this.popInt();
            this.errCode = this.popInt();
        }
    }

    public static class PContentInspectResult
    extends Marshallable {
        public int result;

        @Override
        public byte[] marshall() {
            this.pushInt(this.result);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.result = this.popInt();
        }
    }

    public static class PRemoteAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteAudioStats stats = new IRtcEngineEventHandler.RemoteAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.quality);
            this.pushInt(this.stats.networkTransportDelay);
            this.pushInt(this.stats.jitterBufferDelay);
            this.pushInt(this.stats.audioLossRate);
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.receivedSampleRate);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            this.pushInt64(this.stats.totalActiveTime);
            this.pushInt64(this.stats.publishDuration);
            this.pushInt(this.stats.qoeQuality);
            this.pushInt(this.stats.qualityChangedReason);
            this.pushInt(this.stats.mosValue);
            this.pushInt(this.stats.frozenRateByCustomPlcCount);
            this.pushInt(this.stats.plcCount);
            this.pushInt(this.stats.rxAudioBytes);
            this.pushInt(this.stats.e2eDelay);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.uid = this.popInt();
            this.stats.quality = this.popInt();
            this.stats.networkTransportDelay = this.popInt();
            this.stats.jitterBufferDelay = this.popInt();
            this.stats.audioLossRate = this.popInt();
            this.stats.numChannels = this.popInt();
            this.stats.receivedSampleRate = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.totalActiveTime = this.popInt64();
            this.stats.publishDuration = this.popInt64();
            this.stats.qoeQuality = this.popInt();
            this.stats.qualityChangedReason = this.popInt();
            this.stats.mosValue = this.popInt();
            this.stats.frozenRateByCustomPlcCount = this.popInt();
            this.stats.plcCount = this.popInt();
            this.stats.rxAudioBytes = this.popInt();
            this.stats.e2eDelay = this.popInt();
        }
    }

    public static class PLocalVideoStat
    extends Marshallable {
        public int source;
        public IRtcEngineEventHandler.LocalVideoStats stats = new IRtcEngineEventHandler.LocalVideoStats();

        @Override
        public byte[] marshall() {
            this.pushByte((byte)this.source);
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.sentBitrate);
            this.pushInt(this.stats.sentFrameRate);
            this.pushInt(this.stats.captureFrameRate);
            this.pushInt(this.stats.regulatedCaptureFrameRate);
            this.pushInt(this.stats.captureFrameWidth);
            this.pushInt(this.stats.captureFrameHeight);
            this.pushInt(this.stats.regulatedCaptureFrameWidth);
            this.pushInt(this.stats.regulatedCaptureFrameHeight);
            this.pushInt(this.stats.encoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.targetBitrate);
            this.pushInt(this.stats.targetFrameRate);
            this.pushInt(this.stats.encodedBitrate);
            this.pushInt(this.stats.encodedFrameWidth);
            this.pushInt(this.stats.encodedFrameHeight);
            this.pushInt(this.stats.encodedFrameCount);
            this.pushInt(this.stats.codecType);
            this.pushInt(this.stats.qualityAdaptIndication);
            this.pushShort((short)this.stats.txPacketLossRate);
            this.pushInt(this.stats.captureBrightnessLevel);
            this.pushBool(this.stats.dualStreamEnabled);
            this.pushInt(this.stats.hwEncoderAccelerating);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.source = this.popByte();
            this.stats.uid = this.popInt();
            this.stats.sentBitrate = this.popInt();
            this.stats.sentFrameRate = this.popInt();
            this.stats.captureFrameRate = this.popInt();
            this.stats.regulatedCaptureFrameRate = this.popInt();
            this.stats.captureFrameWidth = this.popInt();
            this.stats.captureFrameHeight = this.popInt();
            this.stats.regulatedCaptureFrameWidth = this.popInt();
            this.stats.regulatedCaptureFrameHeight = this.popInt();
            this.stats.encoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.targetBitrate = this.popInt();
            this.stats.targetFrameRate = this.popInt();
            this.stats.encodedBitrate = this.popInt();
            this.stats.encodedFrameWidth = this.popInt();
            this.stats.encodedFrameHeight = this.popInt();
            this.stats.encodedFrameCount = this.popInt();
            this.stats.codecType = this.popInt();
            this.stats.qualityAdaptIndication = this.popInt();
            this.stats.txPacketLossRate = this.popShort();
            this.stats.captureBrightnessLevel = this.popInt();
            this.stats.dualStreamEnabled = this.popBool();
            this.stats.hwEncoderAccelerating = this.popInt();
        }
    }

    public static class PRemoteVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteVideoStats stats = new IRtcEngineEventHandler.RemoteVideoStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.delay);
            this.pushInt(this.stats.e2eDelay);
            this.pushInt(this.stats.width);
            this.pushInt(this.stats.height);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.decoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.frameLossRate);
            this.pushInt(this.stats.packetLossRate);
            this.pushInt(this.stats.rxStreamType);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            this.pushInt(this.stats.avSyncTimeMs);
            this.pushInt64(this.stats.totalActiveTime);
            this.pushInt64(this.stats.publishDuration);
            this.pushInt(this.stats.mosValue);
            this.pushInt(this.stats.rxVideoBytes);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.uid = this.popInt();
            this.stats.delay = this.popInt();
            this.stats.e2eDelay = this.popInt();
            this.stats.width = this.popInt();
            this.stats.height = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.decoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.frameLossRate = this.popInt();
            this.stats.packetLossRate = this.popInt();
            this.stats.rxStreamType = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.avSyncTimeMs = this.popInt();
            this.stats.totalActiveTime = this.popInt64();
            this.stats.publishDuration = this.popInt64();
            this.stats.mosValue = this.popInt();
            this.stats.rxVideoBytes = this.popInt();
        }
    }

    public static class PVideoNetOptions
    extends Marshallable {
        short width;
        short height;
        short frameRate;
        short bitrate;

        public void marshall(Marshallable m) {
            m.pushShort(this.width);
            m.pushShort(this.height);
            m.pushShort(this.frameRate);
            m.pushShort(this.bitrate);
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.width = this.popShort();
            this.height = this.popShort();
            this.frameRate = this.popShort();
            this.bitrate = this.popShort();
        }
    }

    public static class PMediaResSpeakersReport
    extends Marshallable {
        int mixVolume;
        Speaker[] speakers;

        @Override
        public byte[] marshall() {
            this.pushInt(this.mixVolume);
            int len = this.speakers.length;
            this.pushShort((short)len);
            for (int i = 0; i < len; ++i) {
                this.pushInt(this.speakers[i].uid);
                this.pushInt(this.speakers[i].volume);
                this.pushInt(this.speakers[i].vad);
                this.pushDouble(this.speakers[i].voicePitch);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.mixVolume = this.popInt();
            int len = this.popShort();
            if (len > 0) {
                this.speakers = new Speaker[len];
                for (int i = 0; i < len; ++i) {
                    this.speakers[i] = new Speaker();
                    this.speakers[i].uid = this.popInt();
                    this.speakers[i].volume = this.popInt();
                    this.speakers[i].vad = this.popInt();
                    this.speakers[i].voicePitch = this.popDouble();
                }
            }
        }

        public IRtcEngineEventHandler.AudioVolumeInfo[] getAudioVolumeInfo() {
            if (null != this.speakers && this.speakers.length > 0) {
                IRtcEngineEventHandler.AudioVolumeInfo[] volumInfo = new IRtcEngineEventHandler.AudioVolumeInfo[this.speakers.length];
                for (int k = 0; k < this.speakers.length; ++k) {
                    volumInfo[k] = new IRtcEngineEventHandler.AudioVolumeInfo();
                    volumInfo[k].vad = this.speakers[k].vad;
                    volumInfo[k].volume = this.speakers[k].volume;
                    volumInfo[k].voicePitch = this.speakers[k].voicePitch;
                    volumInfo[k].uid = this.speakers[k].uid;
                }
                return volumInfo;
            }
            return new IRtcEngineEventHandler.AudioVolumeInfo[0];
        }

        public static class Speaker {
            public int uid;
            public int volume;
            public int vad;
            public double voicePitch;
        }
    }

    public static class PMediaResAudioEffectFinished
    extends Marshallable {
        int soundId;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.soundId = this.popInt();
        }
    }

    public static class PMediaResLastmileProbeResult
    extends Marshallable {
        short state;
        int rtt;
        LastmileProbeOneWayResult uplinkReport;
        LastmileProbeOneWayResult downlinkReport;

        @Override
        public byte[] marshall() {
            this.pushShort(this.state);
            this.pushInt(this.uplinkReport.packetLossRate);
            this.pushInt(this.uplinkReport.jitter);
            this.pushInt(this.uplinkReport.availableBandwidth);
            this.pushInt(this.downlinkReport.packetLossRate);
            this.pushInt(this.downlinkReport.jitter);
            this.pushInt(this.downlinkReport.availableBandwidth);
            this.pushInt(this.rtt);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popShort();
            this.uplinkReport = new LastmileProbeOneWayResult();
            this.downlinkReport = new LastmileProbeOneWayResult();
            this.uplinkReport.packetLossRate = this.popInt();
            this.uplinkReport.jitter = this.popInt();
            this.uplinkReport.availableBandwidth = this.popInt();
            this.downlinkReport.packetLossRate = this.popInt();
            this.downlinkReport.jitter = this.popInt();
            this.downlinkReport.availableBandwidth = this.popInt();
            this.rtt = this.popInt();
        }

        public IRtcEngineEventHandler.LastmileProbeResult getLastmileProbeResult() {
            IRtcEngineEventHandler.LastmileProbeResult r = new IRtcEngineEventHandler.LastmileProbeResult();
            r.state = this.state;
            r.rtt = this.rtt;
            r.uplinkReport.packetLossRate = this.uplinkReport.packetLossRate;
            r.uplinkReport.jitter = this.uplinkReport.jitter;
            r.uplinkReport.availableBandwidth = this.uplinkReport.availableBandwidth;
            r.downlinkReport.packetLossRate = this.downlinkReport.packetLossRate;
            r.downlinkReport.jitter = this.downlinkReport.jitter;
            r.downlinkReport.availableBandwidth = this.downlinkReport.availableBandwidth;
            return r;
        }

        public static class LastmileProbeOneWayResult {
            public int packetLossRate;
            public int jitter;
            public int availableBandwidth;
        }
    }

    public static class PMediaResLastmileQuality
    extends Marshallable {
        int quality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.quality = this.popInt();
        }
    }

    public static class PMediaResNetworkQuality
    extends Marshallable {
        int uid;
        int txQuality;
        int rxQuality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.txQuality = this.popInt();
            this.rxQuality = this.popInt();
        }
    }

    public static class PUserStateChanged
    extends Marshallable {
        int uid;
        int state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popInt();
        }
    }

    public static class PMediaResUserState
    extends Marshallable {
        int uid;
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popBool();
        }
    }

    public static class PMediaResUserOfflineEvent
    extends Marshallable {
        int uid;
        int reason;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PMediaResUserJoinedEvent
    extends Marshallable {
        int uid;
        int elapsed;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PMediaResJoinMedia
    extends Marshallable {
        public String channel;
        public int uid;
        public int elapsed;
        public boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.elapsed = this.popInt();
            this.firstSuccess = this.popBool();
        }
    }

    public static class PMediaResRtcStats
    extends Marshallable {
        int totalDuration;
        int totalTxBytes;
        int totalRxBytes;
        int txKBitRate;
        int rxKBitRate;
        int txAudioBytes;
        int rxAudioBytes;
        int txVideoBytes;
        int rxVideoBytes;
        int txAudioKBitRate;
        int rxAudioKBitRate;
        int txVideoKBitRate;
        int rxVideoKBitRate;
        int lastmileDelay;
        int txPacketLossRate;
        int rxPacketLossRate;
        double cpuTotalUsage;
        int gatewayRtt;
        double cpuAppUsage;
        double memoryAppUsageRatio;
        double memoryTotalUsageRatio;
        int memoryAppUsageInKbytes;
        int users;
        int connectTimeMs;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.totalDuration = this.popInt();
            this.totalTxBytes = this.popInt();
            this.totalRxBytes = this.popInt();
            this.txAudioBytes = this.popInt();
            this.rxAudioBytes = this.popInt();
            this.txVideoBytes = this.popInt();
            this.rxVideoBytes = this.popInt();
            this.txKBitRate = this.popShort();
            this.rxKBitRate = this.popShort();
            this.txAudioKBitRate = this.popShort();
            this.rxAudioKBitRate = this.popShort();
            this.txVideoKBitRate = this.popShort();
            this.rxVideoKBitRate = this.popShort();
            this.lastmileDelay = this.popShort();
            this.txPacketLossRate = this.popInt();
            this.rxPacketLossRate = this.popInt();
            this.cpuTotalUsage = this.popDouble();
            this.gatewayRtt = this.popInt();
            this.cpuAppUsage = this.popDouble();
            this.memoryAppUsageRatio = this.popDouble();
            this.memoryTotalUsageRatio = this.popDouble();
            this.memoryAppUsageInKbytes = this.popInt();
            this.users = this.popInt();
            this.connectTimeMs = this.popInt();
        }

        public IRtcEngineEventHandler.RtcStats getRtcStats() {
            IRtcEngineEventHandler.RtcStats rtcStats = new IRtcEngineEventHandler.RtcStats();
            rtcStats.totalDuration = this.totalDuration;
            rtcStats.txBytes = this.totalTxBytes;
            rtcStats.rxBytes = this.totalRxBytes;
            rtcStats.txAudioBytes = this.txAudioBytes;
            rtcStats.rxAudioBytes = this.rxAudioBytes;
            rtcStats.txVideoBytes = this.txVideoBytes;
            rtcStats.rxVideoBytes = this.rxVideoBytes;
            rtcStats.txKBitRate = this.txKBitRate;
            rtcStats.rxKBitRate = this.rxKBitRate;
            rtcStats.txAudioKBitRate = this.txAudioKBitRate;
            rtcStats.rxAudioKBitRate = this.rxAudioKBitRate;
            rtcStats.txVideoKBitRate = this.txVideoKBitRate;
            rtcStats.rxVideoKBitRate = this.rxVideoKBitRate;
            rtcStats.lastmileDelay = this.lastmileDelay;
            rtcStats.users = this.users;
            rtcStats.cpuTotalUsage = this.cpuTotalUsage;
            rtcStats.gatewayRtt = this.gatewayRtt;
            rtcStats.cpuAppUsage = this.cpuAppUsage;
            rtcStats.connectTimeMs = this.connectTimeMs;
            rtcStats.txPacketLossRate = this.txPacketLossRate;
            rtcStats.rxPacketLossRate = this.rxPacketLossRate;
            rtcStats.memoryAppUsageRatio = this.memoryAppUsageRatio;
            rtcStats.memoryTotalUsageRatio = this.memoryTotalUsageRatio;
            rtcStats.memoryAppUsageInKbytes = this.memoryAppUsageInKbytes;
            return rtcStats;
        }
    }

    public static class PMediaResTransportQuality
    extends Marshallable {
        public boolean isAudio;
        public int uid;
        public int bitrate;
        public short delay;
        public short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.isAudio = this.popBool();
            this.uid = this.popInt();
            this.bitrate = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }

    public static class PMediaResAudioQuality
    extends Marshallable {
        int uid;
        int quality;
        short delay;
        short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.quality = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }
}

