/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.RouteInfo;
import android.net.TransportInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.agora.utils2.internal.Connectivity;
import io.agora.utils2.internal.Logging;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectivityUtility {
    private static final String TAG = ConnectivityUtility.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final String PREFERENCE_CHANGE_NETWORK_PERMISSION_KEY = "rtc_change_network_state_permission";
    public static final String PREFERENCE_ACCESS_NETWORK_PERMISSION_KEY = "rtc_access_network_state_permission";
    private ConnectivityManager connectivityManager;
    private TelephonyManager telephonyManager;
    private WifiManager wifiManager;
    private SharedPreferences rtcSharedPreferences;
    private BroadcastReceiver connectionRecevier;
    private CustomNetworkCallback callback = null;
    private VpnNetworkCallback vpnCallback = null;
    private ConnectivityManager.NetworkCallback cellularNetworkCallback = null;
    private static Method getTransportTypesMethod = null;
    private Boolean vpnEnabled = null;
    private Boolean hasChangeNetworkStatePermission = null;
    private Boolean hasAccessNetworkStatePermission = null;
    private HashMap<String, AgoraNetworkInfo> activeNetworkInfoHashMap = new HashMap();
    private HashMap<Integer, AgoraNetworkInfo> networkInfoByCategoryHashMap = new HashMap();
    private AgoraNetworkInfo defaultNetworkInfo;
    private CopyOnWriteArrayList<NetworkListener> networkListeners = new CopyOnWriteArrayList();

    private static void logD(String message) {
    }

    public void addNetworkListener(NetworkListener listener) {
        if (listener != null) {
            this.networkListeners.addIfAbsent(listener);
        }
    }

    public void removeNetworkListener(NetworkListener listener) {
        if (listener != null) {
            this.networkListeners.remove(listener);
        }
    }

    public ConnectivityUtility(Context context) {
        this.initialize(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AgoraNetworkInfo> getCurrentActiveInfo() {
        ArrayList<AgoraNetworkInfo> infos = new ArrayList<AgoraNetworkInfo>();
        HashMap<String, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
        synchronized (hashMap) {
            Collection<AgoraNetworkInfo> list = this.activeNetworkInfoHashMap.values();
            infos.addAll(list);
        }
        ConnectivityUtility.logD("getCurrentActiveInfo: " + ((Object)infos).toString());
        return infos;
    }

    public boolean isVpnEnabled() {
        NetworkInfo networkInfo;
        Network activeNetwork;
        NetworkCapabilities capabilities;
        if (this.vpnEnabled != null) {
            return this.vpnEnabled;
        }
        this.vpnEnabled = Build.VERSION.SDK_INT >= 23 ? Boolean.valueOf((capabilities = this.connectivityManager.getNetworkCapabilities(activeNetwork = this.connectivityManager.getActiveNetwork())) == null ? false : capabilities.hasTransport(4)) : Boolean.valueOf((networkInfo = this.connectivityManager.getNetworkInfo(17)) != null && networkInfo.isConnected());
        return this.vpnEnabled;
    }

    @RequiresApi(api=21)
    private static int getTransportType(NetworkCapabilities capabilities) {
        int[] transportPriority;
        if (capabilities == null) {
            Logging.e(TAG, "NetworkCapabilities is null, returning TRANSPORT_WIFI by default");
            return 1;
        }
        for (int transport : transportPriority = new int[]{3, 1, 0}) {
            if (!capabilities.hasTransport(transport)) continue;
            return transport;
        }
        Logging.e(TAG, "No transport type found, returning TRANSPORT_WIFI by default");
        return 1;
    }

    @RequiresApi(api=21)
    private String getNetworkDescription(Network network) {
        NetworkCapabilities capabilities = this.connectivityManager.getNetworkCapabilities(network);
        if (capabilities != null) {
            return "id:" + network.toString() + " capabilities:" + capabilities.toString();
        }
        return "id:" + network.toString();
    }

    public boolean checkChangeNetworkStatePermission(Context context) {
        return this.checkPermission(context, this.hasChangeNetworkStatePermission, PREFERENCE_CHANGE_NETWORK_PERMISSION_KEY, "android.permission.CHANGE_NETWORK_STATE");
    }

    public boolean checkAccessNetworkStatePermission(Context context) {
        return this.checkPermission(context, this.hasAccessNetworkStatePermission, PREFERENCE_ACCESS_NETWORK_PERMISSION_KEY, "android.permission.ACCESS_NETWORK_STATE");
    }

    private boolean checkPermission(Context context, Boolean permission2, String permissionKey, String premission) {
        if (permission2 == null) {
            if (this.rtcSharedPreferences.contains(permissionKey)) {
                permission2 = this.rtcSharedPreferences.getBoolean(permissionKey, false);
            } else {
                int result = context.checkPermission(premission, Process.myPid(), Process.myUid());
                permission2 = result == 0;
                SharedPreferences.Editor editor = this.rtcSharedPreferences.edit();
                editor.putBoolean(permissionKey, permission2.booleanValue());
                editor.apply();
            }
        }
        return permission2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkInfo(Network network) {
        if (network == null) {
            return;
        }
        AgoraNetworkInfo info = AgoraNetworkInfo.buildFromNetwork(this.connectivityManager, this.telephonyManager, network);
        if (info == null) {
            return;
        }
        info.networkType = AgoraNetworkInfo.determineNetworkType(this.telephonyManager, info.transportType);
        this.updateNetworkMaps(network, info);
        if (info.transportType == 1) {
            this.updateWifiCapabilities(network, info);
        }
        HashMap<String, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
        synchronized (hashMap) {
            this.defaultNetworkInfo = info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkMaps(Network network, AgoraNetworkInfo info) {
        HashMap<Object, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
        synchronized (hashMap) {
            ConnectivityUtility.logD("startMonitor: put active network to map " + network.toString());
            this.activeNetworkInfoHashMap.put(network.toString(), info);
        }
        hashMap = this.networkInfoByCategoryHashMap;
        synchronized (hashMap) {
            this.networkInfoByCategoryHashMap.put(info.transportType, info);
        }
    }

    private void updateWifiCapabilities(Network network, AgoraNetworkInfo info) {
        TransportInfo wifiInfo;
        NetworkCapabilities networkCapabilities = this.connectivityManager.getNetworkCapabilities(network);
        if (networkCapabilities == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29 && (wifiInfo = networkCapabilities.getTransportInfo()) instanceof WifiInfo) {
            info.updateWifiInfo((WifiInfo)wifiInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Context context) {
        if (context == null) {
            return;
        }
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.rtcSharedPreferences = context.getSharedPreferences("shengwang_rtc_sdk", 0);
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
        if (!this.checkAccessNetworkStatePermission(context)) {
            Logging.e(TAG, "startMonitor has no ACCESS_NETWORK_STATE permission");
            return;
        }
        if (this.telephonyManager == null || this.connectivityManager == null || this.wifiManager == null) {
            Logging.e(TAG, "startMonitor get system service failed");
            return;
        }
        this.rtcSharedPreferences = context.getSharedPreferences("shengwang_rtc_sdk", 0);
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = this.connectivityManager.getActiveNetwork();
            this.updateNetworkInfo(network);
        } else {
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            ConnectivityUtility.logD("startMonitor: active networkInfo is " + networkInfo);
            if (networkInfo == null) {
                return;
            }
            AgoraNetworkInfo info = AgoraNetworkInfo.buildFromNetworkInfo(networkInfo);
            HashMap<Object, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
            synchronized (hashMap) {
                ConnectivityUtility.logD("startMonitor:  put active network to map " + networkInfo.toString());
                this.activeNetworkInfoHashMap.put(info.networkInfo.getTypeName(), info);
                this.defaultNetworkInfo = info;
            }
            hashMap = this.networkInfoByCategoryHashMap;
            synchronized (hashMap) {
                this.networkInfoByCategoryHashMap.put(info.transportType, info);
            }
        }
    }

    public void startMonitor(Context context) {
        ConnectivityUtility.logD("startMonitor: ");
        if (this.connectivityManager == null || this.wifiManager == null || this.telephonyManager == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            if (this.connectionRecevier == null) {
                this.connectionRecevier = new BroadcastReceiver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onReceive(Context context, Intent intent) {
                        boolean FAILOVER_CONNECTION = intent.getBooleanExtra("FAILOVER_CONNECTION", false);
                        boolean EXTRA_NO_CONNECTIVITY = intent.getBooleanExtra("EXTRA_NO_CONNECTIVITY", false);
                        ConnectivityUtility.logD("onReceive: CONNECTIVITY_ACTION + " + FAILOVER_CONNECTION + " EXTRA_NO_CONNECTIVITY " + EXTRA_NO_CONNECTIVITY);
                        Bundle bundle = intent.getExtras();
                        if (bundle != null) {
                            NetworkInfo info = (NetworkInfo)bundle.getParcelable("networkInfo");
                            ConnectivityUtility.logD("onReceive:  networkInfo " + info.toString());
                            AgoraNetworkInfo networkInfo = AgoraNetworkInfo.buildFromNetworkInfo(info);
                            HashMap hashMap = ConnectivityUtility.this.activeNetworkInfoHashMap;
                            synchronized (hashMap) {
                                ConnectivityUtility.this.activeNetworkInfoHashMap.put(networkInfo.networkInfo.getTypeName(), networkInfo);
                            }
                            Logging.i(TAG, "Network onReceive " + networkInfo.toString());
                        }
                    }
                };
            }
            try {
                context.registerReceiver(this.connectionRecevier, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            }
            catch (Exception e) {
                Logging.e(TAG, "startMonitor: register connection receiver failed");
            }
        } else {
            NetworkRequest.Builder builder;
            if (this.callback == null) {
                this.callback = new CustomNetworkCallback();
                builder = new NetworkRequest.Builder();
                builder.addCapability(12);
                try {
                    this.connectivityManager.registerNetworkCallback(builder.build(), (ConnectivityManager.NetworkCallback)this.callback);
                }
                catch (Exception e) {
                    Logging.e(TAG, "startMonitor: register network callback failed");
                }
            }
            if (this.vpnCallback == null) {
                builder = new NetworkRequest.Builder();
                builder.addTransportType(4);
                builder.removeCapability(15);
                this.vpnCallback = new VpnNetworkCallback();
                try {
                    this.connectivityManager.registerNetworkCallback(builder.build(), (ConnectivityManager.NetworkCallback)this.vpnCallback);
                }
                catch (Exception e) {
                    Logging.e(TAG, "startMonitor: register vpn network callback failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkType() {
        int type = 0;
        HashMap<String, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
        synchronized (hashMap) {
            if (this.defaultNetworkInfo != null) {
                type = this.defaultNetworkInfo.networkType;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor(Context context) {
        if (Build.VERSION.SDK_INT <= 21) {
            if (this.connectionRecevier != null) {
                try {
                    context.unregisterReceiver(this.connectionRecevier);
                }
                catch (IllegalArgumentException e) {
                    Logging.e(TAG, "Failed to unregister receiver", e);
                }
                this.connectionRecevier = null;
            }
        } else if (this.connectivityManager != null) {
            try {
                if (this.callback != null) {
                    ConnectivityUtility.logD("stopMonitor: unregisterNetworkCallback callback");
                    this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.callback);
                    this.callback = null;
                }
                if (this.cellularNetworkCallback != null) {
                    ConnectivityUtility.logD("stopMonitor: unregisterNetworkCallback cellularNetworkCallback");
                    this.connectivityManager.unregisterNetworkCallback(this.cellularNetworkCallback);
                    this.cellularNetworkCallback = null;
                }
                if (this.vpnCallback != null) {
                    ConnectivityUtility.logD("stopMonitor: unregisterNetworkCallback vpnCallback");
                    this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.vpnCallback);
                    this.vpnCallback = null;
                }
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Failed to unregister network callbacks", e);
            }
        }
        HashMap<Object, AgoraNetworkInfo> hashMap = this.activeNetworkInfoHashMap;
        synchronized (hashMap) {
            this.activeNetworkInfoHashMap.clear();
        }
        hashMap = this.networkInfoByCategoryHashMap;
        synchronized (hashMap) {
            this.networkInfoByCategoryHashMap.clear();
        }
    }

    @RequiresApi(api=21)
    public void requestCellularNetwork() {
        NetworkRequest.Builder requestbuilder = new NetworkRequest.Builder();
        requestbuilder.addTransportType(0);
        requestbuilder.addCapability(12);
        if (this.cellularNetworkCallback == null) {
            this.cellularNetworkCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(@NonNull Network network) {
                    super.onAvailable(network);
                }
            };
        }
        this.connectivityManager.requestNetwork(requestbuilder.build(), this.cellularNetworkCallback);
    }

    public static interface CellularNetworkChangeListener {
        public void onCellularNetworkChanged(int var1);
    }

    @RequiresApi(api=21)
    public class VpnNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            NetworkCapabilities capabilities = ConnectivityUtility.this.connectivityManager.getNetworkCapabilities(network);
            ConnectivityUtility.this.vpnEnabled = capabilities == null ? false : capabilities.hasTransport(4);
        }

        public void onLost(@NonNull Network network) {
            super.onLost(network);
            ConnectivityUtility.this.vpnEnabled = false;
        }
    }

    @RequiresApi(api=21)
    public class CustomNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            ConnectivityUtility.logD("onAvailable: " + ConnectivityUtility.this.getNetworkDescription(network));
            AgoraNetworkInfo info = AgoraNetworkInfo.buildFromNetwork(ConnectivityUtility.this.connectivityManager, ConnectivityUtility.this.telephonyManager, network);
            Cloneable cloneable = ConnectivityUtility.this.activeNetworkInfoHashMap;
            synchronized (cloneable) {
                if (!ConnectivityUtility.this.activeNetworkInfoHashMap.containsKey(network.toString())) {
                    ConnectivityUtility.this.activeNetworkInfoHashMap.put(network.toString(), info);
                }
                if (ConnectivityUtility.this.defaultNetworkInfo == null || info.transportType > ((ConnectivityUtility)ConnectivityUtility.this).defaultNetworkInfo.transportType) {
                    ConnectivityUtility.this.defaultNetworkInfo = info;
                }
            }
            Logging.i(TAG, "Network onAvailable: " + info.toString());
            cloneable = ConnectivityUtility.this.networkListeners;
            synchronized (cloneable) {
                for (NetworkListener listener : ConnectivityUtility.this.networkListeners) {
                    Logging.i(TAG, "Network onDefaultNetworkChanged: " + info.toString());
                    listener.onDefaultNetworkChanged();
                }
            }
            cloneable = ConnectivityUtility.this.networkInfoByCategoryHashMap;
            synchronized (cloneable) {
                ConnectivityUtility.this.networkInfoByCategoryHashMap.put(info.transportType, info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLost(@NonNull Network network) {
            super.onLost(network);
            Logging.i(TAG, "Network onLost: " + ConnectivityUtility.this.getNetworkDescription(network));
            AgoraNetworkInfo info = null;
            AgoraNetworkInfo nextDefaultNetwork = null;
            boolean networkChanged = false;
            Cloneable cloneable = ConnectivityUtility.this.activeNetworkInfoHashMap;
            synchronized (cloneable) {
                if (ConnectivityUtility.this.activeNetworkInfoHashMap.containsKey(network.toString())) {
                    info = (AgoraNetworkInfo)ConnectivityUtility.this.activeNetworkInfoHashMap.get(network.toString());
                    ConnectivityUtility.this.activeNetworkInfoHashMap.remove(network.toString());
                    Logging.i(TAG, "Network onLost: " + info.toString());
                }
                if (ConnectivityUtility.this.activeNetworkInfoHashMap.size() > 0) {
                    Collection list = ConnectivityUtility.this.activeNetworkInfoHashMap.values();
                    nextDefaultNetwork = (AgoraNetworkInfo)list.iterator().next();
                }
                if (ConnectivityUtility.this.defaultNetworkInfo != null && (nextDefaultNetwork == null || ((ConnectivityUtility)ConnectivityUtility.this).defaultNetworkInfo.transportType != nextDefaultNetwork.transportType) || ConnectivityUtility.this.defaultNetworkInfo == null && nextDefaultNetwork != null) {
                    ConnectivityUtility.this.defaultNetworkInfo = nextDefaultNetwork;
                    networkChanged = true;
                    Logging.i(TAG, "Network onDefaultNetworkChanged: " + (ConnectivityUtility.this.defaultNetworkInfo != null ? ConnectivityUtility.this.defaultNetworkInfo.toString() : "null"));
                }
            }
            if (networkChanged) {
                cloneable = ConnectivityUtility.this.networkListeners;
                synchronized (cloneable) {
                    for (NetworkListener listener : ConnectivityUtility.this.networkListeners) {
                        listener.onDefaultNetworkChanged();
                    }
                }
            }
            if (info != null && info.transportType != 0) {
                cloneable = ConnectivityUtility.this.networkInfoByCategoryHashMap;
                synchronized (cloneable) {
                    if (ConnectivityUtility.this.networkInfoByCategoryHashMap.containsKey(info.transportType)) {
                        ConnectivityUtility.this.networkInfoByCategoryHashMap.remove(info.transportType);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLinkPropertiesChanged(@NonNull Network network, @NonNull LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
            ConnectivityUtility.logD("onLinkPropertiesChanged: " + network.toString() + " properties " + linkProperties.toString());
            HashMap hashMap = ConnectivityUtility.this.activeNetworkInfoHashMap;
            synchronized (hashMap) {
                if (ConnectivityUtility.this.activeNetworkInfoHashMap.containsKey(network.toString())) {
                    ((AgoraNetworkInfo)ConnectivityUtility.this.activeNetworkInfoHashMap.get(network.toString())).updateLinkProperties(linkProperties);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
            ConnectivityUtility.logD("onCapabilitiesChanged: " + networkCapabilities.toString());
            WifiInfo info = null;
            HashMap hashMap = ConnectivityUtility.this.activeNetworkInfoHashMap;
            synchronized (hashMap) {
                if (ConnectivityUtility.this.activeNetworkInfoHashMap.containsKey(network.toString())) {
                    ((AgoraNetworkInfo)ConnectivityUtility.this.activeNetworkInfoHashMap.get(network.toString())).updateNetworkCapabilities(networkCapabilities, info);
                }
            }
        }
    }

    public static class AgoraNetworkInfo {
        public Network network;
        public NetworkInfo networkInfo;
        public int transportType;
        public String localAddressIpV4;
        public String localAddressIpV6;
        public int rssi = 0;
        public int signalLevel = 0;
        public int linkSpeed = 0;
        public int frequency = 0;
        public int networkSubtype = 0;
        public int networkType = 0;
        public String interfaceName;
        public String gatewayIp;

        public AgoraNetworkInfo(Network network, int transportType, String localAddressIpV4, String localAddressIpV6) {
            this.network = network;
            this.transportType = transportType;
            this.localAddressIpV4 = localAddressIpV4;
            this.localAddressIpV6 = localAddressIpV6;
        }

        public AgoraNetworkInfo() {
        }

        @RequiresApi(api=21)
        public void updateLinkProperties(@NonNull LinkProperties properties) {
            List routes;
            if (properties == null) {
                return;
            }
            List addresses = properties.getLinkAddresses();
            if (addresses != null) {
                for (LinkAddress address : addresses) {
                    InetAddress inetAddress = address.getAddress();
                    if (inetAddress == null) continue;
                    if (this.localAddressIpV4 == null && inetAddress instanceof Inet4Address) {
                        this.localAddressIpV4 = inetAddress.getHostAddress();
                        continue;
                    }
                    if (this.localAddressIpV6 != null || !(inetAddress instanceof Inet6Address)) continue;
                    this.localAddressIpV6 = inetAddress.getHostAddress();
                }
            }
            if ((routes = properties.getRoutes()) != null && !routes.isEmpty() && ((RouteInfo)routes.get(0)).getGateway() != null) {
                this.gatewayIp = ((RouteInfo)routes.get(0)).getGateway().getHostAddress();
            }
            this.interfaceName = properties.getInterfaceName();
        }

        public static int determineNetworkType(TelephonyManager telephonyManager, int transportType) {
            switch (transportType) {
                case 1: {
                    return 2;
                }
                case 0: {
                    try {
                        int networkType = telephonyManager.getNetworkType();
                        if (networkType == 0) {
                            Logging.e(TAG, "seems app has no permission to get network type, use LTE as default");
                            networkType = 13;
                        }
                        return Connectivity.getNetworkTypeFromTelephonyNetworkType(networkType);
                    }
                    catch (Exception e) {
                        Logging.e(TAG, "Failed to get cellular network type return 4G by default", e);
                        return 5;
                    }
                }
                case 3: {
                    return 1;
                }
            }
            return -1;
        }

        public void updateNetworkCapabilities(@NonNull NetworkCapabilities capabilities, WifiInfo wifiInfo) {
            if (this.transportType == 1) {
                if (Build.VERSION.SDK_INT >= 29) {
                    TransportInfo info = capabilities.getTransportInfo();
                    if (info instanceof WifiInfo) {
                        this.updateWifiInfo((WifiInfo)info);
                    }
                } else if (wifiInfo != null) {
                    this.updateWifiInfo(wifiInfo);
                }
            }
        }

        public void updateWifiInfo(@NonNull WifiInfo info) {
            ConnectivityUtility.logD("updateWifiInfo");
            if (info != null) {
                this.rssi = info.getRssi();
                this.linkSpeed = info.getLinkSpeed();
                if (Build.VERSION.SDK_INT >= 21) {
                    this.frequency = info.getFrequency();
                }
                if (this.frequency >= 5000) {
                    this.networkSubtype = 101;
                } else if (this.frequency >= 2400) {
                    this.networkSubtype = 100;
                }
                this.signalLevel = WifiManager.calculateSignalLevel((int)this.rssi, (int)5);
                ConnectivityUtility.logD(String.format("updateWifiInfo: rssi=%d linkSpeed=%d frequency=%d networkSubtype=%d signalLevel=%d", this.rssi, this.linkSpeed, this.frequency, this.networkSubtype, this.signalLevel));
            }
        }

        @RequiresApi(api=21)
        public static AgoraNetworkInfo buildFromNetwork(@NonNull ConnectivityManager manager, @NonNull TelephonyManager telephonyManager, @NonNull Network network) {
            AgoraNetworkInfo info = new AgoraNetworkInfo();
            info.network = network;
            NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
            info.transportType = ConnectivityUtility.getTransportType(capabilities);
            info.networkType = AgoraNetworkInfo.determineNetworkType(telephonyManager, info.transportType);
            LinkProperties properties = manager.getLinkProperties(network);
            if (properties != null) {
                info.updateLinkProperties(properties);
            }
            return info;
        }

        public static AgoraNetworkInfo buildFromNetworkInfo(@NonNull NetworkInfo networkInfo) {
            AgoraNetworkInfo info = new AgoraNetworkInfo();
            info.networkInfo = networkInfo;
            info.networkSubtype = networkInfo.getSubtype();
            switch (networkInfo.getType()) {
                case 0: {
                    info.transportType = 0;
                    info.networkType = Connectivity.getNetworkTypeFromTelephonyNetworkType(info.networkSubtype);
                    break;
                }
                case 1: {
                    info.transportType = 1;
                    info.networkType = 2;
                    break;
                }
                case 9: {
                    info.transportType = 3;
                    info.networkType = 1;
                    break;
                }
                default: {
                    info.networkType = -1;
                }
            }
            try {
                ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface networkInterface : interfaces) {
                    ArrayList<InetAddress> addresses = Collections.list(networkInterface.getInetAddresses());
                    for (InetAddress inetAddress : addresses) {
                        if (info.localAddressIpV4 == null && inetAddress instanceof Inet4Address) {
                            info.localAddressIpV4 = inetAddress.getHostAddress();
                            continue;
                        }
                        if (info.localAddressIpV6 != null || !(inetAddress instanceof Inet6Address)) continue;
                        info.localAddressIpV6 = inetAddress.getHostAddress();
                    }
                    if (info.localAddressIpV4 == null || info.localAddressIpV6 == null) continue;
                    break;
                }
            }
            catch (SocketException e) {
                Logging.e(TAG, "get inetaddress failed");
            }
            return info;
        }

        public String toString() {
            return "AgoraNetworkInfo{network=" + this.network + ", networkInfo=" + this.networkInfo + ", transportType=" + this.transportType + ", localAddressIpV4='" + this.localAddressIpV4 + '\'' + ", localAddressIpV6='" + this.localAddressIpV6 + '\'' + ", rssi=" + this.rssi + ", signalLevel=" + this.signalLevel + ", linkSpeed=" + this.linkSpeed + ", frequency=" + this.frequency + ", networkSubtype=" + this.networkSubtype + ", networkType=" + this.networkType + ", interfaceName='" + this.interfaceName + '\'' + ", gatewayIp='" + this.gatewayIp + '\'' + '}';
        }
    }

    public static interface NetworkListener {
        public void onDefaultNetworkChanged();
    }
}

