/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.rte.Canvas;
import io.agora.rte.PlayerConfig;
import io.agora.rte.PlayerCustomSourceProvider;
import io.agora.rte.PlayerInfo;
import io.agora.rte.PlayerInitialConfig;
import io.agora.rte.PlayerObserver;
import io.agora.rte.Rte;
import io.agora.rte.Stream;
import io.agora.rte.callback.AsyncCallback;
import io.agora.rte.callback.PlayerGetStatsCallback;
import io.agora.rte.exception.RteException;

public class Player {
    private long mNativeHandle = 0L;

    public Player(Rte rte, PlayerInitialConfig initialConfig) {
        this.mNativeHandle = this.nativeCreatePlayer(rte != null ? rte.getNativeHandle() : 0L, initialConfig != null ? initialConfig.getNativeHandle() : 0L);
    }

    protected void finalize() {
        this.destroy();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public static void preloadWithUrl(String url) throws RteException {
        Player.nativePreloadWithUrl(url);
    }

    public void openWithUrl(String url, long startTime, AsyncCallback callback) {
        this.nativeOpenWithUrl(this.mNativeHandle, url != null ? url : "", startTime, callback);
    }

    public void openWithCustomSourceProvider(PlayerCustomSourceProvider provider, long startTime, AsyncCallback callback) {
        this.nativeOpenWithCustomSourceProvider(this.mNativeHandle, provider != null ? provider.getNativeHandle() : 0L, startTime, callback);
    }

    public void openWithStream(Stream stream, AsyncCallback callback) {
        this.nativeOpenWithStream(this.mNativeHandle, stream != null ? stream.getNativeHandle() : 0L, callback);
    }

    public void switchWithUrl(String url, boolean syncPts, AsyncCallback callback) {
        this.nativeSwitchWithUrl(this.mNativeHandle, url != null ? url : "", syncPts, callback);
    }

    public void getStats(PlayerGetStatsCallback callback) {
        this.nativeGetStats(this.mNativeHandle, callback);
    }

    public void setCanvas(Canvas canvas) throws RteException {
        this.nativeSetCanvas(this.mNativeHandle, canvas != null ? canvas.getNativeHandle() : 0L);
    }

    public void play() throws RteException {
        this.nativePlay(this.mNativeHandle);
    }

    public void stop() throws RteException {
        this.nativeStop(this.mNativeHandle);
    }

    public void pause() throws RteException {
        this.nativePause(this.mNativeHandle);
    }

    public void seek(long newTime) throws RteException {
        this.nativeSeek(this.mNativeHandle, newTime);
    }

    public void muteAudio(boolean mute) throws RteException {
        this.nativeMuteAudio(this.mNativeHandle, mute);
    }

    public void muteVideo(boolean mute) throws RteException {
        this.nativeMuteVideo(this.mNativeHandle, mute);
    }

    public long getPosition() throws RteException {
        return this.nativeGetPosition(this.mNativeHandle);
    }

    public void getInfo(PlayerInfo info) throws RteException {
        this.nativeGetInfo(this.mNativeHandle, info != null ? info.getNativeHandle() : 0L);
    }

    public void getConfigs(PlayerConfig config) throws RteException {
        this.nativeGetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    public void setConfigs(PlayerConfig config) throws RteException {
        this.nativeSetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    public void registerObserver(PlayerObserver observer) throws RteException {
        this.nativeRegisterObserver(this.mNativeHandle, observer != null ? observer.getNativeHandle() : 0L);
    }

    public void unregisterObserver(PlayerObserver observer) throws RteException {
        this.nativeUnregisterObserver(this.mNativeHandle, observer != null ? observer.getNativeHandle() : 0L);
    }

    private void destroy() {
        this.nativeReleasePlayer(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    private native long nativeCreatePlayer(long var1, long var3);

    private native void nativeReleasePlayer(long var1);

    private static native void nativePreloadWithUrl(String var0);

    private native void nativeOpenWithUrl(long var1, String var3, long var4, AsyncCallback var6);

    private native void nativeOpenWithCustomSourceProvider(long var1, long var3, long var5, AsyncCallback var7);

    private native void nativeOpenWithStream(long var1, long var3, AsyncCallback var5);

    private native void nativeSwitchWithUrl(long var1, String var3, boolean var4, AsyncCallback var5);

    private native void nativeGetStats(long var1, PlayerGetStatsCallback var3);

    private native void nativeSetCanvas(long var1, long var3);

    private native void nativePlay(long var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeMuteAudio(long var1, boolean var3);

    private native void nativeMuteVideo(long var1, boolean var3);

    private native long nativeGetPosition(long var1);

    private native void nativeGetInfo(long var1, long var3);

    private native void nativeGetConfigs(long var1, long var3);

    private native void nativeSetConfigs(long var1, long var3);

    private native void nativeRegisterObserver(long var1, long var3);

    private native void nativeUnregisterObserver(long var1, long var3);
}

