/*
 * Decompiled with CFR 0.152.
 */
package io.agora.iris.pip;

import android.app.PictureInPictureParams;
import android.app.PictureInPictureUiState;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Rational;
import io.agora.iris.pip.AgoraPIPActivityListener;
import io.agora.iris.pip.AgoraPIPActivityProxy;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class AgoraPIPController
implements AgoraPIPActivityListener {
    private boolean mIsSupported = false;
    private boolean mIsAutoEnterSupported = false;
    private PIPParams mPIPParams;
    private PictureInPictureParams.Builder mParamsBuilder;
    private final WeakReference<AgoraPIPActivityProxy> mActivityProxy;
    private final PIPStateChangedListener mListener;
    private static final long CHECK_INTERVAL_MS = 100L;
    private Handler mHandler;
    private Runnable mCheckStateTask;
    private boolean mLastPIPState = false;

    public AgoraPIPController(AgoraPIPActivityProxy activityProxy, PIPStateChangedListener listener) {
        this.mListener = listener;
        this.mHandler = new Handler(Looper.getMainLooper());
        if (activityProxy != null) {
            this.mActivityProxy = new WeakReference<AgoraPIPActivityProxy>(activityProxy);
            activityProxy.setAgoraPIPActivityListener(this);
            this.mIsSupported = this.checkPIPSupport();
            this.mIsAutoEnterSupported = this.checkAutoEnterSupport();
        } else {
            this.mIsSupported = false;
            this.mIsAutoEnterSupported = false;
            this.mActivityProxy = new WeakReference<Object>(null);
        }
    }

    private void checkPIPState() {
        boolean currentState = this.isActivated();
        if (currentState != this.mLastPIPState) {
            this.mLastPIPState = currentState;
            this.notifyPIPStateChanged(currentState ? PIPState.Started : PIPState.Stopped, null);
        }
    }

    private boolean isPIPEnabled() {
        return this.mPIPParams != null && this.mParamsBuilder != null;
    }

    private void notifyPIPStateChanged(PIPState state, String error) {
        if (this.mListener != null) {
            this.mListener.onPIPStateChangedListener(state, error);
        }
    }

    private boolean checkPIPSupport() {
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        PackageManager pm = activityProxy.getApplicationContext().getPackageManager();
        if (pm == null) {
            return false;
        }
        return pm.hasSystemFeature("android.software.picture_in_picture");
    }

    private boolean checkAutoEnterSupport() {
        if (Build.VERSION.SDK_INT >= 31) {
            return true;
        }
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        return activityProxy != null;
    }

    public boolean isSupported() {
        return this.mIsSupported;
    }

    public boolean isAutoEnterSupported() {
        return this.mIsAutoEnterSupported;
    }

    public boolean isActivated() {
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return this.isSupported() && activityProxy.isInPictureInPictureMode();
        }
        return false;
    }

    public boolean setup(Rational aspectRatio, Boolean autoEnterEnabled, Rect sourceRectHint, Boolean seamlessResizeEnabled, Boolean useExternalStateMonitor, Integer externalStateMonitorInterval) {
        if (!this.isSupported()) {
            this.notifyPIPStateChanged(PIPState.Failed, "PIP is not supported");
            return false;
        }
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.mParamsBuilder == null) {
                this.mParamsBuilder = new PictureInPictureParams.Builder();
            }
            if (!(this.mPIPParams != null && Objects.equals(this.mPIPParams.aspectRatio, aspectRatio) && Objects.equals(this.mPIPParams.autoEnterEnabled, autoEnterEnabled) && Objects.equals(this.mPIPParams.sourceRectHint, sourceRectHint) && Objects.equals(this.mPIPParams.seamlessResizeEnabled, seamlessResizeEnabled) && Objects.equals(this.mPIPParams.useExternalStateMonitor, useExternalStateMonitor) && Objects.equals(this.mPIPParams.externalStateMonitorInterval, externalStateMonitorInterval))) {
                this.mPIPParams = new PIPParams(aspectRatio, autoEnterEnabled, sourceRectHint, seamlessResizeEnabled, useExternalStateMonitor, externalStateMonitorInterval);
            }
            if (this.mPIPParams.aspectRatio != null) {
                this.mParamsBuilder.setAspectRatio(this.mPIPParams.aspectRatio);
            }
            if (Build.VERSION.SDK_INT >= 31) {
                this.mParamsBuilder.setAutoEnterEnabled(Boolean.TRUE.equals(this.mPIPParams.autoEnterEnabled));
            }
            if (this.mPIPParams.sourceRectHint != null) {
                this.mParamsBuilder.setSourceRectHint(this.mPIPParams.sourceRectHint);
            }
            if (Build.VERSION.SDK_INT >= 31 && this.mPIPParams.seamlessResizeEnabled != null) {
                this.mParamsBuilder.setSeamlessResizeEnabled(Boolean.TRUE.equals(this.mPIPParams.seamlessResizeEnabled));
            }
            activityProxy.setPictureInPictureParams(this.mParamsBuilder.build());
        }
        this.startStateMonitoring();
        return true;
    }

    public boolean start() {
        if (!this.isSupported()) {
            this.notifyPIPStateChanged(PIPState.Failed, "PIP is not supported");
            return false;
        }
        if (this.isActivated()) {
            return true;
        }
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy == null) {
            return false;
        }
        if (!this.isPIPEnabled()) {
            this.notifyPIPStateChanged(PIPState.Failed, "PIP is not setup");
            return false;
        }
        boolean bRes = true;
        if (Build.VERSION.SDK_INT >= 26) {
            bRes = activityProxy.enterPictureInPictureMode(this.mParamsBuilder.build());
        } else if (Build.VERSION.SDK_INT >= 24) {
            activityProxy.enterPictureInPictureMode();
        }
        if (!bRes) {
            this.notifyPIPStateChanged(PIPState.Failed, "Failed to enter PiP mode");
        }
        return bRes;
    }

    public void stop() {
        if (!this.isSupported() || !this.isActivated()) {
            this.notifyPIPStateChanged(PIPState.Failed, "PIP is not supported or not activated");
            return;
        }
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy == null) {
            return;
        }
        activityProxy.moveTaskToBack(false);
    }

    public void dispose() {
        this.stopStateMonitoring();
        AgoraPIPActivityProxy activityProxy = (AgoraPIPActivityProxy)this.mActivityProxy.get();
        if (activityProxy != null && Build.VERSION.SDK_INT >= 31) {
            activityProxy.setPictureInPictureParams(new PictureInPictureParams.Builder().setAutoEnterEnabled(false).build());
        }
        this.mPIPParams = null;
        this.mParamsBuilder = null;
        this.mHandler = null;
        this.mLastPIPState = false;
        this.mCheckStateTask = null;
    }

    private void startStateMonitoring() {
        if (this.mActivityProxy.get() != null && !Boolean.TRUE.equals(this.mPIPParams.useExternalStateMonitor)) {
            return;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        if (this.mCheckStateTask != null) {
            return;
        }
        this.mCheckStateTask = new Runnable(){

            @Override
            public void run() {
                AgoraPIPController.this.checkPIPState();
                AgoraPIPController.this.mHandler.postDelayed((Runnable)this, AgoraPIPController.this.mPIPParams.externalStateMonitorInterval != null ? AgoraPIPController.this.mPIPParams.externalStateMonitorInterval.longValue() : 100L);
            }
        };
        this.mHandler.post(this.mCheckStateTask);
    }

    private void stopStateMonitoring() {
        if (this.mHandler != null && this.mCheckStateTask != null) {
            this.mHandler.removeCallbacks(this.mCheckStateTask);
        }
    }

    @Override
    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        if (this.mPIPParams != null && Boolean.TRUE.equals(this.mPIPParams.useExternalStateMonitor)) {
            return;
        }
        if (isInPictureInPictureMode) {
            this.notifyPIPStateChanged(PIPState.Started, null);
        } else {
            this.notifyPIPStateChanged(PIPState.Stopped, null);
        }
    }

    @Override
    public boolean onPictureInPictureRequested() {
        return false;
    }

    @Override
    public void onPictureInPictureUiStateChanged(PictureInPictureUiState state) {
    }

    @Override
    public void onUserLeaveHint() {
        if (Build.VERSION.SDK_INT < 31 && this.mPIPParams != null && Boolean.TRUE.equals(this.mPIPParams.autoEnterEnabled)) {
            this.start();
        }
    }

    private static class PIPParams {
        private final Rational aspectRatio;
        private final Boolean autoEnterEnabled;
        private final Rect sourceRectHint;
        private final Boolean seamlessResizeEnabled;
        private final Boolean useExternalStateMonitor;
        private final Integer externalStateMonitorInterval;

        public PIPParams(Rational aspectRatio, Boolean autoEnterEnabled, Rect sourceRectHint, Boolean seamlessResizeEnabled, Boolean useExternalStateMonitor, Integer externalStateMonitorInterval) {
            this.aspectRatio = aspectRatio;
            this.autoEnterEnabled = autoEnterEnabled;
            this.sourceRectHint = sourceRectHint;
            this.seamlessResizeEnabled = seamlessResizeEnabled;
            this.useExternalStateMonitor = useExternalStateMonitor;
            this.externalStateMonitorInterval = externalStateMonitorInterval;
        }
    }

    public static interface PIPStateChangedListener {
        public void onPIPStateChangedListener(PIPState var1, String var2);
    }

    public static enum PIPState {
        Started(0),
        Stopped(1),
        Failed(2);

        private final int value;

        private PIPState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

