/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.internal.video.MediaCodecWrapper;
import io.agora.base.internal.video.MediaCodecWrapperFactory;
import java.io.IOException;
import java.nio.ByteBuffer;

class MediaCodecWrapperFactoryImpl
implements MediaCodecWrapperFactory {
    MediaCodecWrapperFactoryImpl() {
    }

    @Override
    public MediaCodecWrapper createByCodecName(String name) throws IOException {
        return new MediaCodecWrapperImpl(MediaCodec.createByCodecName((String)name));
    }

    private static class MediaCodecWrapperImpl
    implements MediaCodecWrapper {
        private final MediaCodec mediaCodec;

        public MediaCodecWrapperImpl(MediaCodec mediaCodec) {
            this.mediaCodec = mediaCodec;
        }

        @Override
        @Nullable
        public MediaCodecInfo.CodecCapabilities getCodecInfo(String type) {
            if (Build.VERSION.SDK_INT >= 18) {
                MediaCodecInfo codecInfo = this.mediaCodec.getCodecInfo();
                return codecInfo != null ? codecInfo.getCapabilitiesForType(type) : null;
            }
            return null;
        }

        @Override
        public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
            this.mediaCodec.configure(format, surface, crypto, flags);
        }

        @Override
        public void start() {
            this.mediaCodec.start();
        }

        @Override
        public void flush() {
            this.mediaCodec.flush();
        }

        @Override
        public void stop() {
            this.mediaCodec.stop();
        }

        @Override
        public void release() {
            this.mediaCodec.release();
        }

        @Override
        public int dequeueInputBuffer(long timeoutUs) {
            return this.mediaCodec.dequeueInputBuffer(timeoutUs);
        }

        @Override
        public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
            this.mediaCodec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }

        @Override
        public int dequeueOutputBuffer(MediaCodec.BufferInfo info, long timeoutUs) {
            return this.mediaCodec.dequeueOutputBuffer(info, timeoutUs);
        }

        @Override
        public void releaseOutputBuffer(int index, boolean render) {
            this.mediaCodec.releaseOutputBuffer(index, render);
        }

        @Override
        public MediaFormat getOutputFormat() {
            return this.mediaCodec.getOutputFormat();
        }

        @Override
        public ByteBuffer[] getInputBuffers() {
            return this.mediaCodec.getInputBuffers();
        }

        @Override
        public ByteBuffer[] getOutputBuffers() {
            return this.mediaCodec.getOutputBuffers();
        }

        @Override
        @TargetApi(value=18)
        public Surface createInputSurface() {
            return this.mediaCodec.createInputSurface();
        }

        @Override
        @TargetApi(value=19)
        public void setParameters(Bundle params) {
            this.mediaCodec.setParameters(params);
        }

        @Override
        @TargetApi(value=18)
        public void signalEndOfInputStream() {
            this.mediaCodec.signalEndOfInputStream();
        }
    }
}

