/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VideoDecoderUtils {
    private static final String TAG = "HardwareVideoDecoderUtils";
    private static final List<String> H264_HWDEC_EXCEPTION_MODELS = Arrays.asList("ASUS_T00J");
    static Map<VideoCodecType, MediaCodecInfo> mediaCodecInfoMaps = new ConcurrentHashMap<VideoCodecType, MediaCodecInfo>();

    @CalledByNative
    static boolean isSupportHwDecoderByType(String codecType) {
        return VideoCodecType.contains(codecType) && VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType)) != null;
    }

    @CalledByNative
    static boolean isSupportHwDecoderByTypeAndProfile(String codecType, String profile) {
        Logging.w(TAG, "isSupportHwDecoderByTypeAndProfile " + codecType + ":" + profile);
        MediaCodecInfo info = null;
        if (VideoCodecType.contains(codecType) && (info = VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType))) != null) {
            try {
                if (VideoCodecProfile.contains(profile) && VideoDecoderUtils.isSupportedProfile(info.getCapabilitiesForType(VideoCodecType.valueOf(codecType).mimeType()), VideoCodecProfile.valueOf(profile))) {
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return false;
    }

    @CalledByNative
    static boolean IsSupportDecodeHEVC10Bit() {
        MediaCodecInfo info = VideoDecoderUtils.findCodecForType(VideoCodecType.H265);
        if (info == null) {
            return false;
        }
        try {
            MediaCodecInfo.CodecCapabilities codecCapabilities = info.getCapabilitiesForType(VideoCodecType.H265.mimeType());
            if (codecCapabilities == null || codecCapabilities.profileLevels == null) {
                return false;
            }
            for (MediaCodecInfo.CodecProfileLevel profileLevels : codecCapabilities.profileLevels) {
                if (profileLevels.profile != 2 && profileLevels.profile != 4096 && profileLevels.profile != 8192) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type) {
        return VideoDecoderUtils.findCodecForType(type, true, true, null);
    }

    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type, boolean enableGoogle, boolean enableDav1d, String skipCodecName) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (!(type != VideoCodecType.VP8 || mediaCodecInfoMaps.get((Object)VideoCodecType.VP8) == null || enableGoogle || !TextUtils.isEmpty((CharSequence)skipCodecName) && mediaCodecInfoMaps.get((Object)VideoCodecType.VP8).getName().contains(skipCodecName))) {
            return mediaCodecInfoMaps.get((Object)VideoCodecType.VP8);
        }
        if (!(type != VideoCodecType.VP9 || mediaCodecInfoMaps.get((Object)VideoCodecType.VP9) == null || enableGoogle || !TextUtils.isEmpty((CharSequence)skipCodecName) && mediaCodecInfoMaps.get((Object)VideoCodecType.VP9).getName().contains(skipCodecName))) {
            return mediaCodecInfoMaps.get((Object)VideoCodecType.VP9);
        }
        if (!(type != VideoCodecType.H264 || mediaCodecInfoMaps.get((Object)VideoCodecType.H264) == null || enableGoogle || !TextUtils.isEmpty((CharSequence)skipCodecName) && mediaCodecInfoMaps.get((Object)VideoCodecType.H264).getName().contains(skipCodecName))) {
            return mediaCodecInfoMaps.get((Object)VideoCodecType.H264);
        }
        if (!(type != VideoCodecType.H265 || mediaCodecInfoMaps.get((Object)VideoCodecType.H265) == null || enableGoogle || !TextUtils.isEmpty((CharSequence)skipCodecName) && mediaCodecInfoMaps.get((Object)VideoCodecType.H265).getName().contains(skipCodecName))) {
            return mediaCodecInfoMaps.get((Object)VideoCodecType.H265);
        }
        if (!(type != VideoCodecType.AV1 || mediaCodecInfoMaps.get((Object)VideoCodecType.AV1) == null || enableDav1d || !TextUtils.isEmpty((CharSequence)skipCodecName) && mediaCodecInfoMaps.get((Object)VideoCodecType.AV1).getName().contains(skipCodecName))) {
            return mediaCodecInfoMaps.get((Object)VideoCodecType.AV1);
        }
        MediaCodecInfo dav1dInfo = null;
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            boolean softwareOnly = false;
            if (info != null && Build.VERSION.SDK_INT >= 29) {
                softwareOnly = info.isSoftwareOnly();
            }
            if (info == null || info.isEncoder() || !enableDav1d && info.getName().contains("av1-dav1d") || !enableGoogle && softwareOnly && !info.getName().contains("av1-dav1d") || !TextUtils.isEmpty((CharSequence)skipCodecName) && info.getName().toLowerCase().contains(skipCodecName.toLowerCase()) || !VideoDecoderUtils.isSupportedCodec(info, type)) continue;
            if (type == VideoCodecType.AV1 && info.getName().contains("av1-dav1d")) {
                dav1dInfo = info;
                continue;
            }
            mediaCodecInfoMaps.put(type, info);
            return info;
        }
        if (type == VideoCodecType.AV1 && null != dav1dInfo) {
            mediaCodecInfoMaps.put(type, dav1dInfo);
            return dav1dInfo;
        }
        return null;
    }

    static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        try {
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
                Logging.w(TAG, "selectColorFormat is null");
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
            return false;
        }
        if (MediaCodecUtils.checkInvalidDecoder(info.getName())) {
            return false;
        }
        return VideoDecoderUtils.isHardwareSupported(info, type);
    }

    static boolean isHardwareSupported(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        switch (type) {
            case VP8: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Intel.") || name.startsWith("OMX.Exynos.") || name.startsWith("OMX.Nvidia.");
            }
            case VP9: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.");
            }
            case H264: {
                return !H264_HWDEC_EXCEPTION_MODELS.contains(Build.MODEL);
            }
            case H265: {
                return Build.VERSION.SDK_INT >= 21;
            }
            case AV1: {
                return Build.VERSION.SDK_INT >= 30;
            }
        }
        return false;
    }

    static SupportCodecInfo getSupportedDecoders() {
        int supportCodecs = 0;
        ArrayList<String> infoNames = new ArrayList<String>();
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            boolean softwareOnly = false;
            if (info != null && Build.VERSION.SDK_INT >= 29) {
                softwareOnly = info.isSoftwareOnly();
            }
            if (info.isEncoder() || softwareOnly) continue;
            for (String mimeType : info.getSupportedTypes()) {
                String infoName = info.getName().toLowerCase();
                if (mimeType.equals(VideoCodecType.VP8.mimeType())) {
                    supportCodecs |= 1;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (mimeType.equals(VideoCodecType.H264.mimeType())) {
                    supportCodecs |= 2;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (mimeType.equals(VideoCodecType.H265.mimeType())) {
                    supportCodecs |= 4;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (!mimeType.equals(VideoCodecType.AV1.mimeType()) || infoNames.contains(infoName)) continue;
                infoNames.add(infoName);
            }
        }
        return new SupportCodecInfo(supportCodecs, ((Object)infoNames).toString());
    }

    static boolean isSupportedProfile(MediaCodecInfo.CodecCapabilities cap, VideoCodecProfile profile) {
        if (cap != null) {
            for (int i = 0; i < cap.profileLevels.length; ++i) {
                Logging.i(TAG, "device decoder profile:" + cap.profileLevels[i].profile);
                if (cap.profileLevels[i].profile != profile.profile()) continue;
                Logging.i(TAG, "match decoder profile:" + cap.profileLevels[i].profile);
                return true;
            }
        }
        return false;
    }

    @CalledByNative
    static int getMaxSupportedInstances(String codecType) {
        if (Build.VERSION.SDK_INT < 23) {
            return -1;
        }
        MediaCodecInfo info = null;
        if (VideoCodecType.contains(codecType) && (info = VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType))) != null) {
            try {
                MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(VideoCodecType.valueOf(codecType).mimeType());
                if (capabilities == null) {
                    return -1;
                }
                return capabilities.getMaxSupportedInstances();
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return -1;
    }

    static class SupportCodecInfo {
        private int supportCodecs;
        private String codecNames;

        public SupportCodecInfo(int supportCodecs, String codecNames) {
            this.supportCodecs = supportCodecs;
            this.codecNames = codecNames;
        }

        public int getSupportCodecs() {
            return this.supportCodecs;
        }

        public String getCodecNames() {
            return this.codecNames;
        }
    }
}

