/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.ConditionVariable;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.base.internal.video.TimerSurfaceTextureHelper;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureFormat;
import java.util.Locale;

@TargetApi(value=21)
public class VideoCaptureScreen
extends VideoCapture
implements SurfaceTextureHelper.IVideoCapture {
    private static final String TAG = "VideoCaptureScreen";
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final Intent mMediaProjectionPermissionResultData;
    private int mWidth;
    private int mHeight;
    private int mFramerate;
    @Nullable
    private VirtualDisplay mVirtualDisplay;
    @Nullable
    private MediaProjection mMediaProjection;
    private MediaProjectionManager mMediaProjectionManager;
    private MediaProjection.Callback mMediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            Logging.w(VideoCaptureScreen.TAG, "media projection stopped");
        }
    };
    private ConditionVariable mWaitForDeviceClosedConditionVariable = new ConditionVariable();
    private int lastRotation = -1;

    public VideoCaptureScreen(long nativeVideoCaptureAndroid, EglBase.Context sharedContext, Intent mediaProjectionPermissionResultData) {
        super(nativeVideoCaptureAndroid, TimerSurfaceTextureHelper.create("ScreenCapturerThread", sharedContext));
        this.mMediaProjectionPermissionResultData = mediaProjectionPermissionResultData;
    }

    @Override
    public boolean allocate(@NonNull VideoCaptureFormat req) {
        Logging.d(TAG, String.format(Locale.US, "allocate: requested (%d x %d) %d", req.mWidth, req.mHeight, req.mFramerate));
        if (req.mFramerate <= 0) {
            throw new IllegalArgumentException("invalid frame rate");
        }
        this.mFramerate = req.mFramerate;
        if (req.mWidth == 0 || req.mHeight == 0) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            this.mWidth = displayMetrics.widthPixels;
            this.mHeight = displayMetrics.heightPixels;
        } else {
            this.mWidth = req.mWidth;
            this.mHeight = req.mHeight;
        }
        this.mCaptureFormat = new VideoCaptureFormat(this.mWidth, this.mHeight, req.getFramerate(), req.getPixelFormat());
        this.mMediaProjectionManager = (MediaProjectionManager)ContextUtils.getApplicationContext().getSystemService("media_projection");
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        Logging.d(TAG, "startCaptureMaybeAsync()");
        try {
            this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(-1, this.mMediaProjectionPermissionResultData);
        }
        catch (SecurityException e) {
            Logging.e(TAG, "Failed to getMediaProjection, you should start a foreground service before capture screen!", e);
            return false;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "Failed to getMediaProjection, IllegalStateException!", e);
            return false;
        }
        if (this.mMediaProjection == null) {
            Logging.e(TAG, "getMediaProjection error. invalid mediaProjectionPermissionResultData");
            return false;
        }
        if (this.mSurfaceTextureHelper == null) {
            Logging.e(TAG, "SurfaceTextureHelper null");
            return false;
        }
        this.lastRotation = this.getDeviceRotation();
        this.mMediaProjection.registerCallback(this.mMediaProjectionCallback, this.mSurfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        ((TimerSurfaceTextureHelper)this.mSurfaceTextureHelper).setFrameRate(this.mFramerate);
        this.mSurfaceTextureHelper.startListening(this);
        return true;
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        Logging.d(TAG, "stopCaptureAndBlockUntilStopped()");
        if (this.mSurfaceTextureHelper == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.mSurfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                VideoCaptureScreen.this.mSurfaceTextureHelper.stopListening();
                if (VideoCaptureScreen.this.mVirtualDisplay != null) {
                    VideoCaptureScreen.this.mVirtualDisplay.release();
                    VideoCaptureScreen.this.mVirtualDisplay = null;
                }
                if (VideoCaptureScreen.this.mMediaProjection != null) {
                    VideoCaptureScreen.this.mMediaProjection.unregisterCallback(VideoCaptureScreen.this.mMediaProjectionCallback);
                    try {
                        VideoCaptureScreen.this.mMediaProjection.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(VideoCaptureScreen.TAG, "Exception when stopCaptureAndBlockUntilStopped: " + exception.getMessage());
                    }
                    finally {
                        VideoCaptureScreen.this.mMediaProjection = null;
                    }
                }
                VideoCaptureScreen.this.mWaitForDeviceClosedConditionVariable.open();
            }
        });
        this.mWaitForDeviceClosedConditionVariable.block();
    }

    @Override
    public void deallocate() {
        Logging.d(TAG, "deallocate()");
    }

    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        Logging.d(TAG, "changeCaptureFormat, " + width + " x " + height);
        this.mWidth = width;
        this.mHeight = height;
        if (this.mVirtualDisplay == null) {
            return;
        }
        if (this.mSurfaceTextureHelper == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.mSurfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                VideoCaptureScreen.this.mVirtualDisplay.release();
                VideoCaptureScreen.this.createVirtualDisplay();
            }
        });
    }

    private void createVirtualDisplay() {
        if (this.mSurfaceTextureHelper == null || this.mMediaProjection == null) {
            return;
        }
        this.mSurfaceTextureHelper.setTextureSize(this.mWidth, this.mHeight);
        this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.mWidth, this.mHeight, 400, 3, new Surface(this.mSurfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    @Override
    public void onFrame(VideoFrame frame) {
        int rotation = this.getDeviceRotation();
        if (this.lastRotation != rotation) {
            this.lastRotation = rotation;
            this.changeCaptureFormat(this.mHeight, this.mWidth, 15);
        }
        this.onFrameCaptured(frame);
    }

    @Override
    public void onFrameDropped(int dropReason) {
        super.onFrameDropped(dropReason);
    }
}

