/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.telephony.CellSignalStrength;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthNr;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.ThreadUtils;
import io.agora.utils2.internal.ConnectivityUtility;
import io.agora.utils2.internal.DeviceUtils;
import io.agora.utils2.internal.Logging;
import io.agora.utils2.internal.PowerChangeReceiver;
import io.agora.utils2.internal.ProcessLifecycleOwner;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

@TargetApi(value=17)
public class CommonUtility
implements ConnectivityUtility.NetworkListener {
    private static final String TAG = "CommonUtility";
    static final int UNKNOWN_BATTERY_PERCENTAGE = 255;
    private static final int INTERNAL_UPDATE_ROTATION = 200;
    public static final String PREFIX_URI = "content://";
    public static final String PREFIX_ASSETS = "/assets/";
    private static final String URI_PROTOCOL_HEAD = "/proc/";
    private static final String OFFSET_SEPARATOR_CHARACTER = "agora_offset_&&_";
    private static final String LENGTH_SEPARATOR_CHARACTER = "agora_length_&&_";
    private ConnectivityManager.NetworkCallback mobileNetworkCallback = null;
    private final WeakReference<Context> mContext;
    private final ThreadUtils.ThreadChecker mThreadChecker;
    private final Handler mHandler;
    private volatile int mBatteryPercentage = 255;
    private boolean mDisposed = false;
    private volatile boolean mUpdateRotationTrigger = false;
    private volatile int lastOrientation = -1;
    private AgoraPhoneStateListener mPhoneStateListener = null;
    private PowerChangeReceiver mPowerChangeReceiver = null;
    private ProcessLifecycleOwner mProcessLifecycleOwner = null;
    private OrientationEventListener mOrientationListener = null;
    private DisplayManager.DisplayListener mDisplayListener = null;
    private BroadcastReceiver mOrientationObserver = null;
    private int mLastOrientation = -1;
    private Listener mListener;
    private static boolean ignoreMonitor = false;
    private static volatile CommonUtility sInstance;
    private AtomicInteger reference = new AtomicInteger(0);
    private ConnectivityUtility mConnectivityUtility;
    private ArrayList<SystemEventListener> systemEventListeners = new ArrayList();
    private static Handler mProcessInfoHandler;
    private final Runnable rotationRunnable = new Runnable(){

        @Override
        public void run() {
            Context context = (Context)CommonUtility.this.mContext.get();
            if (context == null) {
                return;
            }
            CommonUtility.this.getDisplayRotation();
            CommonUtility.this.mUpdateRotationTrigger = false;
        }
    };

    public static void setIgnoreMonitor(boolean ignore) {
        ignoreMonitor = ignore;
    }

    @Override
    public void onDefaultNetworkChanged() {
        this.onNetworkChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void registerSystemEventListener(SystemEventListener eventListener) {
        Log.d((String)TAG, (String)("registerSystemEventListener: " + eventListener.getClass().getName()));
        if (eventListener == null) {
            return;
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            if (this.systemEventListeners.contains(eventListener)) {
                return;
            }
            this.systemEventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void unregisterSystemEventListener(SystemEventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            if (this.systemEventListeners.contains(eventListener)) {
                this.systemEventListeners.remove(eventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @CalledByNative
    public static CommonUtility getInstance(Context context) {
        if (sInstance == null) {
            Class<CommonUtility> clazz = CommonUtility.class;
            // MONITORENTER : io.agora.utils2.internal.CommonUtility.class
            if (sInstance == null) {
                sInstance = new CommonUtility(context);
            }
            // MONITOREXIT : clazz
        }
        CommonUtility.sInstance.reference.getAndIncrement();
        return sInstance;
    }

    private CommonUtility(Context context) {
        Logging.d(TAG, "constructor()");
        this.mContext = new WeakReference<Context>(context);
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        this.mConnectivityUtility = new ConnectivityUtility(context);
        this.mConnectivityUtility.addNetworkListener(this);
        HandlerThread handlerThread = new HandlerThread("UtilityThread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.startMonitor();
            }
        });
    }

    private CommonUtility(Context context, long handle) {
        Logging.d(TAG, "constructor()");
        this.mContext = new WeakReference<Context>(context);
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        this.mConnectivityUtility = new ConnectivityUtility(context);
        this.mConnectivityUtility.addNetworkListener(this);
        HandlerThread handlerThread = new HandlerThread("UtilityThread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.startMonitor();
            }
        });
    }

    @CalledByNative
    public static int[] getDisplayMetrics() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return new int[]{0, 0};
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        if (null == wm) {
            return new int[]{0, 0};
        }
        Display display = wm.getDefaultDisplay();
        if (null == display) {
            return new int[]{0, 0};
        }
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(metrics);
        }
        Logging.d(TAG, "getDisplayMetrics widthPixel: " + metrics.heightPixels + " , heightPixel: " + metrics.widthPixels);
        return new int[]{metrics.widthPixels, metrics.heightPixels};
    }

    @CalledByNative
    public static float[] getDisplayXYDpi() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return new float[]{0.0f, 0.0f};
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        if (null == wm) {
            return new float[]{0.0f, 0.0f};
        }
        Display display = wm.getDefaultDisplay();
        if (null == display) {
            return new float[]{0.0f, 0.0f};
        }
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(metrics);
        }
        Logging.d(TAG, "getDisplayXYDpi xdpi: " + metrics.xdpi + " , ydpi: " + metrics.ydpi);
        return new float[]{metrics.xdpi, metrics.ydpi};
    }

    @CalledByNative
    public static Object getSystemService(Context context, String serviceName) {
        return context.getSystemService(serviceName);
    }

    @VisibleForTesting
    void setListener(Listener listener) {
        this.mListener = listener;
    }

    @VisibleForTesting
    Handler getHandler() {
        return this.mHandler;
    }

    @VisibleForTesting
    ProcessLifecycleOwner getProcessLifecycleOwner() {
        return this.mProcessLifecycleOwner;
    }

    void startMonitor() {
        Logging.d(TAG, "startMonitor()");
        if (ignoreMonitor) {
            Logging.e(TAG, "ignoreMonitor in simulator, just for ut");
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.mConnectivityUtility.startMonitor(context);
        try {
            this.mPhoneStateListener = new AgoraPhoneStateListener(this, this.mHandler);
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", e);
        }
        try {
            this.mPowerChangeReceiver = new PowerChangeReceiver(this);
            IntentFilter iFilter = new IntentFilter();
            iFilter.addAction("android.intent.action.BATTERY_CHANGED");
            context.registerReceiver((BroadcastReceiver)this.mPowerChangeReceiver, iFilter);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PowerChangeReceiver, ", e);
        }
        try {
            this.mProcessLifecycleOwner = new ProcessLifecycleOwner(CommonUtility.isAppInForeground(), this);
            Application app = (Application)context.getApplicationContext();
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mProcessLifecycleOwner);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to registerActivityLifecycleCallbacks, ", e);
        }
        try {
            this.monitorOrientationChange(context, true);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to monitorOrientationChange, ", e);
        }
    }

    private void stopMonitor() {
        Logging.d(TAG, "stopMonitor()");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.mConnectivityUtility.stopMonitor(context);
        this.mConnectivityUtility.removeNetworkListener(this);
        try {
            if (this.mPhoneStateListener != null) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 0);
                this.mPhoneStateListener = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mPowerChangeReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mPowerChangeReceiver);
                this.mPowerChangeReceiver = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mProcessLifecycleOwner != null) {
                Application app = (Application)context.getApplicationContext();
                app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mProcessLifecycleOwner);
                this.mProcessLifecycleOwner = null;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unregister ProcessLifecycleOwner failed ", e);
        }
        try {
            this.monitorOrientationChange(context, false);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to monitorOrientationChange, ", e);
        }
        this.closeGravityMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void dispose() {
        if (sInstance == null || CommonUtility.sInstance.reference.decrementAndGet() > 0) {
            return;
        }
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        Logging.d(TAG, "dispose()");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.stopMonitor();
            }
        });
        if (mProcessInfoHandler != null) {
            mProcessInfoHandler.post(new Runnable(){

                @Override
                public void run() {
                    mProcessInfoHandler.getLooper().quit();
                    mProcessInfoHandler = null;
                }
            });
        }
        final CountDownLatch waitingLatch = new CountDownLatch(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                waitingLatch.countDown();
                CommonUtility.this.mHandler.getLooper().quit();
            }
        });
        try {
            waitingLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.mListener != null) {
            this.mListener.onDispose();
        }
        Object object = this;
        synchronized (object) {
            this.systemEventListeners.clear();
        }
        object = CommonUtility.class;
        synchronized (CommonUtility.class) {
            sInstance = null;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public int getNetworkType() {
        return this.mConnectivityUtility.getNetworkType();
    }

    @CalledByNative
    public int getBatteryLifePercent() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.mBatteryPercentage;
        }
        return 255;
    }

    @CalledByNative
    public MediaNetworkInfo getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.getNetworkInfo(context);
        }
        return null;
    }

    @CalledByNative
    public String getRealFilePath(Context context, String url) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            Logging.e(TAG, "getRealFilePath failed for init error");
            return "";
        }
        String realPath = null;
        if (url.startsWith(PREFIX_ASSETS)) {
            realPath = CommonUtility.getAssetsFilePath(context, url);
        } else if (url.startsWith(PREFIX_URI)) {
            Uri uri = Uri.parse((String)url);
            realPath = CommonUtility.getContentFilePath(context, uri);
        }
        return realPath != null ? realPath : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFilePath(Context context, Uri uri) {
        if (context == null || uri == null) {
            Logging.e(TAG, "getContentFilePath failed for init error");
            return null;
        }
        ContentResolver resolver = context.getContentResolver();
        AssetFileDescriptor fileDescriptor = null;
        int realFd = -1;
        Object pfd = null;
        try {
            fileDescriptor = resolver.openAssetFileDescriptor(uri, "r");
            realFd = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor.getFileDescriptor()).getFd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (realFd < 0) {
            return null;
        }
        String realPath = URI_PROTOCOL_HEAD + Process.myPid() + "/fd/" + realFd;
        Logging.d(TAG, "getContentFilePath is: " + realPath);
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssetsFilePath(Context context, String url) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            Logging.e(TAG, "getAssetsFilePath failed for init error");
            return null;
        }
        AssetManager manager = context.getAssets();
        AssetFileDescriptor fileDescriptor = null;
        String assetsFileName = url.substring(url.indexOf(PREFIX_ASSETS) + PREFIX_ASSETS.length());
        String realPath = null;
        try {
            fileDescriptor = manager.openFd(assetsFileName);
            int readFd = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor.getFileDescriptor()).getFd();
            if (readFd < 0) {
                String string = null;
                return string;
            }
            realPath = PREFIX_ASSETS + readFd + OFFSET_SEPARATOR_CHARACTER + fileDescriptor.getStartOffset() + LENGTH_SEPARATOR_CHARACTER + fileDescriptor.getDeclaredLength();
            Logging.d(TAG, "getAssetsFilePath for init offset:" + fileDescriptor.getStartOffset() + "," + fileDescriptor.getDeclaredLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Logging.d(TAG, "getAssetsFilePath is: " + realPath);
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public String getAssetsCacheFile(Context context, String pathOrUri, String fileName) {
        Logging.d(TAG, "getAssetsCacheFile filePath: " + pathOrUri);
        boolean isUri = pathOrUri.startsWith(PREFIX_URI);
        File cacheFile = new File(context.getCacheDir(), fileName);
        try {
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int len;
            inputStream = isUri ? new FileInputStream(context.getContentResolver().openFileDescriptor(Uri.parse((String)pathOrUri), "r").getFileDescriptor()) : context.getAssets().open(pathOrUri);
            outputStream = new FileOutputStream(cacheFile);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cacheFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAudioRoutingPhoneChanged(boolean enableAudio, int event, int arg) {
        if (this.mDisposed) {
            return;
        }
        Logging.d(TAG, "onAudioRoutingPhoneChanged() enableAudio:" + enableAudio + ", event:" + event + ", arg: " + arg);
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                Log.d((String)TAG, (String)("onAudioRoutingPhoneChanged: " + eventListener.getClass().getName()));
                eventListener.onAudioRoutingPhoneChanged(enableAudio, event, arg);
            }
        }
        if (this.mListener != null) {
            this.mListener.onAudioRoutingPhoneChanged(enableAudio, event, arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNetworkChange() {
        if (this.mDisposed) {
            return;
        }
        Logging.d(TAG, "onNetworkChange()");
        MediaNetworkInfo info = this.getNetworkInfo((Context)this.mContext.get());
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                Log.d((String)TAG, (String)("onNetworkChange: " + eventListener.getClass().getName()));
                eventListener.onNetworkChange(info);
            }
        }
        if (this.mListener != null) {
            this.mListener.onNetworkChange(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onForegroundChanged(boolean foreground) {
        Log.d((String)TAG, (String)("onForegroundChanged() " + foreground));
        if (this.mDisposed) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onForegroundChanged(foreground);
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                eventListener.onForegroundChanged(foreground);
            }
        }
    }

    void onPowerChange(int batteryPercentage) {
        Logging.d(TAG, "onPowerChange() " + batteryPercentage);
        this.mBatteryPercentage = batteryPercentage;
    }

    private static String getSystemProperty(String name) throws Exception {
        Class<?> systemPropertyClazz = Class.forName("android.os.SystemProperties");
        return (String)systemPropertyClazz.getMethod("get", String.class).invoke(systemPropertyClazz, name);
    }

    private static boolean isSimulatorProperty() {
        int suspectCount = 0;
        String hardware = "";
        String arch = "";
        String baseBandVersion = "";
        String buildFlavor = "";
        String productBoard = "";
        String boardPlatform = "";
        String manufacturer = Build.MANUFACTURER;
        try {
            hardware = CommonUtility.getSystemProperty("ro.hardware");
            if (null == hardware || hardware.toLowerCase().equals("intel")) {
                ++suspectCount;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property hardware fail.");
        }
        try {
            arch = System.getProperty("os.arch");
            if (null == arch || arch.toLowerCase().equals("i686") && !manufacturer.toLowerCase().contains("asus")) {
                ++suspectCount;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property arch fail.");
        }
        if (Build.VERSION.SDK_INT > 28) {
            if (null == hardware || hardware.toLowerCase().contains("ttvm") || hardware.toLowerCase().contains("nox")) {
                ++suspectCount;
            }
            try {
                buildFlavor = CommonUtility.getSystemProperty("ro.build.flavor");
                if (null == buildFlavor || buildFlavor.contains("vbox") || buildFlavor.contains("sdk_gphone")) {
                    ++suspectCount;
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property buildFlavor fail.");
            }
            try {
                productBoard = CommonUtility.getSystemProperty("ro.product.board");
                if (null == productBoard || productBoard.contains("android") || productBoard.contains("goldfish")) {
                    ++suspectCount;
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property productBoard fail.");
            }
            try {
                boardPlatform = CommonUtility.getSystemProperty("ro.board.platform");
                if (null == boardPlatform || boardPlatform.contains("android")) {
                    ++suspectCount;
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property boardPlatform fail.");
            }
        }
        Logging.d(TAG, "suspectCount = " + suspectCount + ", hardware = " + hardware + ", arch = " + arch + ", baseBandVersion = " + baseBandVersion + ", buildFlavor = " + buildFlavor + ", productBoard = " + productBoard + ", boardPlatform = " + boardPlatform + ", manufacturer = " + manufacturer);
        return suspectCount > 0;
    }

    @CalledByNative
    public static boolean isSimulator() {
        int suspectCount = 0;
        String serial = "";
        String manufacturer = "";
        try {
            manufacturer = Build.MANUFACTURER;
            if (manufacturer.toLowerCase().contains("netease")) {
                ++suspectCount;
            }
            Logging.d(TAG, "manufacturer = " + manufacturer);
        }
        catch (Exception e) {
            Logging.e(TAG, "get manufacturer info fail.");
        }
        if (CommonUtility.isSimulatorProperty()) {
            ++suspectCount;
        }
        if (Build.VERSION.SDK_INT > 28) {
            if ("nokia".equalsIgnoreCase(manufacturer) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
                return false;
            }
            if (suspectCount > 0 && !manufacturer.toLowerCase().contains("welldo")) {
                return true;
            }
        } else if ((serial.toLowerCase().equals("unknown") || suspectCount > 0) && !manufacturer.toLowerCase().contains("welldo")) {
            return true;
        }
        return false;
    }

    @CalledByNative
    public static int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    @CalledByNative
    public static int isSpeakerphoneEnabled(Context context) {
        if (context == null) {
            Logging.w(TAG, "fail to isSpeakerphoneEnabled, context null");
            return -1;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isSpeakerphoneOn() ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddressBound(String addr) {
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                eventListener.onAddressBound(addr);
            }
        }
    }

    @CalledByNative
    public void bindSocket2Network(int socketfd, String address) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        final ConnectivityManager connectivityManager = (ConnectivityManager)((Context)this.mContext.get()).getSystemService("connectivity");
        NetworkRequest requestForCellular = new NetworkRequest.Builder().addTransportType(0).build();
        final int socketFdInner = socketfd;
        final String addressInner = address.toString();
        final CommonUtility comm = this;
        if (this.mobileNetworkCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mobileNetworkCallback);
        }
        this.mobileNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                LinkProperties prop = connectivityManager.getLinkProperties(network);
                if (prop == null || prop.getLinkAddresses().isEmpty()) {
                    Logging.e(CommonUtility.TAG, "onAvailable: prop is null or empty!");
                    return;
                }
                InetAddress addr = ((LinkAddress)prop.getLinkAddresses().get(0)).getAddress();
                String ip = CommonUtility.inetAddressToIpAddress(addr);
                if (ip != null && ip.equals(addressInner)) {
                    Logging.d(CommonUtility.TAG, "start bindSocket2Network");
                    Logging.d(CommonUtility.TAG, "addressInner" + addressInner);
                    FileDescriptor fileDescriptor = new FileDescriptor();
                    try {
                        Field field = FileDescriptor.class.getDeclaredField("descriptor");
                        field.setAccessible(true);
                        field.setInt(fileDescriptor, socketFdInner);
                        network.bindSocket(fileDescriptor);
                        comm.notifyAddressBound(addressInner);
                        Logging.d(CommonUtility.TAG, "bindSocket2Network success: network" + network + "+socketfd" + socketFdInner);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            connectivityManager.requestNetwork(requestForCellular, this.mobileNetworkCallback);
        }
        catch (Exception e) {
            this.mobileNetworkCallback = null;
            Logging.e(TAG, "requestNetwork failed " + e.toString());
        }
    }

    @CalledByNative
    public static AndroidContextInfo getContextInfo(Context context) {
        if (context == null) {
            Logging.w(TAG, "fail to getContextInfo, context null");
            return null;
        }
        AndroidContextInfo info = new AndroidContextInfo();
        info.device = DeviceUtils.getDeviceId();
        info.configDir = CommonUtility.getAppPrivateStorageDir(context);
        info.dataDir = context.getCacheDir().getAbsolutePath();
        info.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        info.deviceInfo = DeviceUtils.getDeviceInfo();
        info.systemInfo = DeviceUtils.getSystemInfo();
        info.manufacturer = DeviceUtils.getManufacturer();
        info.pkgName = context.getPackageName();
        return info;
    }

    @CalledByNative
    public static String[] getLocalHostList() {
        if (sInstance != null) {
            List<ConnectivityUtility.AgoraNetworkInfo> infos = CommonUtility.sInstance.mConnectivityUtility.getCurrentActiveInfo();
            String[] addresses = new String[infos.size()];
            int i = 0;
            for (ConnectivityUtility.AgoraNetworkInfo info : infos) {
                addresses[i] = (info.localAddressIpV4 == null ? info.localAddressIpV6 : info.localAddressIpV4) + info.interfaceName;
            }
            return addresses;
        }
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                String interfaceName = intf.getName();
                if (interfaceName.startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr);
                    if (TextUtils.isEmpty((CharSequence)ip)) continue;
                    ips.add(ip + "+" + interfaceName);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception ex) {
            Logging.w(TAG, "fail to getLocalHostList", ex);
        }
        return null;
    }

    @CalledByNative
    public int VPNBehindAddress() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return 1;
        }
        return this.mConnectivityUtility.isVpnEnabled() ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOrientation(int orientation) {
        if (orientation == -1) {
            return -1;
        }
        if ((orientation > 340 || orientation < 20) && this.mLastOrientation != 270) {
            this.mLastOrientation = 270;
        } else if (orientation > 70 && orientation < 110 && this.mLastOrientation != 180) {
            this.mLastOrientation = 180;
        } else if (orientation > 160 && orientation < 200 && this.mLastOrientation != 90) {
            this.mLastOrientation = 90;
        } else if (orientation > 250 && orientation < 290 && this.mLastOrientation != 0) {
            this.mLastOrientation = 0;
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                eventListener.onGravityOriChange(this.mLastOrientation);
            }
        }
        return this.mLastOrientation;
    }

    @CalledByNative
    public int setupGravityMonitor() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        try {
            if (this.mOrientationListener == null) {
                this.mOrientationListener = new OrientationEventListener(context, 2){

                    public void onOrientationChanged(int orientation) {
                        if (orientation == -1) {
                            return;
                        }
                        CommonUtility.this.checkOrientation(orientation);
                    }
                };
            }
            this.mOrientationListener.enable();
            Logging.d(TAG, "[setupGravityMonitor] done!");
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create OrientationEventListener, ", e);
        }
        return -1;
    }

    @CalledByNative
    public int closeGravityMonitor() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        try {
            if (this.mOrientationListener != null) {
                this.mOrientationListener.disable();
                this.mOrientationListener = null;
                Logging.d(TAG, "[closeGravityMonitor] done!");
                return 0;
            }
            Logging.e(TAG, "[closeGravityMonitor] mOrientationListener is null!");
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to close OrientationEventListener, ", e);
        }
        return -1;
    }

    boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        return this.mConnectivityUtility.checkAccessNetworkStatePermission(context);
    }

    static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid());
        return res == 0;
    }

    private MediaNetworkInfo getNetworkInfo(Context context) {
        List<ConnectivityUtility.AgoraNetworkInfo> networkInfos = this.mConnectivityUtility.getCurrentActiveInfo();
        MediaNetworkInfo ni = new MediaNetworkInfo();
        if (networkInfos.isEmpty()) {
            return ni;
        }
        ConnectivityUtility.AgoraNetworkInfo info = networkInfos.get(0);
        if (networkInfos.size() > 1) {
            for (ConnectivityUtility.AgoraNetworkInfo ainfo : networkInfos) {
                if (ainfo.transportType != 1) continue;
                info = ainfo;
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)info.localAddressIpV4)) {
            ni.localIp4 = info.localAddressIpV4;
        }
        if (!TextUtils.isEmpty((CharSequence)info.localAddressIpV6)) {
            ni.localIp6 = info.localAddressIpV6;
        }
        ni.networkType = info.networkType;
        ni.networkSubtype = info.networkSubtype;
        if (ni.networkType == 2) {
            ni.linkspeed = info.linkSpeed;
            ni.frequency = info.frequency;
            ni.signalLevel = info.signalLevel;
            ni.networkSubtype = info.networkSubtype;
            ni.rssi = info.rssi;
            Logging.d(TAG, "networkType from WIFI, rssi = " + ni.rssi + " level = " + ni.signalLevel);
        } else if (this.mPhoneStateListener != null) {
            this.mPhoneStateListener.fillCellInfoIfPossible(context, ni);
            Logging.d(TAG, "networkType from Phone State Listener\uff0c rssi = " + ni.rssi + " level = " + ni.signalLevel);
        }
        ArrayList<String> ifconfigs = new ArrayList<String>();
        if (this.mConnectivityUtility.isVpnEnabled()) {
            ifconfigs.add("tun");
        }
        ni.ifconfigs = ifconfigs;
        return ni;
    }

    public ArrayList<String> getVpnIfconfigs() {
        ArrayList<String> ifconfigs = new ArrayList<String>();
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                String name = nif.getName();
                if (!name.contains("tun") && !name.contains("ppp") && !name.contains("ipsec") && !name.contains("tap")) continue;
                ifconfigs.add(name);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Fail to get network interfaces array list. ", e);
        }
        return ifconfigs;
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    private static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    @CalledByNative
    public static boolean isAppInForeground() {
        final ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        final CountDownLatch countLatch = new CountDownLatch(1);
        Runnable processInfoTask = new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
                }
                catch (Exception e) {
                    Logging.e(CommonUtility.TAG, "get App InForeground state failed.", e);
                }
                countLatch.countDown();
            }
        };
        if (mProcessInfoHandler == null) {
            HandlerThread handlerThread = new HandlerThread("processInfo");
            handlerThread.start();
            mProcessInfoHandler = new Handler(handlerThread.getLooper());
        }
        mProcessInfoHandler.post(processInfoTask);
        if (!ThreadUtils.awaitUninterruptibly(countLatch, 100L)) {
            Logging.e(TAG, "get App InForeground state timeout.");
            mProcessInfoHandler.removeCallbacksAndMessages(null);
            return true;
        }
        return appProcessInfo.importance == 100 || appProcessInfo.importance == 200;
    }

    @CalledByNative
    public static int getCpuTemperature() {
        return DeviceUtils.getCpuTemperature();
    }

    @CalledByNative
    public static int safeLoadLibrary(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return -2;
        }
        int loaded = 0;
        try {
            System.loadLibrary(path);
        }
        catch (SecurityException e) {
            loaded = -1;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = -1;
        }
        catch (NullPointerException e) {
            loaded = -1;
        }
        catch (Exception e) {
            loaded = -1;
        }
        if (loaded != 0) {
            Log.i((String)TAG, (String)("failed to load library: " + path));
        }
        return loaded;
    }

    private void monitorOrientationChange(Context context, boolean enable) {
        if (enable) {
            this.enableDisplayListener(context);
            this.regiseterBroadcaster(context);
        } else {
            this.disableDisplayListener();
            this.unregisterBroadcaster(context);
        }
    }

    private void enableDisplayListener(Context context) {
        if (context == null || this.mDisplayListener != null) {
            return;
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager == null) {
            return;
        }
        this.mDisplayListener = new DisplayManager.DisplayListener(){

            public void onDisplayChanged(int displayId) {
                CommonUtility.this.updateOrientationManual();
            }

            public void onDisplayAdded(int displayId) {
            }

            public void onDisplayRemoved(int displayId) {
            }
        };
        displayManager.registerDisplayListener(this.mDisplayListener, this.mHandler);
        Logging.d(TAG, "[enableDisplayListener] done!");
    }

    private void disableDisplayListener() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            displayManager.unregisterDisplayListener(this.mDisplayListener);
            this.mDisplayListener = null;
        }
        Logging.d(TAG, "[disableDisplayListener] done!");
    }

    public void updateOrientationManual() {
        if (this.mHandler == null || this.mDisposed) {
            return;
        }
        this.mUpdateRotationTrigger = true;
        this.mHandler.postDelayed(this.rotationRunnable, 200L);
    }

    private void regiseterBroadcaster(Context context) {
        if (context == null) {
            return;
        }
        if (this.mOrientationObserver != null) {
            return;
        }
        this.mOrientationObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                    Log.d((String)CommonUtility.TAG, (String)"VideoCaptureCamera OrientationObserver");
                    CommonUtility.this.updateOrientationManual();
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        context.registerReceiver(this.mOrientationObserver, intentFilter);
        Logging.d(TAG, "[regiseterBroadcaster] done!");
    }

    private void unregisterBroadcaster(Context context) {
        if (context == null || this.mOrientationObserver == null) {
            return;
        }
        context.unregisterReceiver(this.mOrientationObserver);
        Logging.d(TAG, "[unregisterBroadcaster] done!");
    }

    @CalledByNative
    public int getDisplayRotation() {
        int rotation;
        if (!this.mUpdateRotationTrigger && this.lastOrientation != -1) {
            return this.lastOrientation;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            rotation = this.getRotationByDM();
            if (rotation < 0) {
                rotation = this.getRotationByWM();
            }
        } else {
            rotation = this.getRotationByWM();
        }
        this.lastOrientation = rotation;
        Log.d((String)TAG, (String)("VideoCaptureCamera getDisplayRotation: " + rotation));
        return rotation;
    }

    private int getRotationByDM() {
        Display display;
        int rotation = -1;
        DisplayManager dm = null;
        if (ContextUtils.getApplicationContext() != null) {
            dm = (DisplayManager)ContextUtils.getApplicationContext().getSystemService("display");
        }
        if (dm != null && (display = dm.getDisplay(0)) != null) {
            rotation = display.getRotation();
        }
        return rotation;
    }

    private int getRotationByWM() {
        Display display;
        int rotation = 0;
        WindowManager wm = null;
        if (ContextUtils.getApplicationContext() != null) {
            wm = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
        }
        if (wm != null && (display = wm.getDefaultDisplay()) != null) {
            rotation = display.getRotation();
        }
        return rotation;
    }

    static interface Listener {
        public void onAudioRoutingPhoneChanged(boolean var1, int var2, int var3);

        public void onNetworkChange(MediaNetworkInfo var1);

        public void onDispose();

        public void onForegroundChanged(boolean var1);
    }

    public static class AndroidContextInfo {
        public String device;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String deviceInfo;
        public String systemInfo;
        public String manufacturer;
        public String pkgName;

        @CalledByNative(value="AndroidContextInfo")
        public String getDevice() {
            return this.device;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getConfigDir() {
            return this.configDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDataDir() {
            return this.dataDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPluginDir() {
            return this.pluginDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDeviceInfo() {
            return this.deviceInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getSystemInfo() {
            return this.systemInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getManufacturer() {
            return this.manufacturer;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPkgName() {
            return this.pkgName;
        }
    }

    public static class MediaNetworkInfo {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType = -1;
        int networkSubtype = -1;
        int signalLevel = 0;
        int rssi = 0;
        int snr = -100;
        ArrayList<String> dnsList = null;
        int linkspeed = 0;
        int frequency = 0;
        ArrayList<String> ifconfigs = null;

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp4() {
            return this.localIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp4() {
            return this.gatewayIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp6() {
            return this.localIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp6() {
            return this.gatewayIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkType() {
            return this.networkType;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkSubtype() {
            return this.networkSubtype;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getSignalLevel() {
            return this.signalLevel;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getRssi() {
            return this.rssi;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getAsu() {
            return this.snr;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getDnsList() {
            return this.dnsList;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getLinkspeed() {
            return this.linkspeed;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getFrequency() {
            return this.frequency;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getVpnIfconfigs() {
            return this.ifconfigs;
        }

        public String toString() {
            return "MediaNetworkInfo{localIp4='" + this.localIp4 + '\'' + ", gatewayIp4='" + this.gatewayIp4 + '\'' + ", localIp6='" + this.localIp6 + '\'' + ", gatewayIp6='" + this.gatewayIp6 + '\'' + ", networkType=" + this.networkType + ", networkSubtype=" + this.networkSubtype + ", signalLevel=" + this.signalLevel + ", rssi=" + this.rssi + ", snr=" + this.snr + ", dnsList=" + this.dnsList + ", linkspeed=" + this.linkspeed + ", frequency=" + this.frequency + ", ifconfigs=" + this.ifconfigs + '}';
        }
    }

    static class AgoraPhoneStateListener
    extends PhoneStateListener {
        private final WeakReference<CommonUtility> mCommonUtilityRef;
        private final WeakReference<Handler> mHandlerRef;
        private SignalStrength mSignalStrength;
        private volatile boolean phoneStatusNeedResume = false;

        AgoraPhoneStateListener(CommonUtility commonUtility, Handler handler) {
            this.mCommonUtilityRef = new WeakReference<CommonUtility>(commonUtility);
            this.mHandlerRef = new WeakReference<Handler>(handler);
        }

        @RequiresApi(value=26)
        void fillCellInfoHighLevel(@NonNull MediaNetworkInfo cellInfo) {
            if (this.mSignalStrength != null) {
                try {
                    Method method = this.mSignalStrength.getClass().getDeclaredMethod("getCellSignalStrengths", new Class[0]);
                    if (method != null) {
                        List signalList = (List)method.invoke((Object)this.mSignalStrength, new Object[0]);
                        this.fillCellInfoByNetworkType(signalList, cellInfo);
                    }
                }
                catch (Exception e) {
                    Logging.e(CommonUtility.TAG, "fillCellInfoHighLevel getDeclareMethod:getCellSignalStrengths failed! ");
                    this.fillCellInfoLowLevel(cellInfo);
                }
            }
        }

        @RequiresApi(value=26)
        void fillCellInfoByNetworkType(@NonNull List<CellSignalStrength> cellInfoList, @NonNull MediaNetworkInfo cellInfo) {
            for (CellSignalStrength cellSignal : cellInfoList) {
                if (cellSignal instanceof CellSignalStrengthLte) {
                    CellSignalStrengthLte signalStrength = (CellSignalStrengthLte)cellSignal;
                    cellInfo.rssi = signalStrength.getDbm();
                    cellInfo.signalLevel = signalStrength.getLevel();
                    cellInfo.snr = signalStrength.getRssnr();
                    break;
                }
                if (cellSignal instanceof CellSignalStrengthGsm || cellSignal instanceof CellSignalStrengthCdma || cellSignal instanceof CellSignalStrengthWcdma) {
                    cellInfo.rssi = cellSignal.getDbm();
                    cellInfo.signalLevel = cellSignal.getLevel();
                    break;
                }
                if (Build.VERSION.SDK_INT < 29 || !(cellSignal instanceof CellSignalStrengthNr)) continue;
                CellSignalStrengthNr signalStrength = (CellSignalStrengthNr)cellSignal;
                cellInfo.rssi = signalStrength.getDbm();
                cellInfo.signalLevel = signalStrength.getLevel();
                break;
            }
        }

        void fillCellInfoLowLevel(@NonNull MediaNetworkInfo cellInfo) {
            cellInfo.rssi = this.getRssi();
            cellInfo.signalLevel = this.getLevel();
        }

        public void fillCellInfoIfPossible(Context context, MediaNetworkInfo cellInfo) {
            if (Build.VERSION.SDK_INT <= 28) {
                this.fillCellInfoLowLevel(cellInfo);
            } else {
                this.fillCellInfoHighLevel(cellInfo);
            }
        }

        public int getRssi() {
            return this.invokeMethod("getDbm");
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            return this.invokeMethod("getAsuLevel");
        }

        private int invokeMethod(String methodName) {
            try {
                if (this.mSignalStrength != null) {
                    Method method = this.mSignalStrength.getClass().getDeclaredMethod(methodName, new Class[0]);
                    return (Integer)method.invoke((Object)this.mSignalStrength, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            this.mSignalStrength = signalStrength;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            final CommonUtility utility = (CommonUtility)this.mCommonUtilityRef.get();
            Handler handler = (Handler)this.mHandlerRef.get();
            if (utility == null || handler == null) {
                return;
            }
            if (state == 0) {
                if (this.phoneStatusNeedResume) {
                    this.phoneStatusNeedResume = false;
                    Logging.d(CommonUtility.TAG, "system phone call end delay 1000ms");
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            utility.onAudioRoutingPhoneChanged(true, 22, 0);
                        }
                    }, 1000L);
                }
            } else if (state == 1) {
                Logging.d(CommonUtility.TAG, "system phone call ring");
                this.phoneStatusNeedResume = true;
                utility.onAudioRoutingPhoneChanged(false, 22, 1);
            } else if (state == 2) {
                Logging.d(CommonUtility.TAG, "system phone call start");
                this.phoneStatusNeedResume = true;
                utility.onAudioRoutingPhoneChanged(false, 22, 2);
            }
        }
    }

    public static interface SystemEventListener {
        public void onAudioRoutingPhoneChanged(boolean var1, int var2, int var3);

        public void onNetworkChange(MediaNetworkInfo var1);

        public void onForegroundChanged(boolean var1);

        public void onGravityOriChange(int var1);

        public void onAddressBound(String var1);
    }
}

