Pod::Spec.new do |s|
    s.name             = 'AgoraLite_iOS'
    s.version          = '{version}'
    s.summary          = 'Agora iOS video SDK'
    s.description      = 'iOS library for agora A/V communication, broadcasting and data channel service.'
    s.homepage         = 'https://docs.agora.io/en/Agora%20Platform/downloads'
    s.license          = { "type" => "Copyright", "text" => "Copyright 2023 agora.io. All rights reserved." }
    s.author           = { "Agora Lab" => "developer@agora.io" }
    s.source           = {source}
    s.platforms        = { :ios => '8.0' }
    s.requires_arc     = true

    s.subspec 'RtcBasic' do |ss|
        ss.vendored_frameworks = "AgoraRtcKit.xcframework", "Agoraffmpeg.xcframework", "AgoraSoundTouch.xcframework"
        ss.weak_frameworks = "AgoraRtcKit", "Agoraffmpeg", "AgoraSoundTouch"
        ss.dependency 'AgoraInfra_iOS', '1.3.0'
    end
    s.subspec 'VideoCodecDec' do |ss|
        ss.vendored_frameworks = "AgoraVideoDecoderExtension.xcframework", "video_dec.xcframework"
        ss.weak_frameworks = "AgoraVideoDecoderExtension", "video_dec"
    end
end
