// swift-tools-version:5.3
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "AgoraLite_iOS",
    defaultLocalization: "en",
    platforms: [.iOS(.v9)],
    products: [
        .library(name: "RtcBasic", targets: ["AgoraRtcKit", "Agoraffmpeg", "AgoraSoundTouch", "AgoraInfra_iOS"]),
        .library(name: "VideoCodecDec", targets: ["AgoraVideoDecoderExtension", "video_dec"]),
    ],
    dependencies: [
        .package(url: "https://github.com/AgoraIO/AgoraInfra_iOS.git", from: "1.3.0")
    ],
    targets: [
        .binaryTarget(
            name: "AgoraRtcKit",
            url: "{AgoraRtcKit_url}",
            checksum: "{AgoraRtcKit_checksum}"
        ),
        .binaryTarget(
            name: "Agoraffmpeg",
            url: "{Agoraffmpeg_url}",
            checksum: "{Agoraffmpeg_checksum}"
        ),
        .binaryTarget(
            name: "AgoraSoundTouch",
            url: "{AgoraSoundTouch_url}",
            checksum: "{AgoraSoundTouch_checksum}"
        ),
        .binaryTarget(
            name: "AgoraVideoDecoderExtension",
            url: "{AgoraVideoDecoderExtension_url}",
            checksum: "{AgoraVideoDecoderExtension_checksum}"
        ),
        .binaryTarget(
            name: "video_dec",
            url: "{video_dec_url}",
            checksum: "{video_dec_checksum}"
        ),
        .target(
            name: "AgoraInfra_iOS",
            dependencies: [
                .product(name: "AgoraInfra_iOS", package: "AgoraInfra_iOS")
            ]
        )
    ]
)
