/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.ColorSpacePrimaries;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.H264Utils;
import io.agora.base.internal.video.VideoCodecStatus;
import io.agora.base.internal.video.VideoCodecType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

@TargetApi(value=18)
class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    public static final int HW_CONFIGURE_FLAG_DECODE = 0;
    private static final String HW_CONFIGURE_DECODE_FLAG = "hw_configure_decode_flag";
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String MTK_PREFIX = "OMX.MTK.";
    static final String HISI_PREFIX = "OMX.hisi.";
    static final String HISI_K3_PREFIX = "OMX.k3.";
    static final String HISI_IMGT_PREFIX = "OMX.IMG.TOPAZ.";
    static final String HISI_IMGM_PREFIX = "OMX.IMG.MSVDX.";
    static final String SPRD_PREFIX = "OMX.sprd.";
    static final String RK_PREFIX = "OMX.rk.";
    static final String AMLOGIC_PREFIX = "OMX.amlogic.";
    static final String ALLWINNER_PREFIX = "OMX.allwinner.";
    static final String MSTAR_PREFIX = "OMX.MS.";
    static final String NVT_PREFIX = "OMX.NVT.";
    static final String[] HW_CODEC_PREFIXS_KNOWN = new String[]{"OMX.Exynos.", "OMX.Intel.", "OMX.Nvidia.", "OMX.qcom.", "OMX.MTK.", "OMX.hisi.", "OMX.k3.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.sprd.", "OMX.rk.", "OMX.amlogic.", "OMX.allwinner.", "OMX.MS.", "OMX.NVT."};
    public static final String[] H264_HW_EXCEPTION_CODECS = new String[]{"OMX.realtek."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int COLOR_FormatYUVP010 = 54;
    static final int COLOR_QCOM_FormatYUVP010VENUS = 2141391882;
    static final int[] DECODER_COLOR_FORMATS_HDR = new int[]{54, 2141391882};
    static final int[] DECODER_COLOR_FORMATS_LT_L = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    @TargetApi(value=21)
    static final int[] DECODER_COLOR_FORMATS_L = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876, 2135033992};
    static final int[] DECODER_COLOR_FORMATS = Build.VERSION.SDK_INT >= 21 ? DECODER_COLOR_FORMATS_L : DECODER_COLOR_FORMATS_LT_L;
    static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS_WITHOUT_YUV420P = new int[]{21, 2141391872, 2141391876};
    static final String[] DEQUEUE_HIGHT_LATENCY_IMEMS_DEVICE_LIST = new String[]{"rk3588_s"};
    static final int[] TEXTURE_COLOR_FORMATS = new int[]{2130708361};

    static int[] encoderColorFormats(String name) {
        if (!TextUtils.isEmpty((CharSequence)name) && (name.startsWith(HISI_IMGT_PREFIX) || name.startsWith(HISI_PREFIX) || name.startsWith(HISI_K3_PREFIX))) {
            return ENCODER_COLOR_FORMATS_WITHOUT_YUV420P;
        }
        return ENCODER_COLOR_FORMATS;
    }

    static boolean yuv420spPreferNV21(String name) {
        return !TextUtils.isEmpty((CharSequence)name) && name.startsWith(ALLWINNER_PREFIX);
    }

    static boolean checkInvalidEncoder(String name) {
        for (String codecPrefix : H264_HW_EXCEPTION_CODECS) {
            if (TextUtils.isEmpty((CharSequence)name) || !name.startsWith(codecPrefix)) continue;
            return true;
        }
        return false;
    }

    static boolean checkInvalidDecoder(String name) {
        return Build.MODEL.toLowerCase().contains("m2102k1c") && !TextUtils.isEmpty((CharSequence)name) && name.startsWith("c2.qti.");
    }

    @Nullable
    static Integer selectColorFormat(int[] supportedColorFormats, MediaCodecInfo.CodecCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        for (int supportedColorFormat : supportedColorFormats) {
            for (int codecColorFormat : capabilities.colorFormats) {
                if (codecColorFormat != supportedColorFormat) continue;
                return codecColorFormat;
            }
        }
        return null;
    }

    static boolean codecSupportsType(MediaCodecInfo info, VideoCodecType type) {
        for (String mimeType : info.getSupportedTypes()) {
            if (!type.mimeType().equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        switch (type) {
            case VP8: 
            case VP9: 
            case H265: 
            case AV1: {
                return new HashMap<String, String>();
            }
            case H264: {
                return H264Utils.getDefaultH264Params(highProfile);
            }
        }
        throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)type));
    }

    static boolean isCodecInPrepareList(String name) {
        for (String codecPrefix : HW_CODEC_PREFIXS_KNOWN) {
            if (!name.startsWith(codecPrefix)) continue;
            return true;
        }
        return false;
    }

    static int applyCustomFlags(String configJson) {
        int configureFlags = 0;
        if (TextUtils.isEmpty((CharSequence)configJson)) {
            return configureFlags;
        }
        try {
            JSONObject jsonObject = new JSONObject(configJson);
            if (jsonObject.has(HW_CONFIGURE_DECODE_FLAG)) {
                configureFlags = (Integer)jsonObject.get(HW_CONFIGURE_DECODE_FLAG);
                Logging.i(TAG, "applying custom flags: " + configureFlags);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "abort applying custom flags: " + e.getMessage());
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        return configureFlags;
    }

    static ByteBuffer getHdrStaticInfo() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(25).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fRX);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fRY);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fGX);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fGY);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fBX);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fBY);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fWX);
        byteBuffer.putShort((short)ColorSpacePrimaries.BT2020.fWY);
        byteBuffer.putShort((short)1000);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)1000);
        byteBuffer.putShort((short)500);
        byteBuffer.rewind();
        return byteBuffer;
    }

    static void applyCustomConfig(MediaFormat format, String configJson) {
        if (format == null || TextUtils.isEmpty((CharSequence)configJson)) {
            return;
        }
        Logging.i(TAG, "applying custom config: " + configJson);
        try {
            JSONObject jsonObject = new JSONObject(configJson);
            Iterator keysIter = jsonObject.keys();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                Object value = jsonObject.get(key);
                if (key.equals(HW_CONFIGURE_DECODE_FLAG)) {
                    Logging.i(TAG, "unsupported config key.");
                    continue;
                }
                if (value instanceof String) {
                    format.setString(key, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    format.setInteger(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof JSONObject) {
                    JSONObject childObject = (JSONObject)value;
                    String childKey = (String)childObject.keys().next();
                    if ("setInteger".equals(key)) {
                        format.setInteger(childKey, childObject.getInt(childKey));
                        continue;
                    }
                    if ("setLong".equals(key)) {
                        format.setLong(childKey, childObject.getLong(childKey));
                        continue;
                    }
                    if ("setFloat".equals(key)) {
                        format.setFloat(childKey, (float)childObject.getDouble(childKey));
                        continue;
                    }
                    if ("setString".equals(key)) {
                        format.setString(childKey, childObject.getString(childKey));
                        continue;
                    }
                    if (!"setFeatureEnabled".equals(key)) continue;
                    if (Build.VERSION.SDK_INT >= 21) {
                        format.setFeatureEnabled(childKey, childObject.getBoolean(childKey));
                        continue;
                    }
                    Logging.e(TAG, "setFeatureEnabled requires api level 21");
                    continue;
                }
                Logging.e(TAG, "unsupported config value type " + value.getClass());
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "abort applying custom config: " + e.getMessage());
            ThrowableExtension.printStackTrace((Throwable)e);
        }
    }

    static VideoCodecStatus isMediaCodecException(RuntimeException error) {
        if (error instanceof IllegalStateException) {
            if (Build.VERSION.SDK_INT >= 21 && error instanceof MediaCodec.CodecException) {
                return VideoCodecStatus.ERROR;
            }
            StackTraceElement[] stackTrace = error.getStackTrace();
            if (stackTrace.length > 0 && stackTrace[0].getClassName().equals("android.media.MediaCodec")) {
                return VideoCodecStatus.ERROR;
            }
        }
        return VideoCodecStatus.FALLBACK_SOFTWARE;
    }

    static boolean useHighLatencyStrategy() {
        for (String model : DEQUEUE_HIGHT_LATENCY_IMEMS_DEVICE_LIST) {
            if (!model.contentEquals(Build.MODEL)) continue;
            return true;
        }
        return false;
    }

    private MediaCodecUtils() {
    }
}

