/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.base.internal.CalledByNative;
import io.agora.rte.Constants;

public class PlayerInfo {
    private long mNativeHandle = this.nativeCreatePlayerInfo();

    @CalledByNative
    public PlayerInfo() {
    }

    protected void finalize() {
        this.destroy();
    }

    @CalledByNative
    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private void destroy() {
        this.nativeReleasePlayerInfo(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    public int state() {
        return this.nativeState(this.mNativeHandle);
    }

    public long duration() {
        return this.nativeDuration(this.mNativeHandle);
    }

    public int streamCount() {
        return this.nativeStreamCount(this.mNativeHandle);
    }

    public boolean hasAudio() {
        return this.nativeHasAudio(this.mNativeHandle);
    }

    public boolean hasVideo() {
        return this.nativeHasVideo(this.mNativeHandle);
    }

    public boolean isAudioMuted() {
        return this.nativeIsAudioMuted(this.mNativeHandle);
    }

    public boolean isVideoMuted() {
        return this.nativeIsVideoMuted(this.mNativeHandle);
    }

    public int videoHeight() {
        return this.nativeVideoHeight(this.mNativeHandle);
    }

    public int videoWidth() {
        return this.nativeVideoWidth(this.mNativeHandle);
    }

    public Constants.AbrSubscriptionLayer abrSubscriptionLayer() {
        return Constants.AbrSubscriptionLayer.fromInt(this.nativeAbrSubscriptionLayer(this.mNativeHandle));
    }

    public int audioSampleRate() {
        return this.nativeAudioSampleRate(this.mNativeHandle);
    }

    public int audioChannels() {
        return this.nativeAudioChannels(this.mNativeHandle);
    }

    public int audioBitsPerSample() {
        return this.nativeAudioBitsPerSample(this.mNativeHandle);
    }

    public String currentUrl() {
        return this.nativeCurrentUrl(this.mNativeHandle);
    }

    private native long nativeCreatePlayerInfo();

    private native void nativeReleasePlayerInfo(long var1);

    private native int nativeState(long var1);

    private native long nativeDuration(long var1);

    private native int nativeStreamCount(long var1);

    private native boolean nativeHasAudio(long var1);

    private native boolean nativeHasVideo(long var1);

    private native boolean nativeIsAudioMuted(long var1);

    private native boolean nativeIsVideoMuted(long var1);

    private native int nativeVideoHeight(long var1);

    private native int nativeVideoWidth(long var1);

    private native int nativeAbrSubscriptionLayer(long var1);

    private native int nativeAudioSampleRate(long var1);

    private native int nativeAudioChannels(long var1);

    private native int nativeAudioBitsPerSample(long var1);

    private native String nativeCurrentUrl(long var1);
}

