/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecType;
import java.nio.ByteBuffer;

public class CodecSpecificInfo {
    @Nullable
    private final ByteBuffer metadata;
    @Nullable
    private ByteBuffer compressed_alpha_buffer;
    public long elapsedRealtime;
    public long opaque;

    public CodecSpecificInfo() {
        this(null, null, 0L);
    }

    public VideoCodecType getVideoCodecType() {
        return VideoCodecType.UNKNOWN;
    }

    public VideoCodecProfile getVideoCodecProfile() {
        return VideoCodecProfile.UNKNOWN;
    }

    @CalledByNative
    public CodecSpecificInfo(long opaque) {
        this.metadata = null;
        this.compressed_alpha_buffer = null;
        this.opaque = opaque;
    }

    @CalledByNative
    public CodecSpecificInfo(ByteBuffer metadata, ByteBuffer compressed_alpha_buffer, long opaque) {
        this.metadata = metadata;
        this.compressed_alpha_buffer = compressed_alpha_buffer;
        this.opaque = opaque;
    }

    public CodecSpecificInfo(ByteBuffer metadata, long elapsedRealtime) {
        this.metadata = metadata;
        this.elapsedRealtime = elapsedRealtime;
        this.opaque = 0L;
    }

    @CalledByNative
    @Nullable
    public ByteBuffer getMetadata() {
        return this.metadata;
    }

    @CalledByNative
    public long getOpaque() {
        return this.opaque;
    }

    @CalledByNative
    @Nullable
    public ByteBuffer getCompressedAlphadata() {
        return this.compressed_alpha_buffer;
    }

    public class CodecSpecificInfoHEVC
    extends CodecSpecificInfo {
        private VideoCodecProfile profile;

        public CodecSpecificInfoHEVC(VideoCodecProfile profile) {
            this.profile = profile;
        }

        @Override
        public VideoCodecType getVideoCodecType() {
            return VideoCodecType.H265;
        }

        @Override
        public VideoCodecProfile getVideoCodecProfile() {
            return this.profile;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }
}

