/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine.earmonitor;

import android.content.Context;
import androidx.annotation.Nullable;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ReflectUtils;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.earmonitor.IHardwareEarMonitor;

public abstract class GsaiHardwareEarMonitor
implements IHardwareEarMonitor {
    private String TAG;
    @Nullable
    private HardwareEarMonitorListener mListener;
    @Nullable
    private Context mContext;
    @Nullable
    private Object mMediaClient = null;
    @Nullable
    private Class<?> mMediaClientClass;
    private volatile boolean mInitialized = false;
    private volatile boolean mEarMonitorEnabled = false;

    public GsaiHardwareEarMonitor(HardwareEarMonitorListener listener, String TAG) {
        this.TAG = TAG;
        this.mListener = listener;
        this.mContext = ContextUtils.getApplicationContext();
        Logging.d(TAG, ">>ctor");
    }

    public static boolean hasEarMonitorClass() {
        Class<?> mediaClientClass = ReflectUtils.safeFindClass("com.itgsa.opensdk.media.MediaClient");
        return mediaClientClass != null;
    }

    @Override
    public void initialize() {
        Logging.d(this.TAG, "HnAudioClient initialize");
        if (this.mContext == null) {
            Logging.e(this.TAG, "mContext is null!");
            return;
        }
        if (this.mInitialized) {
            Logging.w(this.TAG, "already initialized, ignore");
            return;
        }
        try {
            this.mMediaClientClass = ReflectUtils.safeFindClass("com.itgsa.opensdk.media.MediaClient");
            this.mMediaClient = ReflectUtils.safeCallMethod(this.mMediaClientClass, null, "initialize", new Class[]{Context.class}, new Object[]{this.mContext});
            this.mInitialized = true;
            if (this.mListener != null) {
                this.mListener.onInitResult(0);
                this.mListener.onHardwareEarMonitorSupported(this.isHardwareEarMonitorSupported());
            }
            Logging.d(this.TAG, "MediaClient initialize success");
        }
        catch (Throwable e) {
            Logging.d(this.TAG, "MediaClient initialize failed");
        }
    }

    @Override
    public boolean isHardwareEarMonitorSupported() {
        try {
            boolean isSupported = (Boolean)ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "isSupported", new Class[0], new Object[0]);
            Logging.d(this.TAG, "Karaoke earMonitor is" + (isSupported ? " " : " not ") + "support ");
            return isSupported;
        }
        catch (Throwable e) {
            Logging.e(this.TAG, "isHardwareEarMonitorSupported false ", e);
            return false;
        }
    }

    protected abstract int getMixerSoundType();

    @Override
    public int enableHardwareEarMonitor(boolean enable) {
        Logging.d(this.TAG, ">>enableHardwareEarMonitor " + enable);
        try {
            if (enable) {
                ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "setMixerSoundType", new Class[]{Integer.TYPE}, new Object[]{this.getMixerSoundType()});
                ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "setPlayFeedbackParam", new Class[]{Integer.TYPE}, new Object[]{1});
                ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "openKTVDevice", new Class[0], new Object[0]);
            } else {
                ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "setPlayFeedbackParam", new Class[]{Integer.TYPE}, new Object[]{0});
                ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "closeKTVDevice", new Class[0], new Object[0]);
            }
            this.mEarMonitorEnabled = enable;
        }
        catch (Throwable e) {
            Logging.e(this.TAG, "enableHardwareEarMonitor failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public int setHardwareEarMonitorVolume(int vol) {
        if (!this.mEarMonitorEnabled) {
            return -7;
        }
        vol = (int)((double)vol * 0.15);
        Logging.d(this.TAG, ">>setHardwareEarMonitorVolume " + vol);
        try {
            ReflectUtils.safeCallMethod(this.mMediaClientClass, this.mMediaClient, "setMicVolParam", new Class[]{Integer.TYPE}, new Object[]{vol});
        }
        catch (Throwable e) {
            Logging.e(this.TAG, "setHardwareEarMonitorVolume failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.d(this.TAG, "karaoke kit destroy");
        this.mListener = null;
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        this.mEarMonitorEnabled = false;
        this.enableHardwareEarMonitor(false);
    }
}

