/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.rte.Constants;
import io.agora.rte.Rect;
import io.agora.rte.exception.RteException;

public class CanvasConfig {
    private long mNativeHandle = this.nativeCreateCanvasConfig();

    protected void finalize() {
        this.destroy();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void setVideoRenderMode(Constants.VideoRenderMode mode) throws RteException {
        if (mode == null) {
            throw new RteException("mode is null", Constants.ErrorCode.getValue(Constants.ErrorCode.INVALID_ARGUMENT));
        }
        this.nativeSetVideoRenderMode(this.mNativeHandle, Constants.VideoRenderMode.getValue(mode));
    }

    public Constants.VideoRenderMode getVideoRenderMode() throws RteException {
        return Constants.VideoRenderMode.fromInt(this.nativeGetVideoRenderMode(this.mNativeHandle));
    }

    public void setVideoMirrorMode(Constants.VideoMirrorMode mode) throws RteException {
        if (mode == null) {
            throw new RteException("mode is null", Constants.ErrorCode.getValue(Constants.ErrorCode.INVALID_ARGUMENT));
        }
        this.nativeSetVideoMirrorMode(this.mNativeHandle, Constants.VideoMirrorMode.getValue(mode));
    }

    public Constants.VideoMirrorMode getVideoMirrorMode() throws RteException {
        return Constants.VideoMirrorMode.fromInt(this.nativeGetVideoMirrorMode(this.mNativeHandle));
    }

    public void setCropArea(Rect rect) throws RteException {
        this.nativeSetCropArea(this.mNativeHandle, rect);
    }

    public Rect getCropArea() throws RteException {
        return this.nativeGetCropArea(this.mNativeHandle);
    }

    private void destroy() {
        this.nativeReleaseCanvasConfig(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    private native long nativeCreateCanvasConfig();

    private native void nativeReleaseCanvasConfig(long var1);

    private native void nativeSetVideoRenderMode(long var1, int var3);

    private native int nativeGetVideoRenderMode(long var1);

    private native void nativeSetVideoMirrorMode(long var1, int var3);

    private native int nativeGetVideoMirrorMode(long var1);

    private native void nativeSetCropArea(long var1, Rect var3);

    private native Rect nativeGetCropArea(long var1);
}

