/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.VideoCodecStatus;

public interface VideoEncoder {
    @CalledByNative
    public long createNativeVideoEncoder();

    @CalledByNative
    public VideoCodecStatus attachProxyThread();

    @CalledByNative
    public boolean isHardwareEncoder();

    @Nullable
    @CalledByNative
    public VideoHWCodecSpec getVideoHWCodecSpec();

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus flush();

    @CalledByNative
    public VideoCodecStatus resume();

    @CalledByNative
    public VideoCodecStatus detachProxyThread();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2, CodecSpecificInfo var3);

    @CalledByNative
    public VideoCodecStatus setChannelParameters(short var1, long var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public boolean isQcomHardware();

    @CalledByNative
    public String getImplementationName();

    @CalledByNative
    public long getResetCoolDownTimeMs();

    @CalledByNative
    @Nullable
    public EncoderStyle getEncoderStyle();

    public static class EncoderStyle {
        int bitrateAdjustment = 0;
        boolean isNeedResetWhenDownBps = false;
        boolean highProfileSupported;
        int bitrateAdjustNumerator = 1;
        int bitrateAdjustDenominator = 1;

        @CalledByNative(value="EncoderStyle")
        public int getBitrateAdjustment() {
            return this.bitrateAdjustment;
        }

        @CalledByNative(value="EncoderStyle")
        public boolean isNeedResetWhenDownBps() {
            return this.isNeedResetWhenDownBps;
        }

        @CalledByNative(value="EncoderStyle")
        public int getBitrateAdjustNumerator() {
            return this.bitrateAdjustNumerator;
        }

        @CalledByNative(value="EncoderStyle")
        public int getBitrateAdjustDenominator() {
            return this.bitrateAdjustDenominator;
        }

        public String toString() {
            return "EncoderStyle{bitrateAdjustment=" + this.bitrateAdjustment + ", isNeedResetWhenDownBps=" + this.isNeedResetWhenDownBps + ", highProfileSupported=" + this.highProfileSupported + '}';
        }
    }

    public static @interface BitrateAdjustment {
        public static final int NO_ADJUSTMENT = 0;
        public static final int FRAMERATE_ADJUSTMENT = 1;
        public static final int ACTUAL_FRAMERATE_ADJUSTMENT = 2;
        public static final int DYNAMIC_ADJUSTMENT = 3;
        public static final int CONSTANT_UNIT_BITRATE_ADJUSTMENT = 4;
    }

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, int var2, int var3, int var4, int var5, int var6, CodecSpecificInfo var7);

        public void onEncodeReset();

        public void onEncodeBufferPrepared(long var1);
    }

    public static class ScalingSettings {
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        public ScalingSettings(int low, int high) {
            this.on = true;
            this.low = low;
            this.high = high;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on) {
            this.on = on;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on, int low, int high) {
            this.on = on;
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return this.on ? "[ " + this.low + ", " + this.high + " ]" : "OFF";
        }
    }

    public static class VideoHWCodecSpec {
        public final String codecName;
        public final String maxResolution;
        public final int platformid;
        public final int inputType;
        public final int bitrateMode;
        public final int profile;
        public final int minSupportedBitrate;
        public final String supportCodecNames;

        public VideoHWCodecSpec(String codecName, String maxResolution, int bitrateMode, int inputType, int profile, int minSupportedBitrate, String supportCodecNames) {
            this.codecName = codecName;
            this.maxResolution = maxResolution;
            this.bitrateMode = bitrateMode;
            this.inputType = inputType;
            this.profile = profile;
            this.minSupportedBitrate = minSupportedBitrate;
            this.platformid = 4;
            this.supportCodecNames = supportCodecNames;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getCodecName() {
            return this.codecName;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getMaxResolution() {
            return this.maxResolution;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getPlatformid() {
            return this.platformid;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getInputType() {
            return this.inputType;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getBitrateMode() {
            return this.bitrateMode;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getProfile() {
            return this.profile;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getMinSupportedBitrate() {
            return this.minSupportedBitrate;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getSupportCodecNames() {
            return this.supportCodecNames;
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] bitratesBbs) {
            this.bitratesBbs = bitratesBbs;
        }

        public int getSum() {
            int sum = 0;
            int[][] nArray = this.bitratesBbs;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] spatialLayer;
                for (int bitrate : spatialLayer = nArray[i]) {
                    sum += bitrate;
                }
            }
            return sum;
        }
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypes) {
            this.frameTypes = frameTypes;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;
        public final int keyFrameInterval;
        public final int rateControlMode;
        public final boolean expectTexture;

        @CalledByNative(value="Settings")
        public Settings(int numberOfCores, int width, int height, int startBitrate, int maxFramerate, int numberOfSimulcastStreams, boolean automaticResizeOn, int keyFrameInterval, int rateControlMode, boolean expectTexture) {
            this.numberOfCores = numberOfCores;
            this.width = width;
            this.height = height;
            this.startBitrate = startBitrate;
            this.maxFramerate = maxFramerate;
            this.numberOfSimulcastStreams = numberOfSimulcastStreams;
            this.automaticResizeOn = automaticResizeOn;
            this.keyFrameInterval = keyFrameInterval;
            this.rateControlMode = rateControlMode;
            this.expectTexture = expectTexture;
        }

        public Settings(int numberOfCores, int width, int height, int startBitrate, int maxFramerate, boolean automaticResizeOn) {
            this(numberOfCores, width, height, startBitrate, maxFramerate, 1, automaticResizeOn, 0, -1, true);
        }
    }
}

