/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.VideoCodecType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class VideoEncoderUtils {
    private static final String TAG = "HardwareVideoEncoderUtils";
    public static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("Lenovo S90-u", "CHM-CL00", "CHM-TL00H", "CHM-UL00", "E6533", "HUAWEI CRR-UL00", "HUAWEI MT7-TL00", "HONOR H30-L01", "CHE-TL00H", "CHE-TL00", "Che2-TL00", "Che2-TL00M", "HTC D820mt", "HUAWEI P7-L10", "HUAWEI P7-L07", "M5s", "SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060");
    private static final List<String> H265_HW_EXCEPTION_HARDWARES = Arrays.asList("mt6771", "mt6762");
    @Nullable
    private static List<MediaCodecInfo> encodecInfos = null;

    public static int getRecommendedEncoderType() {
        return VideoEncoderUtils.getRecommendedEncoderTypeImpl(Build.MODEL, Build.VERSION.SDK_INT);
    }

    static int getRecommendedEncoderTypeImpl(String model, int version) {
        if (H264_HW_EXCEPTION_MODELS.contains(model)) {
            return 1;
        }
        if (version <= 18) {
            return 1;
        }
        return 0;
    }

    @CalledByNative
    static boolean isSupportHwEncoderByType(String codecType) {
        return VideoCodecType.contains(codecType) && (VideoEncoderUtils.findCodecForType(VideoCodecType.valueOf(codecType), false, false) != null || VideoEncoderUtils.findCodecForType(VideoCodecType.valueOf(codecType), true, false) != null);
    }

    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type, boolean useTexture) {
        return VideoEncoderUtils.findCodecForType(type, useTexture, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type, boolean useTexture, boolean enableGoogle) {
        if (encodecInfos == null) {
            encodecInfos = new ArrayList<MediaCodecInfo>();
            HandlerThread handlerThread = new HandlerThread("encoderInfo_thread");
            try {
                handlerThread.start();
                Handler handler = new Handler(handlerThread.getLooper());
                ThreadUtils.invokeAtFrontUninterruptibly(handler, 3000L, new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                            MediaCodecInfo info = null;
                            try {
                                info = MediaCodecList.getCodecInfoAt((int)i);
                            }
                            catch (IllegalArgumentException e) {
                                Logging.e(VideoEncoderUtils.TAG, "Cannot retrieve encoder codec info", e);
                            }
                            if (info == null || !info.isEncoder()) continue;
                            encodecInfos.add(info);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            finally {
                handlerThread.quit();
            }
        }
        if (encodecInfos == null || encodecInfos.size() == 0) {
            return null;
        }
        for (int i = 0; i < encodecInfos.size(); ++i) {
            MediaCodecInfo info = null;
            info = encodecInfos.get(i);
            boolean softwareOnly = false;
            if (info != null && Build.VERSION.SDK_INT >= 29) {
                softwareOnly = info.isSoftwareOnly();
            }
            if (info == null || !info.isEncoder() || !enableGoogle && softwareOnly || !VideoEncoderUtils.isSupportedCodec(info, type, useTexture)) continue;
            Logging.d(TAG, "found available encodec: " + info.getName());
            return info;
        }
        return null;
    }

    static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type, boolean useTexture) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        try {
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.encoderColorFormats(info.getName()), info.getCapabilitiesForType(type.mimeType())) == null) {
                Logging.e(TAG, "no match color format");
                return false;
            }
        }
        catch (Exception e) {
            Logging.w(TAG, "fail to selectColorFormat, not support mimeType:" + type.mimeType());
            return false;
        }
        if (MediaCodecUtils.checkInvalidEncoder(info.getName())) {
            return false;
        }
        if (useTexture) {
            return VideoEncoderUtils.isHardwareTextureSupportedInCurrentSdk(info, type);
        }
        return VideoEncoderUtils.isHardwareSupportedInCurrentSdk(info, type);
    }

    static boolean isHardwareTextureSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
                    return false;
                }
                if (info.getName().startsWith("OMX.k3.")) {
                    return Build.VERSION.SDK_INT > 19;
                }
                return Build.VERSION.SDK_INT >= 19;
            }
            case H265: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH265();
            }
            case AV1: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkAV1();
            }
            case UNKNOWN: {
                Logging.e(TAG, "UNKNOWN is not excepted!!!");
                return false;
            }
        }
        return false;
    }

    static boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH264(info);
            }
            case H265: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH265();
            }
            case AV1: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkAV1();
            }
            case UNKNOWN: {
                Logging.e(TAG, "UNKNOWN is not excepted!!!");
                return false;
            }
        }
        return false;
    }

    static boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21;
    }

    static boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    static boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    static boolean isHardwareSupportedInCurrentSdkAV1() {
        return Build.VERSION.SDK_INT >= 34;
    }

    static boolean isHardwareSupportedInCurrentSdkH265() {
        if (H265_HW_EXCEPTION_HARDWARES.contains(Build.HARDWARE)) {
            Logging.w(TAG, "Hardware: " + Build.HARDWARE + " has black listed H.265 encoder.");
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    static SupportCodecInfo getSupportedEncoders() {
        int supportCodecs = 0;
        ArrayList<String> infoNames = new ArrayList<String>();
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            boolean softwareOnly = false;
            if (info != null && Build.VERSION.SDK_INT >= 29) {
                softwareOnly = info.isSoftwareOnly();
            }
            if (!info.isEncoder() || softwareOnly) continue;
            for (String mimeType : info.getSupportedTypes()) {
                String infoName = info.getName().toLowerCase();
                if (mimeType.equals(VideoCodecType.VP8.mimeType())) {
                    supportCodecs |= 1;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (mimeType.equals(VideoCodecType.H264.mimeType())) {
                    supportCodecs |= 2;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (mimeType.equals(VideoCodecType.H265.mimeType())) {
                    supportCodecs |= 4;
                    if (infoNames.contains(infoName)) continue;
                    infoNames.add(infoName);
                    continue;
                }
                if (!mimeType.equals(VideoCodecType.AV1.mimeType()) || infoNames.contains(infoName)) continue;
                infoNames.add(infoName);
            }
        }
        return new SupportCodecInfo(supportCodecs, ((Object)infoNames).toString());
    }

    static class SupportCodecInfo {
        private int supportCodecs;
        private String codecNames;

        public SupportCodecInfo(int supportCodecs, String codecNames) {
            this.supportCodecs = supportCodecs;
            this.codecNames = codecNames;
        }

        public int getSupportCodecs() {
            return this.supportCodecs;
        }

        public String getCodecNames() {
            return this.codecNames;
        }
    }
}

