/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.agora.base.FaceDetectionInfo;
import io.agora.base.VideoFrame;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.rtc2.video.IVideoCaptureCamera;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureParameter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

@TargetApi(value=17)
public abstract class VideoCaptureCamera
extends VideoCapture
implements IVideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera.class.getSimpleName();
    private static int cameraSkipCaptureWidth;
    private static int cameraSkipCapturHeight;
    protected static boolean enableCameraCaptureRequestActiveDetect;
    protected final VideoCaptureParameter mParameter;
    protected int mId;
    protected final int mSkipControl;
    protected final boolean mCaptureToTexture;
    protected final boolean mEnableTextureCopy;
    protected static int MAX_CAMERA_TIME_MS;
    protected static final int MAX_CAMERA_TIME_MS_LIMIT = 1000000;
    protected static final int SIZE_WIDTH_OF_2K = 2560;
    protected static final int SIZE_HEIGHT_OF_2K = 1440;
    protected static final int CONTROL_VIDEO_STABILIZATION_MODE_OFF = 0;
    protected static final int CONTROL_VIDEO_STABILIZATION_MODE_ON = 1;
    protected static final int FOCAL_LENGTH_STEP = 6;
    protected static final int FOCAL_LENGTH_TYPE_SUPPORTED_OF_LOGICAL = 1;
    protected static final int FOCAL_LENGTH_TYPE_SUPPORTED_OF_PHYSICAL = 2;
    protected static final int FOCAL_LENGTH_TYPE_SUPPORTED_OF_ZOOM = 3;
    protected static final float FOCAL_LENGTH_WIDE_ANGLE_UPPER_LIMIT = 2.4f;
    protected static final float FOCAL_LENGTH_ULTRA_WIDE_ANGLE_UPPER_LIMIT = 3.5f;
    static final int ANDROID_CAMERA_SKIP_CONTROL_DEFAULT = 0;
    static final int ANDROID_CAMERA_SKIP_CONTROL_AE = 1;
    static final int ANDROID_CAMERA_SKIP_CONTROL_AF = 2;
    protected static final int CAMERA_TEMPLATE_PREVIEW = 0;
    protected static final int CAMERA_TEMPLATE_RECORD = 1;
    protected static final int CONTROL_VIDEO_FOCUS_MODE_NONE = 0;
    protected static final int CONTROL_VIDEO_FOCUS_MODE_AUTO = 1;
    protected static final int CONTROL_VIDEO_FOCUS_MODE_VIDEO = 2;
    protected static final int CONTROL_VIDEO_FOCUS_MODE_PICTURE = 3;
    protected int mCameraTemplateType;
    protected int mCameraFocusMode;
    protected boolean mCameraExtraSurface;
    protected int mCameraNoiseReduction;
    protected boolean mEnableAutoFaceFocus = false;
    protected boolean mEnableFaceDetection = false;
    protected boolean mIsFaceDetectionStarted = false;
    protected boolean mIsCameraTorchStarted;
    protected static final int CAMERA_TORCH_DISENABLE = -1;
    protected static final int CAMERA_TORCH_DEFAULT = 0;
    protected static final int CAMERA_TORCH_ENABLE = 1;
    protected int mTorchMode = 0;
    protected boolean mIsmCameraExposureStarted = false;
    protected float[] mCameraExposurePositions = new float[]{-1.0f, -1.0f};
    protected boolean mIsmCameraFocusStarted = false;
    protected float[] mCameraFocusPositions = new float[]{-1.0f, -1.0f};
    protected boolean mIsmCameraZoomStarted = false;
    protected float mCameraZoomFactor = -1.0f;
    protected int dropCount = 0;
    protected int mCameraExposureCompensation = 0;
    protected int mCameraNoiseReductionMode = 0;
    protected int mCameraAntiBandingMode = 0;
    protected int mCameraVideoStabilityMode = 0;
    protected int mCamerEdgeEnhanceMode = 0;
    protected boolean mFirstVideoFrameCaptured = false;
    protected boolean mIsExposureCompensationStarted = false;
    protected boolean mIsAntiBandingStarted = false;
    protected boolean mIsEdgeEnhanceStarted = false;
    protected boolean mIsStabilityStarted = false;
    protected boolean mIsNoiseReducationStarted = false;
    protected boolean mAutoFaceDetectFocusStarted = false;
    protected static boolean mEnableRefocus;
    protected static boolean mEnableTargetFps;
    protected static boolean mCustomStrictMode;
    protected static int mLowFpsLimit;
    protected Rect lastFocusAreaRect;
    protected int mPQFirstDiff;
    protected int mCustomMinFps;
    protected int mCustomMaxFps;
    @Nullable
    protected CameraManager.AvailabilityCallback mCameraAvailableListener;
    private static final String[] SIZE_HEIGHT_GT_720_BUGGY_DEVICE_LIST;
    private static final String[] SIZE_HEIGHT_1440_BUGGY_DEVICE_LIST;
    static final String[] REFOCUS_BUGGY_DEVICE_LIST;
    protected LinkedBlockingQueue<List<FaceDetectionInfo>> mPerFrameFaceDetectionInfoQueue = new LinkedBlockingQueue();
    CaptureViewWeakRef mRenderView = new CaptureViewWeakRef(null);
    boolean isMirror = false;
    int mRenderMode;

    static void setCameraSkipCaptureWidth(int width) {
        cameraSkipCaptureWidth = width;
    }

    static void setCameraSkipCapturHeight(int height) {
        cameraSkipCapturHeight = height;
    }

    static void enableCameraCaptureRequestActiveDetect(boolean enable) {
        enableCameraCaptureRequestActiveDetect = enable;
    }

    @VisibleForTesting
    static void setLowFpsLimit(int lowFpsLimit) {
        mLowFpsLimit = lowFpsLimit;
    }

    @VisibleForTesting
    static void setEnableTargetFps(boolean enableTargetFps) {
        mEnableTargetFps = enableTargetFps;
    }

    @VisibleForTesting
    static void setCustomStrictMode(boolean customStrictMode) {
        mCustomStrictMode = customStrictMode;
    }

    @VisibleForTesting
    public boolean isEnableAutoFaceFocus() {
        return this.mEnableAutoFaceFocus;
    }

    @VisibleForTesting
    public boolean isEnableFaceDetection() {
        return this.mEnableFaceDetection;
    }

    @VisibleForTesting
    public boolean isFaceDetectionStarted() {
        return this.mIsFaceDetectionStarted;
    }

    @VisibleForTesting
    public void setCameraProxyHandler() {
        HandlerThread thread = new HandlerThread("VideoCaptureCamera_ProxyThread");
        thread.start();
        this.mProxyThreadHandler = new Handler(thread.getLooper());
    }

    VideoCaptureCamera(int id, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean enableTextureCopy, int captureTextureBufferCount, boolean pqFirst, int skipControl, EglBase.Context sharedContext, int templateType, int focusMode, VideoCaptureParameter param) {
        super(nativeVideoCaptureAndroid, sharedContext, captureTextureBufferCount);
        this.mParameter = param;
        this.mId = id;
        this.mPQFirst = pqFirst;
        this.mSkipControl = skipControl;
        this.mCameraTemplateType = templateType;
        this.mCameraFocusMode = focusMode;
        this.mCaptureToTexture = captureToTexture && this.mSurfaceTextureHelper != null;
        this.mEnableTextureCopy = this.mCaptureToTexture && enableTextureCopy;
        this.mCameraExtraSurface = param.extraSurface;
        this.mCameraNoiseReduction = param.noiseReduce;
        this.mPQFirstDiff = param.pqFirstDiff;
        this.mCustomMinFps = param.customMinFps;
        this.mCustomMaxFps = param.customMaxFps;
        if (Build.MODEL.toLowerCase().contains("redmi 4a")) {
            MAX_CAMERA_TIME_MS = 50000;
        }
        if (param.cameraTimeout > 0 && param.cameraTimeout < 1000000) {
            MAX_CAMERA_TIME_MS = param.cameraTimeout;
        }
        Logging.i(TAG, "VideoCaptureCamera info ,mId:" + this.mId + ",mPQFirst:" + this.mPQFirst + ",mCaptureToTexture:" + this.mCaptureToTexture + ",mCaptureTextureBufferCount:" + captureTextureBufferCount + ",mEnableTextureCopy:" + this.mEnableTextureCopy + " ,autoFaceDetect:" + param.faceFocusing);
    }

    static boolean shouldExcludeSize(int width, int height) {
        if (width == cameraSkipCaptureWidth) {
            Logging.w(TAG, "camera capture skip width: " + width);
            return true;
        }
        if (height == cameraSkipCapturHeight) {
            Logging.w(TAG, "camera capture skip height: " + width);
            return true;
        }
        if (height > 720) {
            for (String buggyDevice : SIZE_HEIGHT_GT_720_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return true;
            }
        }
        if (width > 2560 || height > 1440 || width * height > 3686400) {
            for (String buggyDevice : SIZE_HEIGHT_1440_BUGGY_DEVICE_LIST) {
                if (!Build.MODEL.contains(buggyDevice)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean shouldSkipRefocus() {
        for (String buggyDevice : REFOCUS_BUGGY_DEVICE_LIST) {
            if (!Build.MODEL.toLowerCase().contains(buggyDevice)) continue;
            return true;
        }
        return !mEnableRefocus;
    }

    protected static VideoCapture.FramerateRange getClosestFramerateRange(List<VideoCapture.FramerateRange> framerateRanges, final int targetFramerate) {
        return Collections.min(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                return value < threshold ? value * lowWeight : threshold * lowWeight + (value - threshold) * highWeight;
            }

            int diff(VideoCapture.FramerateRange range) {
                int minFpsError = this.progressivePenalty(range.min, 8000, 1, 4);
                int maxFpsError = this.progressivePenalty(Math.abs(targetFramerate - range.max), 5000, 1, 3);
                return minFpsError + maxFpsError;
            }

            @Override
            public int compare(VideoCapture.FramerateRange range1, VideoCapture.FramerateRange range2) {
                return this.diff(range1) - this.diff(range2);
            }
        });
    }

    @Nullable
    private static VideoCapture.FramerateRange findBestFrameRateRangePreferFPS(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate) {
        Collections.sort(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){

            @Override
            public int compare(VideoCapture.FramerateRange o1, VideoCapture.FramerateRange o2) {
                int result = o1.min - o2.min;
                return result == 0 ? o1.max - o2.max : result;
            }
        });
        Logging.i(TAG, "sorted fps Ranges List order by min first:" + framerateRanges.toString());
        for (VideoCapture.FramerateRange range : framerateRanges) {
            if (range.min < targetFramerate) continue;
            Logging.i(TAG, "set fps : " + range.toString() + " to camera in fps first mode, request:" + targetFramerate);
            return range;
        }
        return null;
    }

    @Nullable
    private static VideoCapture.FramerateRange findBestFrameRateRangePreferPQ(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate, int pqFirstType, int pqFirstDiff) {
        Collections.sort(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){

            @Override
            public int compare(VideoCapture.FramerateRange o1, VideoCapture.FramerateRange o2) {
                int result = o1.max - o2.max;
                return result == 0 ? o1.min - o2.min : result;
            }
        });
        Logging.i(TAG, "sorted fps Ranges List order by max first:" + framerateRanges.toString());
        if (pqFirstType == 0) {
            for (VideoCapture.FramerateRange range : framerateRanges) {
                if (range.max < targetFramerate) continue;
                Logging.i(TAG, "set fps : " + range.toString() + " to camera in PQ first mode, request:" + targetFramerate);
                return range;
            }
        } else if (pqFirstType == 2) {
            int maxMin = Integer.MAX_VALUE;
            ArrayList<Integer> candidateIndices = new ArrayList<Integer>();
            for (int i = 0; i < framerateRanges.size(); ++i) {
                VideoCapture.FramerateRange range = framerateRanges.get(i);
                if (range.max < targetFramerate || targetFramerate < range.min || VideoCaptureCamera.overLowFpsLimit(range.min)) continue;
                int minVal = range.min;
                if (minVal < maxMin) {
                    maxMin = minVal;
                    candidateIndices.clear();
                    candidateIndices.add(i);
                    continue;
                }
                if (minVal != maxMin) continue;
                candidateIndices.add(i);
            }
            if (!candidateIndices.isEmpty()) {
                Logging.i(TAG, "set fps, fps ranges contain target were found: " + ((Object)candidateIndices).toString());
                int minMaxDiff = Integer.MAX_VALUE;
                int bestIndex = (Integer)candidateIndices.get(0);
                Iterator minVal = candidateIndices.iterator();
                while (minVal.hasNext()) {
                    int index = (Integer)minVal.next();
                    VideoCapture.FramerateRange range = framerateRanges.get(index);
                    int maxDiff = range.max - range.min;
                    if (maxDiff >= minMaxDiff) continue;
                    minMaxDiff = maxDiff;
                    bestIndex = index;
                }
                VideoCapture.FramerateRange range = framerateRanges.get(bestIndex);
                if (mEnableTargetFps) {
                    range.max = targetFramerate;
                }
                Logging.i(TAG, "set fps : " + range.toString() + " to camera in PQ first mode: " + pqFirstType + ", request:" + targetFramerate);
                return range;
            }
            Logging.i(TAG, "set fps, fps ranges not contain target: " + targetFramerate);
            int minDistance = Integer.MAX_VALUE;
            int bestIndex = -1;
            Logging.i(TAG, "set fps, by minimum limit mode, find index: " + bestIndex);
            for (int i = 0; i < framerateRanges.size(); ++i) {
                VideoCapture.FramerateRange range = framerateRanges.get(i);
                int distance = targetFramerate < range.min ? range.min - targetFramerate : (targetFramerate > range.max ? targetFramerate - range.max : 0);
                if (distance >= minDistance) continue;
                minDistance = distance;
                bestIndex = i;
            }
            if (bestIndex != -1) {
                VideoCapture.FramerateRange range = framerateRanges.get(bestIndex);
                if (mEnableTargetFps && range.max != targetFramerate && targetFramerate >= range.min && targetFramerate <= range.max) {
                    range.max = targetFramerate;
                }
                Logging.i(TAG, "set fps : " + range + " to camera in PQ first mode: " + pqFirstType + ", request:" + targetFramerate);
                return range;
            }
        } else {
            int diff = 0;
            int bestIndex = -1;
            for (int i = 0; i < framerateRanges.size(); ++i) {
                int temp;
                VideoCapture.FramerateRange range = framerateRanges.get(i);
                if (range.max < targetFramerate || targetFramerate < range.min || VideoCaptureCamera.overLowFpsLimit(range.min) || (temp = targetFramerate - range.min) <= diff) continue;
                diff = temp;
                bestIndex = i;
                if (diff >= pqFirstDiff) break;
            }
            Logging.i(TAG, "set fps, by pqFirst diff mode, find index: " + bestIndex);
            if (bestIndex != -1) {
                VideoCapture.FramerateRange range = framerateRanges.get(bestIndex);
                if (mEnableTargetFps && range.max != targetFramerate && targetFramerate >= range.min && targetFramerate <= range.max) {
                    range.max = targetFramerate;
                }
                Logging.i(TAG, "set fps : " + range.toString() + " to camera in PQ first mode, " + (mEnableTargetFps ? "by target fps " : " by full fps") + ", request:" + targetFramerate);
                return range;
            }
        }
        return null;
    }

    static boolean overLowFpsLimit(int min) {
        boolean overLowLimit = false;
        if (mLowFpsLimit > 0 && min < mLowFpsLimit * 1000) {
            overLowLimit = true;
        }
        return overLowLimit;
    }

    @Nullable
    private static VideoCapture.FramerateRange findBestFrameRateRangeCustomRange(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate, int customMinFps, int customMaxFps) {
        int adjustedMinFps = Math.min(customMinFps, targetFramerate);
        int adjustedMaxFps = Math.max(customMaxFps, targetFramerate);
        ArrayList<Integer> containingTargetIndices = new ArrayList<Integer>();
        for (int i = 0; i < framerateRanges.size(); ++i) {
            VideoCapture.FramerateRange range = framerateRanges.get(i);
            if (mCustomStrictMode) {
                if (range.max != customMaxFps || range.min != customMinFps) continue;
                Logging.i(TAG, "set fps, by customRange strictMode, find index: " + i);
                return range;
            }
            if (range.max < targetFramerate || targetFramerate < range.min || VideoCaptureCamera.overLowFpsLimit(range.min)) continue;
            containingTargetIndices.add(i);
        }
        if (!containingTargetIndices.isEmpty()) {
            Object range;
            int minDistanceToCustom;
            VideoCapture.FramerateRange range2;
            int index;
            int minDistance = Integer.MAX_VALUE;
            int bestIndex = -1;
            Iterator iterator = containingTargetIndices.iterator();
            while (iterator.hasNext()) {
                index = (Integer)iterator.next();
                range2 = framerateRanges.get(index);
                if (adjustedMinFps < range2.min || (minDistanceToCustom = Math.abs(range2.min - adjustedMinFps)) >= minDistance) continue;
                minDistance = minDistanceToCustom;
                bestIndex = index;
            }
            Logging.i(TAG, "set fps, by customRange lower limit, find index: " + bestIndex);
            if (bestIndex != -1) {
                range = framerateRanges.get(bestIndex);
                if (mEnableTargetFps && ((VideoCapture.FramerateRange)range).max != targetFramerate && targetFramerate >= ((VideoCapture.FramerateRange)range).min && targetFramerate <= ((VideoCapture.FramerateRange)range).max) {
                    ((VideoCapture.FramerateRange)range).max = targetFramerate;
                }
                Logging.i(TAG, "set fps : " + ((VideoCapture.FramerateRange)range).toString() + " to camera in custom range mode, request:" + targetFramerate);
                return range;
            }
            minDistance = Integer.MAX_VALUE;
            range = containingTargetIndices.iterator();
            while (range.hasNext()) {
                index = (Integer)range.next();
                range2 = framerateRanges.get(index);
                minDistanceToCustom = Math.abs(range2.min - adjustedMinFps);
                if (minDistanceToCustom >= minDistance) continue;
                minDistance = minDistanceToCustom;
                bestIndex = index;
            }
            Logging.i(TAG, "set fps, by customRange closet mode, find index: " + bestIndex);
            if (bestIndex != -1) {
                range = framerateRanges.get(bestIndex);
                if (mEnableTargetFps && ((VideoCapture.FramerateRange)range).max != targetFramerate && targetFramerate >= ((VideoCapture.FramerateRange)range).min && targetFramerate <= ((VideoCapture.FramerateRange)range).max) {
                    ((VideoCapture.FramerateRange)range).max = targetFramerate;
                }
                Logging.i(TAG, "set fps : " + ((VideoCapture.FramerateRange)range).toString() + " to camera in custom range mode, request:" + targetFramerate);
                return range;
            }
        }
        return null;
    }

    @Nullable
    static VideoCapture.FramerateRange findBestFrameRateRange(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate, boolean pqFirst, int pqFirstType, int PQFirstDiff, int customMinFps, int customMaxFps) {
        if (framerateRanges.isEmpty()) {
            return null;
        }
        Logging.i(TAG, "findBestFrameRateRange " + framerateRanges.toString());
        VideoCapture.FramerateRange result = pqFirst ? (customMinFps > 0 && customMaxFps > 0 ? VideoCaptureCamera.findBestFrameRateRangeCustomRange(framerateRanges, targetFramerate, customMinFps, customMaxFps) : VideoCaptureCamera.findBestFrameRateRangePreferPQ(framerateRanges, targetFramerate, pqFirstType, PQFirstDiff)) : VideoCaptureCamera.findBestFrameRateRangePreferFPS(framerateRanges, targetFramerate);
        if (result == null) {
            Logging.e(TAG, "Failed to find match fps in " + (pqFirst ? "PQ" : " FPS") + " first mode, try closest.");
            result = VideoCaptureCamera.getClosestFramerateRange(framerateRanges, targetFramerate);
        }
        return result;
    }

    @VisibleForTesting
    @NonNull
    public abstract List<VideoCapture.FramerateRange> getSupportFramerateRanges();

    @VisibleForTesting
    @NonNull
    public abstract VideoCapture.FramerateRange getSelectedFramerateRange();

    protected void notifyCameraFocusAreaChanged(Rect focusRect) {
        if (this.mNativeVideoCaptureAndroid != 0L) {
            this.nativeNotifyCameraFocusAreaChanged(this.mNativeVideoCaptureAndroid, focusRect.width(), focusRect.height(), focusRect.left, focusRect.top);
        }
    }

    protected void notifyFaceDetection(int imageWidth, int imageHeight, ArrayList<RectF> faceArray, ArrayList<Double> distanceArray) {
        int size = faceArray.size();
        if (this.mNativeVideoCaptureAndroid != 0L && size > 0) {
            ArrayList<FaceDetectionInfo> list = new ArrayList<FaceDetectionInfo>();
            for (int i = 0; i <= size - 1; ++i) {
                Rect rc = new Rect();
                faceArray.get(i).round(rc);
                list.add(new FaceDetectionInfo(i, rc, distanceArray.get(i)));
            }
            this.mPerFrameFaceDetectionInfoQueue.offer(list);
        }
    }

    protected void notifyCameraExposureAreaChanged(Rect rect) {
        if (this.mNativeVideoCaptureAndroid != 0L) {
            this.nativeNotifyCameraExposureAreaChanged(this.mNativeVideoCaptureAndroid, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, rect.left, rect.top);
        }
    }

    @RequiresApi(value=21)
    protected void registerCameraAvailableCallback(CameraManager manager) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ContextUtils.getApplicationContext() == null) {
            return;
        }
        if (manager == null) {
            manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        }
        if (manager == null) {
            return;
        }
        if (this.mCameraAvailableListener != null) {
            return;
        }
        try {
            this.mCameraAvailableListener = new CameraAvailabilityCallback();
            Logging.i(TAG, "register CameraAvailablyCallback");
            manager.registerAvailabilityCallback(this.mCameraAvailableListener, this.mProxyThreadHandler);
        }
        catch (RuntimeException ex) {
            Logging.w(TAG, "registerAvailabilityCallback error " + ex.getMessage());
        }
    }

    protected void unRegisterAvailabilityCallback() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (this.mCameraAvailableListener == null) {
            return;
        }
        if (ContextUtils.getApplicationContext() == null) {
            return;
        }
        try {
            CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
            if (manager == null) {
                manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
            }
            if (manager == null) {
                return;
            }
            manager.unregisterAvailabilityCallback(this.mCameraAvailableListener);
            this.mCameraAvailableListener = null;
            Logging.i(TAG, "unregister Camera AvailabilityCallback done.");
        }
        catch (RuntimeException ex) {
            Logging.w(TAG, "unregisterAvailabilityCallback error " + ex.getMessage());
        }
    }

    @Override
    public void setPreviewInfo(Object view, boolean mirror, int renderMode) {
        this.isMirror = mirror;
        this.mRenderMode = renderMode;
        if (view instanceof View) {
            this.mRenderView = new CaptureViewWeakRef((View)view);
            Logging.i(TAG, "setPreviewInfo " + this.mRenderView.getWidth() + " x " + this.mRenderView.getHeight());
        } else {
            Logging.i(TAG, "setPreviewInfo ");
        }
        if (!this.mIsmCameraFocusStarted && this.mCameraFocusPositions[0] > 0.0f && this.mCameraFocusPositions[1] > 0.0f) {
            this.setFocus(this.mCameraFocusPositions[0], this.mCameraFocusPositions[1]);
        }
        if (!this.mIsmCameraExposureStarted && this.mCameraExposurePositions[0] > 0.0f && this.mCameraExposurePositions[1] > 0.0f) {
            this.setExposure(this.mCameraExposurePositions[0], this.mCameraExposurePositions[1]);
        }
    }

    protected native void nativeNotifyCameraFocusAreaChanged(long var1, int var3, int var4, int var5, int var6);

    protected native void nativeNotifyCameraExposureAreaChanged(long var1, int var3, int var4, int var5, int var6);

    protected void attachPerFrameMetaInfos(VideoFrame videoFrame) {
        if (this.mPerFrameFaceDetectionInfoQueue.isEmpty()) {
            return;
        }
        ArrayList faceDetectionInfoList = (ArrayList)this.mPerFrameFaceDetectionInfoQueue.poll();
        if (faceDetectionInfoList != null) {
            for (FaceDetectionInfo faceDetectionInfo : faceDetectionInfoList) {
                videoFrame.getMetaInfo().getCustomMetaInfo(FaceDetectionInfo.class.getSimpleName()).put(faceDetectionInfo.getId(), (Object)faceDetectionInfo);
            }
        }
    }

    protected VideoFrameMetaInfo getPerFrameMetaInfos() {
        VideoFrameMetaInfo metaInfo = new VideoFrameMetaInfo();
        if (this.mPerFrameFaceDetectionInfoQueue.isEmpty()) {
            return metaInfo;
        }
        ArrayList faceDetectionInfoList = (ArrayList)this.mPerFrameFaceDetectionInfoQueue.poll();
        if (faceDetectionInfoList != null) {
            for (FaceDetectionInfo faceDetectionInfo : faceDetectionInfoList) {
                metaInfo.getCustomMetaInfo(FaceDetectionInfo.class.getSimpleName()).put(faceDetectionInfo.getId(), (Object)faceDetectionInfo);
            }
        }
        return metaInfo;
    }

    protected abstract void onCameraAvailable(String var1);

    protected abstract void onCameraUnavailable(String var1);

    static {
        MAX_CAMERA_TIME_MS = 2000;
        mEnableRefocus = true;
        mEnableTargetFps = false;
        mCustomStrictMode = false;
        mLowFpsLimit = 0;
        SIZE_HEIGHT_GT_720_BUGGY_DEVICE_LIST = new String[]{"Lenovo K520"};
        SIZE_HEIGHT_1440_BUGGY_DEVICE_LIST = new String[]{"PDBM00"};
        REFOCUS_BUGGY_DEVICE_LIST = new String[]{"noh-al00"};
    }

    protected class CaptureViewWeakRef<V>
    extends WeakReference<View> {
        public CaptureViewWeakRef(View referent) {
            super(referent);
        }

        public int getWidth() {
            int captureWidth = VideoCaptureCamera.this.mCaptureFormat == null ? 0 : VideoCaptureCamera.this.mCaptureFormat.mWidth;
            return this.get() == null ? captureWidth : ((View)this.get()).getWidth();
        }

        public int getHeight() {
            int captureHeight = VideoCaptureCamera.this.mCaptureFormat == null ? 0 : VideoCaptureCamera.this.mCaptureFormat.mHeight;
            return this.get() == null ? captureHeight : ((View)this.get()).getHeight();
        }
    }

    @RequiresApi(value=21)
    class CameraAvailabilityCallback
    extends CameraManager.AvailabilityCallback {
        CameraAvailabilityCallback() {
        }

        public synchronized void onCameraAvailable(String cameraId) {
            super.onCameraAvailable(cameraId);
            Logging.i(TAG, "onCameraAvailable: " + cameraId);
            VideoCaptureCamera.this.onCameraAvailable(cameraId);
        }

        public synchronized void onCameraUnavailable(String cameraId) {
            super.onCameraUnavailable(cameraId);
            Logging.w(TAG, "onCameraUnavailable: " + cameraId);
            VideoCaptureCamera.this.onCameraUnavailable(cameraId);
        }

        public void onCameraAccessPrioritiesChanged() {
            super.onCameraAccessPrioritiesChanged();
            Logging.w(TAG, "Camera Access Priorities Changed");
        }
    }
}

