/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import io.agora.rtc2.IVideoEffectObject;
import io.agora.rtc2.internal.RtcEngineImpl;
import io.agora.utils2.internal.Logging;
import java.lang.ref.WeakReference;

public class VideoEffectObjectImpl
implements IVideoEffectObject {
    private static final String TAG = VideoEffectObjectImpl.class.getSimpleName();
    private WeakReference<RtcEngineImpl> mEngineReference;
    private final String mBundlePath;

    public VideoEffectObjectImpl(RtcEngineImpl rtcEngineImpl, String bundlePath) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(rtcEngineImpl);
        this.mBundlePath = bundlePath;
    }

    @Override
    public int addOrUpdateVideoEffect(int nodeId, String templateName) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.addOrUpdateVideoEffect(nodeId, templateName);
    }

    @Override
    public int removeVideoEffect(int nodeId) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.removeVideoEffect(nodeId);
    }

    @Override
    public int performVideoEffectAction(int nodeId, IVideoEffectObject.VIDEO_EFFECT_ACTION actionId) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.performVideoEffectAction(nodeId, actionId.getValue());
    }

    @Override
    public int setVideoEffectFloatParam(String option, String key, float value) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.setVideoEffectFloatParam(option, key, value);
    }

    @Override
    public int setVideoEffectIntParam(String option, String key, int value) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.setVideoEffectIntParam(option, key, value);
    }

    @Override
    public int setVideoEffectBoolParam(String option, String key, boolean value) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return -7;
        }
        return engine.setVideoEffectBoolParam(option, key, value);
    }

    @Override
    public float getVideoEffectFloatParam(String option, String key) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return 0.0f;
        }
        return engine.getVideoEffectFloatParam(option, key);
    }

    @Override
    public int getVideoEffectIntParam(String option, String key) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return 0;
        }
        return engine.getVideoEffectIntParam(option, key);
    }

    @Override
    public boolean getVideoEffectBoolParam(String option, String key) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            Logging.e(TAG, "RtcEngine has been destroyed");
            return false;
        }
        return engine.getVideoEffectBoolParam(option, key);
    }

    private static enum VALUE_TYPE {
        BOOL_VALUE,
        INT_VALUE,
        FLOAT_VALUE;

        private final int ordinal = this.ordinal();

        public int getValue() {
            return this.ordinal;
        }
    }
}

