#include <unistd.h>

#include <thread>
#include <string>
#include "Testhelper/agoraTest.h"
#include "common/file_parser/helper_h264_parser.h"
#include "common/helper.h"
#include "common/sample_common.h"
#include "common/opt_parser.h"

enum TaskType { H264Task = 1, PcmTask, YuvTask };

void TestTask(agora::base::IAgoraService* service, const char* Channel, const char* filename,
              TaskType taskType, bool& flag, int time) {
  agoraTest ag(service, time);
  ag.setConfiguration();
  ag.initializeAndconnect(Channel);
  switch (taskType) {
    case H264Task:
      ag.sendH264Task(filename, 30, flag);
      break;
    case PcmTask:
      ag.sendPcmTask(filename, 1, 16000, flag);
      break;
    case YuvTask:
      ag.sendYuvTask(filename, 15, 352, 288, flag);
      break;
    default:
      break;
  }
  ag.release();
}

int main(int argc, char* argv[]) {
  opt_parser optParser;
  int T = -1;
  int sleepTime = 500;
  optParser.add_long_opt("testtime", &T, "testime (second)");
  optParser.add_long_opt("sleeptime", &sleepTime, "sleeptime (ms)");

  if ((argc <= 1) || !optParser.parse_opts(argc, argv)) {
    std::ostringstream strStream;
    optParser.print_usage(argv[0], strStream);
    std::cout << strStream.str() << std::endl;
    return -1;
  }

  agora::base::IAgoraService* service = createAndInitAgoraService(false, true, true);
  if (!service) {
    AG_LOG(ERROR, "Failed to creating Agora service!");
  }
  bool flag = false;
  int TaskCount = 0;
  // your can set your test case time by this
  agoraTestTimer time(T);

  while (time.CheckTime() && !flag) {
    std::string channelname = "agoratest";
    int t1 = rand() % 5 + 2;
    int t2 = rand() % 500;
    int t3 = rand() % 5 + 2;
    channelname += std::to_string(TaskCount);
    std::thread* TestTaskThread1 =
        new std::thread(TestTask, service, channelname.c_str(), "test_data/send_video.h264",
                        H264Task, std::ref(flag), t1);
    TestTaskThread1->detach();
    usleep(t2 * 1000);
    std::thread* TestTaskThread2 =
        new std::thread(TestTask, service, channelname.c_str(), "test_data/send_audio_16k_1ch.pcm",
                        PcmTask, std::ref(flag), t3);
    TestTaskThread2->detach();
    usleep(sleepTime * 1000);
    printf("task count is : %d \n", TaskCount++);
  }

  sleep(8);
  service->release();
  return 0;
}
