Pod::Spec.new do |s|
    s.name             = 'ShengwangRtcEngine_macOS'
    s.version          = '{version}'
    s.summary          = 'Shengwang macOS video SDK'
    s.description      = 'macOS library for shengwang A/V communication, broadcasting and data channel service.'
    s.homepage         = 'https://docs.agora.io/en/Agora%20Platform/downloads'
    s.license          = { "type" => "Copyright", "text" => "Copyright 2023 agora.io. All rights reserved." }
    s.author           = { "Agora Lab" => "developer@agora.io" }
    s.source           = {source}
    s.platforms        = { :osx => '10.10' }
    s.requires_arc     = true

    s.subspec 'RtcBasic' do |ss|
        ss.vendored_frameworks = "AgoraRtcKit.xcframework", "Agorafdkaac.xcframework", "Agoraffmpeg.xcframework", "AgoraSoundTouch.xcframework"
        ss.weak_frameworks = "AgoraRtcKit", "Agorafdkaac", "Agoraffmpeg", "AgoraSoundTouch"
        ss.dependency 'ShengwangInfra_macOS', '1.3.2.1'
    end
    s.subspec 'AINS' do |ss|
        ss.vendored_frameworks = "AgoraAiNoiseSuppressionExtension.xcframework"
        ss.weak_frameworks = "AgoraAiNoiseSuppressionExtension"
    end
    s.subspec 'AINSLL' do |ss|
        ss.vendored_frameworks = "AgoraAiNoiseSuppressionLLExtension.xcframework"
        ss.weak_frameworks = "AgoraAiNoiseSuppressionLLExtension"
    end
    s.subspec 'AudioBeauty' do |ss|
        ss.vendored_frameworks = "AgoraAudioBeautyExtension.xcframework"
        ss.weak_frameworks = "AgoraAudioBeautyExtension"
    end
    s.subspec 'ClearVision' do |ss|
        ss.vendored_frameworks = "AgoraClearVisionExtension.xcframework"
        ss.weak_frameworks = "AgoraClearVisionExtension"
    end
    s.subspec 'ContentInspect' do |ss|
        ss.vendored_frameworks = "AgoraContentInspectExtension.xcframework"
        ss.weak_frameworks = "AgoraContentInspectExtension"
    end
    s.subspec 'SpatialAudio' do |ss|
        ss.vendored_frameworks = "AgoraSpatialAudioExtension.xcframework"
        ss.weak_frameworks = "AgoraSpatialAudioExtension"
    end
    s.subspec 'VirtualBackground' do |ss|
        ss.vendored_frameworks = "AgoraVideoSegmentationExtension.xcframework"
        ss.weak_frameworks = "AgoraVideoSegmentationExtension"
    end
    s.subspec 'AIAEC' do |ss|
        ss.vendored_frameworks = "AgoraAiEchoCancellationExtension.xcframework"
        ss.weak_frameworks = "AgoraAiEchoCancellationExtension"
    end
    s.subspec 'AIAECLL' do |ss|
        ss.vendored_frameworks = "AgoraAiEchoCancellationLLExtension.xcframework"
        ss.weak_frameworks = "AgoraAiEchoCancellationLLExtension"
    end
    s.subspec 'VQA' do |ss|
        ss.vendored_frameworks = "AgoraVideoQualityAnalyzerExtension.xcframework"
        ss.weak_frameworks = "AgoraVideoQualityAnalyzerExtension"
    end
    s.subspec 'FaceDetection' do |ss|
        ss.vendored_frameworks = "AgoraFaceDetectionExtension.xcframework"
        ss.weak_frameworks = "AgoraFaceDetectionExtension"
    end
    s.subspec 'FaceCapture' do |ss|
        ss.vendored_frameworks = "AgoraFaceCaptureExtension.xcframework"
        ss.weak_frameworks = "AgoraFaceCaptureExtension"
    end
    s.subspec 'LipSync' do |ss|
        ss.vendored_frameworks = "AgoraLipSyncExtension.xcframework"
        ss.weak_frameworks = "AgoraLipSyncExtension"
    end
    s.subspec 'VideoCodecEnc' do |ss|
        ss.vendored_frameworks = "AgoraVideoEncoderExtension.xcframework", "video_enc.xcframework"
        ss.weak_frameworks = "AgoraVideoEncoderExtension", "video_enc"
    end
    s.subspec 'VideoCodecDec' do |ss|
        ss.vendored_frameworks = "video_dec.xcframework"
        ss.weak_frameworks = "video_dec"
    end
    s.subspec 'VideoAv1CodecEnc' do |ss|
        ss.vendored_frameworks = "AgoraVideoAv1EncoderExtension.xcframework"
        ss.weak_frameworks = "AgoraVideoAv1EncoderExtension"
    end
    s.subspec 'ScreenCapture' do |ss|
        ss.vendored_frameworks = "AgoraScreenCaptureExtension.xcframework"
        ss.weak_frameworks = "AgoraScreenCaptureExtension"
    end
end
