/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import io.agora.base.IMetaInfo;
import io.agora.base.VideoFrame;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.CalledByNative;

public final class FaceCaptureInfo
implements IMetaInfo {
    public static final String TAG = FaceCaptureInfo.class.getSimpleName();
    private String mInfoStr;

    @CalledByNative
    public FaceCaptureInfo(String infoStr) {
        this.mInfoStr = infoStr;
    }

    @Override
    @CalledByNative
    public int getId() {
        return 0;
    }

    @Override
    @CalledByNative
    public String getTag() {
        return TAG;
    }

    @CalledByNative
    public String getInfoStr() {
        return this.mInfoStr;
    }

    public String toString() {
        return this.mInfoStr;
    }

    @CalledByNative
    public static void addFaceCapInfoToFrame(FaceCaptureInfo faceCapInfo, VideoFrame frame) {
        VideoFrameMetaInfo metaInfo = frame.getMetaInfo();
        metaInfo.setCustomMetaInfo(new IMetaInfo[]{faceCapInfo});
    }

    @CalledByNative
    public static FaceCaptureInfo extractFaceCaptureInfoFromVideoFrame(VideoFrame frame, int id) {
        VideoFrameMetaInfo metaInfo = frame.getMetaInfo();
        return (FaceCaptureInfo)metaInfo.getCustomMetaInfoAt(TAG, id);
    }
}

