/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.JavaP010Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import java.nio.ByteBuffer;

public class WrappedNativeP010Buffer
extends JavaP010Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final int strideY;
    private final ByteBuffer dataUV;
    private final int strideUV;
    private final long nativeBuffer;

    @CalledByNative
    public WrappedNativeP010Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataUV, int strideUV, long nativeBuffer) {
        super(width, height, dataY, strideY, dataUV, strideUV, null);
        this.width = width;
        this.height = height;
        this.dataY = dataY;
        this.strideY = strideY;
        this.dataUV = dataUV;
        this.strideUV = strideUV;
        this.nativeBuffer = nativeBuffer;
        this.retain();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataUV() {
        return this.dataUV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideUV() {
        return this.strideUV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return super.toI420();
    }

    @Override
    public void retain() {
        if (this.nativeBuffer != 0L) {
            JniCommon.nativeAddRef(this.nativeBuffer);
        }
    }

    @Override
    public void release() {
        if (this.nativeBuffer != 0L) {
            JniCommon.nativeReleaseRef(this.nativeBuffer);
        }
    }

    @Override
    @Nullable
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer mirror(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer rotate(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        return null;
    }
}

