/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal;

import android.content.Context;
import android.os.Process;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;

public class PermissionChecker {
    static boolean forceCheckPermissionFail = false;

    @CalledByNative
    public static boolean hasRecordAudioPermission() {
        return PermissionChecker.hasPermission("android.permission.RECORD_AUDIO");
    }

    @CalledByNative
    public static boolean hasCameraPermission() {
        return PermissionChecker.hasPermission("android.permission.CAMERA");
    }

    @CalledByNative
    public static boolean hasChangeNetPermission() {
        return PermissionChecker.hasPermission("android.permission.CHANGE_NETWORK_STATE");
    }

    static void setForceCheckPermissionFail(boolean forceCheckPermissionFail) {
        PermissionChecker.forceCheckPermissionFail = forceCheckPermissionFail;
    }

    public static boolean hasPermission(String perm) {
        Context context = ContextUtils.getApplicationContext();
        if (context == null || forceCheckPermissionFail) {
            return false;
        }
        return context.checkPermission(perm, Process.myPid(), Process.myUid()) == 0;
    }
}

