/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.NV21Buffer;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.rtc2.video.CoordinatesTransform;
import io.agora.rtc2.video.FocalLengthInfo;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureFormat;
import io.agora.rtc2.video.VideoCaptureParameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=15)
public class VideoCaptureCamera1
extends VideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera1.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private static final int NUM_CAPTURE_BUFFERS = 3;
    private static final int CAMERA_ERROR_DISABLED = 3;
    private static final SparseArray<String> COLOR_TEMPERATURES_MAP = new SparseArray();
    @Nullable
    private VideoCaptureFormat mVideoCaptureFormat;
    private static int IMAGE_FORMAT;
    private int mExpectedFrameSize;
    private int mPhysicalId = -1;
    private Camera.Area mAreaOfInterest;
    private Camera.Parameters mPreviewParameters;
    @Nullable
    private Camera mCamera;
    private ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private boolean mIsRunning;
    private boolean physicalCameraInVaild = false;
    private volatile boolean mCameraErrorTrigger = false;
    private final Object mObjectLock = new Object();
    private static final ReentrantLock mFocalLengthLock;
    private boolean isFirstFrameCaptured = false;
    private static Map<Integer, Camera.Parameters> cameraParametersMaps;
    private final Set<ParameterType> mModifiedParameters = Collections.newSetFromMap(new ConcurrentHashMap());

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int id) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: " + ex);
            return null;
        }
        return cameraInfo;
    }

    @Nullable
    private String getClosestWhiteBalance(int colorTemperature, List<String> supportedTemperatures) {
        int minDiff = Integer.MAX_VALUE;
        String matchedTemperature = null;
        for (int i = 0; i < COLOR_TEMPERATURES_MAP.size(); ++i) {
            int diff;
            if (!supportedTemperatures.contains(COLOR_TEMPERATURES_MAP.valueAt(i)) || (diff = Math.abs(colorTemperature - COLOR_TEMPERATURES_MAP.keyAt(i))) >= minDiff) continue;
            minDiff = diff;
            matchedTemperature = (String)COLOR_TEMPERATURES_MAP.valueAt(i);
        }
        return matchedTemperature;
    }

    static int getNumberOfCameras() {
        CameraLengthTask task = new CameraLengthTask();
        return task.getCameraIdLength();
    }

    static int getCaptureApiType(int id) {
        if (VideoCaptureCamera1.getCameraInfo(id) == null) {
            return 11;
        }
        return 6;
    }

    static int getFacingMode(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(id);
        if (cameraInfo == null) {
            return 0;
        }
        switch (cameraInfo.facing) {
            case 1: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 0;
    }

    @Nullable
    static String getName(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(id);
        if (cameraInfo == null) {
            Logging.e(TAG, "getName: " + id + " , failed to getCameraInfo.");
            return null;
        }
        return "camera " + id + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    @Nullable
    static String getDeviceId(int id) {
        return Integer.toString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int id) {
        Logging.i(TAG, "getDeviceSupportedFormats() " + id);
        List<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        try {
            if (!mFocalLengthLock.tryLock(MAX_CAMERA_TIME_MS, TimeUnit.MILLISECONDS)) {
                Logging.w(TAG, "getDeviceSupportedFormats tryLock mFocalLengthLock timeout after " + MAX_CAMERA_TIME_MS + "ms");
                return formatList;
            }
        }
        catch (InterruptedException e) {
            Logging.e(TAG, "getDeviceSupportedFormats tryLock mFocalLengthLock", e);
            Thread.currentThread().interrupt();
            return formatList;
        }
        try {
            Camera camera;
            try {
                camera = Camera.open((int)id);
            }
            catch (RuntimeException ex) {
                Logging.e(TAG, "Camera.open: " + ex);
                List<VideoCaptureFormat> list = null;
                mFocalLengthLock.unlock();
                return list;
            }
            if (camera == null) {
                List<VideoCaptureFormat> ex = null;
                return ex;
            }
            Camera.Parameters parameters = null;
            try {
                parameters = camera.getParameters();
            }
            catch (RuntimeException ex) {
                Logging.e(TAG, "Failed to get camera parameters " + id, ex);
            }
            formatList = VideoCaptureCamera1.getFormatsFromParemeters(parameters, IMAGE_FORMAT);
            try {
                camera.release();
            }
            catch (Exception e) {
                Logging.e(TAG, "Failed to release camera: " + id, e);
            }
        }
        finally {
            mFocalLengthLock.unlock();
        }
        return formatList;
    }

    @NonNull
    public static List<FocalLengthInfo> queryCameraFocalLengthCapability() {
        int numberOfCameras = VideoCaptureCamera1.getNumberOfCameras();
        if (numberOfCameras <= 0) {
            return null;
        }
        FocalLengthInfo[] logicalLengthInfos = new FocalLengthInfo[12];
        boolean found = false;
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            int maxId = Math.max(1, 0);
            if (i <= maxId) {
                if (!VideoCaptureCamera1.getFocalLengthInfo(1, i, cameraInfo.facing == 1, logicalLengthInfos)) continue;
                found = true;
                continue;
            }
            if (!VideoCaptureCamera1.getFocalLengthInfo(2, i, cameraInfo.facing == 1, logicalLengthInfos)) continue;
            found = true;
        }
        if (!found) {
            Logging.w(TAG, "Logical Camera, FocalLengths empty!");
        } else {
            Logging.d(TAG, "Logical Camera, FocalLengths available.");
        }
        ArrayList<FocalLengthInfo> focalLengthInfoList = new ArrayList<FocalLengthInfo>();
        for (FocalLengthInfo focalLengthInfo : logicalLengthInfos) {
            if (focalLengthInfoList.contains(focalLengthInfo)) continue;
            focalLengthInfoList.add(focalLengthInfo);
        }
        return focalLengthInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getFocalLengthInfo(int type, int id, boolean front, FocalLengthInfo[] focalLengthInfos) {
        boolean found = false;
        try {
            if (!mFocalLengthLock.tryLock(MAX_CAMERA_TIME_MS, TimeUnit.MILLISECONDS)) {
                Logging.w(TAG, "getFocalLengthInfo tryLock mFocalLengthLock timeout after " + MAX_CAMERA_TIME_MS + "ms");
                return false;
            }
        }
        catch (InterruptedException e) {
            Logging.e(TAG, "getFocalLengthInfo tryLock mFocalLengthLock", e);
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            Camera camera;
            try {
                camera = Camera.open((int)id);
            }
            catch (RuntimeException ex) {
                Logging.e(TAG, "Camera.open: " + ex);
                boolean bl = false;
                mFocalLengthLock.unlock();
                return bl;
            }
            if (camera == null) {
                boolean ex = false;
                return ex;
            }
            Camera.Parameters parameters = null;
            try {
                parameters = camera.getParameters();
            }
            catch (RuntimeException ex) {
                Logging.e(TAG, "Failed to get camera parameters " + id, ex);
                boolean bl = false;
                mFocalLengthLock.unlock();
                return bl;
            }
            float minFocalLength = VideoCaptureCamera1.getFocalLength(parameters);
            int cameraDirection = front ? 1 : 0;
            Logging.d(TAG, "The " + (front ? "front Camera " : "rear Camera ") + "minimum supported value is: " + 10.0f * minFocalLength + "mm");
            int index = 6 * (type - 1) + (front ? 0 : 3) + 0;
            focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, id, 0);
            if (minFocalLength >= 2.4f && minFocalLength < 3.5f) {
                index = 6 * (type - 1) + (front ? 0 : 3) + 1;
                Logging.d(TAG, "getFocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 1 + " front: " + front);
                focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, id, 1);
                found = true;
            } else if (minFocalLength < 2.4f && (double)minFocalLength > 0.1) {
                index = 6 * (type - 1) + (front ? 0 : 3) + 2;
                Logging.d(TAG, "getFocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 2 + " front: " + front);
                focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, id, 2);
                found = true;
            }
            try {
                camera.release();
            }
            catch (Exception e) {
                Logging.e(TAG, "Failed to release camera: " + id, e);
            }
        }
        finally {
            mFocalLengthLock.unlock();
        }
        return found;
    }

    @NonNull
    private static List<VideoCaptureFormat> getFormatsFromParemeters(@Nullable Camera.Parameters parameters, int filterImageForamt) {
        Logging.i(TAG, "getFormatsFromParemeters() ");
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        if (parameters == null) {
            return formatList;
        }
        List pixelFormats = parameters.getSupportedPreviewFormats();
        if (pixelFormats == null || pixelFormats.isEmpty()) {
            Logging.i(TAG, "failed to getFormatsFromParemeters, preview formats null or empty");
            return formatList;
        }
        for (Integer previewFormat : pixelFormats) {
            if (previewFormat != filterImageForamt) continue;
            int pixelFormat = 17;
            ArrayList<int[]> listFpsRange = null;
            try {
                listFpsRange = parameters.getSupportedPreviewFpsRange();
            }
            catch (StringIndexOutOfBoundsException ex) {
                Logging.e(TAG, "Camera.Parameters.getSupportedPreviewFpsRange: " + ex);
            }
            if (listFpsRange == null) {
                listFpsRange = new ArrayList<int[]>();
            }
            if (listFpsRange.size() == 0) {
                listFpsRange.add(new int[]{0, 0});
            }
            int maxFps = 0;
            for (int[] fpsRange : listFpsRange) {
                int fps = (fpsRange[1] + 999) / 1000;
                if (maxFps >= fps) continue;
                maxFps = fps;
            }
            List supportedSizes = parameters.getSupportedPreviewSizes();
            if (supportedSizes == null || supportedSizes.isEmpty()) continue;
            for (Camera.Size size : supportedSizes) {
                if (VideoCaptureCamera1.shouldExcludeSize(size.width, size.height)) continue;
                formatList.add(new VideoCaptureFormat(size.width, size.height, maxFps, pixelFormat));
            }
        }
        return formatList;
    }

    VideoCaptureCamera1(int id, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean enableTextureCopy, int captureTextureBufferCount, boolean pqFirst, int skipControl, EglBase.Context sharedContext, int templateType, VideoCaptureParameter param) {
        super(id, nativeVideoCaptureAndroid, captureToTexture, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, templateType, param.camera1FocusMode, param);
        if (param.physicalId >= 0) {
            this.mPhysicalId = param.physicalId;
        }
    }

    @Override
    @NonNull
    public List<VideoCapture.FramerateRange> getSupportFramerateRanges() {
        ArrayList<VideoCapture.FramerateRange> framerateRanges = new ArrayList<VideoCapture.FramerateRange>();
        if (this.mCamera == null) {
            return framerateRanges;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        int fpsUnitFactor = ((int[])listFpsRange.get(0))[0] > 1000 ? 1 : 1000;
        for (int[] range : listFpsRange) {
            framerateRanges.add(new VideoCapture.FramerateRange(range[0] * fpsUnitFactor, range[1] * fpsUnitFactor));
        }
        return framerateRanges;
    }

    @Override
    @NonNull
    public VideoCapture.FramerateRange getSelectedFramerateRange() {
        if (this.mCamera == null) {
            return new VideoCapture.FramerateRange(0, 0);
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        int fpsUnitFactor = ((int[])listFpsRange.get(0))[0] > 1000 ? 1 : 1000;
        int[] range = new int[2];
        parameters.getPreviewFpsRange(range);
        return new VideoCapture.FramerateRange(range[0] * fpsUnitFactor, range[1] * fpsUnitFactor);
    }

    @Override
    protected void onCameraAvailable(String cameraId) {
        if (!cameraId.equals(Integer.toString(this.mId))) {
            return;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            Logging.e(TAG, "failed to get camera info for " + this.mId);
            return;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning || !this.mCameraErrorTrigger) {
                Logging.i(TAG, "onCameraAvailable, Wrong state, mIsRunning: " + this.mIsRunning + " cameraError: " + this.mCameraErrorTrigger);
                return;
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.onAvailable(0);
    }

    @Override
    protected void onCameraUnavailable(String cameraId) {
        if (!cameraId.equals(Integer.toString(this.mId))) {
            return;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            Logging.e(TAG, "failed to get camera info for " + this.mId);
            return;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning || !this.mCameraErrorTrigger) {
                Logging.i(TAG, "onCameraUnavailable, Wrong state, mIsRunning: " + this.mIsRunning + " cameraError: " + this.mCameraErrorTrigger);
                return;
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.onAvailable(1);
    }

    @Override
    public boolean allocate(@NonNull VideoCaptureFormat req) {
        Boolean openResult;
        Logging.i(TAG, String.format(Locale.US, "allocate: requested (%d x %d) @%dfps", req.getWidth(), req.getHeight(), req.getFramerate()));
        if (this.mSurfaceTextureHelper == null) {
            Logging.e(TAG, "surfaceTextureHelper null");
            return false;
        }
        if (this.mProxyThreadHandler == null) {
            Logging.w(TAG, "proxyThread unavailable");
            return false;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            Logging.e(TAG, "failed to get camera info for " + this.mId);
            this.releaseCamera();
            return false;
        }
        this.physicalCameraInVaild = false;
        try {
            openResult = ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Logging.i(TAG, "allocate openCamera camera name:" + VideoCaptureCamera1.this.mId + " ,physicalId: " + VideoCaptureCamera1.this.mPhysicalId);
                    try {
                        if (!mFocalLengthLock.tryLock(VideoCaptureCamera.MAX_CAMERA_TIME_MS, TimeUnit.MILLISECONDS)) {
                            Logging.w(TAG, "allocate tryLock mFocalLengthLock timeout after " + VideoCaptureCamera.MAX_CAMERA_TIME_MS + "ms");
                            return false;
                        }
                    }
                    catch (InterruptedException e) {
                        Logging.e(TAG, "allocate tryLock mFocalLengthLock", e);
                        Thread.currentThread().interrupt();
                        return false;
                    }
                    if (VideoCaptureCamera1.this.mPhysicalId >= 0) {
                        try {
                            Logging.i(TAG, "allocate openCamera start");
                            VideoCaptureCamera1.this.mCamera = Camera.open((int)VideoCaptureCamera1.this.mPhysicalId);
                            Logging.i(TAG, "allocate openCamera done");
                        }
                        catch (RuntimeException ex) {
                            Logging.e(TAG, "allocate: Camera.open: " + ex);
                            VideoCaptureCamera1.this.physicalCameraInVaild = true;
                        }
                        finally {
                            mFocalLengthLock.unlock();
                        }
                        if (!VideoCaptureCamera1.this.physicalCameraInVaild) {
                            VideoCaptureCamera1.this.mId = VideoCaptureCamera1.this.mPhysicalId;
                        }
                    } else {
                        try {
                            Logging.i(TAG, "allocate openCamera start");
                            VideoCaptureCamera1.this.mCamera = Camera.open((int)VideoCaptureCamera1.this.mId);
                            Logging.i(TAG, "allocate openCamera done");
                        }
                        catch (RuntimeException ex) {
                            Logging.e(TAG, "allocate: Camera.open: " + ex);
                            Boolean bl = false;
                            return bl;
                        }
                        finally {
                            mFocalLengthLock.unlock();
                        }
                    }
                    if (VideoCaptureCamera1.this.physicalCameraInVaild && !VideoCaptureCamera1.this.physicalFallback()) {
                        return false;
                    }
                    if (!VideoCaptureCamera1.this.mIsRunning && VideoCaptureCamera1.this.mCamera != null && VideoCaptureCamera1.this.mProxyThreadHandler == null) {
                        try {
                            VideoCaptureCamera1.this.mCamera.release();
                            VideoCaptureCamera1.this.mCamera = null;
                            Logging.i(TAG, "allocate releaseCamera after stopping!");
                        }
                        catch (Exception ex) {
                            Logging.e(TAG, "allocate releaseCamera: failed to release camera, " + ex);
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "allocate: " + e);
            return false;
        }
        Logging.i(TAG, "allocate openCamera result:" + openResult);
        if (openResult == null || !openResult.booleanValue()) {
            return false;
        }
        this.mVideoCaptureFormat = req;
        this.mCameraNativeOrientation = cameraInfo.orientation;
        this.mInvertDeviceOrientationReadings = cameraInfo.facing == 0;
        Logging.i(TAG, String.format(Locale.US, "allocate: Rotation dev=%d, cam=%d, facing back? %s", this.getDeviceRotation(), this.mCameraNativeOrientation, this.mInvertDeviceOrientationReadings));
        Camera.Parameters parameters = null;
        try {
            parameters = this.getCameraParameters();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "failed to get camera parameters for " + this.mId, ex);
        }
        if (parameters == null) {
            Logging.e(TAG, "failed to get camera parameters");
            this.releaseCamera();
            return false;
        }
        List<VideoCaptureFormat> formatList = VideoCaptureCamera1.getFormatsFromParemeters(parameters, IMAGE_FORMAT);
        if (formatList == null) {
            return false;
        }
        Logging.i(TAG, "format list: " + Arrays.toString(formatList.toArray()));
        this.mCaptureFormat = VideoCaptureCamera1.FindBestMatchedCapability(formatList, req);
        if (this.mCaptureFormat == null) {
            Logging.e(TAG, "failed to match capability");
            this.releaseCamera();
            return false;
        }
        int frameRate = this.mCaptureFormat.mFramerate;
        if (!this.mParameter.camera1FpsRange && this.mPQFirst) {
            this.setPreviewFrameRateModePQ(parameters, frameRate);
        } else {
            this.setPreviewFrameRateMode(parameters, frameRate, this.mPQFirst);
        }
        boolean focusModeModified = false;
        boolean whiteBalanceModified = false;
        List supportedFocusModes = parameters.getSupportedFocusModes();
        if (null != supportedFocusModes && this.mCameraFocusMode != 0) {
            Logging.i(TAG, "supported focusModes: " + Arrays.toString(supportedFocusModes.toArray()));
            if (supportedFocusModes.contains("continuous-video") && (this.mCameraFocusMode == 2 || this.mCameraFocusMode == 1)) {
                parameters.setFocusMode("continuous-video");
                focusModeModified = true;
                Logging.i(TAG, "Continuous focus mode continuous video.");
            } else if (supportedFocusModes.contains("continuous-picture") && (this.mCameraFocusMode == 3 || this.mCameraFocusMode == 1)) {
                parameters.setFocusMode("continuous-picture");
                focusModeModified = true;
                Logging.i(TAG, "Continuous focus mode continuous picture.");
            } else if (supportedFocusModes.contains("auto") && this.mCameraFocusMode == 1) {
                parameters.setFocusMode("auto");
                focusModeModified = true;
                Logging.i(TAG, "Continuous focus mode auto.");
            } else {
                Logging.i(TAG, "Continuous focus mode not supported.");
            }
        }
        if (this.mSkipControl != 1 && parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
            focusModeModified = true;
        } else {
            Logging.i(TAG, "Continuous focus mode not supported.");
        }
        List supportedWhiteBalances = parameters.getSupportedWhiteBalance();
        if (supportedWhiteBalances != null) {
            Logging.i(TAG, "Camera " + this.mId + "supports white balance: " + Arrays.toString(supportedWhiteBalances.toArray()));
            if (this.mParameter.autoWhiteBalance && supportedWhiteBalances.contains("auto")) {
                parameters.setWhiteBalance("auto");
                whiteBalanceModified = true;
            }
        }
        parameters.setPreviewSize(this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight);
        parameters.setPreviewFormat(this.mCaptureFormat.mPixelFormat);
        try {
            if (focusModeModified && whiteBalanceModified) {
                this.setParameterWithTracking(parameters, ParameterType.FOCUS_MODE, ParameterType.WHITE_BALANCE);
            } else if (focusModeModified) {
                this.setParameterWithTracking(parameters, ParameterType.FOCUS_MODE);
            } else if (whiteBalanceModified) {
                this.setParameterWithTracking(parameters, ParameterType.WHITE_BALANCE);
            } else {
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception ex) {
            Logging.e(TAG, "setParameters: " + ex);
            this.releaseCamera();
            return false;
        }
        try {
            this.mSurfaceTextureHelper.setTextureSize(this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight);
            this.mCamera.setPreviewTexture(this.mSurfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException ex) {
            Logging.e(TAG, "allocate: " + ex);
            this.releaseCamera();
            return false;
        }
        catch (Exception ex) {
            Logging.e(TAG, "allocate: " + ex);
            this.releaseCamera();
            return false;
        }
        CrErrorCallback errorCallback = new CrErrorCallback();
        this.notifyInjector(errorCallback);
        this.mCamera.setErrorCallback((Camera.ErrorCallback)errorCallback);
        if (!this.mCaptureToTexture) {
            this.mExpectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
            for (int i = 0; i < 3; ++i) {
                byte[] buffer = new byte[this.mExpectedFrameSize];
                this.mCamera.addCallbackBuffer(buffer);
            }
        }
        this.mCamera.setDisplayOrientation(0);
        return true;
    }

    private boolean physicalFallback() {
        try {
            if (!mFocalLengthLock.tryLock(MAX_CAMERA_TIME_MS, TimeUnit.MILLISECONDS)) {
                Logging.w(TAG, "physicalFallback tryLock mFocalLengthLock timeout after " + MAX_CAMERA_TIME_MS + "ms");
                return false;
            }
        }
        catch (InterruptedException e) {
            Logging.e(TAG, "physicalFallback tryLock mFocalLengthLock", e);
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "allocate: Camera.open: " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            mFocalLengthLock.unlock();
        }
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        CameraManager manager;
        Boolean previewResult;
        Logging.i(TAG, "startCaptureMaybeAsync, use Texture: " + this.mCaptureToTexture);
        if (this.mCamera == null) {
            Logging.e(TAG, "startCaptureAsync: mCamera is null");
            return false;
        }
        if (this.mProxyThreadHandler == null) {
            Logging.w(TAG, "proxyThread unavailable");
            return false;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (this.mIsRunning) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        if (this.mCaptureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            previewResult = ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        VideoCaptureCamera1.this.mCamera.startPreview();
                        Logging.i(TAG, "startCaptureMaybeAsync done.");
                    }
                    catch (Exception ex) {
                        Logging.e(TAG, "startCaptureAsync: Camera.startPreview: " + ex);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        if (previewResult == null || !previewResult.booleanValue()) {
            return false;
        }
        if (!this.mIsCameraTorchStarted && this.mTorchMode != 0) {
            this.setTorchMode(this.mTorchMode == 1);
        }
        if (!this.mIsmCameraExposureStarted && this.mCameraExposurePositions[0] > 0.0f && this.mCameraExposurePositions[1] > 0.0f) {
            this.setExposure(this.mCameraExposurePositions[0], this.mCameraExposurePositions[1]);
        }
        if (!this.mIsmCameraFocusStarted && this.mCameraFocusPositions[0] > 0.0f && this.mCameraFocusPositions[1] > 0.0f) {
            this.setFocus(this.mCameraFocusPositions[0], this.mCameraFocusPositions[1]);
        }
        if (!this.mIsmCameraZoomStarted && this.mCameraZoomFactor > 0.0f) {
            this.setZoom(this.mCameraZoomFactor);
        }
        if (!this.mIsExposureCompensationStarted && this.mCameraExposureCompensation != 0) {
            this.setExposureCompensation(this.mCameraExposureCompensation);
        }
        if (this.mParameter.faceFocusing) {
            this.setAutoFaceFocus(this.mParameter.faceFocusing);
        }
        this.onFaceDetectionRequestChanged();
        this.mPreviewBufferLock.lock();
        try {
            this.onStarted();
            this.mIsRunning = true;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        if (ContextUtils.getApplicationContext() == null || this.mProxyThreadHandler == null) {
            Logging.w(TAG, "context or proxyThread unavailable");
            return true;
        }
        if (Build.VERSION.SDK_INT >= 21 && (manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera")) != null) {
            this.registerCameraAvailableCallback(manager);
        }
        return true;
    }

    private void setPreviewFrameRateModePQ(Camera.Parameters parameters, int frameRate) {
        List supportedRates = parameters.getSupportedPreviewFrameRates();
        if (supportedRates == null || supportedRates.size() == 0) {
            Logging.w(TAG, "allocate: camera don't supported PQ first.");
            this.setPreviewFrameRateMode(parameters, frameRate, false);
        } else {
            int diff = Math.abs((Integer)supportedRates.get(0) - frameRate);
            int closedFps = (Integer)supportedRates.get(0);
            for (Integer supportedRate : supportedRates) {
                int diffTemp = Math.abs(supportedRate - frameRate);
                if (diffTemp >= diff) continue;
                diff = diffTemp;
                closedFps = supportedRate;
            }
            parameters.setPreviewFrameRate(closedFps);
            Logging.i(TAG, String.format(Locale.US, "allocate: matched (%d x %d) @%d -set- @%d, PQ first", this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, frameRate, closedFps));
        }
    }

    private void setPreviewFrameRateMode(Camera.Parameters parameters, int frameRate, boolean pqFirst) {
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange == null || listFpsRange.size() == 0) {
            Logging.w(TAG, "allocate: camera don't supported fps first.");
            parameters.setPreviewFrameRate(frameRate);
        } else {
            int fpsUnitFactor = ((int[])listFpsRange.get(0))[0] > 1000 ? 1 : 1000;
            ArrayList<VideoCapture.FramerateRange> framerateRanges = new ArrayList<VideoCapture.FramerateRange>(listFpsRange.size());
            for (int[] range : listFpsRange) {
                framerateRanges.add(new VideoCapture.FramerateRange(range[0] * fpsUnitFactor, range[1] * fpsUnitFactor));
            }
            VideoCapture.FramerateRange aeFramerateRange = VideoCaptureCamera1.findBestFrameRateRange(framerateRanges, frameRate * 1000, pqFirst, this.mPQFirstType, this.mPQFirstDiff * 1000, this.mCustomMinFps * 1000, this.mCustomMaxFps * 1000);
            if (aeFramerateRange != null) {
                parameters.setPreviewFpsRange(aeFramerateRange.min / fpsUnitFactor, aeFramerateRange.max / fpsUnitFactor);
            }
        }
    }

    private void onFaceDetectionRequestChanged() {
        if (this.mEnableAutoFaceFocus) {
            Logging.i(TAG, "startFaceDetection for auto focus enabled");
            Camera.FaceDetectionListener listener = new Camera.FaceDetectionListener(){
                private long mLastFocusedTs;

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    if (VideoCaptureCamera1.this.mEnableFaceDetection) {
                        VideoCaptureCamera1.this.notifyFaceDetection(faces);
                    }
                    if (faces == null || faces.length == 0 || camera == null || !VideoCaptureCamera1.this.mEnableAutoFaceFocus) {
                        return;
                    }
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faces[0].score > 20) {
                            if (faces[0].rect != null && !faces[0].rect.equals((Object)VideoCaptureCamera1.this.lastFocusAreaRect)) {
                                VideoCaptureCamera1.this.notifyCameraFocusAreaChanged(faces[0].rect);
                            }
                            VideoCaptureCamera1.this.lastFocusAreaRect = faces[0].rect;
                        }
                        return;
                    }
                    if (faces[0].score <= 50) {
                        Logging.d(TAG, "face score = " + faces[0].score);
                        this.mLastFocusedTs = System.currentTimeMillis();
                        return;
                    }
                    try {
                        ArrayList<Camera.Area> focusList = new ArrayList<Camera.Area>();
                        Camera.Area firstFace = new Camera.Area(faces[0].rect, 1000);
                        focusList.add(firstFace);
                        if (camera.getParameters().getMaxNumFocusAreas() > 0) {
                            camera.getParameters().setFocusAreas(focusList);
                        }
                        if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                            camera.getParameters().setMeteringAreas(focusList);
                        }
                        VideoCaptureCamera1.this.notifyCameraFocusAreaChanged(faces[0].rect);
                        if (VideoCaptureCamera1.this.isAutoFaceFocusSupported()) {
                            camera.autoFocus(new Camera.AutoFocusCallback(){

                                public void onAutoFocus(boolean success, Camera camera) {
                                    Logging.d(TAG, "auto face focus called api1 every 3 seconds");
                                    try {
                                        if (camera != null) {
                                            camera.cancelAutoFocus();
                                        }
                                    }
                                    catch (RuntimeException e) {
                                        Logging.w(TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)e));
                                    }
                                }
                            });
                        }
                        this.mLastFocusedTs = System.currentTimeMillis();
                    }
                    catch (RuntimeException e) {
                        Logging.w(TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)e));
                    }
                }
            };
            if (this.isFaceDetectSupported()) {
                this.safetyStarFaceDetection(listener);
            }
        } else if (this.mEnableFaceDetection && this.isFaceDetectSupported()) {
            Camera.FaceDetectionListener listener = new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    if (VideoCaptureCamera1.this.mEnableFaceDetection) {
                        VideoCaptureCamera1.this.notifyFaceDetection(faces);
                    }
                }
            };
            Logging.i(TAG, "startFaceDetection for face dectect enabled");
            this.safetyStarFaceDetection(listener);
        } else {
            this.safetyStopFaceDetection();
        }
    }

    private void safetyStarFaceDetection(Camera.FaceDetectionListener listener) {
        block4: {
            Logging.i(TAG, "facedetect: " + this.mEnableFaceDetection);
            try {
                if (this.mCamera != null) {
                    if (this.mIsFaceDetectionStarted) {
                        this.mCamera.stopFaceDetection();
                    }
                    this.mCamera.setFaceDetectionListener(listener);
                    this.mCamera.startFaceDetection();
                    this.mIsFaceDetectionStarted = true;
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "Failed to stop face detection", e);
                if (this.mCamera == null) break block4;
                this.mCamera.stopFaceDetection();
                this.mCamera.setFaceDetectionListener(null);
                this.mIsFaceDetectionStarted = false;
            }
        }
    }

    private void safetyStopFaceDetection() {
        Logging.i(TAG, "stopFaceDetection()");
        try {
            if (this.mIsFaceDetectionStarted) {
                if (this.mCamera != null) {
                    this.mCamera.stopFaceDetection();
                }
                this.mIsFaceDetectionStarted = false;
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Failed to stop face detection", e);
        }
        finally {
            if (this.mCamera != null) {
                this.mCamera.setFaceDetectionListener(null);
            }
        }
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        block9: {
            Logging.i(TAG, "stopCaptureAndBlockUntilStopped()");
            this.unRegisterAvailabilityCallback();
            if (this.mProxyThreadHandler == null) {
                Logging.w(TAG, "proxyThread unavailable");
                return;
            }
            this.mPreviewBufferLock.lock();
            try {
                if (this.mIsRunning) break block9;
                this.mPreviewBufferLock.unlock();
            }
            catch (Throwable throwable) {
                this.mPreviewBufferLock.unlock();
                ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (VideoCaptureCamera1.this.mSurfaceTextureHelper != null) {
                            ISurfaceTextureHelper surfaceTexture = VideoCaptureCamera1.this.mSurfaceTextureHelper;
                            VideoCaptureCamera1.this.mSurfaceTextureHelper = null;
                            surfaceTexture.stopListening();
                            surfaceTexture.dispose();
                        }
                        return null;
                    }
                });
                if (this.mSurfaceTextureHelper != null) {
                    Logging.e(TAG, "waiting camera proxy thread disposing timeout after " + MAX_CAMERA_TIME_MS + "ms");
                    ISurfaceTextureHelper surfaceTexture = this.mSurfaceTextureHelper;
                    this.mSurfaceTextureHelper = null;
                    surfaceTexture.stopListening();
                    surfaceTexture.dispose();
                }
                throw throwable;
            }
            ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new /* invalid duplicate definition of identical inner class */);
            if (this.mSurfaceTextureHelper != null) {
                Logging.e(TAG, "waiting camera proxy thread disposing timeout after " + MAX_CAMERA_TIME_MS + "ms");
                ISurfaceTextureHelper surfaceTexture = this.mSurfaceTextureHelper;
                this.mSurfaceTextureHelper = null;
                surfaceTexture.stopListening();
                surfaceTexture.dispose();
            }
            return;
        }
        this.mIsRunning = false;
        this.mPreviewBufferLock.unlock();
        ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new /* invalid duplicate definition of identical inner class */);
        if (this.mSurfaceTextureHelper != null) {
            Logging.e(TAG, "waiting camera proxy thread disposing timeout after " + MAX_CAMERA_TIME_MS + "ms");
            ISurfaceTextureHelper surfaceTexture = this.mSurfaceTextureHelper;
            this.mSurfaceTextureHelper = null;
            surfaceTexture.stopListening();
            surfaceTexture.dispose();
        }
        this.mIsCameraTorchStarted = false;
        this.mIsmCameraExposureStarted = false;
        this.mIsmCameraFocusStarted = false;
        this.mIsmCameraZoomStarted = false;
        this.mIsExposureCompensationStarted = false;
        this.mProxyThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureCamera1.this.safetyStopFaceDetection();
            }
        });
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!VideoCaptureCamera1.this.mCaptureToTexture) {
                        VideoCaptureCamera1.this.mCamera.setPreviewCallbackWithBuffer(null);
                    }
                    try {
                        VideoCaptureCamera1.this.mCamera.stopPreview();
                        Logging.i(TAG, "stopPreview done!");
                    }
                    catch (Exception e) {
                        Logging.e(TAG, "stopPreview got exception:" + e.toString());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "stopPreview got exception:" + e.toString());
        }
        Logging.i(TAG, "stopCaptureAndBlockUntilStopped() done");
    }

    @Override
    public boolean needFallback() {
        return false;
    }

    static float getFocalLength(Camera.Parameters parameters) {
        if (parameters != null) {
            float focalLength = parameters.getFocalLength();
            Logging.d(TAG, "getCameraParameters: Camera.focalLength: " + focalLength);
            return focalLength;
        }
        Logging.e(TAG, "failed get focalLength");
        return -1.0f;
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.getCameraParameters();
            return this.isZoomSupported(parameters);
        }
        return false;
    }

    @Override
    public int setZoom(float zoomValue) {
        Camera.Parameters parameters;
        if (this.mCamera == null) {
            this.mCameraZoomFactor = zoomValue;
            return 0;
        }
        if (this.mIsmCameraZoomStarted && (double)Math.abs(this.mCameraZoomFactor - zoomValue) < 0.1) {
            return 0;
        }
        this.mCameraZoomFactor = zoomValue;
        Logging.i(TAG, "setCameraZoom api1 called zoomValue =" + zoomValue);
        if (zoomValue < 0.0f) {
            return -1;
        }
        int zoomRatio = (int)(zoomValue * 100.0f + 0.5f);
        List<Integer> zoomRatios = this.getZoomRatios();
        if (zoomRatios == null) {
            return -1;
        }
        int zoomLevel = 0;
        for (int i = 0; i < zoomRatios.size(); ++i) {
            int temp = zoomRatios.get(i);
            if (zoomRatio > temp) continue;
            zoomLevel = i;
            break;
        }
        if (!this.isZoomSupported(parameters = this.getCameraParameters())) {
            return -1;
        }
        int maxZoom = parameters.getMaxZoom();
        if (zoomLevel > maxZoom) {
            Logging.w(TAG, "zoom value is larger than maxZoom value");
            return -1;
        }
        parameters.setZoom(zoomLevel);
        try {
            this.mIsmCameraZoomStarted = true;
            this.setParameterWithTracking(parameters, ParameterType.ZOOM);
        }
        catch (Exception e) {
            Logging.w(TAG, "setParameters failed, zoomLevel: " + zoomLevel + ", " + e);
            return -1;
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mCamera != null) {
            List<Integer> zoomRatios;
            Camera.Parameters parameters = this.getCameraParameters();
            int maxZoom = 0;
            if (this.isZoomSupported(parameters)) {
                maxZoom = parameters.getMaxZoom();
            }
            if ((zoomRatios = this.getZoomRatios()) != null && zoomRatios.size() > maxZoom) {
                return (float)zoomRatios.get(maxZoom).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    @Override
    public boolean isFocusSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera1.isSupported("auto", parameters.getSupportedFocusModes());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFocus(float x, float y) {
        if (this.mCamera == null || this.mRenderView.getWidth() == 0 || this.mRenderView.getHeight() == 0) {
            this.mCameraFocusPositions[0] = x;
            this.mCameraFocusPositions[1] = y;
            return 0;
        }
        if (this.mIsmCameraFocusStarted && (double)Math.abs(this.mCameraFocusPositions[0] - x) < 0.1 && (double)Math.abs(this.mCameraFocusPositions[1] - y) < 0.1) {
            return 0;
        }
        this.mCameraFocusPositions[0] = x;
        this.mCameraFocusPositions[1] = y;
        Logging.i(TAG, "setFocus " + x + " - " + y);
        if (x < 0.0f || x > (float)this.mRenderView.getWidth() || y < 0.0f || y > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null) {
            return -1;
        }
        if (x <= 1.0f && y <= 1.0f) {
            return this.setFocusByCustom(x, y);
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(x, y, x, y), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        x = startRect.left;
        y = startRect.top;
        Rect focusRect = CoordinatesTransform.calculateFocusArea(x, y, 1.0f);
        Rect meteringRect = CoordinatesTransform.calculateFocusArea(x, y, 1.5f);
        Log.w((String)TAG, (String)("mCamera.autoFocus focusRect: " + focusRect + ", meteringRect: " + meteringRect));
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException e) {
            Logging.w(TAG, "Failed to cancle AutoFocus" + e);
        }
        Camera.Parameters params = this.getCameraParameters();
        if (params == null) {
            return -1;
        }
        if (params.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.w(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.w(TAG, "metering areas not supported");
        }
        RectF temp = CoordinatesTransform.cameraToNormalized(new RectF(meteringRect));
        temp = CoordinatesTransform.normalizedToSensor(temp, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, 0, false);
        if (temp == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        temp.round(meteringRect);
        final String currentFocusMode = params.getFocusMode();
        if (VideoCaptureCamera1.isSupported("macro", params.getSupportedFocusModes())) {
            params.setFocusMode("macro");
            Object object = this.mObjectLock;
            synchronized (object) {
                try {
                    this.setParameterWithTracking(params, ParameterType.FOCUS_AREAS, ParameterType.METERING_AREAS, ParameterType.FOCUS_MODE);
                }
                catch (Exception e) {
                    Logging.w(TAG, "mCamera.setParameters Exception: " + e);
                }
            }
        }
        Logging.w("focus", "FOCUS_MODE_MACRO is not supported");
        try {
            this.mIsmCameraFocusStarted = true;
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAutoFocus(boolean success, Camera camera) {
                    if (VideoCaptureCamera1.this.mCamera == null || VideoCaptureCamera.shouldSkipRefocus()) {
                        return;
                    }
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    Object object = VideoCaptureCamera1.this.mObjectLock;
                    synchronized (object) {
                        try {
                            camera.setParameters(params);
                        }
                        catch (Exception e) {
                            Logging.w(TAG, "mCamera setParameters Exception: " + e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.w(TAG, "mCamera.autoFocus Exception: " + e);
            return -1;
        }
        Rect rect = new Rect();
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(meteringRect), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, false);
        translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        translated = CoordinatesTransform.cameraToNormalized(new RectF(focusRect));
        translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraFocusAreaChanged(rect);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setFocusByCustom(float x, float y) {
        Rect focusRect = CoordinatesTransform.calculateFocusArea(x, y, 1.0f);
        Rect meteringRect = CoordinatesTransform.calculateFocusArea(x, y, 1.5f);
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException e) {
            Logging.w(TAG, "Failed to cancle AutoFocus" + e);
        }
        Camera.Parameters params = this.getCameraParameters();
        if (params == null) {
            return -1;
        }
        if (params.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.w(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.w(TAG, "metering areas not supported");
        }
        RectF temp = CoordinatesTransform.cameraToNormalized(new RectF(meteringRect));
        temp = CoordinatesTransform.normalizedToSensor(temp, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, 0, false);
        if (temp == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        temp.round(meteringRect);
        final String currentFocusMode = params.getFocusMode();
        if (VideoCaptureCamera1.isSupported("macro", params.getSupportedFocusModes())) {
            params.setFocusMode("macro");
            Object object = this.mObjectLock;
            synchronized (object) {
                try {
                    this.setParameterWithTracking(params, ParameterType.FOCUS_AREAS, ParameterType.METERING_AREAS, ParameterType.FOCUS_MODE);
                }
                catch (Exception e) {
                    Logging.w(TAG, "mCamera.setParameters Exception: " + e);
                }
            }
        }
        Logging.w("focus", "FOCUS_MODE_MACRO is not supported");
        try {
            this.mIsmCameraFocusStarted = true;
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAutoFocus(boolean success, Camera camera) {
                    if (VideoCaptureCamera1.this.mCamera == null || VideoCaptureCamera.shouldSkipRefocus()) {
                        return;
                    }
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    Object object = VideoCaptureCamera1.this.mObjectLock;
                    synchronized (object) {
                        try {
                            camera.setParameters(params);
                        }
                        catch (Exception e) {
                            Logging.w(TAG, "mCamera setParameters Exception: " + e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.w(TAG, "mCamera.autoFocus Exception: " + e);
            return -1;
        }
        Rect rect = new Rect();
        RectF translated = CoordinatesTransform.cameraToNormalized(new RectF(focusRect));
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated = new RectF(translated.left * 1000.0f, translated.top * 1000.0f, translated.right * 1000.0f, translated.bottom * 1000.0f);
        translated.round(rect);
        this.notifyCameraFocusAreaChanged(rect);
        return 0;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera1.isSupported("auto", parameters.getSupportedFocusModes());
        }
        return false;
    }

    @Override
    public int setAutoFaceFocus(boolean enable) {
        if (this.mEnableAutoFaceFocus == enable) {
            return 0;
        }
        this.mEnableAutoFaceFocus = enable;
        this.onFaceDetectionRequestChanged();
        return 0;
    }

    @Override
    public int setFaceDetection(boolean enable) {
        Logging.i(TAG, "setFaceDetection:" + enable);
        if (this.mEnableFaceDetection == enable) {
            return 0;
        }
        this.mEnableFaceDetection = enable;
        this.onFaceDetectionRequestChanged();
        return 0;
    }

    @Override
    public int setVideoEdgeMode(int mode) {
        Logging.w(TAG, "setVideoEdgeMode failure: " + mode);
        return -1;
    }

    @Override
    public int setVideoStabilityMode(int mode) {
        Logging.w(TAG, "setVideoStabilityMode: " + mode);
        if (this.mCamera == null) {
            return -1;
        }
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters == null) {
            return -1;
        }
        if (!parameters.isVideoStabilizationSupported()) {
            Logging.e(TAG, "not supported VideoStability Mode = " + mode);
            return -1;
        }
        if (mode == 1) {
            parameters.setVideoStabilization(true);
        } else if (mode == 0) {
            parameters.setVideoStabilization(false);
        }
        try {
            this.setParameterWithTracking(parameters, ParameterType.VIDEO_STABILIZATION);
        }
        catch (Exception e) {
            Logging.w(TAG, "setVideoStabilityMode failed, mode: " + mode + ", " + e);
            return -1;
        }
        return 0;
    }

    @Override
    public int setNoiseReductionMode(int mode) {
        Logging.e(TAG, "NoiseReduction not supported in camera1 ");
        return -1;
    }

    @Override
    public int setEdgeEnhanceMode(int mode) {
        Logging.e(TAG, "EdgeEnhancement not supported in camera1 ");
        return -1;
    }

    @Override
    public int setAntiBandingMode(final int mode) {
        if (this.mProxyThreadHandler == null) {
            return -1;
        }
        Integer ret = ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, new Callable<Integer>(){

            @Override
            public Integer call() {
                Logging.i(TAG, "setAntiBandingMode:" + mode);
                String antibandingSupported = VideoCaptureCamera1.this.toCamera1ABMode(mode);
                if (VideoCaptureCamera1.this.mCamera == null) {
                    return -1;
                }
                Camera.Parameters parameters = VideoCaptureCamera1.this.getCameraParameters();
                if (parameters == null) {
                    return -1;
                }
                if (VideoCaptureCamera1.isSupported(antibandingSupported, parameters.getSupportedAntibanding())) {
                    Logging.i(TAG, "AgoraVideo set anti-banding = " + antibandingSupported);
                    parameters.setAntibanding(antibandingSupported);
                    try {
                        VideoCaptureCamera1.this.setParameterWithTracking(parameters, new ParameterType[]{ParameterType.ANTIBANDING});
                    }
                    catch (Exception e) {
                        Logging.e(TAG, "anti banding got exception:" + e);
                    }
                    return 0;
                }
                Logging.e(TAG, "not supported anti-banding = " + antibandingSupported);
                return -1;
            }
        });
        return ret == null ? -1 : ret;
    }

    private String toCamera1ABMode(int mode) {
        switch (mode) {
            case 1: {
                return "50hz";
            }
            case 2: {
                return "60hz";
            }
            case 3: {
                return "auto";
            }
            case 0: {
                return "off";
            }
        }
        return "auto";
    }

    @Override
    public int setExposureCompensation(int value) {
        if (this.mCamera == null) {
            this.mCameraExposureCompensation = value;
            return 0;
        }
        if (this.mIsExposureCompensationStarted && this.mCameraExposureCompensation == value) {
            return 0;
        }
        this.mCameraExposureCompensation = value;
        Logging.i(TAG, "setExposureCompensation:" + value);
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters != null) {
            float step = parameters.getExposureCompensationStep();
            int min = parameters.getMinExposureCompensation();
            int max = parameters.getMaxExposureCompensation();
            int index = parameters.getExposureCompensation();
            Logging.i(TAG, "compensation step=" + step + ", min=" + min + ", max=" + max + ", cur index=" + index);
            int val = value;
            if (value > max) {
                val = max;
            }
            if (value < min) {
                val = min;
            }
            parameters.setExposureCompensation(val);
            try {
                this.mIsExposureCompensationStarted = true;
                this.setParameterWithTracking(parameters, ParameterType.EXPOSURE_COMPENSATION);
                index = parameters.getExposureCompensation();
                float ev = step * (float)index;
                Logging.i(TAG, "cur index=" + index + ", ev=" + ev);
                return 0;
            }
            catch (Exception e) {
                Logging.e(TAG, "exposure compensation got exception:" + e);
            }
        }
        return -1;
    }

    @Override
    public boolean isFaceDetectSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            Logging.i(TAG, "face dedect, numDetectedFaces: " + parameters.getMaxNumDetectedFaces());
            return parameters.getMaxNumDetectedFaces() > 0;
        }
        return false;
    }

    @Override
    public boolean isTorchSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCaptureCamera1.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    @Override
    public int setTorchMode(boolean isOn) {
        int mode;
        int n = mode = isOn ? 1 : -1;
        if (this.mCamera == null) {
            this.mTorchMode = isOn ? 1 : -1;
            return 0;
        }
        if (this.mIsCameraTorchStarted && this.mTorchMode == mode) {
            return 0;
        }
        this.mTorchMode = mode;
        Logging.i(TAG, "setTorchMode isOn: " + isOn);
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters != null) {
            List supportedFlashModes = parameters.getSupportedFlashModes();
            if (supportedFlashModes != null && supportedFlashModes.contains("torch")) {
                Logging.w(TAG, "setTorchMode isFlashSupported: true");
                if (isOn) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                try {
                    this.mIsCameraTorchStarted = true;
                    this.setParameterWithTracking(parameters, ParameterType.FLASH_MODE);
                }
                catch (Exception e) {
                    Logging.w(TAG, "setTorchMode failed, mode: " + (isOn ? "torch" : "off") + ", " + e);
                    return -1;
                }
                return 0;
            }
            Logging.w(TAG, "setTorchMode isFlashSupported: false");
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isExposureSupported() {
        Camera.Parameters parameters;
        boolean isExposureSupported = false;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            isExposureSupported = parameters.getMaxNumMeteringAreas() > 0;
        }
        return isExposureSupported;
    }

    @Override
    public boolean isCameraExposureSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            int min = parameters.getMinExposureCompensation();
            int max = parameters.getMaxExposureCompensation();
            Logging.i(TAG, "isCameraExposureSupported compensation min: " + min + " max: " + max);
            return min < 0 && max > 0;
        }
        return false;
    }

    @Override
    public int setExposure(float positionXinView, float positionYinView) {
        RectF temp;
        if (this.mCamera == null || this.mRenderView.getWidth() == 0 || this.mRenderView.getHeight() == 0) {
            this.mCameraExposurePositions[0] = positionXinView;
            this.mCameraExposurePositions[1] = positionYinView;
            return 0;
        }
        if (this.mIsmCameraExposureStarted && (double)Math.abs(this.mCameraExposurePositions[0] - positionXinView) < 0.1 && (double)Math.abs(this.mCameraExposurePositions[1] - positionYinView) < 0.1) {
            return 0;
        }
        this.mCameraExposurePositions[0] = positionXinView;
        this.mCameraExposurePositions[1] = positionYinView;
        Logging.i(TAG, "setExposure called camera api1 x = " + positionXinView + " y = " + positionYinView);
        if (positionXinView < 0.0f || positionXinView > (float)this.mRenderView.getWidth() || positionYinView < 0.0f || positionYinView > (float)this.mRenderView.getHeight()) {
            Logging.i(TAG, "setExposure unreasonable inputs!");
            return -1;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null) {
            return -1;
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(positionXinView, positionYinView, positionXinView, positionYinView), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        positionXinView = startRect.left;
        positionYinView = startRect.top;
        Rect meteringRect = CoordinatesTransform.calculateFocusArea(positionXinView, positionYinView, 1.5f);
        if (this.mCamera != null) {
            Camera.Parameters params = this.getCameraParameters();
            if (params == null) {
                Logging.d(TAG, "getCameraParameters null");
                return -1;
            }
            if (params.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 800));
                params.setMeteringAreas(meteringAreas);
            } else {
                Logging.i(TAG, "metering areas not supported");
            }
            try {
                this.setParameterWithTracking(params, ParameterType.METERING_AREAS);
                this.mIsmCameraExposureStarted = true;
            }
            catch (Exception e) {
                Logging.i(TAG, "setExposure failed, " + e);
                return -1;
            }
        }
        if ((temp = CoordinatesTransform.cameraToNormalized(new RectF(meteringRect))) == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        if ((temp = CoordinatesTransform.normalizedToSensor(temp, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, 0, false)) == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        temp.round(meteringRect);
        Rect rect = new Rect();
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(meteringRect), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, false);
        translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        return 0;
    }

    @Override
    public void setCameraDropCount(int dropCount) {
        if (dropCount < 0) {
            this.dropCount = 0;
        }
        if (this.mCaptureFormat != null && dropCount > this.mCaptureFormat.mFramerate) {
            this.dropCount = this.mCaptureFormat.mFramerate;
        }
        this.dropCount = dropCount;
    }

    @Override
    public void deallocate() {
        Logging.i(TAG, "deallocate()");
        this.stopCaptureAndBlockUntilStopped();
        if (this.mProxyThreadHandler == null) {
            Logging.w(TAG, "proxyThread unavailable");
            return;
        }
        this.mProxyThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    try {
                        if (VideoCaptureCamera1.this.mCamera == null) break block5;
                        Object object = EglBase.lock;
                        synchronized (object) {
                            VideoCaptureCamera1.this.mCamera.setPreviewTexture(null);
                        }
                    }
                    catch (Exception ex) {
                        Logging.e(TAG, "deallocate: failed to setPreviewTexture " + ex);
                    }
                }
                VideoCaptureCamera1.this.mCaptureFormat = null;
            }
        });
        this.releaseCamera();
    }

    private void setParameterWithTracking(Camera.Parameters parameters, ParameterType ... modifiedTypes) {
        if (null != this.mCamera && null != parameters) {
            this.mCamera.setParameters(parameters);
        }
        if (modifiedTypes != null) {
            for (ParameterType type : modifiedTypes) {
                if (type == null) continue;
                this.mModifiedParameters.add(type);
            }
        }
    }

    private void resetModifiedParameters() {
        if (this.mModifiedParameters.isEmpty()) {
            return;
        }
        Camera.Parameters cachedParams = cameraParametersMaps.get(this.mId);
        if (cachedParams == null) {
            Logging.w(TAG, "resetModifiedParameters: no cached parameters for camera " + this.mId);
            this.mModifiedParameters.clear();
            return;
        }
        Logging.i(TAG, "resetModifiedParameters: resetting " + this.mModifiedParameters.size() + " parameters for camera " + this.mId);
        for (ParameterType paramType : this.mModifiedParameters) {
            try {
                switch (paramType) {
                    case ZOOM: {
                        cachedParams.setZoom(0);
                        break;
                    }
                    case FOCUS_MODE: {
                        cachedParams.setFocusMode("auto");
                        break;
                    }
                    case EXPOSURE_COMPENSATION: {
                        cachedParams.setExposureCompensation(0);
                        break;
                    }
                    case FLASH_MODE: {
                        cachedParams.setFlashMode("off");
                        break;
                    }
                    case WHITE_BALANCE: {
                        cachedParams.setWhiteBalance("auto");
                        break;
                    }
                    case VIDEO_STABILIZATION: {
                        cachedParams.setVideoStabilization(false);
                        break;
                    }
                    case ANTIBANDING: {
                        cachedParams.setAntibanding("off");
                        break;
                    }
                    case METERING_AREAS: {
                        cachedParams.setMeteringAreas(null);
                        break;
                    }
                    case FOCUS_AREAS: {
                        cachedParams.setFocusAreas(null);
                    }
                }
                Logging.d(TAG, "resetModifiedParameters: reset " + (Object)((Object)paramType));
            }
            catch (Exception e) {
                Logging.w(TAG, "resetModifiedParameters: failed to reset " + (Object)((Object)paramType) + ": " + e);
            }
        }
        this.mModifiedParameters.clear();
    }

    @VisibleForTesting
    public int getModifiedParameterCount() {
        return this.mModifiedParameters.size();
    }

    private void releaseCamera() {
        if (this.mProxyThreadHandler == null) {
            Logging.w(TAG, "proxyThread unavailable");
            return;
        }
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, MAX_CAMERA_TIME_MS, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        if (VideoCaptureCamera1.this.mCamera != null) {
                            VideoCaptureCamera1.this.resetModifiedParameters();
                            VideoCaptureCamera1.this.mCamera.release();
                            VideoCaptureCamera1.this.mCamera = null;
                            Logging.i(TAG, "releaseCamera done!");
                        }
                    }
                    catch (Exception ex) {
                        Logging.e(TAG, "releaseCamera: failed to release camera, " + ex);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "releaseCamera: failed to release camera, " + e);
        }
    }

    private void listenForTextureFrames() {
        if (this.mSurfaceTextureHelper == null) {
            return;
        }
        this.mSurfaceTextureHelper.startListening(new SurfaceTextureHelper.IVideoCapture(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFrame(VideoFrame frame) {
                VideoCaptureCamera1.this.updateRealCaptureFpsStatsOnFrameCaptured();
                VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                try {
                    if (!VideoCaptureCamera1.this.mIsRunning) {
                        this.onFrameDropped(100201);
                        return;
                    }
                    if (!VideoCaptureCamera1.this.mFirstVideoFrameCaptured) {
                        Logging.i(TAG, "first video frame captured by camera1 texture!");
                        VideoCaptureCamera1.this.mFirstVideoFrameCaptured = true;
                    }
                    if (VideoCaptureCamera1.this.dropCount > 0) {
                        Logging.i(TAG, "Drop frames after restart capture. Left " + VideoCaptureCamera1.this.dropCount + " .");
                        --VideoCaptureCamera1.this.dropCount;
                        return;
                    }
                    VideoFrame.Buffer capturedBuffer = frame.getBuffer();
                    if (capturedBuffer == null) {
                        this.onFrameDropped(100201);
                        return;
                    }
                    if (VideoCaptureCamera1.this.mEnableTextureCopy && (capturedBuffer = ((SurfaceTextureHelper)VideoCaptureCamera1.this.mSurfaceTextureHelper).textureCopy((VideoFrame.TextureBuffer)frame.getBuffer())) == null) {
                        this.onFrameDropped(100204);
                        Logging.i(TAG, "TextureVideoSinkListener copy frame error");
                        return;
                    }
                    VideoFrame modifiedFrame = new VideoFrame(VideoCapture.createTextureBufferWithModifiedTransformMatrix((TextureBuffer)capturedBuffer, !VideoCaptureCamera1.this.mInvertDeviceOrientationReadings, 0), VideoCaptureCamera1.this.getCameraRotation(), frame.getTimestampNs());
                    VideoCaptureCamera1.this.attachPerFrameMetaInfos(modifiedFrame);
                    VideoCaptureCamera1.this.onFrameCaptured(modifiedFrame);
                    if (VideoCaptureCamera1.this.mEnableTextureCopy) {
                        capturedBuffer.release();
                    }
                    modifiedFrame.release();
                }
                finally {
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                }
                if (!VideoCaptureCamera1.this.isFirstFrameCaptured) {
                    Logging.i(TAG, "first frame captured.");
                    VideoCaptureCamera1.this.isFirstFrameCaptured = true;
                    VideoCaptureCamera1.this.onFirstFrameCaptured();
                }
            }

            @Override
            public void onFrameDropped(int dropReason) {
                VideoCaptureCamera1.super.onFrameDropped(dropReason);
            }
        });
    }

    private void onFirstFrameCaptured() {
        if (!this.mIsmCameraExposureStarted && this.mCameraExposurePositions[0] > 0.0f && this.mCameraExposurePositions[1] > 0.0f) {
            this.setExposure(this.mCameraExposurePositions[0], this.mCameraExposurePositions[1]);
        }
    }

    private void listenForBytebufferFrames() {
        this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] data, final Camera camera) {
                VideoCaptureCamera1.this.updateRealCaptureFpsStatsOnFrameCaptured();
                VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                if (!VideoCaptureCamera1.this.mIsRunning) {
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                    VideoCaptureCamera1.this.onFrameDropped(100201);
                    return;
                }
                if (!VideoCaptureCamera1.this.mFirstVideoFrameCaptured) {
                    Logging.i(TAG, "first video frame captured by camera1 yuv!");
                    VideoCaptureCamera1.this.mFirstVideoFrameCaptured = true;
                }
                if (VideoCaptureCamera1.this.dropCount > 0) {
                    if (camera != null) {
                        camera.addCallbackBuffer(data);
                    }
                    Logging.d(TAG, "Should drop " + VideoCaptureCamera1.this.dropCount + " frames after start capture.");
                    --VideoCaptureCamera1.this.dropCount;
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                    return;
                }
                if (data.length == VideoCaptureCamera1.this.mExpectedFrameSize) {
                    long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                    NV21Buffer frameBuffer = new NV21Buffer(data, VideoCaptureCamera1.this.mCaptureFormat.getWidth(), VideoCaptureCamera1.this.mCaptureFormat.getHeight(), new Runnable(){

                        @Override
                        public void run() {
                            VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                            if (!VideoCaptureCamera1.this.mIsRunning) {
                                VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                                return;
                            }
                            VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                            if (camera != null) {
                                VideoCaptureCamera1.this.mCamera.addCallbackBuffer(data);
                            }
                        }
                    });
                    VideoFrame frame = new VideoFrame(frameBuffer, VideoCaptureCamera1.this.getCameraRotation(), captureTimeNs);
                    VideoCaptureCamera1.this.attachPerFrameMetaInfos(frame);
                    VideoCaptureCamera1.this.onFrameCaptured(frame);
                    frame.release();
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                } else {
                    VideoCaptureCamera1.this.onFrameDropped(100201);
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                    if (camera != null) {
                        camera.addCallbackBuffer(data);
                    }
                }
                if (!VideoCaptureCamera1.this.isFirstFrameCaptured) {
                    Logging.i(TAG, "first frame captured.");
                    VideoCaptureCamera1.this.isFirstFrameCaptured = true;
                    VideoCaptureCamera1.this.onFirstFrameCaptured();
                }
            }
        });
    }

    public Camera.Parameters getCameraParameters() {
        if (this.mCamera == null) {
            return null;
        }
        try {
            Camera.Parameters cachedParams = cameraParametersMaps.get(this.mId);
            if (cachedParams != null) {
                return cachedParams;
            }
            cachedParams = this.mCamera.getParameters();
            cameraParametersMaps.put(this.mId, cachedParams);
            return cachedParams;
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", ex);
            if (this.mCamera != null) {
                this.safetyStopFaceDetection();
                this.releaseCamera();
            }
            return null;
        }
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean isZoomSupported = parameters.isZoomSupported();
            if (isZoomSupported) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported!");
            return false;
        }
        return false;
    }

    private void notifyFaceDetection(Camera.Face[] faces) {
        ArrayList<RectF> rectArray = new ArrayList<RectF>();
        ArrayList<Double> distanceArray = new ArrayList<Double>();
        boolean numFaces = false;
        boolean isMirror = false;
        if (this.mId == 1) {
            isMirror = true;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null || faces == null) {
            return;
        }
        for (Camera.Face face : faces) {
            RectF translated = CoordinatesTransform.cameraToNormalized(new RectF(face.rect));
            if (translated == null) continue;
            distanceArray.add(this.mId == 1 ? 11.237 * Math.pow(translated.width(), -0.958) : 14.719 * Math.pow(translated.height(), -0.971));
            translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
            if (translated == null) {
                distanceArray.remove(distanceArray.size() - 1);
                continue;
            }
            rectArray.add(translated);
        }
        if (rectArray.isEmpty()) {
            return;
        }
        this.notifyFaceDetection(this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), rectArray, distanceArray);
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported != null && supported.indexOf(value) >= 0;
    }

    static {
        COLOR_TEMPERATURES_MAP.append(2850, (Object)"incandescent");
        COLOR_TEMPERATURES_MAP.append(2950, (Object)"warm-fluorescent");
        COLOR_TEMPERATURES_MAP.append(4250, (Object)"fluorescent");
        COLOR_TEMPERATURES_MAP.append(4600, (Object)"twilight");
        COLOR_TEMPERATURES_MAP.append(5500, (Object)"daylight");
        COLOR_TEMPERATURES_MAP.append(6000, (Object)"cloudy-daylight");
        COLOR_TEMPERATURES_MAP.append(7000, (Object)"shade");
        IMAGE_FORMAT = 17;
        mFocalLengthLock = new ReentrantLock();
        cameraParametersMaps = new ConcurrentHashMap<Integer, Camera.Parameters>();
    }

    private static enum ParameterType {
        ZOOM,
        FOCUS_MODE,
        EXPOSURE_COMPENSATION,
        FLASH_MODE,
        WHITE_BALANCE,
        VIDEO_STABILIZATION,
        ANTIBANDING,
        METERING_AREAS,
        FOCUS_AREAS;

    }

    static class CameraLengthTask
    implements Runnable {
        static int length = 0;
        final CountDownLatch countDown = new CountDownLatch(1);

        CameraLengthTask() {
        }

        @Override
        public void run() {
            try {
                length = Camera.getNumberOfCameras();
            }
            catch (Exception ex) {
                Logging.e(TAG, "getNumberOfCameras: " + ex.toString());
            }
            finally {
                this.countDown.countDown();
            }
        }

        public int getCameraIdLength() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.countDown, VideoCaptureCamera.MAX_CAMERA_TIME_MS)) {
                Logging.e(TAG, "getNumberOfCameras timeout");
            }
            return length;
        }
    }

    class CrErrorCallback
    implements Camera.ErrorCallback {
        CrErrorCallback() {
        }

        public void onError(int error, Camera camera) {
            Logging.e(TAG, "Camera ErrorCallback id: " + error);
            if (error == 2 || error == 100 || error == 1 || error == 3) {
                int cameraEvent;
                if (error == 2) {
                    VideoCaptureCamera1.this.mCameraErrorTrigger = true;
                    cameraEvent = 6;
                } else if (error == 100) {
                    VideoCaptureCamera1.this.deallocate();
                    cameraEvent = 5;
                } else if (error == 3) {
                    VideoCaptureCamera1.this.mCameraErrorTrigger = true;
                    cameraEvent = 3;
                } else {
                    VideoCaptureCamera1.this.deallocate();
                    cameraEvent = 901;
                }
                if (Build.VERSION.SDK_INT < 21 && (error == 3 || error == 2)) {
                    VideoCaptureCamera1.this.deallocate();
                    cameraEvent = 901;
                }
                VideoCaptureCamera1.this.onError(cameraEvent, "Camera ErrorCallback id: " + error);
            }
        }
    }

    private static class BuggyDeviceHack {
        private static final String[] COLORSPACE_BUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747", "ODROID-U2", "XT1092", "XT1095", "XT1096", "XT1097"};

        private BuggyDeviceHack() {
        }

        static int getImageFormat() {
            return BuggyDeviceHack.isBuggyDevice() ? 17 : 842094169;
        }

        static boolean isBuggyDevice() {
            for (String buggyDevice : COLORSPACE_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return true;
            }
            return false;
        }
    }
}

